#!/usr/bin/perl -w
#построение кластеров для кампаний

use strict;
use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';


my %categs;
my $freq_total;
my $bid = "1431116409";
#my $banner = $proj->bf->get_banner_by_id($bid);
#my $campaign = $banner->campaign_obj;

while (<STDIN>) { #z1161733324 (от id_camp2.pl)
    chomp;
    my ($id, $text, $categ) = split /\t/;

    $categs{$categ}++; #частота категории
     unless ($categ =~ /NO_CATEGS/) {
        $freq_total++;
     }
}
print "'$bid'\t$freq_total\n==========\n" if %categs;
cluster_build(\%categs);


#--- построение кластеров для кампании ---
sub cluster_build {
    my ($categs) = @_;

    my %clust_dist2;
    my $dist = 2; #расстояние до корня
    for (keys %$categs) {
        my @edges = split m{/}, $_;
        my $bound = $dist <= @edges ? $dist-1 : $#edges;
        my $branch = join "/", @edges[0..$bound];
        $clust_dist2{$branch}{FREQ} += $categs{$_}; #общая частота кластера
        $clust_dist2{$branch}{CAT}++; #число категорий в кластере
    }

    my $freq_cumul = 0; #накопленная частота
    my $flag = 1;
    my $freq_max = 0;
    my $prod_max = 0;
    for (sort { $clust_dist2{$b}{FREQ} <=> $clust_dist2{$a}{FREQ} || $clust_dist2{$a} cmp $clust_dist2{$b} } keys %clust_dist2) {
        if ($flag) {
            $freq_max = $clust_dist2{$_}{FREQ};
            $prod_max = $clust_dist2{$_}{FREQ} * $clust_dist2{$_}{CAT};
            $flag = 0;
        }

        unless ($_ =~ /NO_CATEGS/) {
            $freq_cumul += $clust_dist2{$_}{FREQ};
            #my $frac = sprintf "%.2f", $freq_cumul / $freq_total;
            my $frac = sprintf "%.2f", $clust_dist2{$_}{FREQ} / $freq_max;
            my $prod = $clust_dist2{$_}{FREQ} * $clust_dist2{$_}{CAT};
            my $frac2 = sprintf "%.2f", $prod / $prod_max;
            #print "$_\t$clust_dist2{$_}{FREQ}\t$frac\t($clust_dist2{$_}{CAT})=$prod\t$frac2\n";
            print "$_\t$clust_dist2{$_}{FREQ}\n";
        } else {
            print "$_\t$clust_dist2{$_}{FREQ}\t***\n";
        }
    }
    print "\n";
}
