#!/usr/bin/perl -w
#объединенная таблица оценок тестов schachtel.pl

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

my %exp = ( #эксперименты
    "1" => "banner",
    "2" => "title",
    "3" => "model",
    "4" => "intent",
);

my %obj = ( #объекты категоризации
    "1" => "text",
    "2" => "tails",
    "3" => "banners",
    "4" => "snippets",
);

my %cnt; #счетчики
while (<STDIN>) { #union_tabl
    chomp;
    my @pat = split /\t/; #образец
    my $corr; #правильная категория
    if ($pat[4] =~ /^Прав/i) {
        $corr = $pat[2];
        $cnt{MYCORR}++; #мой скрипт
    } elsif ($pat[3]) {
        $corr = $pat[3];
    } else {
        $corr = "UNDEF";
    }

    for my $i (1..4) { #эксперименты
        chomp($_ = <STDIN>);
        my @exp = split /\t/;

        for my $j (1..4) { #объекты категоризации
            $cnt{"$i,$j"}{RSUM}++; #общая сумма для полноты
            $cnt{"$i,$j"}{PSUM}++ if $corr ne "UNDEF"; #общая сумма для точности
            if ($exp[$j+1] ne "NOCATEGORY") {
                $cnt{"$i,$j"}{R}++; #полнота
                if ($exp[$j+1] eq $corr) {
                    $cnt{"$i,$j"}{P}++; #точность
                    $cnt{"$i,$j"}{NEW}++ if ($pat[4] !~ /^Прав/i); #новизна
                }
            }
        }
    }
}

for my $i (1..4) { #эксперименты
    for my $j (1..4) { #объекты категоризации
        print "--[", $exp{"$i"}, ", ", $obj{"$j"}, "]--\n";

        print "R = ", $cnt{"$i,$j"}{R}, " / ";
        print $cnt{"$i,$j"}{RSUM}, " = ";
        printf "%.2f%%\n", 100 * $cnt{"$i,$j"}{R} / $cnt{"$i,$j"}{RSUM}; #полнота
        
        $cnt{"$i,$j"}{P} = 0 unless $cnt{"$i,$j"}{P};
        print "P = ", $cnt{"$i,$j"}{P}, " / ";
        print $cnt{"$i,$j"}{PSUM}, " = ";
        printf "%.2f%%\n", 100 * $cnt{"$i,$j"}{P} / $cnt{"$i,$j"}{PSUM}; #точность

        $cnt{"$i,$j"}{NEW} = 0 unless $cnt{"$i,$j"}{NEW};
        #print "N = ", $cnt{"$i,$j"}{NEW}, " / ";
        #print $cnt{MYCORR}, " = ";
        #printf "%.2f%%\n", 100 * $cnt{"$i,$j"}{NEW} / $cnt{MYCORR}; #новизна
        printf "CP = %.2f%%\n", (100 * $cnt{"$i,$j"}{P} / $cnt{"$i,$j"}{PSUM}) * (1 - $cnt{"$i,$j"}{NEW} / $cnt{MYCORR}); #P * (1 - N)
    }
}
