#!/usr/bin/perl -w
#выявление точек сочленения в графе

use strict;
use utf8;
use open ":utf8";
use Data::Dumper;
#use warnings('all');
no warnings('recursion');

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

#1. Построение графа
my %graph;
while (<STDIN>) { #categs_dict.frq
    chomp;
    next unless m{/};

    s/^ +//;
    /^(\d+) (.+)$/; #частота + пара категорий

    my ($freq, $cat_1_2) = ($1, $2);
    my ($cat_1, $cat_2) = split m{/}, $cat_1_2;

    push @{$graph{$cat_1}}, $cat_2; #представление графа в виде связанных списков смежных вершин
    push @{$graph{$cat_2}}, $cat_1;
}


#2. Обход в глубину, построение DFS-дерева и вычисление min из глубинных номеров верщин, смежных с потомками данной вершины
my %Dnum = (); #порядковые номера посещенных вершин
my %Low;
my $count = 0;

my %vis; #посещенные вершины
my %DFST; #DFS-дерево - набор ребер: key=родитель, value=массив_детей
my %COMP; #начальные вершины компонент связности

for my $cat (sort keys %graph) { #обход в глубину и построение DFS-дерева
    ComputeLow($cat) unless $Dnum{$cat}; #вычисление min из глубинных номеров верщин, смежных с потомками данной вершины

    next if $vis{$cat};
    $COMP{$cat} = 1; #новая КОМПОНЕНТА СВЯЗНОСТИ

    my @unvis = ($cat); #непосещенные вершины
    while (my $parent = $unvis[-1]) { #родитель выбирается с верхушки стека
        unless ($vis{$parent}) {
            $vis{$parent} = 1;
        }

        for my $child (@{$graph{$parent}}) {
            unless ($vis{$child}) {
                push @{$DFST{$parent}}, $child; #массив детей
                push @unvis, $child; #новый родитель
                last;
            }
        }
        pop @unvis if $parent eq $unvis[-1]; #удаление родителя, если в @unvis ничего не добавилось (все ребра обработаны)
    }
}


#3. Выявление точек сочленения ("articulation point")
my %artic_point;
for my $parent (sort keys %graph) {
    if ($COMP{$parent}) { #начальная вершина компоненты связности
        if (@{$DFST{$parent}} > 1) { #точка сочленения - стартовая вершина
            print "$parent\n";
            $artic_point{$parent} = 1;
        }
    } else {
        for my $child (@{$graph{$parent}}) {
            if ($Dnum{$parent} == $Low{$child} && !$artic_point{$parent}) { #точка сочленения - НЕстартовая вершина
                print "$parent\n";
                $artic_point{$parent} = 1;
            }
        }
    }
}


#--- вычисление наименьшего из глубинных номеров верщин, смежных с потомками заданной вершины (РЕКУРСИЯ) ---
sub ComputeLow {
    my ($parent) = @_;
    $Dnum{$parent} = ++$count;
    $Low{$parent} = $count;

    for my $child (@{$graph{$parent}}) {
        unless ($Dnum{$child}) {
            ComputeLow($child);
            $Low{$parent} = $Low{$parent} < $Low{$child} ? $Low{$parent} : $Low{$child};
        } else {
            $Low{$parent} = $Low{$parent} < $Dnum{$child} ? $Low{$parent} : $Dnum{$child};
        }
    }
}
