#!/usr/bin/perl -w
#обход графа в ширину и определение компонентов связности

use strict;
use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

#1. Построение графа
my %graph;
while (<STDIN>) { #categs_dict.frq
    chomp;
    next unless m{/};

    s/^ +//;
    /^(\d+) (.+)$/; #частота + пара категорий

    my ($freq, $cat_1_2) = ($1, $2);
    my ($cat_1, $cat_2) = split m{/}, $cat_1_2;

    push @{$graph{$cat_1}}, $cat_2; #представление графа в виде связанных списков смежных вершин
    push @{$graph{$cat_2}}, $cat_1;
}

#печать вершин с max количеством ребер
#for my $cat (sort { @{$graph{$b}} <=> @{$graph{$a}} || $a cmp $b } keys %graph) {
#    print "$cat\t", @{$graph{$cat}}+0, "\n";
#    #last;
#}


#2. Обход в ширину
my %vis; #посещенные вершины
for my $cat (sort keys %graph) {
    next if $vis{$cat};

    my @unvis = ($cat); #непосещенные вершины
    my $vertex = 0; #число вершин в компоненте связности
    my $edge = 0; #число ребер в компоненте связности
    while (my $parent = shift @unvis) {
        unless ($vis{$parent}) {
            $vertex++;
            print "$parent\n";
            $vis{$parent} = 1;

            for my $child (@{$graph{$parent}}) {
                unless ($vis{$child}) {
                    push @unvis, $child;
                    $edge++;
                }
            }
        }
    }
    print "--$vertex=$edge\n"; #компоненты связности
}
