#!/usr/bin/perl -w
#обход графа в ширину и вычисление метрик

use strict;
use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

#1. Построение графа
my %graph;
while (<STDIN>) { #categs_dict.frq
    chomp;
    next unless m{/};

    s/^ +//;
    /^(\d+) (.+)$/; #частота + пара категорий

    my ($freq, $cat_1_2) = ($1, $2);
    my ($cat_1, $cat_2) = split m{/}, $cat_1_2;

    push @{$graph{$cat_1}}, $cat_2; #представление графа в виде связанных списков смежных вершин
    push @{$graph{$cat_2}}, $cat_1;
}


#2. Обход в ширину и вычисление метрик
my %vis; #посещенные вершины
my @comp; #компонента связности
my $num = 0; #номер компоненты связности
for my $cat (sort keys %graph) {
    next if $vis{$cat};

    my @unvis = ($cat); #непосещенные вершины
    my $vertex = 0; #число вершин в компоненте связности
    my $edge = 0; #число ребер в компоненте связности
    while (my $parent = shift @unvis) {
        unless ($vis{$parent}) {
            $vertex++;
            push @comp, $parent;
            $vis{$parent} = 1;

            for my $child (@{$graph{$parent}}) {
                unless ($vis{$child}) {
                    push @unvis, $child;
                    $edge++;
                }
            }
        }
    }

    #print "--$vertex=$edge\n"; #компоненты связности
    #for $cat (@comp) {
    #    print "$cat\n";
    #}
    $num++;
    metric($num, $vertex, $edge, \@comp);
    @comp = ();
}

#--- вычисление метрик для одной компоненты связности (обход в ширину) ---
sub metric {
    my ($num, $vertex, $edge, $comp) = @_; #массив вершин одной компоненты связности

    my %eps; #эксцентриситеты вершин
    for my $i (0..$#{$comp}) {
        my %vis; #посещенные вершины
        my @unvis = ($$comp[$i]); #непосещенные вершины
        my %level = ( $$comp[$i] => 0 ); #расстояния от корневой вершины $cat

        $vis{".$$comp[$i]"} = 1; #вершины, посещенные как дети
        $eps{"$$comp[$i]"} = 0;
        while (my $parent = shift @unvis) {
            unless ($vis{$parent}) {
                $vis{$parent} = 1; #вершины, посещенные как родители
                for my $child (@{$graph{$parent}}) {
                    unless ($vis{".$child"}) {
                        $vis{".$child"} = 1;
                        push @unvis, $child;
                        $level{$child} = $level{$parent} + 1;
                        $eps{$$comp[$i]} = $level{$child} if $eps{$$comp[$i]} < $level{$child};
                    }
                }
            }
        }
        print "$num\t$vertex\t$edge\t$$comp[$i]\t$eps{$$comp[$i]}\n";
    }
}
