#!/usr/bin/perl -w
#обход графа в глубину и выявление мостов (перешейков)

use strict;
use utf8;
use open ":utf8";
use Data::Dumper;
#use warnings('all');
no warnings('recursion');

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

#1. Построение графа
my %graph;
while (<STDIN>) { #categs_dict.frq
    chomp;
    next unless m{/};

    s/^ +//;
    /^(\d+) (.+)$/; #частота + пара категорий

    my ($freq, $cat_1_2) = ($1, $2);
    my ($cat_1, $cat_2) = split m{/}, $cat_1_2;

    push @{$graph{$cat_1}}, $cat_2; #представление графа в виде связанных списков смежных вершин
    push @{$graph{$cat_2}}, $cat_1;
}


#2. Выявление мостов
my %used; #посещенные вершины
my %tin;
my %fup;
my $timer = 0;

for my $cat (sort keys %graph) {
    dfs($cat) unless $used{$cat};
}

#--- поиск в глубину ---
sub dfs {
    my ($v, $p) = @_; #вершина и ее родитель

    $used{$v} = 1;
    $tin{$v} = $fup{$v} = $timer++;
    for my $cat (@{$graph{$v}}) {
        next if $p && $cat eq $p;
        if ($used{$cat}) {
            $fup{$v} = $fup{$v} < $tin{$cat} ? $fup{$v} : $tin{$cat};
        } else {
            dfs ($cat, $v);
            $fup{$v} = $fup{$v} < $fup{$cat} ? $fup{$v} : $fup{$cat};
            if ($fup{$cat} > $tin{$v}) {
                my $bridge = $v lt $cat ? "$v/$cat" : "$cat/$v"; #мост
                print "$bridge\n";
            }
        }
    }
}
