#!/usr/bin/perl -w
#вычисление различных зависимостей между категориями

use strict;
use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

#use FindBin;
#use lib "$FindBin::Bin/../lib";
use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";

use Utils::Common;
use Project;
use BM::Phrase;
use BM::PhraseList;
use Time::HiRes qw(tv_interval gettimeofday);

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});

my %dic;
my $N; #общее число слов в генеральной совокупности
while (<STDIN>) { #categs_dict.frq
    chomp;
    next unless m{/};

    s/^ +//;
    /^(\d+) (.+)$/; #частота + пара категорий

    my ($freq, $cat_1_2) = ($1, $2);
    my ($cat_1, $cat_2) = split m{/}, $cat_1_2;

    $dic{$cat_1_2}{FREQ} += $freq; #совместная частота
    $dic{$cat_1}{FREQ} += $freq;
    $dic{$cat_2}{FREQ} += $freq;

    $N += $freq;

    my $cat_1_anc = ancestors_add($cat_1); #добавление предков для категории
    my @lev_1 = split m{/}, $cat_1_anc;

    my $cat_2_anc = ancestors_add($cat_2);
    my @lev_2 = split m{/}, $cat_2_anc;

    #вычисление расстояния между категориями
    my $i_min = $#lev_1 < $#lev_2 ? $#lev_1 : $#lev_2;
    my $cat_dist = 0;
    for my $i (0.. $i_min) {
        $cat_dist++ if $lev_1[$i] eq $lev_2[$i];
    }
    $cat_dist = @lev_1 + @lev_2 - 2*$cat_dist;

    $dic{$cat_1_2}{DIST} = $cat_dist;
    $dic{$cat_1}{LEV} = @lev_1+0;
    $dic{$cat_2}{LEV} = @lev_2+0;

#print "$cat_1_anc\t$dic{$cat_1}{LEV}\n";
#print "$cat_2_anc\t$dic{$cat_2}{LEV}\n";
#print "$dic{$cat_1_2}{DIST}\n";
#print "--\n";
}

for my $cat_1_2 (sort { $dic{$b}{FREQ} <=> $dic{$a}{FREQ} || $a cmp $b } keys %dic) { #сортировка по убыванию совместной частоты
    next unless $cat_1_2 =~ m{/};

    my ($cat_1, $cat_2) = split m{/}, $cat_1_2;
    my $MI = sprintf "%.3f", log2($N * $dic{$cat_1_2}{FREQ} / ($dic{$cat_1}{FREQ} * $dic{$cat_2}{FREQ}));
    my $depend_1_2 = sprintf "%.3f", $dic{$cat_1_2}{FREQ} / $dic{$cat_1}{FREQ}; #зависимость cat_1 от cat_2
    my $depend_2_1 = sprintf "%.3f", $dic{$cat_1_2}{FREQ} / $dic{$cat_2}{FREQ};

    print "$cat_1_2\t$dic{$cat_1}{LEV}\t$dic{$cat_2}{LEV}\t$dic{$cat_1_2}{DIST}\t$dic{$cat_1_2}{FREQ}\t$MI\t$depend_1_2\t$depend_2_1\n";
}


#--- добавление предков для категории ---
sub ancestors_add {
    my ($categ) = @_;

    my @ancestors; #все предки категории
    my $ancestor = $categ;
    while ($ancestor = $proj->categs_tree->get_minicateg_parent($ancestor)) {
        push @ancestors, $ancestor;
    }

    return join("/", reverse @ancestors)."/$categ";
}


#--- log2 ---
sub log2 {
    my $n = shift;
    return log($n)/log(2);
}
