#!/usr/bin/perl -w
#обход графа в глубину

use strict;
use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

#1. Построение графа
my %graph;
while (<STDIN>) { #categs_dict.frq
    chomp;
    next unless m{/};

    s/^ +//;
    /^(\d+) (.+)$/; #частота + пара категорий

    my ($freq, $cat_1_2) = ($1, $2);
    my ($cat_1, $cat_2) = split m{/}, $cat_1_2;

    push @{$graph{$cat_1}}, $cat_2; #представление графа в виде связанных списков смежных вершин
    push @{$graph{$cat_2}}, $cat_1;
}

#2. Обход в глубину
my %vis; #посещенные вершины
for my $cat (sort keys %graph) {
    next if $vis{$cat};
    my @unvis = ($cat); #непосещенные вершины
    while (my $parent = $unvis[-1]) { #родитель выбирается с верхушки стека
        unless ($vis{$parent}) {
            print "$parent\n";
            $vis{$parent} = 1;
        }

        for my $child (@{$graph{$parent}}) {
            unless ($vis{$child}) {
                push @unvis, $child; #новый родитель
                last;
            }
        }
        pop @unvis if $parent eq $unvis[-1]; #удаление родителя, если в @unvis ничего не добавилось (все ребра обработаны)
    }
    print "--\n"; #компонента связности
}
