#!/usr/bin/perl -w
#выбор полностью "хороших"/"плохих" категорий

use strict;
use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

my $cat_prev;
my $freq_prev;
while (<STDIN>) { #./data/zcat.u
    chomp;
    s/^ +//;
    /^(\d+) (.+)$/; #частота + категория
    my ($freq, $cat) = ($1, $2);

    if ($cat_prev) {
        if ($cat_prev."\t*" eq $cat) { #* - признак категории, приводящей к омонимии баннеров
            undef $cat_prev; #смешанные категории (hom_coef: > 0% && < 100%)
        } else {
            print "$cat_prev\t$freq_prev\n" if $cat_prev =~ /\*$/; #чистые омониммы (hom_coef: 100%)
            #print "$cat_prev\t$freq_prev\n" if $cat_prev !~ /\*$/; #чистые НЕомониммы (hom_coef: 0%)
            $cat_prev = $cat;
            $freq_prev = $freq;
        }
    } else {
        $cat_prev = $cat;
        $freq_prev = $freq;
    }
}
print "$cat_prev\n" if $cat_prev && $cat_prev =~ /\*$/;
#print "$cat_prev\n" if $cat_prev && $cat_prev !~ /\*$/;
