#!/usr/bin/perl -w

# Скрипт создает симлинки типа /opt/broadmatching/scripts -> /opt/arcadia/rt-research/broadmatching/scripts, /opt/arcadia/rt-research/broadmatching/work -> /opt/broadmatching/work
# Вызывается из ansible при наливке машины

# Для тестирования в отдельной директории можно использовать опцию --main-dir. Подготовить директории можно командой create_dirs_for_test:
# emurav@catalogia-media-dev02e:~/arcadia/rt-research/broadmatching$ ./scripts/utils/arcadia-setup/arcadia-setup.pl --main-dir /home/emurav/temp/arcadia-setup/opt/ create_dirs_for_test


use strict;

use Getopt::Long;

use FindBin;
use lib "$FindBin::Bin/../../lib";
use Utils::Sys qw[
    print_err
    do_sys_cmd
    handle_errors
];

handle_errors;

my %opt = (
    'main-dir' => '/opt',
    'tmpfs-dir' => '/run/shm/broadmatching',
);
GetOptions(\%opt, 'help|h', 'storage-dir=s', 'main-dir=s', "arcadia-dir=s", "bm-dir=s", );
my $mode = $ARGV[0] // '';  # Вызов create_wo_checkout и switch_to_arcadia используется в ansible
if ($opt{help}) {
    print "Create symlinks in /opt/broadmatching/, /opt/arcadia/rt-research/broadmatching/, ...\n";
    print "Usage:   arcadia-setup.pl MODE [OPTIONS]\n";
    print "  MODE can be:\n";
    print "    create_scripts_symlinks_in_broadmatching\n";
    print "    create_data_symlinks_in_arcadia\n";
    print "    create_storage_symlinks_in_broadmatching --storage-dir DIRECTORY\n";
    print "    switch_to_arcadia          (Obsolete)\n";
    print "    create_wo_checkout         (Obsolete)\n";
    print "    create_dirs_for_test\n";
    print "  OPTIONS:\n";
    print "    --main-dir DIRECTORY\n";
    print "    --arcadia-dir DIRECTORY\n";
    print "    --bm-dir DIRECTORY\n";
    print "    --storage-dir DIRECTORY\n";
    print "Examples:\n";
    print "  arcadia-setup.pl create_data_symlinks_in_arcadia\n";
    print "  arcadia-setup.pl create_data_symlinks_in_arcadia --arcadia-dir /opt/recheckout_arcadia_1531431321/arcadia\n";
    print "  arcadia-setup.pl create_storage_symlinks_in_broadmatching --storage-dir /space/broadmatching-storage\n";
    print "  arcadia-setup.pl create_dirs_for_test --main-dir /home/emurav/temp/arcadia-setup/opt/\n";
    exit(0);
}

print_err("======== Started $mode ========");

my @errors;

do {
    my $bm_dir = $opt{'bm-dir'} || ($opt{'main-dir'} ? $opt{'main-dir'}."/broadmatching" : die "--bm-dir or --main-dir must be setted!");
    my $arcadia_dir = $opt{'arcadia-dir'} || ($opt{'main-dir'} ? $opt{'main-dir'}."/arcadia" : die "--arcadia-dir or --main-dir must be setted!");
    my $arcadia_bm_dir = "$arcadia_dir/rt-research/broadmatching";

    my @bm_svn_subdirs = qw[ scripts dicts bin bm-utils sbin bin-dicts packages configs ];
    my @bm_work_subdirs = qw[ work temp export monitor-info gen-dicts log lock tmpfs  QTests raw-data simpgraphs   bmbanners_stat secrets ];

    if ($mode eq 'create_wo_checkout') {
        # Не удаляем, т.к. вызывается из ansible
        print_err("WARN: mode '$mode' is deprecated, do nothing");
    } elsif ($mode eq 'switch_to_arcadia') {
        # Вызывается из ansible 
        update_symlinks($arcadia_bm_dir, $bm_dir, [@bm_svn_subdirs]);
        update_symlinks($bm_dir, $arcadia_bm_dir, [@bm_work_subdirs]);

        my $tmpfs_dir = $opt{'tmpfs-dir'} || die "--tmpfs-dir must be setted";
        my $dir = "$tmpfs_dir/tmpfs";
        unless (-d $dir) {
            do_sys_cmd("mkdir -p $dir");
        }
        update_symlinks($tmpfs_dir, $bm_dir, ['tmpfs']);
    } elsif ($mode eq 'create_data_symlinks_in_arcadia') {
        update_symlinks($bm_dir, $arcadia_bm_dir, [@bm_work_subdirs]);
    } elsif ($mode eq 'create_scripts_symlinks_in_broadmatching') {
        update_symlinks($arcadia_bm_dir, $bm_dir, [@bm_svn_subdirs]);
    } elsif ($mode eq 'create_storage_symlinks_in_broadmatching') {
        # Для bmgen01* (role => 'bmgen'): Создаем в /opt/broadmatching/ симлинки на /space/broadmatching-storage/{work,temp,...}
        my $storage_dir = $opt{'storage-dir'} || die "--storage-dir must be setted for the 'create_storage_symlinks_in_broadmatching' mode!";
        my @storage_subdirs = qw[ bmbanners_stat export gen-dicts raw-data simpgraphs temp work ];
        update_symlinks($storage_dir, $bm_dir, [@storage_subdirs]);
    } elsif ($mode eq 'create_dirs_for_test') {
        # Создать директории для тестирования скрипта
        do_sys_cmd("mkdir -p $bm_dir");
        do_sys_cmd("mkdir -p $arcadia_bm_dir");
    } else {
        die "Bad mode ($mode)!";
    }
};

print_err("======== Done $mode ========");

exit (@errors ? 1 : 0);


sub update_symlinks {
    my ($dir, $symlinks_dir, $subdirs) = @_;
    print_err("update_symlinks ($dir, $symlinks_dir, " . @$subdirs . ") ...");

    unless (-d $symlinks_dir) {
        die "symlinks_dir $symlinks_dir does not exist!";
    }
    unless (-d $dir) {
        warn "dir $dir does not exist!";
    }

    for my $subdir (@$subdirs) {
        my $from = "$dir/$subdir";
        my $to = "$symlinks_dir/$subdir";
        if ( -d $to  and  !-l $to ) {
            die "Could not update_symlinks: '$to' already exists!";
        }
        do_sys_cmd("ln -sfn $from $to");
    }
    print_err("update_symlinks ($dir, $symlinks_dir, " . @$subdirs . ") done");
}
