#!/usr/bin/perl -w
use warnings;
use strict;

use Getopt::Long;

use FindBin;
use lib "$FindBin::Bin/../../lib";
use Utils::Sys qw[ handle_errors ];

use lib "$FindBin::Bin/../../wlib";

use CatalogiaMediaProject;

use utf8;
use open ":utf8";

handle_errors();

my %opt;
GetOptions(\%opt, 'use_comptrie_subphraser', 'apply_moderation', 'source=s', 'help');

if ($opt{help}) {
    print "$_\n" for (
        'dump-categs-phrases.pl [ OPTIONS ]',
        'Options:',
        '  --use_comptrie_subphraser',
        '  --apply_moderation',
        '  --source SOURCE',
        '    SOURCE - one of:  get_category_raw_phrases  db  subphraser',
        '  --help',
        'Example:',
        '  BM_NO_PATCH=debug_env ./scripts/utils/catalogia/dump-categs-phrases.pl --source subphraser --apply_moderation',
    );
    exit(0);
}

my $proj = CatalogiaMediaProject->new({
        no_auth         => 1,
        no_form         => 1,
        nrmsrv => 0,
        load_dicts      => 1,
        load_languages  => [ qw(ru en tr) ],
        load_minicategs_light => 1,
        ($opt{use_comptrie_subphraser} ? (use_comptrie_subphraser => 1) : ()),
        use_sandbox_categories_suppression_dict => 1,
});

my @categs = $proj->categs_tree->get_minicategs_list;

foreach my $categ ( @categs ) {
    foreach my $lang ( keys %{$proj->languages} ) {
        my $cat_id = $proj->categs_tree->get_minicateg_id($categ);

        my $phrases;
        if ($opt{source} eq 'get_category_raw_phrases') {
            if ($opt{apply_moderation}) {
                die "'apply_moderation' can not be used with 'get_category_raw_phrases'";
            }
            $phrases = [ $proj->languages->{$lang}->get_category_raw_phrases($categ) ];
        } elsif ($opt{source} eq 'db') {
            $phrases = $proj->category_interface->get_phrases($cat_id, $lang, $opt{apply_moderation}, source => 'db');
        } elsif ($opt{source} eq 'subphraser') {
            $phrases = $proj->category_interface->get_phrases($cat_id, $lang, $opt{apply_moderation}, source => 'subphraser');
        } else {
            die "Provide source!";
        }

        my $phrases_str = join(',', @$phrases);
        print join("\t", $lang, $categ, $phrases_str), "\n";
    }
}
