#!/usr/bin/perl -w
use strict;
use utf8;

use Getopt::Long;

use FindBin;
use lib "$FindBin::Bin/../lib";
use Project;

my %opt;
GetOptions(\%opt, 'help|h', 'mysql_params|mysql-params|m=s');
if (@ARGV != 1 or $opt{help}) {
    printf "Usage: $0 dbh_name\n";
    printf "To pass extra params to mysql connection: $0 dbh_name -m '-A --max_allowed_packet=100G'\n";
    exit(0);
}

my $proj = Project->new;
my $name = shift @ARGV;

my $extra_params = $opt{mysql_params} // '';

my $ps1 = "$name [\\d]> ";
$ps1 = "(debug_env) $ps1" if $proj->options->{show_debug_mode_warnings};

my $cmd = "MYSQL_PS1='$ps1' " . cmd_from_dbh(get_dbh_dict($proj)->{$name}) . " " . $extra_params;
$proj->log("Executing this command: $cmd");
system($cmd);


sub get_dbh_dict {
    my $proj = shift;
    
    my %dbh_list;
    %dbh_list = (%dbh_list, %{ $proj->{dbhlist} });
    %dbh_list = (%dbh_list, banners_dbh => $proj->bf->banners_dbh);

    return \%dbh_list;
}

sub cmd_from_dbh {
    my $dbh = shift // die "provide dbh";

    $dbh->get_connect_params; # load password
    my $cmd = "mysql ". $dbh->{db_opt}->{database};
    $cmd .= join "", map { " --" . $_ . "=" . $dbh->{db_opt}->{$_} } grep { defined $dbh->{db_opt}->{$_} } ('user', 'password', 'port', 'socket');
    $cmd .= " --host=".$dbh->{db_opt}->{hosts}->[0];
    return $cmd;
}
