#!/usr/bin/perl -w
use strict;

use open ':utf8';
use utf8;

use Getopt::Long;
use JSON;

use FindBin;
use lib "$FindBin::Bin/../../lib";

use Utils::DB;
use Utils::Sys qw(
    get_file_lock
);
use Project;

get_file_lock() or exit(0);

my %opt = (
    keep => 12,
);
GetOptions(\%opt, 'keep=i', 'test', 'help');
if (@ARGV != 2 or $opt{help}) {
    printf "Usage: $0 dbh_name tables_list [Options]\n";
    printf "Cleanup old monthly tables\n";
    printf "Options:\n";
    printf "  --keep=N          keep N month tables for each type (default: 12)\n";
    printf "  --test            do not drop tables, only print list of them\n";
    exit(0);
}

my ($dbh_name, $tbl_list) = @ARGV;
my $proj = Project->new;
if ($opt{test}) {
    $proj->log("running in test mode ...");
}
my $dbh = $proj->{dbhlist}{$dbh_name};
$proj->log('dbh: '.to_json($dbh->get_connect_params));

my @types = split /,/, $tbl_list;
for my $type (@types) {
    my @tbls = Utils::DB::get_tables($dbh, $type.'%');
    @tbls = sort { $a cmp $b } grep { /^$type\d{6}$/ } @tbls;
    my $to_delete = @tbls - $opt{keep};
    next if $to_delete <= 0;
    my @del = splice(@tbls, 0, $to_delete);

    next if !@del;
    $proj->log("drop tables @del ...");
    $dbh->do("drop tables ".join(',', @del)) unless $opt{test};
}
$proj->log("all done!");

exit(0);
