#!/usr/bin/perl -w
use strict;

use utf8;
use open ':utf8';

use JSON qw(to_json);
use Getopt::Long;

use FindBin;
use lib "$FindBin::Bin/../../lib";
use Project;
use Utils::Sys;
use BM::DB::Tables;


my %opt;
GetOptions(\%opt, 'help', 'name=s');

if (@ARGV != 2 or $opt{help}) {
    printf "Usage: create-table.pl [Options] dbh table\n";
    printf "Create table with def from BM::DB::Tables\n";
    printf "Options:\n";
    printf "  --name N    change table name\n";
    printf "Example:\n";
    printf "  create-table.pl database_dbh BMGoalReaches --name TMP_BMGoalReaches\n";
    exit;
}

my $proj = Project->new;
my $dbh_name = shift @ARGV;
my @dbh;
my $dbh = $proj->{dbhlist}{$dbh_name};
if ($dbh) {
    @dbh = ($dbh);
} else {
    die "Can't find dbh!\n";
}

my $def_name = shift @ARGV;

for my $dbh (@dbh) {
    printf "dbh_params: %s\n", to_json($dbh->get_connect_params);

    my $tbl_name = $opt{name} // $def_name;
    my $tbl_def = $BM::DB::Tables::table_def{$def_name}
        or die "Can't find table def!\n";
    printf "table_def:\n%s\n", $tbl_def;

    $dbh->do("create table if not exists $tbl_name $tbl_def");
    print "\nOK\n";
}
