#!/usr/bin/perl -w
use strict;

use utf8;
use open ':utf8';

use JSON;
use Getopt::Long;

use FindBin;
use lib "$FindBin::Bin/../../lib";
use Project;
use BM::Resources;
use Utils::Sys qw(handle_errors);

handle_errors();

my $proj = Project->new;
my $opts = $proj->options->{db_dump};
my @groups;
if (@ARGV) {
    # явно задаём группы
    @groups = map { split /,/, $_ } @ARGV;
} else {
    # определяем по роли
    my $host = $proj->get_curr_host;
    while (my ($group, $opt) = each %$opts) {
        push @groups, $group if BM::Resources::is_producer($host, $opt->{producer});
    }
}

for my $group (@groups) {
    $proj->log("processing group $group ...");
    my $opt = $opts->{$group};
    for my $table (@{$opt->{tables}}) {
        $proj->elem_factory->table_to_db_dump($group, $table);
    }
}

$proj->log("all done!");
