#!/usr/bin/perl -w
use strict;

use Getopt::Long;
use Data::Dumper;

use FindBin;
use lib "$FindBin::Bin/../lib";
use Utils::Hosts qw[
    get_hosts
    get_curr_host
];
use Utils::Sys qw[
    do_sys_cmd
    handle_errors
    print_err
];

handle_errors();

my %opt;
GetOptions(\%opt,
    'hosts=s',
    'help',
);
if ($opt{help}) {
    print $_,"\n" for (
        "Must be run with 'bmclient' user!",
        "Usage:",
        "  ssh_id_push.pl [ --hosts COMMA_SEPARATED_HOSTS_LIST ]",
        "Example:",
        "  ssh_id_push.pl",
        "  ssh_id_push.pl --hosts bmgen02e.bm.yandex.ru",
    );
    exit(0);
}

"bmclient" eq getpwuid($>) or die "This script should run by bmclient";

my @hosts = $opt{hosts} ? (grep { $_ } split /,/, $opt{hosts})
    : (grep $_ ne get_curr_host, get_hosts(exclude => {is_alias=>1}));
print_err("hosts: @hosts");

my @error_hosts;
for my $host (@hosts) {
    if (!do_sys_cmd("scp -p -o StrictHostKeyChecking=no /opt/broadmatching/.ssh/id_rsa $host:~/.ssh/", no_die => 1)) {
        push @error_hosts,($host);
    }
}
if (@error_hosts) {
    print_err "SSH_ID_PUSH_ERROR " . int((@error_hosts / @hosts) * 100) . "% " . join(" ",@error_hosts);
    exit 1;
}
else {
    print_err("SSH_ID_PUSH_OK");
}
