#!/usr/bin/perl -w
use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use FindBin;
use lib "$FindBin::Bin/../lib";
use Utils::CompileTime;
use Utils::Sys qw[
    handle_errors
    print_err
];

handle_errors();

my $revision = $ARGV[0] || die "Provide revision!";

print_err("save_revision_to_file $revision ...");
Utils::CompileTime::save_revision_to_file(revision => $revision);
print_err("save_revision_to_file $revision done");
