#!/usr/bin/perl -w
use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use JSON qw(to_json);
use Getopt::Long;
use Time::HiRes qw/gettimeofday tv_interval/;
use POSIX ":sys_wait_h";
use DBI;
use Getopt::Long;
use Data::Dumper;
use FindBin;
use File::Temp qw(tempdir);
use lib "$FindBin::Bin/../lib";
use Utils::Common;
use Utils::RestartSettings;
use Utils::Hosts qw(get_hosts get_host_role get_curr_host);
use Utils::DB;
use Utils::Sys qw(
    print_log
    print_err
    do_safely
    get_file_lock
    release_file_lock
    handle_errors
);
use Project;

$| = 1;

handle_errors();

my %opt = (
    name => '',
);
GetOptions(
    \%opt,
    'name=s',               #
);

my $name = $opt{name};

my $settings = get_settings($name)
    or die "Bad name ($name)";

check_service(name => $name, %$settings) or do {
    print_err("Could not wait for service ($name) alive");
    exit(1);
};

exit(0);


sub get_settings {
    my ($name) = @_;

    my %all_settings = (
        fcgi => {
            func_check => sub {
                my $host = get_curr_host();
                #my $host = "catalogia-media-front01e";
                my $cmd = "wget -O- --no-check-certificate 'http://$host/cgi/ind.pl?cmd=mytest1'";
                Utils::Sys::do_sys_cmd($cmd);
                return 1;
            },
        },
        prefprojsrv => {
            func_check => sub {
                my $proj = Project->new({ nrmsrv => 1 });
                my $text = "куплю";
                my $phr = $proj->phrase($text);
                my $norm = $phr->norm_phr;
                if ($norm  and  $norm ne $text) {
                    return 1;
                }
                die "prefprojsrv does not work!";
            },
        },
        subphraser => {
            func_check => sub {
                # Возвращает 1, если subphraser работает хотя бы для одного из перечисленных наборов параметров Project
                for my $proj_prm (
                    { nrmsrv => 1 },
                    { load_dicts => 1, load_minicategs_light => 1 },
                ) {
                    my $res = do_safely( sub {
                            print_err("proj_prm: " . to_json($proj_prm));
                            my $proj = Project->new($proj_prm);
                            my @ctgs = $proj->phrase("купить холодильник")->get_minicategs;
                            print_err("ctgs: @ctgs");
                            if (@ctgs) {
                                return 1;
                            }
                            return 0;
                        },
                        no_die => 1,
                        timeout => 120,
                    );
                    return 1 if $res;
                }
                die "subphraser does not work!";
            },
            timeout => 240,
        },

        'bmapi' => {
            func_check => sub {
                my $ua = LWP::UserAgent->new(timeout => 3);
                my $host = "localhost";
                my $url = "http://$host/fcgi-bin?act=alive";
                print_err("url: $url");
                my $resp = $ua->get($url);
                my $result;
                if($resp->is_success) {
                    $result = 1;
                }
                return $result;
            },
        },
    );

    return $all_settings{$name};
}

sub check_service {
    my (%prm) = (
        tries => 60,
        sleep_between_tries => 5,
        timeout => 5,
        @_,
    );

    do_safely(
        sub { $prm{func_check}->() || die "func_check returned false" },
        (map {$_ => $prm{$_}} qw[ tries sleep_between_tries timeout ]),
        no_die => 1,
        verbose => 1,
    );
}
