-- баннеры с BM показами
create table if not exists `Banners` (
    `BannerID` int unsigned not null,
    `CampaignID` int unsigned not null,
    `ClientID` int unsigned not null,
    `Title` text not null,
    `Body` text not null,
    `URL` text not null,
    primary key (`BannerID`)
) Engine=MyISAM CHARSET='utf8';

-- категории
create table if not exists `BannerCategory` (
    `BannerID` int unsigned not null,
    `Category` varchar(255) not null,
    primary key (`BannerID`, `Category`),
    key (`Category`)
) Engine=MyISAM CHARSET='utf8';

-- хранение данных от монитора
create table if not exists `MonitorData` (
    `IndicatorID` int unsigned not null,
    `ComputeTime` datetime not null,
    `Value` text not null,
    primary key (`IndicatorID`, `ComputeTime`)
) Engine=MyISAM CHARSET='utf8';

create table if not exists `Indicators` (
    `IndicatorID` int unsigned not null auto_increment,
    `GroupName` char(80) not null,
    `Object` char(80) not null,
    `Property` char(80) not null,
    `Host` char(80) not null,
    primary key (`IndicatorID`),
    unique key (`GroupName`, `Object`, `Property`, `Host`),
    key (`GroupName`, `IndicatorID`),
    key (`Object`, `IndicatorID`),
    key (`Property`, `IndicatorID`),
    key (`Host`, `IndicatorID`)
) Engine=MyISAM CHARSET='utf8';

create table if not exists `MonitorErrors` (
    `ErrorID` bigint unsigned not null,  -- md5int от join через ',' всех остальных полей, кроме ErrorInfo 
    `Host` varchar(255) not null,
    `File` varchar(255),
    `ErrorTime` datetime not null,
    `PID` int unsigned,  -- может быть пустым
    `ErrorText` text,
    `ErrorInfo` text,
    primary key (`ErrorID`),
    key (`ErrorTime`),
    key (`Host`)
) Engine=MyISAM CHARSET='utf8';

-- данные от метрики
create table if not exists `BMConversion` (
    `BannerID` int unsigned not null,
    `PhraseID` bigint unsigned not null,
    `EventsDate` date not null default '0000-00-00',
    `Visits` int unsigned not null,
    `Views` int unsigned not null,
    `TestedVisits` int unsigned not null,
    `GoodVisits` int unsigned not null,
    `BounceVisits` int unsigned not null,
    primary key (`BannerID`, `PhraseID`, `EventsDate`),
    key (`EventsDate`, `BannerID`)
) Engine=MyISAM CHARSET='utf8';

create table if not exists `OwnConversion` (
    `BannerID` int unsigned not null,
    `EventsDate` date not null default '0000-00-00',
    `Visits` int unsigned not null,
    `Views` int unsigned not null,
    `TestedVisits` int unsigned not null,
    `GoodVisits` int unsigned not null,
    `BounceVisits` int unsigned not null,
    primary key (`BannerID`, `EventsDate`),
    key (`EventsDate`, `BannerID`)
) Engine=MyISAM CHARSET='utf8';

create table if not exists `BMGoalReaches` (
    `bid` int unsigned not null,
    `PhraseID` bigint unsigned not null,
    `GroupID` int unsigned not null,
    `GoalID` int unsigned not null,
    `EventsDate` date not null,
    `Clicks` int unsigned not null,
    primary key (`GoalID`, `bid`, `PhraseID`, `GroupID`, `EventsDate`),
    key (`EventsDate`, `bid`)
) Engine=MyISAM default charset=utf8;

create table if not exists `OwnGoalReaches` (
    `bid` int unsigned not null,
    `GroupID` int unsigned not null,
    `GoalID` int unsigned not null,
    `EventsDate` date not null,
    `Clicks` int unsigned not null,
    primary key (`GoalID`, `bid`, `GroupID`, `EventsDate`),
    key (`EventsDate`, `bid`)
) Engine=MyISAM default charset=utf8;



-- подневная статистика по кампаниям
create table if not exists `OrderStat` (
    `CampaignID` int unsigned not null,
    `EventsDate` date not null default '0000-00-00',
    `TargetType` int unsigned not null,
    `Shows` int unsigned not null,
    `Clicks` int unsigned not null,
    `Cost` bigint unsigned not null,
    primary key (`CampaignID`, `EventsDate`, `TargetType`),
    key (`EventsDate`, `CampaignID`)
) Engine=MyISAM CHARSET='utf8';


create table if not exists `BadBanners` (
    `EventsDate` date not null default '0000-00-00',
    `BannerID` int unsigned not null,
    `BadType` int unsigned not null,
    primary key (`EventsDate`, `BannerID`)
) Engine=MyISAM CHARSET='utf8';
