﻿// (c) ammap.com | SVG (in JSON format) map of New Zealand - Low
// areas: {id:"NZ-AUK"},{id:"NZ-BOP"},{id:"NZ-CAN"},{id:"NZ-CIT"},{id:"NZ-GIS"},{id:"NZ-HKB"},{id:"NZ-MBH"},{id:"NZ-MWT"},{id:"NZ-NSN"},{id:"NZ-NTL"},{id:"NZ-OTA"},{id:"NZ-STL"},{id:"NZ-TAS"},{id:"NZ-TKI"},{id:"NZ-WKO"},{id:"NZ-WGN"},{id:"NZ-WTC"}
AmCharts.maps.newZealandLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"165.876210",
				"topLatitude":"-34.392108",
				"rightLongitude":"183.847768",
				"bottomLatitude":"-52.609857"
			}
		},
		"g":{
			"path":[
				{
					"id":"NZ-AUK",
					"title":"Auckland",
					"d":"M363.36,352.48l1.04,-0.08l-0.79,3.25l-1.66,-1.94L363.36,352.48zM362.66,348.24l1.31,0.74l-1.91,1.1l-0.41,2.96l-2.84,-0.55l-2.22,-2.28l-1.06,1.04l-0.05,-1.98l1.22,0.64l1.68,-0.91l1.53,1.01l0.23,-1.08L362.66,348.24zM352.74,347.26l0.51,2.68l-3.51,1.01l-0.04,-1.76l2.02,-0.07L352.74,347.26zM349.79,330.94l1.48,1.16l-0.18,1.92l-2.31,-1.17L349.79,330.94zM359.67,320.25l0.88,0.64l-0.65,2.39l-1.94,-0.57l0.05,-1.68L359.67,320.25zM341.8,319.09l3.26,4.8l4,1.46l-1.66,2.2l0.39,1.45l3.1,0.7l-5.4,1.05l0.09,1.74l1.77,1l-1.99,2.36l-0.5,-2.36l-1.01,1.79l1.24,0.66l0.15,2.4l-0.88,-0.26l-0.32,1.74l1.57,2.27l4.14,-1.45l-0.19,1.31l-4.15,1.28l3.33,8.89l-1.3,-0.13l-0.59,-1.37l-2.6,1.24l-1.38,-2.51l-0.7,0.12l0.46,3.82l1.38,1.4l1.99,-2.33l2.5,1.42l0.44,-0.88l2.21,0.03l0.53,1.21l1.03,0.13l1.87,1.87l1.16,-0.19l-0.3,-1.32l2.1,-0.35l2.6,3.47l1.47,-0.89l0.69,1.12l1.22,-1l3.61,3.55l0,0l-3.04,1.79l-2.09,-0.8l-0.07,1.88l-3.27,-1.17l-2.55,4.91l-2.09,-0.82l-0.49,0.71l2.57,3.56l-0.73,1.33l-2.34,-0.2l-0.18,2.72l-2.61,-0.64l-0.09,1.36l-1.61,0.96l0,0l-2.13,0.57l-0.79,1.78l-1.8,-0.98l-5.79,-14.56l4.7,-0.37l0.12,4.66l1.09,0.38l0.74,4.16l1.08,0.2l-1.28,-3.88l0.29,-1.15l2.52,-2.19l0.57,1.05l2.63,-2.87l-1.64,-1.99l-1.97,0.43l-0.92,-1.29l1.29,-1.16l-0.72,-1.36l0.63,-0.78l-3.56,0.47l-2.42,1.86l-0.3,2.34l-1.73,-1.05l-3.15,2.46l-2.69,-11.68l-9.92,-15.74l0.27,-1.73l2.59,-0.97l2.6,4.8l2.93,1.79l-0.48,1.78l1.46,1.2l1.28,-0.74l-1.06,-1.26l1.36,-1.42l-1.48,-3.78l0.87,-2.79l-1.4,-1.3l-1.37,0.96l-1.24,-1.32l-2.91,-0.36l0.64,-3.13l2.89,0.68l2.25,-1.84l0,0l2.69,-1.38l0,0l0.39,-1.41l0,0l2.02,-0.75l0.12,-1.34l2,-0.76l1.42,-2.36l0,0L341.8,319.09zM371.56,314.67l0.29,1.92l1.57,0.69l-0.67,1.58l3,1.55l-1.4,2.83l2.87,2.96l-0.79,2.76l-1.97,-0.87l0.56,-1.44l-2.15,0.35l0.24,-2.31l-1.45,0.38l-3.61,-2.7l-0.03,-1.28l1.96,1l-0.14,-2.73l-1.78,-0.56l2.55,-0.89l-1.31,-2.41L371.56,314.67z"
				},
				{
					"id":"NZ-BOP",
					"title":"Bay of Plenty",
					"d":"M394.56,383.51l6.38,8.36l-2.61,-2.4l-0.34,1.2l-1.67,-0.92l-0.09,-1.52l1.61,0.48l-3.42,-3.94L394.56,383.51zM404.22,463.79l1.91,-1.02l-0.91,-7.51l-2.86,0.58l-3.57,-6.18l0.78,-2.2l4.02,1.13l1.61,-1.44l-3.28,-3.85l1.85,-3.95l-4.01,-1.14l-0.47,-1.17l-2.08,0.27l0.09,-2.73l1.06,0.13l2.31,-2.78l1.52,3.18l5,-1.67l0.73,1.06l-0.92,1.97l2.29,0.99l1.25,-2.91l3.49,1.33l1,-6.58l-1.56,-1.81l-6.31,-2.65l-3.28,-10.53l-1.91,-1.4l-2.61,-0.06l-6.05,-5.17l-0.49,-1.68l1.39,-0.79l-1.4,-1.6l0.02,-1.87l-1.33,-0.56l0.76,-2.68l-4.6,-10.78l1,-0.9l-1.01,-2.03l0.98,-1.42l0.98,1.51l1.56,-0.04l-1.52,-1.84l2.13,-1.56l-0.48,-1.16l1.41,-1.56l0,0l2.01,4.44l-1.86,-0.22l-0.53,1.69l0.77,-0.56l1.1,1.45l-2.26,0.97l1.3,0.99l-0.41,0.72l0.65,1.53l1.25,0.55l-0.07,1.39l2.48,-0.63l-0.67,1.56l2.16,0.25l0.13,1.14l1.62,-1.28l1.22,0.42l-0.32,2.9l2.97,-1.49l-2.21,-1.49l-0.21,-2.13l10.04,6.78l1.44,-1.21l7.59,5.79l18.69,6.42l-2.89,-0.29l2.72,1.99l0.75,-1.59l9.13,-0.14l3.7,-1.74l7.7,-9.44l-0.61,-0.98l2.3,-2.98l4.79,-0.9l2.06,-2.75l1.89,0.62l1.53,-1.96l0.65,-1.17l2.81,-0.45l0,0l1.02,2.64l-5.2,1.32l1.05,3.28l-1.02,2.29l0.89,1.24l1.61,-1.47l1.44,1.54l-4.04,4.1l-4.21,13l-5.4,-4.2l-2.13,-0.19l1.25,2.16l-1.59,4.66l-6.58,3.21l0.42,1.97l-1.43,3.52l-8.89,4.6l0.7,4.29l-2.19,0.61l-1.13,2.61l-1.68,0.41l0,0l-0.8,1.68l-2.46,0.19l-2.19,3.85l-2.35,-0.15l-1.41,-1.6l-2.65,1.31l-1.85,-0.35l-0.91,1.98l-1.31,-0.03l-0.46,6.39l-4.15,4.32l0.74,2.96l-6.44,0.09l-1.24,2.93l1.15,3.08l-3.01,0.38l1.03,1.5l-2.2,0.6L404.22,463.79z"
				},
				{
					"id":"NZ-CAN",
					"title":"Canterbury",
					"d":"M267.54,617.44l0.69,3.5l2.01,-0.47l0.66,1.48l1.37,0.06l-0.62,2.55l1.61,1.41l-0.81,1.76l1.04,1.05l1.59,-0.61l1.11,3.64l2.67,1.01l-1.56,2.64l1.9,-0.15l1.29,2.41l0.97,-1.54l3.22,-0.66l2.47,-4.71l0.94,-0.07l-2.4,-1.12l4.59,-3.48l-0.2,-0.79l6.64,-2.84l0.63,-5.47l2.34,-0.91l2.27,-3.51l1.5,0.28l2.87,-2.61l0.6,-2.57l2.18,2.31l1.1,-1.33l5.27,-1.05l0.76,1.14l3.25,-0.21l-0.41,1.89l0,0l-4.38,6.34l-0.11,4.27l-6.68,5.94l-2.79,4.07l-0.34,2.41l1.49,1.05l-4.06,-0.19l-3.49,3.02l-1.11,3.46l0.82,0.45l-8.1,15.74l0.2,1.78l-3,3.68l-4.01,1.89l-2.27,3.29l-1.51,-0.21l-8.71,4.57l-3.58,6.94l-0.63,6.93l0.65,7.11l-0.96,1.49l4.14,1.8l-5.08,1.09l-1.06,0.79l0.34,1.76l6.49,-2.8l1.33,-0.09l2,1.15l0.77,-0.06l2.44,0.97l2.07,0.61l0.39,2.19l1.17,-0.47l0.89,0.91l-0.45,1.06l1.23,1.47l-1.07,4.63l-5.23,2.95l-1.17,-1.84l0.94,-4.76l-1.13,-0.79l-1.17,3.9l1.56,4.16l-4.63,-0.56l-4.69,-3.4l-15.39,2.23l-12.13,5.49l-21.86,13.74l-7.49,8.44l0.43,3.68l-3.63,8.28l0.41,12.6l-1.02,5.87l0,0l-11.15,-2.34l-10.33,-4.54l-2.3,4.32l-3.94,2.8l-2.04,0.49l-0.89,-2.44l-1.12,-0.18l-3.89,1.83l-4.85,0.34l-0.93,-3.04l-2.92,-3.5l-1.97,-9.4l-1.99,-0.46l-2.12,1.43l-2.89,-1.35l-1.17,-4.46l-0.68,2.1l-2.96,-0.4l0.33,-6.86l-2.8,-0.16l-1.33,-1.02l0.66,-0.55l0,0l0.41,-1.99l0,0l0.4,-7.76l-1.57,-2.44l2.58,-2.78l0.41,-1.97l0.97,-0.06l1.63,-4.23l1.24,-0.16l-0.58,-3.99l0,0l6.11,-7.1l1.39,0.07l-0.09,-1.16l2.95,-1.12l0.08,-2.43l2.25,-1.17l-0.04,-2.09l2.24,-1.17l-0.02,-3.59l2.02,-0.48l3.38,-3.98l3.85,-1.77l0.95,1.42l1.88,-0.72l5.03,-4.6l3.15,1.17l1.75,-2.45l-0.63,-0.94l2.81,-1.38l-0.52,-1.28l4.8,-0.95l4.06,-5.12l0.79,1.18l1.51,-0.28l2.68,-3.1l-0.63,-0.94l1.49,-2.35l1.01,0.5l0.45,-1.36l4.36,-1.08l0.43,-3.42l3.04,-2.05l-0.2,-0.81l2.31,-0.59l1.59,0.86l1.48,-2.35l1.88,-0.73l0.9,0.84l5.84,-1.38l1.86,0.76l1.41,-1.43l-0.74,-0.6l1.3,-1.09l-0.06,-2.63l4.94,-2.21l1.45,-4.39l2.14,-0.83l-0.2,-0.81l5.01,-1.06l0.74,-2.93l2.25,-1.16l2.13,-4.34l2.02,-0.49l2.38,-2.96l3.88,-1.2l1.24,-5.14l0,0l5.08,-3.39l0.2,-2.68l1.28,-1.06l-0.4,-1.58L267.54,617.44z"
				},
				{
					"id":"NZ-CIT",
					"title":"Chatham Islands Territory",
					"d":"M698.21,730.59l2.69,2.67l-3.51,4.45l-1,-3.73l1.19,-1.11l-1.48,-1.29L698.21,730.59zM682.5,701.9l7.4,2.99l3.47,-0.77l1.86,0.71l2.03,-1.09l2.19,0.62l-1.37,0.2l-0.52,1.77l-1.69,-0.63l-2.11,1.51l-3.27,5.8l-0.33,-3.29l2.58,-1.95l-2.59,-1.6l-2.74,-0.43l-2.07,-1.19l0.5,2.79l3.81,0.79l-3.18,2.49l1.97,3.35l-0.38,1.92l1.85,0.85l0.54,-2.43l1.24,4.96l2.54,0.95l0.02,0.92l-5.93,1.35l-3.89,3.14l-2.27,-0.43l-1.99,-6.17l5.9,-3.89l-2.36,-6.18l-2.68,-1.4l-2,1.78l-3.08,-0.5l0.4,0.77l-1.32,0.57l-2.5,-0.24l-0.52,-0.98l1.08,-1.86l2.16,-0.29l-0.16,-2.02l2.62,1.09l3.48,-0.94L682.5,701.9z"
				},
				{
					"id":"NZ-GIS",
					"title":"Gisborne District",
					"d":"M479.7,386.4l5.74,1.16l-0.97,1.09l1.87,2.06l5.39,0.93l2.72,2.6l-5.52,8.53l-0.63,4.7l-2.18,2.45l1.46,4.03l-2.22,2.41l1.51,1.76l-1.79,2.85l0.96,1.23l0.48,7.74l-2.5,2.77l0.42,2.83l-5.68,6.12l-2.6,1.29l-0.47,1.51l-2.18,-1.88l-2.86,2.01l-0.23,1.89l1.51,0.35l-2.35,3.56l-0.52,7.2l0,0l-2.14,-0.68l0.14,-1.67l-1.74,-1.47l-1,0.94l-1.02,-0.95l-0.84,1.15l-0.35,-0.94l-2.54,0.2l0.31,-2.83l-0.73,0.84l-1.79,-0.63l-0.3,-2.3l-1.96,0.52l-2.88,-3.13l0.11,-2.19l-2.29,-0.42l1.51,-3.03l-5.56,-1.8l0.07,2.93l-7.09,-3.6l0,0l1.68,-0.41l1.13,-2.61l2.19,-0.61l-0.7,-4.29l8.9,-4.6l1.43,-3.52l-0.42,-1.97l6.58,-3.21l1.59,-4.66l-1.25,-2.16l2.13,0.19l5.4,4.2l4.21,-13l4.04,-4.1l-1.44,-1.54l-1.61,1.47l-0.89,-1.24l1.02,-2.29l-1.05,-3.28l5.2,-1.32l-1.02,-2.64l0,0l3.29,0.44L479.7,386.4z"
				},
				{
					"id":"NZ-HKB",
					"title":"Hawke's Bay",
					"d":"M419.32,531.02l-7.06,-1.11l-2.02,-1.43l-0.77,-1.09l1.52,-1.17l-1.95,-7.07l0,0l0.8,-1.72l0,0l-2.61,-2.3l0.54,-1.61l-2.36,-1l-0.95,-1.84l-3.29,-0.9l-0.74,0.85l-1.62,-1.85l1.17,-2.14l-0.54,-1.72l2.29,-10.03l1.43,-2.22l-1.56,-1.3l0.65,-1.91l-1.56,-1.3l1.7,-0.4l2.57,-2.95l2.88,-0.6l-0.8,-3.51l1.24,-2.95l-2.77,-1.63l1.69,-2.31l-0.41,-2.02l-3.39,-1.11l-1.11,-4.46l0,0l1.95,-2.4l0,0l4.23,3.77l2.2,-0.6l-1.03,-1.49l3.01,-0.37l-1.15,-3.08l1.24,-2.93l6.44,-0.09l-0.74,-2.96l4.15,-4.32l0.46,-6.39l1.31,0.03l0.91,-1.98l1.85,0.35l2.65,-1.31l1.41,1.61l2.35,0.15l2.19,-3.85l2.47,-0.18l0.8,-1.67l0,0l7.09,3.61l-0.07,-2.93l5.56,1.8l-1.51,3.03l2.29,0.43l-0.11,2.19l2.88,3.14l1.96,-0.52l0.31,2.3l1.79,0.63l0.74,-0.84l-0.3,2.83l2.54,-0.2l0.35,0.94l0.85,-1.15l1.02,0.95l1,-0.93l1.74,1.47l-0.14,1.67l2.14,0.69l0,0l0.06,4.98l4,1.86l-3.04,2.98l-2.42,5.01l-1.69,-5.43l2.03,-3.8l-1.2,-1.22l-0.72,0.92l-6.08,-1.36l-9.95,0.65l-8.38,3.06l-6.13,3.78l-0.87,3.16l-4.08,4.2l-1.59,5.22l0.6,1.42l1.41,-0.35l-0.04,3.96l1.76,3.69l2.42,1.26l2.59,-0.29l-3.11,4.45l-0.41,5.56l-4.59,9.33l-0.6,5.32l-3.3,4.76l-4.27,2.12L419.32,531.02z"
				},
				{
					"id":"NZ-MBH",
					"title":"Marlborough District",
					"d":"M331.9,564.89l-0.58,5.97l-0.91,-0.59l-3.49,2.31l-0.98,-0.75l-2.58,1.08l5.01,-3.95l1.96,0.47l0.13,-1.55l-2.25,-0.21L331.9,564.89zM316.8,555.74l1.15,0.04l-0.35,1.33l-0.69,0.56l-1.02,-1.75l-0.56,2.72l-2.22,0.57l1.19,0.28l-0.42,0.67l-3.96,1.23l0.4,-1.57l-2.13,1.6l1.47,0.63l-1.63,1.06l0.68,2.96l1.69,-2.98l4.74,0.49l-3.21,0.87l0.57,2.18l-1.48,-0.38l-0.32,1.58l-2.29,0.46l0.3,1.07l1.67,-0.07l1.12,-0.23l0.29,1.16l-0.63,2.62l-2.17,-0.31l0.42,0.94l-1.74,0.49l0.47,1.06l1.48,-0.97l4.58,-2.1l1.65,-0.36l1.95,-1.62l2.08,0.43l1.89,-1.16l-2.7,0.37l-0.28,-1.04l-6.71,2.61l0.93,-2.12l-1.12,-1.42l2.07,-0.83l-0.79,-0.18l1.13,-0.37l0.14,-1.56l1.64,-0.33l-0.96,1.9l0.61,1.86l1.09,-2.49l2.01,0.22l-1.04,-2.02l1.15,-2.37l-4.49,0.94l0.76,-0.46l-0.68,-0.63l2.03,-0.16l-0.91,-1.21l1.23,0.1l0.73,-1.47l0.3,2.6l1.73,-1l1.57,2.89l-0.41,-2.96l1.76,1.28l0.8,-1.86l0.72,1.41l0.57,0.06l0.14,1.45l-1.23,0.18l2,1.43l0.88,-1.6l2.23,-0.29l-2.5,2.97l0.47,1.57l-0.87,-0.56l-1.49,1.42l-0.23,-2.61l-0.64,1.43l-0.67,-0.38l0.57,2.11l1.53,0.2l0.11,1.57l-1.31,0.93l-0.51,0.6l-1.22,-1.09l-1.91,1.91l-0.24,-1.25l-2.74,0.61l-1.04,1.83l2.47,0.05l4.27,-1.16l-0.45,1.32l1.64,-0.38l0.78,-0.3l3.04,-0.03l1.38,-1.5l-1.04,2.86l-2.3,1.15l0.48,1.45l-1.37,-0.45l-0.38,1.37l-2.37,0.8l2.25,-3.08l-1.12,-0.28l-0.44,-0.18l-1.26,0.73l-3.33,7.26l0.13,2.04l2.18,2.57l-1.21,1.24l3.51,0.31l1.23,7.89l3.8,0.92l-4.48,7.6l-4.36,4.88l0,0l0.41,-1.89l-3.25,0.21l-0.76,-1.14l-5.27,1.05l-1.1,1.33l-2.18,-2.31l-0.6,2.57l-2.86,2.61l-1.49,-0.28l-2.27,3.51l-2.34,0.92l-0.63,5.47l-6.64,2.84l0.2,0.79l-4.59,3.48l2.4,1.12l-0.94,0.07l-2.46,4.71l-3.21,0.66l-0.97,1.54l-1.29,-2.41l-1.9,0.15l1.56,-2.64l-2.67,-1.01l-1.11,-3.64l-1.59,0.61l-1.04,-1.05l0.82,-1.76l-1.61,-1.41l0.62,-2.55l-1.37,-0.06l-0.66,-1.48l-2.01,0.47l-0.68,-3.5l0,0l0,0l0,0l0,0l0,0l0.69,-3.43l1.97,-1.03l-0.35,-1.02l3.38,-3.86l-0.81,-1.7l3.92,-5.48l-0.81,-1.7l3.16,-1.19l2.19,-3.12l-0.02,-1.99l3.37,-1.87l0.94,-3.51l5.11,-0.27l-2.09,-2.62l1.74,-1.83l-0.39,-1.56l5.18,-4.08l-0.14,-1.67l2.51,-3.63l3.48,-1.71l1.07,-6.75l0,0l1.25,1.06l1.02,-0.09l3.86,-1.62l-0.68,-0.66l-2.17,1.2l-0.71,-1.06l2.99,-1.58l0.67,-1.63l0.8,-0.38l0.9,0.12l1.05,-2.31l0.78,0.32l-0.88,2.7l1.07,0.27l2.25,-2.34l-0.44,-0.78l2.81,-2L316.8,555.74zM315.49,548.25l-2.12,4.91l-5.07,4.15l0.86,-2.59l-1.08,0.44l0.44,-3.32l0.45,1.21l0.68,-0.43l-0.32,-1.94l0.9,-2.9l1.78,-1.43l-0.17,4.07l1.04,-1.48l1.26,0.31l0.21,-0.82l-1.86,0.03l2.57,-2.06L315.49,548.25z"
				},
				{
					"id":"NZ-MWT",
					"title":"Manawatu-Wanganui",
					"d":"M419.32,531.02L419.32,531.02L419.33,534.22L417.05,534.5L413.85,536.76L405.46,549.13L405.46,549.13L405.68,547.56L404.12,545.34L400.99,543.76L398.54,543.61L398.33,545.67L395.56,545.1L392.47,548.33L391.58,547.56L387.5,548.93L385.83,548.47L386.83,546.09L385.89,544.77L382.91,544.84L382.65,546.36L380.19,547.64L374.35,544.62L373.09,547.1L370.44,546.18L369.5,547.69L366.32,548.39L363.32,547.89L364,546.5L361.24,545.24L361.24,545.24L364.48,533.58L364.79,524.67L363.61,517.79L357.12,507.79L352.04,503.44L347.41,502.3L347.41,502.3L346.75,501.86L348.43,499.42L353.41,496.5L353.34,493.48L355.92,492.46L354.91,488.99L356.06,486.32L354.54,483.07L351.75,480.85L350.96,478.69L351.93,477.21L349,474.78L350.88,470.76L353.13,470.71L354.12,467.32L355.81,466.93L355.23,466.06L356.97,464.29L359.1,464.56L358.06,462.51L354.75,462.42L354.42,459L353.27,459.72L351.35,458.28L351.65,454.35L350.82,453.58L349.56,454.61L348.55,453.09L347.86,450.09L350.89,447.84L350.89,447.84L353.98,446.66L354.39,442.42L360.71,440.28L365.46,440.62L367.31,438.56L368.26,439.01L368.91,436.6L369.4,438.3L372.6,436.8L375.78,437.2L377.33,439.04L381.04,437.34L376.49,446.94L378.92,450.06L377.47,452.25L379.07,454.62L378.24,458.2L382.97,457.99L380.16,461.54L381.65,464.22L377.97,472.77L387.73,474.12L390.13,472.35L389.54,471.49L391.05,470.35L390.72,469.39L393.81,468.17L394.11,466.69L402.27,466.19L402.27,466.19L403.38,470.66L406.77,471.77L407.18,473.78L405.49,476.09L408.26,477.72L407.02,480.67L407.82,484.19L404.94,484.79L402.37,487.74L400.67,488.14L402.23,489.44L401.58,491.35L403.15,492.65L401.72,494.87L399.42,504.9L399.96,506.62L398.79,508.76L400.41,510.6L401.15,509.75L404.44,510.65L405.39,512.49L407.75,513.49L407.22,515.1L409.83,517.41L409.83,517.41L409.03,519.13L409.03,519.13L410.98,526.2L409.47,527.38L410.24,528.47L412.26,529.9z"
				},
				{
					"id":"NZ-NSN",
					"title":"Nelson City",
					"d":"M290.65,571.88L290.65,571.88L291.42,573.19L289.52,574.51L290.09,576.55L287.07,578.29L286,577.31L286,577.31L286.1,575.74L290.27,573.17z"
				},
				{
					"id":"NZ-NTL",
					"title":"Northland",
					"d":"M278.49,235.78l1.62,1.08l-1.71,0.56l0.01,3.83l-1.62,0.63l0.19,-1.31l-1.87,-0.14l-0.02,1.15l-1.85,-0.03l0.79,0.66l1.94,-0.05l-0.46,1.27l1.09,0.12l0.55,2.13l0.42,-1.39l-1.24,-1.82l1.26,-0.23l1.93,6.8l5.38,6.09l-0.78,1l1.54,2.13l3.33,1.04l-1.61,2.12l0.14,2.8l0.97,0.15l1.52,0.29l-0.69,-1.7l1.8,-0.64l-1.92,-4.36l3.98,-1.24l0.97,-0.16l1.45,-0.44l0.83,1.22l-3.95,2.23l1.75,3.72l3.94,0.7l1.66,-3.67l3.38,2.58l1.81,-0.89l2.29,3.17l-1.68,1.75l0.59,1.08l1.01,-0.03l0.03,-1.72l1.13,0l-0.59,-1.47l2.16,-0.97l1.69,1.57l1.42,-0.48l2.74,5.25l4.16,-0.4l2.04,2.12l-2.3,1.82l-2.29,-2.57l-0.99,0.77l1.27,1.56l-1.59,0.88l3.76,0.19l0.37,3.01l2.42,2.17l2.9,0.28l-1.12,-1.17l-1.68,-0.81l-1.1,-2.1l3.54,2.04l0.16,-1.46l1.58,-1.66l1.19,0.43l0.41,-1.92l1.58,-0.72l-1.67,2.96l1.27,0.98l-1.08,0.83l2.13,2.99l1.25,1.25l-0.43,0.96l-1.54,-2.08l-0.4,1.07l2.04,2.54l-0.4,1.1l2.71,-0.37l-0.18,1.28l2.08,2.67l-0.95,0.37l0.69,1.75l2.45,1.14l-0.02,2.94l-0.89,-0.5l-0.39,1.92l0.78,2.05l1.74,0.14l-0.79,3.36l1.7,3.2l-2.65,-0.15l-1.82,-3.78l-4.56,0.18l-0.37,-1.3l-0.86,3.15l1.49,-1.28l0.36,1.34l4.93,1.03l-1.15,1.49l-0.36,3.87l1.56,3.68l1.3,1.05l1.84,-0.27l1.35,3.82l0,0l-1.42,2.36l-2,0.76l-0.12,1.34l-2.01,0.75l0,0l-0.39,1.41l0,0l-2.69,1.38l0,0l-0.95,-0.58l-1.29,1.96l-2.73,-1.48l1.42,-2.07l0.53,-0.32l2.15,-1.53l-0.51,-0.11L329.28,323l0.07,-1.04l-1.97,-0.98l-1.17,-0.59l0.64,-2.4l-2.17,0.35l-0.03,1.82l0.33,0.96l0.99,0.84l1.29,-0.54l1.24,2.14l-2.58,1.27l-4.15,-4.5l-2.36,0.13l-2.9,-2.49l4.35,6l2.31,1.49l0.94,2.83l-1.43,2.62l-3.83,0.27l-1.79,-5.89l-3.66,-6.44l-21.14,-28.34l2.31,-6.1l3.76,-0.6l2.74,-2.93l-1.73,-0.51l-0.69,2.44l-4.29,0.54l-2.35,5.99l-11.75,-15.62l0.37,-1.42l2.66,0.6l1.34,-1.9l-0.89,-7.14l-11.5,-16.99l-7.59,-7.16l0.94,-2.64l5.13,1.58l1.77,-1.87l4.36,0.54L278.49,235.78z"
				},
				{
					"id":"NZ-OTA",
					"title":"Otago",
					"d":"M504.14,1040.38l-0.35,3.12l-1.27,0.24l-1.15,-1.87L504.14,1040.38zM96.7,745.5l5.17,-0.39l1.44,-1.46l3.05,-0.52l3.98,-3.31l2.2,1.33l3.62,-4.4l0.48,-5.07l0.89,-1.24l3.71,-1.05l0.33,-3.17l1.64,-0.6l-0.2,-0.84l5.03,-2.13l0.68,1.57l3.79,0.13l2.32,-2.66l0.88,2.4l1.61,0.92l3.24,-3.31l4.76,-1.46l0.39,-4.05l4.34,0.48l0,0l0.58,3.99l-1.24,0.16l-1.63,4.23l-0.97,0.06l-0.41,1.97l-2.58,2.78l1.58,2.44l-0.4,7.76l0,0l-0.41,1.99l0,0l-0.66,0.55l1.33,1.02l2.8,0.16l-0.33,6.86l2.96,0.4l0.68,-2.1l1.17,4.46l2.89,1.35l2.12,-1.43l1.99,0.46l1.97,9.4l2.92,3.5l0.93,3.04l4.85,-0.34l3.89,-1.83l1.13,0.18l0.89,2.44l2.04,-0.49l3.94,-2.8l2.3,-4.32l10.33,4.54l11.15,2.34l0,0l-2.36,4.34l-4.17,4.16l0.07,1.71l-2.34,1.74l-2.32,4.8l-1.48,4.6l0.23,1.64l1.57,1l-2.31,3.75l0.82,1.89l-2.99,3.3l-1.19,3.44l-2.17,1.16l-0.65,3.1l-3.24,2.92l-0.02,1.15l2.7,-0.39l2.71,2.27l-3.11,0.98l-0.01,1.32l1.66,0.73l3.16,-1.72l-0.14,2.37l-0.09,1.64l-2.3,0.98l-0.93,0.68l-2.19,-0.42l-0.92,0.36l-3.53,0.45l-7.64,2.84l-3.77,5.24l-1.14,5.57l-10.86,9.01l-3.73,1.74l-0.62,2.9l0.8,2.7l-0.97,1.35l-0.89,0.79l-1.19,0.43l-0.98,1.66l-3.37,1.21l-1.08,2.1l-1.25,-1.14l-2.89,0.09l-1.25,2.39l-2.68,0.31l-0.89,1.74l-2.83,-0.97l-3.52,1.87l0,0l1.13,-3.46l-0.96,-1.59l1.28,-0.2l1.11,-2.09l-3.54,-2.79l1.58,-3.54l-2.59,-1.87l2.24,-2.49l0.59,-7.27l-2.94,-2.99l1.57,-1.89l-1.13,-1.78l0.79,-0.94l-3.41,-3.75l1.1,-6.45l-1.56,-1.92l-1.94,0.75l0.97,-2.27l-1.34,-4.85l1.23,-4.57l2.97,-3.98l1.6,-7.2l2.82,-2.02l-5.53,-8.19l-2.27,1.8l-5.03,8.8l-1.39,-1.66l-0.78,0.93l-2.02,-0.49l-0.14,-4.01l-3.36,-1.54l-0.65,-5.37l-5.11,3.8l-8.57,1.03l-0.8,-5.63l-3.4,-4.33l1.89,-3.5l0.99,-0.06l0.78,-3.08l-0.47,-0.75l-2.21,0.82l-4.42,-4.86l0.47,-1.41l-1.14,-2.36l0.55,-2.36l1.69,-0.01l1.41,-4.22l-1.54,-1.89l2.75,-7.46l-0.28,-2.04l2.23,-2.36L96.7,745.5z"
				},
				{
					"id":"NZ-STL",
					"title":"Southland",
					"d":"M129.95,1214.23l1.06,0.21l0.19,4.62l1.42,0.48l-1.26,0.82l0.2,0.76l-1.38,1.68l-0.86,0.13l-1.47,-0.55l-0.56,0.83l-1.88,-2.75l-1.78,0.21l-0.91,-1.56l1.04,-0.81l2.28,1.16l2.23,-4.07l-0.84,-0.62L129.95,1214.23zM2.17,1112.29l2.21,1.45l2.97,-0.02l0.76,-1.04l5.16,2.09l-5.33,2.93l-1.74,-1.36l-2.75,-0.21l-0.18,-1.4l-1.43,0.35l-0.72,-1.98L2.17,1112.29zM12.11,1092.04l0.85,0.9l1.43,-0.44l1.28,0.66l0.8,0.56l-1.19,0.8l1.02,1.9l-2.93,-0.07l0.9,2.32l-0.74,0.63l-0.15,1.69l-0.78,1.21l0.46,1.02l0.13,0.96l-2.66,-0.08l1.19,1.04l-0.95,0.56l1.93,0.39l1.08,2.03l0.22,1.11l0.58,1.91l0.02,1.61l-2.77,0.71l-3.64,-3.3l-0.32,0.03l-0.32,-2.73l-1.65,-1.11l-0.48,1.54l-0.56,0.11l-0.41,0.83l1.25,1.36l-0.81,0.62l0.9,2.11l-3.1,-0.68l-0.67,-1.75l-1.44,1.77l-0.19,-4.41l5.86,-3.3l2.15,-2.63l-0.56,-1.72l1.21,-4.02l-1.51,-1.04l1.21,-0.62l-0.92,-0.98l-1.3,0.38l3.69,-2.03L12.11,1092.04zM78.02,866.87l4.21,2.11l1.14,4.05l3.29,2.27l-0.31,1.29l2.39,0.33l0.78,1.99l-0.93,0.95l-2.95,-0.91l-0.75,1.35l-1.58,-1.47l-1.5,0.75l0.47,1.27l1.37,-0.33l0.36,1.52l4.18,0.4l-2.24,1.55l2.01,0.43l0.75,-1.36l1.06,-0.72l-0.15,-0.98l1.08,-1.07l-0.65,3.07l2.04,2.36l-2.51,2.58l0.18,1.03l-1.82,2.66l-1.92,-1.14l-1.2,1.4l-3.67,-0.06l-2,2.4l-3.03,1.25l-2.42,-1.19l-1.41,0.62l-0.96,-1.78l-1.15,0.92l0.26,1.54l-0.78,1.63l-0.43,2.41l-1.28,0.4l0.24,-1.39l-3.04,2.47l-1.91,-1.12l-1.47,0.43l0.55,-3.58l4.22,-2.85l-0.1,-1l0.62,-1.96l-1.15,-1.35l2.4,-2.82l3.5,0.19l-1.69,-5.68l0.64,-0.36l-0.09,1.47l1.82,-0.25l1.55,-2.58l-0.62,-3.77l-1.97,-2.99l0.69,-4.59l2.68,-1.58l1.78,0.96L78.02,866.87zM26.22,814.03l1.01,0.66l-1.84,1.2l-1.46,-0.39l0.21,-1L26.22,814.03zM31.68,805.95l1.39,1.56l0.3,4.05l-1.46,2.73l-3.81,0.41l0.01,-1.83l-1.81,-0.67l1.57,-0.7l-1.03,-1.66l-4.29,4.31l3.76,-6.83L31.68,805.95zM42.73,781.22l-0.55,2.93l2.09,5.18l-1.06,0.31l-4.26,-3.4L42.73,781.22zM86.89,733.44l2.22,0.65l3.38,-1.6l4.28,1.4l0,2.13l2.82,2.29l-2.65,2.22l0.9,0.89l-1.13,4.09l0,0l-1.96,0.12l-2.23,2.36l0.28,2.04l-2.75,7.46l1.54,1.89l-1.41,4.22l-1.69,0.01l-0.55,2.36l1.14,2.36l-0.47,1.41l4.42,4.86l2.21,-0.82l0.48,0.75l-0.78,3.08l-0.99,0.06l-1.89,3.5l3.4,4.33l0.8,5.63l8.57,-1.03l5.11,-3.8l0.65,5.37l3.36,1.54l0.14,4.01l2.02,0.49l0.78,-0.92l1.39,1.66l5.03,-8.8l2.27,-1.8l5.53,8.19l-2.82,2.02l-1.6,7.2l-2.97,3.98l-1.23,4.57l1.34,4.85l-0.97,2.28l1.94,-0.75l1.56,1.93l-1.1,6.45l3.41,3.75l-0.79,0.95l1.13,1.79l-1.57,1.89l2.94,2.99l-0.59,7.27l-2.24,2.5l2.59,1.87l-1.58,3.54l3.55,2.79l-1.11,2.09l-1.28,0.2l0.96,1.6l-1.12,3.46l0,0l-2.11,-0.42l1.27,-1.3l-1.57,-1.1l-0.86,3.34l-1.46,0.48l-8.7,-0.65l-0.56,-2.91l-1.56,-1.61l-3.03,-0.7l-4.71,0.99l0.25,-1l1.54,0.02l-1.7,-0.89l-1.76,0.33l1.35,1.48l-2.54,1.24l-5.91,-0.22l0.37,-1.62l-1.06,-2.18l-1.93,0.85l2.32,3.47l-1.2,0.75l-2.43,-3.91l-1.47,-0.2l-0.25,-1.99l5.91,-1.75l-1.11,-0.76l-0.65,-1.18l-1.86,0.53l0.94,1.9l-1.23,0.31l-2.75,-5.72l-2.95,-2.96l-2.96,-0.25l-1.2,1.14l0.66,1.26l-4.88,-1.55l-1.33,0.7l-2.04,-0.06l-1.7,1.26l-1.89,-1.42l-0.16,-1.76l0,-2.11l-0.56,-2l-3.88,-3.77l-4.42,-2.23l-3.86,-0.15l-1.98,2.39l-0.38,3.25l-4.95,0.61l-13.38,-2.96l-3.63,1.3l-0.57,-1.04l-3.73,-0.25l-2.44,-3.01l4.13,-2.45l0.45,-2.31l-1.08,-0.92l-2.01,1.57l-1.21,-1.32l-1.8,1.81l2.07,-5.93l5.85,-1.03l-0.27,-1.27l-4.58,0.18l-1.97,1.26l-4.85,2.35l-0.92,-0.79l-0.88,-5.25l0.91,-4.94l15.16,-2.93l3.65,-2.04l-4.32,-1.23l-3.61,1.28l0.91,-3.33l7.25,-2.04l1.22,-1.44l-9.15,3.35l-0.18,-3.86l5.52,-2.43l0.46,-0.05L43,800.57l-9.03,4.38l-2.65,-0.23l3.11,-9.66l2,-0.34l-1.21,-0.88l0.82,-2.99l2.01,-2.76l4.14,2.36l0.72,0.17l2.33,1.73l1.57,0.57l1.82,4.7l0.74,-0.25l-1.98,-4.62l-2.99,-2.37l1.06,-1.3l4.29,-0.28l0.06,-1.21l-5.24,0.78l-1.41,-3.44l0.71,-2.92l-0.78,-1.46l1.55,-1.91l3.52,4.45l0.1,-0.44l-3.07,-4.04l2.01,-2.89l1.12,1.07l-0.63,-2.46l1.71,-1.25l0.02,-0.98l7.41,-7.73l1.98,3.62l-0.35,1.84l1.36,0.92l-0.82,2.04l1.18,-1.33l1.16,0.58l-2.27,-2.65l0.8,-0.37l-1.9,-5.78l3.59,-2.75l1.64,0.18l0.2,-1.29l1.41,-1.26l1.16,-0.66l0.2,-1.78l1.91,-1.44l0.72,-0.93l4.11,-2.07l0.49,-1.3l1.27,-0.47l1.67,1.83l-0.4,-5.96l4.47,-5.76l3.4,-0.98l-0.94,-2.4l3.83,0.15l0.98,-2.13L86.89,733.44z"
				},
				{
					"id":"NZ-TAS",
					"title":"Tasman District",
					"d":"M301.63,563.39L301.63,563.39l-1.07,6.75l-3.48,1.71l-2.51,3.63l0.14,1.67l-5.18,4.08l0.39,1.56l-1.74,1.83l2.09,2.62l-5.11,0.27l-0.94,3.51l-3.37,1.87l0.02,2l-2.19,3.12l-3.16,1.19l0.81,1.7l-3.92,5.49l0.81,1.7l-3.37,3.86l0.35,1.02l-1.96,1.03l-0.69,3.44l0,0l-3.27,0.08l0.4,1.59l-1.28,1.07l-0.2,2.68l-5.07,3.39l0,0l-1.77,1.84l-2.84,-1.24l-0.95,-6.91l-3.28,0.08l-1.86,-2.78l-2.6,0.11l-1.44,-2.65l0.83,-1.76l-1.69,-0.53l-1.32,-2.98l1.25,-1.62l-0.51,-1.25l1.83,-1.25l0.08,-4.35l-0.88,-0.82l0.79,-2.3l3.96,-2.02l1.3,0.95l-0.52,-3.23l3.57,-1.6l0.47,-4.71l3.11,-2.28l-0.09,-3.08l1.71,-0.92l1.98,0.97l2.99,-1.96l0.51,-4.18l-1.22,-1.82l3.59,-1.05l1.35,-1.93l-2.46,-0.22l-0.69,-2.03l-5.21,-5.48l0.31,-1.55l-4.31,-0.09l-2.16,2.24l-0.68,-2.59l3.03,-3.42l-3.28,-1.03l-1.68,-3.62l-1.16,0.73l0.48,-3.29l-1.1,-1.8l0,0l12.21,-9.79l-0.76,2.36l4.67,-2.32l-0.26,-1.56l-2.99,1.53l3.44,-3.72l6.38,-0.37l7.75,1.79l0.77,0.68l-10.23,-1.87l-2.98,3.62l-0.06,3.21l-0.93,0.43l3.15,5.89l4.79,3.62l2.5,-2.27l1.04,1.25l0.21,-1.75l1.78,-0.36l0.97,3.74l1.34,0.08l-0.59,4.67l1.03,0.72l-1.87,2.88l-0.79,2.36l1.3,1.82l-1.17,2.46l3.14,3.3l0.89,2.11l-1.39,0.58l0.6,1.18l2.65,0.18l1.88,2.06l0,0l1.07,0.97l3.02,-1.74l-0.56,-2.03l1.89,-1.33l-0.77,-1.3l0,0l0.02,-1.1l3.09,-2.4l1.14,0.97l2.01,-1l1.18,-2.62l3.12,-2.7L301.63,563.39z"
				},
				{
					"id":"NZ-TKI",
					"title":"Taranaki",
					"d":"M340.94,444.3l0.14,0.05l0,0l1.7,1.43l5.77,-0.03l2.35,2.09l0,0l-3.03,2.25l0.69,3l1.01,1.52l1.26,-1.03l0.83,0.77l-0.3,3.93l1.93,1.44l1.15,-0.72l0.33,3.42l3.31,0.08l1.05,2.05l-2.13,-0.27l-1.74,1.77l0.58,0.87l-1.69,0.39l-0.99,3.4l-2.25,0.05l-1.88,4.02l2.93,2.43l-0.97,1.48l0.8,2.17l2.79,2.21l1.52,3.26l-1.15,2.66l1.02,3.47l-2.58,1.02l0.07,3.02l-4.98,2.92l-1.68,2.44l0.66,0.44l0,0l-2.33,0.32l-6.21,-2.58l-5.53,-4.3l-3.11,-4.22l-4.72,-2.75l-5.46,-0.82l-6.48,-2.94l-4.67,-5.43l-1.57,-6.59l1.56,-4.42l9.23,-6.84l2.36,-0.25l4.34,-3.14l6.4,0.26l2.91,-1.41l4.72,-5.46L340.94,444.3z"
				},
				{
					"id":"NZ-WKO",
					"title":"Waikato",
					"d":"M370.39,334.59l1.77,0.09l1.14,1.58l0.55,1.17l1.28,-0.86l1.75,1.57l-0.81,2.54l2.59,1.29l0.16,2.16l-1.18,-0.04l0.16,1.16l1.87,-0.21l0.84,1.68l-0.71,1.79l6.74,-3.07l1.55,1.26l0.16,1.1l-2.74,0.9l-0.26,1.55l-1.87,0.81l-1.01,2.98l0.71,0.66l1.2,-2.46l1.7,-0.6l2.25,1.55l1.84,7.22l0.77,3.11l0.02,6.42l-1.22,-1.39l-0.12,1.22l3.16,8.91l0,0l-1.4,1.56l0.48,1.16l-2.13,1.56l1.52,1.84l-1.56,0.04l-0.98,-1.51l-0.97,1.43l1.01,2.03l-0.99,0.9l4.6,10.78l-0.76,2.68l1.34,0.56l-0.02,1.88l1.4,1.6l-1.39,0.79l0.49,1.68l6.05,5.17l2.61,0.07l1.91,1.4l3.28,10.53l6.31,2.65l1.56,1.81l-1,6.58l-3.49,-1.33l-1.25,2.91l-2.29,-0.99l0.92,-1.97l-0.72,-1.06l-5,1.67l-1.52,-3.18l-2.31,2.78l-1.06,-0.13l-0.09,2.73l2.08,-0.27l0.47,1.17l4.01,1.14l-1.84,3.95l3.28,3.85l-1.61,1.44l-4.02,-1.13l-0.78,2.2l3.57,6.19l2.86,-0.58l0.92,7.51l-1.91,1.02l0,0l-1.95,2.4l0,0l-8.16,0.5l-0.3,1.48l-3.09,1.22l0.33,0.96l-1.51,1.14l0.59,0.86l-2.4,1.77l-9.76,-1.35l3.68,-8.54l-1.49,-2.69l2.81,-3.54l-4.74,0.21l0.83,-3.58l-1.6,-2.37l1.45,-2.19l-2.43,-3.13l4.55,-9.6l-3.71,1.7l-1.55,-1.83l-3.18,-0.4l-3.2,1.5l-0.49,-1.7l-0.65,2.41l-0.95,-0.45l-1.85,2.06l-4.75,-0.35l-6.31,2.14l-0.42,4.23l-3.09,1.18l0,0l-2.35,-2.09l-5.77,0.03l-1.7,-1.43l0,0l0.69,-15.91l3.14,-3.95l-0.06,-5.16l-1.4,-4.37l2.21,0.52l1.59,-1.82l-0.39,1.54l1.21,0.81l0.79,0.6l1.45,-0.87l-1.36,-0.04l0.37,-1l3.41,-1.62l-1.09,-1.35l-1.58,0.68l-0.29,-0.99l-2.24,1.99l0.61,-3.08l1.08,-0.66l0.91,0.85l1.58,-3.13l-2.46,-0.25l0.25,1.85l-1.47,0.72l-1.49,-7.06l0.78,-1.65l2.63,-1.31l4.06,0.22l0.8,-0.97l-2.63,0.15l-1.41,-0.81l-1.01,1.23l-2.73,-11.6l-2.62,-6.17l0.04,-3.11l1.49,0.57l2.6,-3.08l0,0l1.61,-0.96l0.09,-1.36l2.61,0.64l0.18,-2.72l2.34,0.2l0.74,-1.33l-2.57,-3.56l0.49,-0.71l2.09,0.82l2.55,-4.9l3.27,1.17l0.07,-1.87l2.09,0.81l3.04,-1.79l0,0l0.63,6.53l1.38,3.04l2.64,0.66l5.25,-2.05l-1.55,-9.54l-3.64,-5.89l1.12,-0.42l0.25,-1.86l2.48,-0.9l-2.91,-3.46l0.23,-5.08l-4.26,-4.3l0.02,-2.04L370.39,334.59z"
				},
				{
					"id":"NZ-WGN",
					"title":"Wellington",
					"d":"M353.91,551.22l-0.43,1.64l-2.53,1.69l1.94,-3.32L353.91,551.22zM361.24,545.24l2.76,1.26l-0.68,1.4l3.01,0.5l3.17,-0.7l0.94,-1.5l2.65,0.91l1.26,-2.48l5.84,3.02l2.46,-1.27l0.27,-1.52l2.98,-0.07l0.94,1.32l-1,2.38l1.67,0.46l4.08,-1.37l0.89,0.77l3.09,-3.23l2.77,0.58l0.21,-2.06l2.45,0.14l3.13,1.59l1.56,2.22l-0.22,1.57l0,0l-1.55,6.26l-3.28,2.9l-2.87,8.39l-2.83,2.87l-1.3,3.44l-3.25,1.62l-2.71,4.39l-5.27,2.74l-9.51,8.24l-2.52,-0.02l-3,2.17l-2.18,-0.34l-1.58,-4.24l0.89,-4.85l-2.81,-1.76l0.01,-1.56l-4.01,0.27l-4.83,3.43l-1.98,-1.52l-0.77,-2.66l2.51,-5.21l-0.97,-1.39l-1.25,-0.3l-2.67,2.16l0.57,2.49l1.38,-1.05l-0.63,2.66l-0.77,-0.94l-3.31,1.85l-2.26,-1.09l-1.78,-2.93l1.22,-2.51l2.7,-0.93l3.56,-5.59l1.74,-1.16l-0.1,-2.03l3.63,-2.53l1.73,-6.03l2.97,-2.92L361.24,545.24z"
				},
				{
					"id":"NZ-WTC",
					"title":"West Coast",
					"d":"M247.53,548.79l1.1,1.8l-0.48,3.29l1.16,-0.72l1.68,3.62l3.28,1.03l-3.02,3.42l0.69,2.59l2.16,-2.24l4.31,0.09l-0.31,1.55l5.21,5.48l0.69,2.03l2.46,0.23l-1.35,1.93l-3.59,1.05l1.22,1.83l-0.5,4.18l-2.98,1.96l-1.98,-0.97l-1.7,0.92l0.09,3.09l-3.11,2.28l-0.47,4.71l-3.57,1.6l0.52,3.23l-1.3,-0.95l-3.96,2.02l-0.79,2.3l0.88,0.82l-0.08,4.35l-1.82,1.25l0.51,1.25l-1.25,1.62l1.33,2.98l1.69,0.53l-0.83,1.76l1.44,2.65l2.6,-0.11l1.86,2.78l3.29,-0.08l0.95,6.91l2.84,1.24l1.78,-1.84l0,0l-1.24,5.14l-3.88,1.2l-2.38,2.96l-2.02,0.49l-2.13,4.34l-2.25,1.16l-0.73,2.93l-5.01,1.06l0.2,0.81l-2.14,0.83l-1.45,4.39l-4.94,2.21l0.06,2.63l-1.3,1.1l0.74,0.6l-1.41,1.44l-1.86,-0.76l-5.84,1.38l-0.89,-0.83l-1.88,0.73l-1.48,2.35l-1.59,-0.86l-2.31,0.59l0.2,0.81l-3.03,2.05l-0.43,3.42l-4.36,1.08l-0.45,1.36l-1.01,-0.5l-1.49,2.35l0.63,0.94l-2.68,3.1l-1.51,0.28l-0.79,-1.18l-4.06,5.12l-4.8,0.95l0.52,1.29l-2.81,1.38l0.63,0.95l-1.75,2.45l-3.15,-1.17l-5.03,4.6l-1.87,0.72l-0.95,-1.42l-3.85,1.77l-3.38,3.99l-2.02,0.48l0.03,3.59l-2.24,1.17l0.04,2.09l-2.25,1.17l-0.08,2.43l-2.95,1.12l0.09,1.17l-1.39,-0.07l-6.11,7.1l0,0l-4.34,-0.48l-0.39,4.05l-4.76,1.46l-3.24,3.31l-1.6,-0.92l-0.87,-2.4l-2.32,2.66l-3.79,-0.13l-0.68,-1.57l-5.03,2.13l0.2,0.84l-1.64,0.6l-0.33,3.17l-3.71,1.05l-0.89,1.24l-0.48,5.07l-3.62,4.4l-2.2,-1.33l-3.98,3.31l-3.05,0.52l-1.44,1.46l-5.17,0.39l0,0l1.13,-4.09l-0.9,-0.88l2.66,-2.22l-2.82,-2.29l0,-2.13l-4.28,-1.39l-3.38,1.6l-2.22,-0.65l0,0l-1.77,-0.99l7.86,-5.72l4.34,-7.87l5.76,-0.29l4.38,-2.46l0.78,2.06l2.32,0.02l5.21,-2.2l12.29,-10.98l7.51,-4.28l1.13,-1.64l5.02,-0.72l1.97,-2.18l1.34,0.8l3.89,-2.8l4.12,-6.83l7.29,-3.34l2.68,-3.97l4.88,-3.91l3.34,-5.47l4.96,0.06l-0.07,-1.09l-0.97,0.02l1.83,-2.47l6.33,-1.97l11.64,-9.6l10.51,-14.5l3.07,-8.86l3.43,-5.92l1.11,-8.23l5.11,-13.13l-0.27,-5.66l10.17,-1.6l6.16,-5.94l4.23,-8.42l3.12,-3.09l1.64,-11.33l-0.32,-13.77L247.53,548.79z"
				}
			]
		}
	}
};