(function() {
    var o_o = utils.o_o,
        PAGE_PARAMS = $('.page-params')[0] && $('.page-params')[0].onclick();

    o_o.decl('dropdown-tree', {
        
        init: function() {
            var _this = this;

            this.domElem.on('click', function() {
                _this.loadBrothers();
            });
        },

        loadBrothers: function() {
            if (this._loaded) return;

            this.toggleButton();

            utils.catAjax({
                data: {
                    action: 'getCategoryChildren',
                    catid: this.params.parentId,
                    lang: PAGE_PARAMS.lang
                },
                success: function(data) {
                    this.getDropdown(this.sortCategories(data.children))
                        .toggleButton()
                        ._loaded = true;
                },
                error: this.toggleButton
            }, this);
        },

        sortCategories: function(categories) {
            var newCategories = {};

            categories.forEach(function(c) {
                var categoryName = c.categoryName,
                    name = categoryName.split(' _ ');

                if (name.length == 1) {
                    if (newCategories[categoryName]) {
                        newCategories[categoryName].catid = c.catid;
                    } else {
                        newCategories[categoryName] = {
                            catid: c.catid,
                            virtualBands: []
                        };
                    }
                } else {
                    var virtualName = name[0],
                        catName = name[1];
                    var parentcatid = c.catid.replace(/^v\d+/, '');

                    newCategories[catName] || (newCategories[catName] = {
                        catid: parentcatid,
                        virtualBands: []
                    });

                    newCategories[catName].virtualBands || (newCategories[catName].virtualBands = []);

                    newCategories[catName].virtualBands.push({ name: virtualName, catid: c.catid });
                }
            });

            return newCategories;
        },

        getDropdown: function(categories) {
            var result = [],
                categoriesKeys = _.keys(categories).sort(),
                dropdownMenu = $('<ul class="dropdown-menu categories-tree__dropdown_scroll_yes" role="menu"></ul>'),
                getVirtualBands = function(bands) {
                    return bands.map(function(band) {
                        return  '<a class="categories-tree__virtual" href="' + utils.getCatUrl(band.catid, PAGE_PARAMS.urlOpts) + '">' + band.name + '</a>';
                    }).join('·');
                };

            categoriesKeys.map(function(name, index) {
                var category = categories[name];

                index && result.push($('<li role="presentation" class="divider"></li>'));

                result.push($(
                    '<li>' +
                        '<a class="categories-tree__neighbors-link" href="' + utils.getCatUrl(category.catid, PAGE_PARAMS.urlOpts) + '">' + name +'</a>' +
                    '</li>' +
                    (category.virtualBands.length ?
                        ('<li>' +
                            '<div class="categories-tree__virtual-wrap">' + getVirtualBands(category.virtualBands) + '</div>' +
                        '</li>') :
                        '')
                ));
            });

            this.domElem.after(dropdownMenu.append(result));

            return this;
        },

        toggleButton: function() {
            this.domElem.toggleClass('btn_spinner_visible');

            return this;
        },

        _loaded: false

    });

    /**
     * Блок «Редактирование флагов».
     */
    o_o.decl({ className: 'category-flags', baseClass: 'spinner' }, {

        /**
         * Вызывается стразу после загрузки страницы.
         * Подписывается на клики кнопкам флагов, «Сохранить» и «Отмена».
         */
        init: function() {
            var _this = this;

            this._saveButton = this.getEditorElem('.flags-editor__save-btn')
                .on('click', function() {
                    if ($(this).hasClass('btn_spinner_visible')) return;

                    _this.saveCategoryFlags();
                });

            this.getEditorElem('.flags-editor__cancel')
                .on('click', function() {
                    if (_this._saveButton.hasClass('btn_spinner_visible')) return;

                    _this.onCancelClick();
                });

            utils.catAjax({
                data: {
                    action: 'setCategoryFlags',
                    catid: PAGE_PARAMS.catid
                },
                success: function(data) {
                    this._currentFlags = this._savedFlags = [].concat(
                        (data.dictionaryFlags || []).map(function(item) { return item.flag; }),
                        data.userFlags || []);

                    this.elem('.category-flags__add-btn')
                        .removeClass('btn_spinner_visible');

                    this.bindAddButton()
                        .repaintFlags(data);
                },
                error: this.toggleSaveButton
            }, this);

        },

        bindAddButton: function() {
            var _this = this;

            this.elem('.category-flags__add-btn')
                .on('click', function() {
                    _this._flagsList || _this.openPopup($(this).attr('data-target'));
                })
                .attr('data-toggle', 'modal');

            return this;
        },

        bindToggleCheked: function() {
            var _this = this;

            this.getEditorElem('.flags-editor__toggle-cheked')
                .on('click', function() {
                    _this.onToggleCheked($(this));
                });

            return this;
        },

        onToggleCheked: function(button) {
            var _this = this;

            this._rows || (this._rows = $('.flags-editor__row', this.getEditorElem('.flags-editor__table-body')));

            if (button.hasClass('only-checked')) {
                for (var i = 0; i < this._rows.length; i++) {
                    this._rows.eq(i).show();
                }

                button.text('Показать только выбранные');
            } else {
                this._checkboxes.each(function(index, checkbox) {
                    checkbox.checked || _this._rows.eq(index).hide();
                });

                button.text('Показать все');
            }

            button.toggleClass('only-checked');
        },

        /**
         * Загружает список всех существующих флагов.
         *
         * @param target {string} id попапа.
         */
        openPopup: function(target) {
            this._flagsList = [];
            this._popup = $(target);

            this.addSpinner(this.getEditorElem('.flags-editor__content'));

            utils.catAjax({
                data: {
                    action: 'getFlagsList'
                },
                success: function(data) {
                    var flagsNodes = [];

                    data.result.forEach(function(item) {
                        flagsNodes.push(this.getRow(item.flag, item.description));
                        this._flagsList.push(item.flag);
                    }, this);

                    this
                        .removeSpinner(this.getEditorElem('.flags-editor__content'))
                        .bindToggleCheked()
                        .getEditorElem('.flags-editor__table-body').append(flagsNodes);

                    this._checkboxes = $('.flags-editor__item', this._popup);
                    this.elem('.category-flags__add-btn').unbind('click');
                },
                error: function() {
                    this._flagsList = null;
                }
            }, this);
        },

        /**
         * Строит строку с чекбоксом и информацией о флаге.
         *
         * @param flag {string} имя флага
         * @param description {string} описание флага
         * @returns {jQuery}
         */
        getRow: function(flag, description) {
            return $(
                '<tr class="flags-editor__row">' +
                    '<td class="flags-editor__cell">' +
                        '<div class="checkbox flags-editor__checkbox">' +
                            '<label>' +
                                '<input type="checkbox" name="' + flag + '" class="flags-editor__item"'+ (~this._currentFlags.indexOf(flag) ? ' checked="checked"' : '') + '> ' +
                                '<span class="badge category-flags__item">' +
                                    flag +
                                '</span>' +
                            '</label>' +
                        '</div>' +
                    '</td>' +
                    '<td class="flags-editor__cell">' + description + '</td>' +
                '</tr>'
            );
        },

        /**
         * Находит и кэширует элементы попапа.
         *
         * @param selector {string} класс элемента.
         * @returns {jQuery}
         */
        getEditorElem: function(selector) {
            this._editorElems || (this._editorElems = {});

            return this._editorElems[selector] || (this._editorElems[selector] = $(selector, this._popup).first());
        },

        _editorElems: null,

        /**
         * Возвращает чекбоксы в исходное состояние.
         */
        onCancelClick: function() {
            var savedFlags = this._savedFlags;

            if (!this._checkboxes || !savedFlags) return;

            this._checkboxes.each(function(index, checkbox) {
                checkbox = $(checkbox);
                checkbox.prop({ checked:  !!~savedFlags.indexOf(checkbox.attr('name'))});
            });

            this.onToggleCheked(
                this
                    .getEditorElem('.flags-editor__toggle-cheked')
                    .addClass('only-checked'));
        },

        /**
         * Вычисляет изменения в флагах.
         *
         * @returns {{
         *     needAdd: {Array},
         *     needDelete: {Array},
         *     currentFlags: {Array}
         * }}
         */
        getFlagsDiffs: function() {
            var needAdd = [],
                needDelete = [],
                currentFlags = this.getEditorElem('.flags-editor-form')
                    .serializeArray()
                    .map(function(flag) {
                        return flag.name;
                    });

            needDelete = _.difference(this._flagsList, currentFlags);
            needAdd = _.difference(currentFlags, this._savedFlags);
            needDelete = _.difference(needDelete, _.difference(this._flagsList, this._savedFlags));

            return {
                needAdd: needAdd,
                needDelete: needDelete,
                currentFlags: currentFlags,
                userComment: document.getElementById('flags-editor-user-comment').value  /* I don't know javascript :( */
            };
        },

        /**
         * Сохраняет изменения флагов категории.
         */
        saveCategoryFlags: function() {
            var diff = this.getFlagsDiffs();

            if (diff.needDelete.length || diff.needAdd.length) {
                this.toggleSaveButton();

                utils.catAjax({
                    data: {
                        action: 'setCategoryFlags',
                        add: diff.needAdd,
                        'delete': diff.needDelete,
                        catid: PAGE_PARAMS.catid,
                        comment: diff.userComment
                    },
                    success: function(data) {
                        this._savedFlags = diff.currentFlags;
                        this.toggleSaveButton()
                            .hidePopup()
                            .repaintFlags(data);
                    },
                    error: this.toggleSaveButton
                }, this);
            } else {
                this.hidePopup();
            }
        },

        /**
         * Прячет попап.
         *
         * @returns {object}
         */
        hidePopup: function() {
            this._popup.modal('hide');

            return this;
        },

        /**
         * Во время запроса сохранения флагов устанавливает лоадер на кнопку.
         *
         * @returns {object}
         */
        toggleSaveButton: function() {
            this._saveButton.toggleClass('btn_spinner_visible');

            return this;
        },

        /**
         * Перерисовывает кнопки выбранных фоагов.
         *
         * @returns {object}
         */
        repaintFlags: function(data) {
            $('.category-flags__wrap', this.domElem)
                .empty()
                .append(
                    $((data.dictionaryFlags || []).map(function(item) {
                        return item.isDeleted ?
                            '<span class="badge category-flags__item category-flags__item_deleted_yes">' + item.flag + '</span>' :
                            '<span class="badge category-flags__item">' + item.flag + '</span>';
                    }).join('&nbsp')),
                    $((data.userFlags || []).map(function(flag) {
                        return '<span class="badge category-flags__item category-flags__item_user_yes">' + flag + '</span>';
                    }).join('&nbsp')));

            return this;
        },

        _flagsList: null,

        _currentFlags: null,

        _savedFlags: null,

        _checkboxes: null

    });

    o_o.decl('panel-switcher', {

        togglePanel: function() {
            this.domElem
                .closest('.panel_type_switcher')
                .toggleClass('panel_show_main panel_show_secondary');
        }

    });

    o_o.decl('popup', {

        init: function() {
            var _this = this;

            this.domElem.on('hidden.bs.modal', function () {
                _this.onHide.apply(_this, arguments);
            });

            this.domElem.on('shown.bs.modal', function () {
                _this.onShow.apply(_this, arguments);
            });
        },

        onShow: function() {},

        onHide: function() {},

        setFocus: function(elem) {
            elem.focus();

            return this;
        },

        hidePopup: function() {
            this.domElem
                .modal('hide');

            return this;
        }

    });

    o_o.decl({ className: 'add-category', baseClass: 'popup' }, {

        onShow: function() {
            this
                .setFocus(this.elem('#add-category-textarea'))
                .elem('.add-category-btn')
                    .on('click', function() {
                        if ($('#add-category-user-comment').val() == "") return;
                        $('#add-category-form').submit();
                    });
        },

        onHide: function() {
            this.elem('.add-category-btn').unbind('click');
        }

    });

    o_o.decl({ className: 'change-parent', baseClass: 'popup' }, {

        _lastCatId: false,

        _catId: null,
        _user_comment: null,

        onShow: function() {
            var _this = this;

            if (!this._autocomplete) {
                this._autocomplete = utils.createAutocomplete({
                    elem: this.elem('#change-parent-textarea'),
                    lang: PAGE_PARAMS.lang
                }, function(suggestion) {
                    _this._catId = suggestion.data;
                });
            }

            this
                .setFocus(this.elem('#change-parent-textarea'))
                .elem('.change-parent-btn').on('click', function() {
                    _this._user_comment = $('#change-parent-user-comment').val();

                    _this._catId && _this._user_comment && utils.catAjax({
                        data: {
                            action: 'changeParent',
                            catid: PAGE_PARAMS.catid,
                            parent_catid: _this._catId,
                            user_comment: _this._user_comment
                        },
                        success: function() {
                            location.reload();
                        }
                    });
                });
        },

        onHide: function() {
            this.elem('.change-parent-btn').unbind('click');
        }

    });

    o_o.decl({ className: 'add-new-antiwords', baseClass: 'popup' }, {

        onShow: function() {
            this
                .setFocus(this.elem('#add-antiwords-textarea'))
                .elem('.add-antiwords-btn').on('click', function() {
                    if ($(this).hasClass('btn_spinner_visible') || !$('#add-antiwords-textarea').val()) return;

                    $(this).addClass('btn_spinner_visible');
                    $('#add-new-antiwords-form').submit();
                });
        },

        onHide: function() {
            this.elem('.add-antiwords-btn').unbind('click');
        }

    });

    o_o.decl('users-comments', {

        init: function() {
            var _this = this;

            this.elem('.users-comments__add-btn').on('click', function() {
                    if (_this.getTextAreaVal() && !$(this).hasClass('btn_spinner_visible')) {
                    _this
                        .toggleButton('.users-comments__add-btn')
                        .sendRequest();
                }
            });

            this.elem('.users-comments__delete-in-popup-btn').on('click', function() {
                    if ($(this).hasClass('btn_spinner_visible')) return;

                    _this
                        .toggleButton('.users-comments__delete-in-popup-btn')
                        .deleteComment();
            });

            this.rebindActions();
        },

        rebindActions: function() {
            var _this = this;

            $('.users-comments__action_type_delete', this.domElem)
                .unbind('click')
                .on('click', function(e) {
                    _this._commentId = this.onclick && this.onclick().commentId;
                    _this.setPopupContent();
                });
        },

        setPopupContent: function() {
            this.elem('.modal-body').text('«' + this.elem('.users-comments__text_id_' + this._commentId).text() + '»');
        },

        sendRequest: function() {
            utils.catAjax({
                data: {
                    action: 'addCategoryComment',
                    catid: PAGE_PARAMS.catid,
                    comment: this.getTextAreaVal()
                },
                success: function(data) {
                    this.toggleButton('.users-comments__add-btn')
                        .addComment(data.commentID, data.addCommentTime);
                }
            }, this);
        },

        deleteComment: function() {
            utils.catAjax({
                data: {
                    action: 'deleteCategoryComment',
                    comment_id: this._commentId
                },
                success: function() {
                    this.toggleButton('.users-comments__delete-in-popup-btn')
                        .hidePopup()
                        .elem('.users-comments__comment_id_' + this._commentId)
                        .parent('.list-group-item')
                        .remove();
                }
            }, this);
        },

        addComment: function(commentId, addCommentTime) {
            var params = $.extend(
                {
                    commentId: commentId,
                    addCommentTime: addCommentTime,
                    login: PAGE_PARAMS.login,
                    comment: this.getTextAreaVal()
                },
                this.params);

            this.elem('.users-comments__add-comment')
                .parent('.list-group-item')
                .before(this.buildComment(params));

            this
                .setTextAreaVal('')
                .rebindActions();
        },

        buildComment: function(params) {
            return $(
                '<li class="list-group-item">' +
                    '<div class="row users-comments__comment users-comments__comment_id_' + params.commentId + '">' +
                        '<div class="col-xs-2 col-md-1">' +
                            '<img src="http://yandex.st/wow/2.56-18/static/css//export/a-yandex.png" class="users-comments__avatar" alt="" /></div>' +
                        '<div class="col-xs-10 col-md-11">' +
                            '<div>' +
                                '<div class="users-comments__info">' +
                                    params.by + ': <a href="#">' + params.login + '</a><span class="users-comments__info-date">' + params.addCommentTime + '</span>' +
                                '</div>' +
                            '</div>' +
                            '<div class="users-comments__text users-comments__text_id_' + params.commentId + '">' +
                                params.comment +
                            '</div>' +
                            '<div class="users-comments__actions">' +
//                                '<span class="users-comments__action"><span class="glyphicon glyphicon-pencil"></span>' + params.editText + '</span> ' +
                                '<span class="users-comments__action users-comments__action_type_delete" data-toggle="modal" data-target="#usersCommentsDelete" onclick="return { commentId: \''+ params.commentId +'\' }">' +
                                    '<span class="glyphicon glyphicon-trash"></span>' +
                                    params.deleteText +
                                '</span>' +
                            '</div>' +
                        '</div>' +
                    '</div>' +
                '</li>'
            );
        },

        hidePopup: function() {
            this.elem('.users-comments__delete-popup').modal('hide');

            return this;
        },

        getTextAreaVal: function() {
            return this.elem('.users-comments__new').val();
        },

        setTextAreaVal: function(value) {
            this.elem('.users-comments__new').val(value);

            return this;
        },

        toggleButton: function(selector) {
            this
                .elem(selector)
                .toggleClass('btn_spinner_visible');

            return this;
        },

        _commentId: null

    });

    o_o.decl({ className: 'delete-category', baseClass: 'popup' }, {

        _user_comment: null,

        onShow: function() {
            var _this = this;

            this
                .setFocus(this.elem('#delete-category-user-comment'))
                .elem('.delete-category-btn').on('click', function() { 
                    _this._user_comment = $('#delete-category-user-comment').val();

                    _this._user_comment && utils.catAjax({
                        data: {
                            action: 'deleteCategory',
                            catid: PAGE_PARAMS.catid,
                            user_comment: _this._user_comment 
                        },
                        success: function() {
                            location.reload();
                        }
                    }, this);
                });
        },

        onHide: function() {
            this.elem('.delete-category-btn').unbind('click');
        }

    });

    o_o.decl({ className: 'category-translate', baseClass: 'popup' }, {

        onShow: function() {
            var _this = this;

            this
                .setFocus(this.elem('#rename-category-textarea'))
                .elem('.category-translate__save-btn').on('click', function() {
                    if ($(this).hasClass('btn_spinner_visible')) return;

                    _this.setTranslate();
                });

        },

        onHide: function() {
            this.elem('.category-translate__save-btn').unbind('click');
        },

        setTranslate: function() {
            var newName = this.getNewName(),
                currentName = this._currentName == null ?
                    PAGE_PARAMS.currentName :
                    this._currentName;

            if (currentName != newName) {
                this.toggleButton();

                utils.catAjax({
                    data: {
                        action: 'setTranslate',
                        new_name: newName,
                        catid: PAGE_PARAMS.catid,
                        lang: PAGE_PARAMS.lang
                    },
                    success: function() {
                        this._currentName = newName;

                        this.toggleButton()
                            .hidePopup()
                            .updateName();
                    }
                }, this);
            }
        },

        updateName: function() {
            var userNameElem = $('.page-title__user-name');

            if (!this._currentName) {
                userNameElem.remove();

                return;
            }

            userNameElem.length ?
                userNameElem.text('(' + this._currentName + ')') :
                $('.page-title__text').first()
                    .append([' ', $('<i class="page-title__user-name">(' + this._currentName + ')</i>')]);

        },

        toggleButton: function() {
            this
                .elem('.category-translate__save-btn')
                .toggleClass('btn_spinner_visible');

            return this;
        },

        getNewName: function() {
            return this.elem('#rename-category-textarea').val();
        },

        renameTextarea: null,

        _currentName: null

    });

    /**
     *  Блок «Описание».
     *  Редактирует информацию о категории.
     */
    o_o.decl({ className: 'edit-description', baseClass: 'popup' }, {

        init: function() {
            this.__base();

            var _this = this;

            $('.description__edit, .description__add').on('click', function() {
                _this.fillDescription();
            });
        },

        onShow: function() {
            var _this = this;

            this.elem('.description__save').on('click', function() {
                if ($(this).hasClass('btn_spinner_visible')) return;

                _this.saveDescription();
            });

            this.elem('.description__textarea')
                .focus();
        },

        onHide: function() {
            this.elem('.description__save').unbind('click');
        },

        /**
         * Вставляет значение из дива в текстарею.
         */
        fillDescription: function() {
            this.elem('.description__textarea')
                .val(this.getTextElem().text());
        },

        /**
         * Сохраняет «Описание» категории.
         */
        saveDescription: function() {
            var text = this.elem('.description__textarea').val(),
                button = this.elem('.description__save');

            if (text == this.getTextElem().text()) {
                this.hidePopup();
            } else {
                button.addClass('btn_spinner_visible');

                utils.catAjax({
                    data: {
                        action: 'setCategoryDescription',
                        description: text,
                        catid: PAGE_PARAMS.catid,
                        lang: PAGE_PARAMS.lang
                    },
                    success: function(data) {
                        button.removeClass('btn_spinner_visible');

                        $('.description')[text ? 'addClass' : 'removeClass']('description_text_yes');
                        this.getTextElem().text(text);
                        this.hidePopup();
                    }
                }, this);
            }
        },

        getTextElem: function() {
            return this._descriptionText || (this._descriptionText = $('.description__text').first());
        }

    });

    o_o.decl('phrases', {

        init: function() {
            var params = this.params;

            if (params.phraseBlockId) {
                this.bildPage(params.phraseBlockId, 0);
            }

            this.bindActions()
                .bindPerPageSelect()
                .bindSearchInput()
                .bindMousewheel();
        },

        bindSearchInput: function() {
            var _this = this;

            this.elem('.search-input').keyup(function (e) {
                e.keyCode == 13 && _this.searchByPhrase();

                _this.elem('.clear-value')[_this.elem('.search-input').val() ? 'show': 'hide']();
            });

            this.elem('.clear-value').on('click', function() {
                _this.clearSearch();
            });

            return this;
        },

        _perPageSelectVal: null,

        bindPerPageSelect: function() {
            var select = this.elem('.per-page__select'),
                _this = this;

            this._perPageSelectVal = select.val();

            select.on('change', function() {
                _this.checkSelected(function() {
                    this.destroyPagination()
                        .bildPage(this.params.phraseBlockId, 0, this._perPageSelectVal = select.val());
                }, function() {
                    select.val(this._perPageSelectVal);
                });
            });

            return this;
        },

        addPhrases: function(phrases) {
            this.elem('.panel-body_type_main').html(phrases);

            return this;
        },

        highlight: function(text) {
            return text.replace(this._regexp, function(str) {
                return '<span class="phrase__hlted">' + str + '</span>';
            });
        },

        splitOnRanges: function(phraseText, atoms) {
            var ranges = [],
                prevEnd = 0;

            atoms.forEach(function(atom, index) {
                var start = atom.start,
                    end = atom.start + atom.length;

                if (atom.start != 0) {
                    if (prevEnd) {
                        ranges.push({
                            text: phraseText.substring(prevEnd, start)
                        });
                    } else {
                        ranges.push({
                            text: phraseText.substring(0, start)
                        });
                    }
                }

                ranges.push({
                    text: phraseText.substring(start, end),
                    catid: atom.catid
                });

                index + 1 == atoms.length && ranges.push({
                    text: phraseText.substring(end, phraseText.length)
                });

                prevEnd = end;
            });

            return ranges;
        },

        getPhraseOnclickAttr: function(index, phrase) {
            return 'onclick="return { index: ' + index + ', text: \'' + _.escape(phrase) + '\'}"';
        },

        bildPhrases: function(phrases, isSearch) {
            var _this = this,
                stringPhrases = (phrases || []).map(function(phrase, index) {
                        var phraseText = phrase.phrase,
                            hasAtoms = phrase.atomsInfo && phrase.atomsInfo.length,
                            phraseState = phrase.phraseState == 'userPhrase' ? ' phrase_type_user' : '';

                        if (hasAtoms) {
                            phraseText = this.splitOnRanges(phraseText, phrase.atomsInfo).map(function(chunk) {
                                var text = isSearch ?
                                    this.highlight(utils.replaceBrackets(chunk.text)) :
                                    utils.replaceBrackets(chunk.text);

                                if (chunk.catid) {
                                    return '<a target="_blank" href="' + utils.getCatUrl(chunk.catid, PAGE_PARAMS.urlOpts) +'">' + text + '</a>';
                                } else {
                                    return text;
                                }
                            }, this).join('');
                        } else if (isSearch) {
                            phraseText = this.highlight(utils.replaceBrackets(phrase.phrase));
                        } else {
                            phraseText = utils.replaceBrackets(phrase.phrase);
                        }

                        return '<span class="phrase' + phraseState + '" ' + this.getPhraseOnclickAttr(index, phrase.phrase) + '>' + phraseText;
                    }, this)
                    .join('<span class="phrase-comma">, </span></span>') + '</span>';

            return $(stringPhrases).on('click', function() {
                _this.onPhraseClick($(this), this.onclick());
            });
        },

        bildPage: function(phraseBlockId, pageNumber, perPage) {
            var _this = this;

            this
                .addPageSpinner()
                .loadPhrases(phraseBlockId, pageNumber, perPage)
                .then(function (data) {
                    var totalBlockPhrasesCount = data.totalBlockPhrasesCount;

                    !_this._totalBlockPhrasesCount && totalBlockPhrasesCount &&
                        _this.elem('.total-block-count__count')
                            .text(utils.prettyNumber(totalBlockPhrasesCount));

                    _this._totalBlockPhrasesCount = totalBlockPhrasesCount;
                    _this._selectedPhrases = null;
                    _this._currentPage = pageNumber;

                    $('.phrase', _this.domElem)
                        .unbind('click');

                    _this.addPhrases(_this.bildPhrases(data.getBlockPhrases))
                        .bildPagination(perPage || PAGE_PARAMS.pagination.perPage, totalBlockPhrasesCount)
                        .checkCounter()
                        .hidePageSpinner();
                });

            return this;
        },

        rebuildCurrentPage: function() {
            this.bildPage(
                this.params.phraseBlockId,
                this._currentPage,
                this.elem('.per-page__select').val());

            return this;
        },

        _totalBlockPhrasesCount: null,

        loadPhrases: function(phraseBlockId, pageNumber, perPage) {
            var deferred = $.Deferred();

            utils.catAjax({
                data: {
                    action: 'handlePhraseBlock',
                    phraseBlockID: phraseBlockId,
                    catid: PAGE_PARAMS.catid,
                    lang: PAGE_PARAMS.lang,
                    pageSize: perPage || PAGE_PARAMS.pagination.perPage,
                    pageIndex: pageNumber,
                    getBlockPhrases: 1
                },
                success: function(data) {
                    deferred.resolve(data);
                },
                error: function(err) {
                    deferred.reject(err);
                }
            }, this);

            return deferred.promise();
        },

        bindActions: function() {
            var _this = this;

            this.elems('.action')
                .on('click', function() {
                    _this.onActionsClick($(this), this.onclick() || {});
                });

            return this;
        },

        onActionsClick: function(elem, params) {
            params.action && this[params.action](elem, params);
        },

        toggleView: function(elem) {
            elem.toggleClass('btn-sm_type_glyphicon-press');
            this.domElem.toggleClass('phrases_type_column');

            this.checkCounter();
        },

        toggleModerate: function(elem) {
            elem.toggleClass('btn-sm_type_glyphicon-press');
            this.domElem.toggleClass('phrases_type_show-moderate');

            this.checkCounter();
        },

        toggleActive: function(elem) {
            elem.toggleClass('btn-sm_type_glyphicon-press');
            this.domElem.toggleClass('phrases_type_show-active');

            this.checkCounter();
        },

        checkSelected: function(onYes, onNo) {
            var selectedPhrases = this.getPhrasesArray();
            if (selectedPhrases.length) {
                this.showConfirm({
                    onYes: onYes,
                    onNo: onNo,
                    message: selectedPhrases.join(', '),
                    ctx: this
                });
            } else {
                onYes.apply(this, arguments);
            }
        },

        _confirmParams: null,

        showConfirm: function(params) {
            this._confirmParams = params;

            this.elem('.confirm-popup__message', this.elem('#' + this.params.confirmId))
                .text(params.message);

            this.openModal(this.params.confirmId);
        },

        confirm: function(domElem, params) {
            if (this._confirmParams) {
                if (params['continue'] == 'yes' && this._confirmParams.onYes) {
                    this._confirmParams.onYes.apply(this._confirmParams.ctx || this, arguments);
                } else {
                    if (this._confirmParams.onNo) {
                        this._confirmParams.onNo.apply(this._confirmParams.ctx || this, arguments);
                    }
                }
            }

            this._confirmParams = null;

            this.hideModal(params.popupId);
        },

        addPageSpinner: function() {
            if (!this.pageSpinner) {
                this.pageSpinner = $('<div class="white-parandja"><div class="spinner spinner_type_middle spinner_type_white-parandja"></div></div>');

                this.elem('.panel-body_type_pagination')
                    .append(this.pageSpinner);
            } else {
                this.pageSpinner.show();
            }

            return this;
        },

        hidePageSpinner: function() {
            this.pageSpinner && this.pageSpinner.hide();
        },

        bildPagination: function(perPage, phrasesCount) {
            if (this._pagination) return this;

            var _this = this,
                params = this.params,
                pageCount = phrasesCount/perPage >> 0;

            phrasesCount % perPage && (pageCount++);

            this.elem('.panel-body_type_pagination')
                .append('<ul id="pagination' + params.phraseBlockId + '"class="pagination-sm pagination_type_phrase"></ul>');

            this.elem('#pagination' + params.phraseBlockId)
                .twbsPagination({
                    totalPages: pageCount || 1,
                    visiblePages: 10,
                    pageClass: 'pagination__item',
                    first: '&#8920;',
                    prev: PAGE_PARAMS.pagination.prev,
                    next: PAGE_PARAMS.pagination.next,
                    last: '&#8921;',
                    onPageClick: function (event, page) {
                        _this.checkSelected(function() {
                            this.bildPage(params.phraseBlockId, page - 1);
                        }, function() {
                            this.elem('#pagination' + this.params.phraseBlockId)
                                .twbsPagination('show', this._currentPage ? this._currentPage + 1 : 1);
                        });
                    }
                });

            this._pagination = true;

            return this;
        },

        onPhraseClick: function(domElem, params) {
            this._selectedPhrases || (this._selectedPhrases = {});

            if (this._selectedPhrases[params.index]) {
                delete this._selectedPhrases[params.index];
            } else {
                this._selectedPhrases[params.index] = {
                    text: params.text,
                    domElem: domElem
                };
            }

            domElem.toggleClass('selected');
        },

        searchHandle: function(value) {
            var deferred = $.Deferred();

            utils.catAjax({
                data: {
                    action: 'handlePhraseBlock',
                    phraseBlockID: this.params.phraseBlockId,
                    catid: PAGE_PARAMS.catid,
                    lang: PAGE_PARAMS.lang,
                    searchBlockPhrases: value
                },
                success: function(data) {
                    deferred.resolve(data);
                },
                error: function(err) {
                    deferred.reject(err);
                }
            }, this);

            return deferred.promise();
        },

        _prevSearchValue: null,

        destroyPagination: function() {
            this._pagination && this.elem('#pagination' + this.params.phraseBlockId).twbsPagination('destroy');

            this._pagination = false;

            return this;
        },

        onFind: function(phrases) {
            $('.phrase', this.domElem)
                .unbind('click');

            this._selectedPhrases = null;

            this.destroyPagination()
                .addPhrases([
                    $('<h4 class="search-info-h4">' +
                        (phrases.length ? ('Найдено: ' + phrases.length + '.') : 'Ничего не найдено.') +
                    '</h4>'),
                    this.bildPhrases(phrases, true)
                ])
                .checkCounter()
                .hidePageSpinner();
        },

        searchByPhrase: function() {
            var value = this.elem('.search-input').val(),
                _this = this;

            if (value) {
                this.checkSelected(function() {
                    if (this._prevSearchValue == value) return;

                    this._regexp = new RegExp('(' + value.replace(/(.)/g, '[$1]') + ')', 'gi');

                    this.addPageSpinner()
                        .searchHandle(value)
                        .then(function(data) {
                            _this.onFind(data.searchBlockPhrases || [], value);
                            _this._prevSearchValue = value;
                        });

                    this.domElem.addClass('searching-phrases');
                });
            } else {
                this.clearSearch();
            }
        },

        clearSearch: function() {
            this.checkSelected(function() {
                this.bildPage(this.params.phraseBlockId, 0)
                    .domElem
                    .removeClass('searching-phrases');

                this.elem('.search-input').val('');
                this.elem('.clear-value').hide();

                this._prevSearchValue = '';
            });

            return this;
        },

        selectAllPhrases: function() {
            var _this = this;

            this._selectedPhrases || (this._selectedPhrases = {});

            $('.phrase', this.domElem).each(function(index, elem) {
                var params = elem.onclick();

                if (!_this._selectedPhrases[params.index]) {
                    var domElem = $(elem);

                    _this._selectedPhrases[params.index] = {
                        text: params.text,
                        domElem: domElem
                    };

                    domElem.toggleClass('selected');
                }
            });
        },

        exportPhrases: function(elem, params) {
            this.checkSelected(function() {
                this.elem('#' + params.exportId).submit();
            });
        },

        exportSelectedPhrases: function(elem, params) {
            var phrases = this.getPhrasesArray();

            if (phrases.length) {
                var form = this.elem('#' + params.exportSelectedId);

                $("input[name='selectedPhrases']", form).val(phrases.join(','));

                form.submit();
            }
        },

        bindMousewheel: function() {
            var _this = this;

            this.elem('.panel-body_type_main')
                .scroll(function(event, delta) {
                    _this.checkCounter();
                });

            return this;
        },

        checkCounter: function() {
            var phrases = this.elem('.panel-body_type_main')[0],
                counter = this.elem('.panel-body_type_counter');

            if (phrases.offsetHeight + phrases.scrollTop > phrases.scrollHeight) {

                counter.hasClass('counter-hidden') || counter.addClass('counter-hidden');
            } else {
                var pr = Math.round((phrases.offsetHeight + phrases.scrollTop) * 100 / phrases.scrollHeight);
                this.elem('.phrases-counter').text(pr + '%');

                counter.removeClass('counter-hidden');
            }

            return this;
        },

        getEditingPhrasesWarnings: function(action, phrases) {
            var deferred = $.Deferred(),
                actionObj = {};

            actionObj[action] = phrases;

            utils.catAjax({
                type: 'POST',
                data: $.extend({
                    action: 'handlePhraseBlock',
                    phraseBlockID: this.params.phraseBlockId,
                    catid: PAGE_PARAMS.catid,
                    lang: PAGE_PARAMS.lang
                }, actionObj),
                success: function(data) {
                    deferred.resolve(data);
                },
                error: function(err) {
                    deferred.reject(err);
                }
            }, this);

            return deferred.promise();
        },

        getCategoriesCell: function(phrase, isSaved) {
            if (phrase.Action == 'Add' && !isSaved) {

                //TODO Кирилл!!
                phrase.Categories.unshift({
                    CategoryName: PAGE_PARAMS.currentName,
                    CatID: PAGE_PARAMS.catid
                });

                return '<select name="categ_' + phrase.ID + '">' +
                    phrase.Categories.map(function(c) {
                        return '<option value="' + c.CatID + '" ' + (c.CatID == PAGE_PARAMS.catid ? 'selected' : '')+ '>' + c.CategoryName + '</a>';
                    }).join('') +
                '</select>';
            } else {
                if (phrase.Action == 'Delete') {
                return '<input type="hidden" name="categ_' + phrase.ID + '" value="' + phrase.CatID + '"/>' +
                    '<a href="' + utils.getCatUrl(PAGE_PARAMS.catid, PAGE_PARAMS.urlOpts) + '" target="_blank">' + PAGE_PARAMS.currentName + '</a>';
                } else {
                    return '<input type="hidden" name="categ_' + phrase.ID + '" value="' + phrase.CatID + '"/>' +
                        '<a href="' + utils.getCatUrl(phrase.selectedCatid, PAGE_PARAMS.urlOpts) + '" target="_blank">' + phrase.selectedCatName + '</a>';
                }
            }

        },

        getBannerLink: function(phrase) {
            return '<a target="_blank" class="search-banners-link" href="' + utils.getSearchBannersUrl(phrase) + '">' +
                '<span class="glyphicon glyphicon-search"></span>' +
            '</a>';
        },

        getCommentAndCheckboxCell: function(phrase, isSaved) {
            var result;

            if (isSaved) {
                result = [phrase.comment || ''];
            } else {
                result = [
                    '<input type="text" name="comment_' + phrase.ID + '">',
                    phrase.CriticalWarning ?
                        '' :
                        ('<input name="' + phrase.ID + '" type="checkbox" ' + (phrase.Warnings.length ? '' : 'checked') + '>')
                ];
            }

            return result
                .map(function(s) { return '<td>' + s + '</td>'; })
                .join('');
        },

        getEditingPhrasesTable: function(phrases, isSaved) {
            var rows = [],
                hedder = '<tr class="editing-phrases-table__head">' +
                    [
                        'Категория',
                        '',
                        'Действие',
                        'Фраза',
                        'snorm_phr',
                        'Текущие категории',
                        'Предупреждения',
                        'Комментарий',
                        (isSaved ? undefined : 'Подтверждение')
                    ]
                        .filter(function(value) { return typeof value == 'string' })
                        .map(function(name) { return '<td>' + name + '</td>'; })
                        .join('') +
                '</tr>';

            phrases.forEach(function(phrase) {
                rows.push('<tr>' +
                        '<td>' + this.getCategoriesCell(phrase, isSaved) + '</td>' +
                        '<td>' + this.getBannerLink(phrase.InitialPhrase) + '</td>' +
                        '<td>' + phrase.Action + '</td>' +
                        '<td>' + utils.replaceBrackets(phrase.InitialPhrase) + '</td>' +
                        '<td>' + utils.replaceBrackets(phrase.SnormPhrase) + '</td>' +
                        '<td>' + phrase.CurrentCategories + '</td>' +
                        '<td style="background-color: #' +
                            (phrase.Warnings.length ?
                                (phrase.CriticalWarning ?
                                    'F2DEDE' :
                                    'FCF8E3') :
                                'DFF0D8') +
                        '">' +
                            phrase.Warnings
                                .map(function(w) { return '<div>' + w + '</div>'; })
                                .join('') +
                        '</td>' +
                        this.getCommentAndCheckboxCell(phrase, isSaved) +
                    '</tr>');
            }, this);

            return '<table class="table editing-phrases-table">' + hedder + rows.join('') + '</table>';

        },

        getEditingPhrasesForm: function(warnings, isSaved) {
            return [
                '<form method="post" class="editing-phrases-form">',
                this.getEditingPhrasesTable(warnings, isSaved),
                '</form>'
            ].join('');
        },

        onSearchBannersClick: function(elem) {
            elem.parent().css('background-color', '#DFF0D8');
        },

        showEditingPhrasesPopup: function(warnings, editWarningsId, isSaved) {
            var _this = this;

            if (isSaved) {
                $('.modal-title', this.elem('.editing-phrases-popup')).text('Сохранено');

                this.elem('.save-approved-hrases').hide();
            } else {
                $('.modal-title', this.elem('.editing-phrases-popup')).text('Подтверждение');

                this.elem('.save-approved-hrases').show();
            }

            $('.search-banners-link', this.elem('.editing-phrases-popup')).unbind('click');

            $('.modal-body', this.elem('.editing-phrases-popup'))
                .html(this.getEditingPhrasesForm(warnings, isSaved));

            $('.search-banners-link', this.elem('.editing-phrases-popup')).on('click', function() {
                _this.onSearchBannersClick($(this));
            });

            this._editingPhrasesWarnings = warnings;

            isSaved || this.openModal(editWarningsId);

            return this;
        },

        _editingPhrasesWarnings: false,

        hideModal: function(id) {
            this.elem('#' + id).modal('hide');

            return this;
        },

        openModal: function(id) {
            this.elem('#' + id).modal('show');

            return this;
        },

        openAddPhrasesPopup: function(domElem, params) {
            this.checkSelected(function() {
                this.openModal(params.popupId);
            });
        },

        addNewPhrases: function(button, params) {
            var _this = this,
                phrases = this.elem('.add-phrases-textarea').val();


            if (phrases) {
                button.addClass('btn_spinner_visible');

                this.getEditingPhrasesWarnings('add', phrases)
                    .then(function(data) {
                        _this.elem('.add-phrases-textarea').val('');
                        button.removeClass('btn_spinner_visible');

                        _this.hideModal(params.popupId)
                            .showEditingPhrasesPopup(data.editingPhrasesWarnings, params.editWarningsId);
                    });
            }
        },

        getPhrasesArray: function() {
            return _
                .keys(this._selectedPhrases)
                .map(function(name) {
                    return _.unescape(this._selectedPhrases[name].text)
                        .replace(/&#39;/g, '\'');
                }, this);
        },

        trashPhrases: function(elem, params) {
            var _this = this;

            this.addPageSpinner()
                .getEditingPhrasesWarnings('delete', this.getPhrasesArray())
                .then(function(data) {
                    _this.hidePageSpinner();
                    _this.showEditingPhrasesPopup(data.editingPhrasesWarnings, params.editWarningsId);
                });

        },

        saveEditingPhrases: function(approvedPhrases) {
            var deferred = $.Deferred();

            utils.catAjax({
                type: 'POST',
                data: {
                    action: 'handlePhraseBlock',
                    approvedPhrases: JSON.stringify(approvedPhrases),
                    phraseBlockID: this.params.phraseBlockId
                },
                success: function(data) {
                    deferred.resolve(data);
                },
                error: function(err) {
                    deferred.reject(err);
                }
            }, this);

            return deferred.promise();
        },

        getApprovedPhrases: function() {
            var editingPhrases = {},
                approvedPhrases = [];

            this._editingPhrasesWarnings.map(function(item) {
                var action = item.Action.toLowerCase(),
                    catId = action == 'add' ? this.elem('select[name=categ_' + item.ID + ']').val() : item.CatID;

                if (this.elem('input[name=' + item.ID + ']').prop('checked')) {
                    var lang = item.Language,
                        comment = this.elem('input[name=comment_' + item.ID + ']').val();

                    editingPhrases[catId] || (editingPhrases[catId] = {});
                    editingPhrases[catId][lang] || (editingPhrases[catId][lang] = {});
                    editingPhrases[catId][lang][action] || (editingPhrases[catId][lang][action] = []);

                    editingPhrases[catId][lang][action].push({
                        text: item.InitialPhrase,
                        comment: comment
                    });

                    item.comment = comment;
                    item.selectedCatName = this.elem('select[name=categ_' + item.ID + '] option:selected').text();
                    item.selectedCatid = catId;
                }

                return item;
            }, this);

            _.keys(editingPhrases).map(function(catid) {
                _.keys(editingPhrases[catid]).map(function(lang) {
                    var item = {
                        catid: catid,
                        lang: lang
                    };

                    ['add', 'delete'].map(function(action) {
                        editingPhrases[catid][lang][action] && (item[action] = editingPhrases[catid][lang][action]);
                    });

                    approvedPhrases.push(item);
                });
            });

            return approvedPhrases;
        },

        saveApprovedPhrases: function(button, params) {
            button.addClass('btn_spinner_visible');

            var _this = this,
                approvedPhrases = this.getApprovedPhrases();

            if(approvedPhrases.length) {
                this.saveEditingPhrases(approvedPhrases)
                    .then(function() {
                        button.removeClass('btn_spinner_visible');

                        //_this.hideModal(params.popupId)
                        _this.showEditingPhrasesPopup(_this._editingPhrasesWarnings, params.popupId, true)
                            .rebuildCurrentPage();
                    }, function() {
                        console.log(arguments);
                    });
            } else {
                button.removeClass('btn_spinner_visible');
            }
        },

        clearAllActive: function() {
            _.keys(this._selectedPhrases)
                .forEach(function(name) {
                    this._selectedPhrases[name].domElem.removeClass('selected');
                }, this);

            this._selectedPhrases = null;
        }

    });

    o_o.decl('vce', {

        init: function() {
            var mainCheckboxes = $('.vce__checkbox-item'),
                modeCheckboxes = $('.vce__children-checkbox'),
                rows = $('.vce__row_type_checkbox');

            $('.vce__save-btn').on('click', function() {
                var cheked = [],
                    mode = [],
                    button = $(this);

                if (button.hasClass('btn_spinner_visible')) return;

                mainCheckboxes.each(function(index, checkbox) {
                    var domElem = $(checkbox);

                    if (domElem.prop('checked')) {
                        var name = domElem.attr('name');

                        cheked.push(name);

                        if (modeCheckboxes.eq(index).prop('checked')) {
                            mode.push('ApplyVirtualFull');
                        } else {
                            mode.push('ApplyVirtual');
                        }
                    }
                });

                if (cheked.length) {
                    button.addClass('btn_spinner_visible');

                    utils.catAjax({
                        data: {
                            action: 'applyVirtualCategories',
                            catid: PAGE_PARAMS.catid,
                            apply: cheked,
                            mode: mode
                        },
                        success: function(data) {
                            button.removeClass('btn_spinner_visible');
                            $('#setVirtualCategory').modal('hide');
                        }
                    }, this);
                }
            });

            mainCheckboxes.on('change', function() {
                var index = this.onclick() - 1,
                    row = rows.eq(index),
                    checkbox = $(this);

                if (checkbox.prop('checked')) {
                    row.addClass('vce__row_checked_yes');
                } else {
                    row.removeClass('vce__row_checked_yes');
                    modeCheckboxes.eq(index).prop({ checked: true });
                }
            });
        }

    });

    o_o.decl('nephew-relation', {

        _relationId: null,

        init: function() {
            var _this = this;

            this.toggleButton(this.elem('.edit'))
                .loadRelation()
                .then(this.addRelation);

            this.elem('.edit').on('click', function() {
                _this.edit();

                if (!_this.autocomplete) {
                    _this.autocomplete = true;

                    ['domain', 'image'].forEach(function(name, index) {
                        utils.createAutocomplete(
                            {
                                elem: this.elem('.nephew-relation__input_type_' + name),
                                lang: PAGE_PARAMS.lang,
                                width: 400
                            },
                            function(params) {
                                this._relationId[name] = {
                                    catid: params.data,
                                    catName: params.value
                                };
                            },
                            this);
                    }, _this);
                }
            });
        },

        edit: function() {
            this.domElem.toggleClass('edit');
            this.elems('.nephew-relation__input').val('');
            this._relationId = {};
        },

        addRelation: function(data) {
            var _this = this;

            this.toggleButton(this.elem('.edit'));

            this.elem('.list-group').prepend($(
                ['domain', 'image'].reduce(function(prev, current) {
                    return prev + _this.getGroup(current, data[current]);
                }, '')
            ));

            this.elems('.nephew-relation__add-button').on('click', function() {
                _this.addNewRelation($(this), this.onclick());
            });

            this.elems('.nephew-relation__remove-button').on('click', function() {
                _this.removeRelation($(this), this.onclick());
            });
        },

        removeRelation: function(elem, params) {
            var checkboxes = $('.nephew-relation__checkbox', elem.closest('.nephew-relation__' + params.type)),
                cheked = [],
                chekedItems = [],
                _this = this;

            checkboxes.each(function(index, checkbox) {
                var domElem = $(checkbox);

                if (domElem.prop('checked')) {
                    var catid = checkbox.onclick().catid;

                    cheked.push(catid);
                    chekedItems.push(domElem.closest('.nephew-relation__item'));
                }
            });

            if (!cheked.length) {
                return;
            }

            this.toggleButton(elem);

            if (params.type == 'image') {
                this.request({ catid: PAGE_PARAMS.catid, deleteRelation: cheked })
                    .then(function() {
                        chekedItems.map(function(item) {
                            $(item).remove();
                        });

                        _this.toggleButton(elem);
                    }, function() {
                        _this.toggleButton(elem);
                    });
            } else {
                $.when.apply($, cheked.map(function(id) {
                    return _this.request({ catid: id, deleteRelation: [PAGE_PARAMS.catid] });
                }))
                .then(function() {
                    chekedItems.map(function(item) {
                        $(item).remove();
                    });
                    _this.toggleButton(elem);
                }, function() {
                    _this.toggleButton(elem);
                });
            }
        },

        addNewRelation: function(button, params) {
            var form = button.closest('.nephew-relation__add-form'),
                input = $('.nephew-relation__input', form),
                relationSuggest = this._relationId[params.type] || {},
                requestParams = params.type == 'image' ?
                    {
                        catid: PAGE_PARAMS.catid,
                        addRelation: [relationSuggest.catid]
                    } :
                    {
                        catid: relationSuggest.catid,
                        addRelation: [PAGE_PARAMS.catid]
                    };

            if (relationSuggest.catid && $.trim(relationSuggest.catName) == $.trim(input.val())) {
                this.toggleButton(button);

                this.request(requestParams)
                    .then(function() {
                        form.before(this.getItem(params.type, relationSuggest.catid, relationSuggest.catName || relationSuggest.catid));

                        input.val('');

                        this._relationId[params.type] && (this._relationId[params.type] = undefined);

                        this.toggleButton(button);
                            //.bindRemove();
                    }, function(error) {
                        console.log(error);
                    });
            }
        },

        toggleButton: function(button) {
            button.toggleClass('btn_spinner_visible');

            return this;
        },

        getItem: function(groupName, catid, catName) {
            return '<div class="nephew-relation__item">' +
                '<input class="nephew-relation__checkbox" onclick="return { catid: \'' + catid + '\', type: \'' + groupName + '\' }; " type="checkbox">' +
                '<span class="nephew-relation__asterisk glyphicon glyphicon-link"></span>' +
                '<a class="nephew-relation__link" href="' + utils.getCatUrl(catid, PAGE_PARAMS.urlOpts) + '" target="_blank">' + catName + '</a>' +
            '</div>';
        },

        getGroup: function(groupName, group) {
            var _this = this;

            return '<li class="list-group-item nephew-relation__' + groupName +'">' +
                '<div class="nephew-relation__heading">' + _this.params[groupName] + '</div>' +
                (group || []).reduce(function(prev, current) {
                    return prev + _this.getItem(groupName, current.catID, current.catName);
                }, '') +
                '<div class="form-inline nephew-relation__add-form">' +
                    '<button class="btn btn-default btn-sm nephew-relation__remove-button nephew-relation__remove-button_type_' + groupName + '" onclick="return { type: \'' + groupName + '\' };">' +
                        '<div class="spinner spinner_type_button"></div>' +
                        '<span class="glyphicon glyphicon-trash"></span> ' + _this.params['remove'] +
                    '</button>' +
                    '<input class="form-control input-sm nephew-relation__input nephew-relation__input_type_' + groupName + '" placeholder="' + _this.params['search'] + '">' +
                    '<button class="btn btn-default btn-sm nephew-relation__add-button nephew-relation__add-button_type_' + groupName + '" onclick="return { type: \'' + groupName + '\' };">' +
                        '<div class="spinner spinner_type_button"></div>' +
                        '<span class="glyphicon glyphicon-plus"></span> ' + _this.params['add'] +
                    '</button>' +
                '</div>' +
            '</li>';
        },

        request: function(params) {
            var deferred = $.Deferred();

            utils.catAjax({
                data: $.extend({ action: 'handleRelationBlock', relationBlockID: 'nephewRelationBlock' }, params),
                success: function(data) {
                    deferred.resolveWith(this, [data]);
                },
                error: function(err) {
                    deferred.rejectWith(this, [err]);
                }
            }, this);

            return deferred.promise();
        },

        loadRelation: function() {
            return this.request({
                catid: PAGE_PARAMS.catid,
                getRelation: 1
            });
        }

    });

    o_o.decl('banners-examples', {

        init: function() {
            var _this = this;

            this.loadBanners();

            this.getLoadMoreButton().on('click', function() {
                _this.loadBanners();
            });
            this.getClearAllButton().on('click', function() {
                _this.elem('.list-group').children().remove();
            });
            this.getToggleActiveButton().on('click', function() {
                _this.toggleActive();
            });
        },

        loadBanners: function() {
            this.toggleButton();

            utils.catAjax({
                data: {
                    action: 'getBannerSamples',
                    catid: PAGE_PARAMS.catid,
                    lang: PAGE_PARAMS.lang,
                    active_only: this.getActiveFlagStatus()
                },
                success: function(data) {
                    this.toggleButton()
                        .addBanners(data.bannerSamples);
                },
                error: this.toggleButton
            }, this);
        },

        _loadMoreButton: null,

        getLoadMoreButton: function() {
            return this._loadMoreButton || (this._loadMoreButton = this.elem('.load-more'));
        },
        _clearAllButton: null,
        getClearAllButton: function() {
            return this._clearAllButton || (this._clearAllButton = this.elem('.clear-all'));
        },
        _toggleActiveButton: null,
        getToggleActiveButton: function() {
            return this._toggleActiveButton || (this._toggleActiveButton = this.elem('.toggle-active'));
        },

        _activeFlagStatus: 0,
        toggleActive: function() {
            this.getToggleActiveButton().toggleClass('btn-sm_type_glyphicon-press');
            this._activeFlagStatus = 1-this._activeFlagStatus;
        },
        getActiveFlagStatus: function() {
            return this._activeFlagStatus;
        },

        toggleButton: function() {
            this
                .getLoadMoreButton()
                .toggleClass('btn_spinner_visible');

            return this;
        },

        addBanners: function(banners) {
            var elems;

            this.elem('.list-group').prepend(elems = $(
                banners.map(function(banner) {
                    return '<li class="list-group-item active">' +
                        '<div class="banner">' +
                            '<a class="banner__link" href="'+banner.url+'" target="_blank">' + banner.title + '</a>' +
                            '<div class="banner__text">' + banner.body + '</div>' +
                            '<div class="banner__domain">BannerID: ' +
                                banner.id +
                                '<span class="banner__status ' + (+banner.active_flag ? 'active' : 'no-active') + '">' +
                                    this.params[+banner.active_flag ? 'activeText' : 'notActiveText'] +
                                '</span>' +
                            '</div>' +
                        '</div>' +
                    '</li>'
                }, this).join('')
            ));

            setTimeout(function() {
                elems.removeClass('active');
            }, 500);
        }

    });

    o_o.decl('diff-table', {

        init: function() {
            var isOpen = false,
                domElem = this.domElem,
                folders = $('.diff-table__folder', domElem);

            this.elems('.diff-table__folder-toggler, .diff-table__line_type_toggler').on('click', function() {
                $(this).closest('.diff-table__folder').toggleClass('diff-table__folder_open_yes');
            });

            this.elems('.diff-table__folders-toggler').on('click', function() {
                domElem[isOpen ? 'removeClass' : 'addClass']('diff-table_open_yes');
                folders[isOpen ? 'removeClass' : 'addClass']('diff-table__folder_open_yes');
                isOpen = !isOpen;
            });
        }

    });

    o_o.decl('wake-up', {

        init: function() {
            var date,
                check = this.check,
                domElem = this.domElem;

            setInterval(function() {
                check(date, domElem);

                date = new Date().getTime();
            }, 1000);
        },

        check: function(date, domElem) {
            if (!date) return;

            var now = new Date().getTime();

            if (now - date > 1100) {
                domElem.trigger('wake-up-donnie');
            }
        }

    });

    o_o.decl('subscribers-link', {

        init: function() {
            var _this = this;

            this._setSubscribeStatusByType(this.params.subscribeType, +this.params.subscribeStatus);
            this._subscribersIcon = $('.glyphicon_type_subscribers');
            this._subscribersIconFull = $('.glyphicon_type_subscribers-full');

            this.domElem.on('click', function() {
                _this._onClick();
            });
        },

        _subscribeStatus: null,

        _onClick: function() {
            if (this.domElem.hasClass('disable') || !this.params.subscribeStatus) {
                return;
            }

            this.domElem.addClass('disable');

            var subscribeStatus = this._subscribeStatus,
                subscribeType = this.params.subscribeType,
                dataForAjax = {
                    action: 'handleCategorySubscription',
                    catid: PAGE_PARAMS.catid,
                    getSubscribers: 1,
                    getSubscribedParents: 1
                };

            if (subscribeType == 'single') {
                dataForAjax[subscribeStatus ? 'unsubscribeSingle' : 'subscribeSingle'] = 1;
            }

            if (subscribeType == 'full') {
                dataForAjax[subscribeStatus ? 'unsubscribeFull' : 'subscribeFull'] = 1;
            }

            utils.catAjax({
                data: dataForAjax,
                success: function(data) {
                    $('body').trigger('subscribers-reload', data);

                    this.elem('.subscribers-link-text')
                        .text(this.params[subscribeStatus ? 'subscribe' : 'unsubscribe']);

                    this._setSubscribeStatusByType(subscribeType, !subscribeStatus);
                    this._isAnySubscription() ?
                        this._subscribersIcon.addClass('subscribe_yes') :
                        this._subscribersIcon.removeClass('subscribe_yes');

                    if (subscribeType == 'full') {
                        this._subscribeStatus ?
                            this._subscribersIconFull.addClass('subscribe_yes') :
                            this._subscribersIconFull.removeClass('subscribe_yes');
                    }

                    this.domElem.removeClass('disable');
                },
                error: function() {
                    this.domElem.removeClass('disable');
                }
            }, this);
        },

        _setSubscribeStatusByType: function(subscribeType, status) {
            if (subscribeType == 'single') {
                return PAGE_PARAMS.isSingleSubscriber = this._subscribeStatus = status;
            }

            if (subscribeType == 'full') {
                return PAGE_PARAMS.isFullSubscriber = this._subscribeStatus = status;
            }
        },

        _isAnySubscription: function() {
            return this._subscribeStatus || PAGE_PARAMS.isFullSubscriber || PAGE_PARAMS.isSingleSubscriber;
        }

    });

    o_o.decl('subscribers-list', {

        init: function() {
            var _this = this;

            this.loadSubscribers();

            $('body').on('subscribers-reload', function(e, data) {
                _this.addSubscribers(data.subscribers);
            });

        },

        getButton: function() {
            return this._loadMoreButton || (this._loadMoreButton = this.elem('.subscribers-list__reload'));
        },

        loadSubscribers: function() {
            this.getButton().toggleClass('btn_spinner_visible');

            utils.catAjax({
                data: {
                    action: 'handleCategorySubscription',
                    catid: PAGE_PARAMS.catid,
                    getSubscribers: 1,
                    getSubscribedParents: 1
                },
                success: function(data) {
                    this.addSubscribers(data.subscribers)
                        .getButton().toggleClass('btn_spinner_visible');
                },
                error: function() {
                    this.getButton().toggleClass('btn_spinner_visible');
                }
            }, this);
        },

        addSubscribers: function(subscribers) {
            this.elem('.list-group-item').html(subscribers.join(', '));

            return this;
        }

    });

}());
