/**
 * @module inherit
 * @version 2.2.2
 * @author Filatov Dmitry <dfilatov@yandex-team.ru>
 * @description This module provides some syntax sugar for "class" declarations, constructors, mixins, "super" calls and static members.
 */

(function(global) {

var hasIntrospection = (function(){'_';}).toString().indexOf('_') > -1,
    emptyBase = function() {},
    hasOwnProperty = Object.prototype.hasOwnProperty,
    objCreate = Object.create || function(ptp) {
        var inheritance = function() {};
        inheritance.prototype = ptp;
        return new inheritance();
    },
    objKeys = Object.keys || function(obj) {
        var res = [];
        for(var i in obj) {
            hasOwnProperty.call(obj, i) && res.push(i);
        }
        return res;
    },
    extend = function(o1, o2) {
        for(var i in o2) {
            hasOwnProperty.call(o2, i) && (o1[i] = o2[i]);
        }

        return o1;
    },
    toStr = Object.prototype.toString,
    isArray = Array.isArray || function(obj) {
        return toStr.call(obj) === '[object Array]';
    },
    isFunction = function(obj) {
        return toStr.call(obj) === '[object Function]';
    },
    noOp = function() {},
    needCheckProps = true,
    testPropObj = { toString : '' };

for(var i in testPropObj) { // fucking ie hasn't toString, valueOf in for
    testPropObj.hasOwnProperty(i) && (needCheckProps = false);
}

var specProps = needCheckProps? ['toString', 'valueOf'] : null;

function getPropList(obj) {
    var res = objKeys(obj);
    if(needCheckProps) {
        var specProp, i = 0;
        while(specProp = specProps[i++]) {
            obj.hasOwnProperty(specProp) && res.push(specProp);
        }
    }

    return res;
}

function override(base, res, add) {
    var addList = getPropList(add),
        j = 0, len = addList.length,
        name, prop;
    while(j < len) {
        if((name = addList[j++]) === '__self') {
            continue;
        }
        prop = add[name];
        if(isFunction(prop) &&
                (!hasIntrospection || prop.toString().indexOf('.__base') > -1)) {
            res[name] = (function(name, prop) {
                var baseMethod = base[name]?
                        base[name] :
                        name === '__constructor'? // case of inheritance from plain function
                            res.__self.__parent :
                            noOp;
                return function() {
                    var baseSaved = this.__base;
                    this.__base = baseMethod;
                    var res = prop.apply(this, arguments);
                    this.__base = baseSaved;
                    return res;
                };
            })(name, prop);
        } else {
            res[name] = prop;
        }
    }
}

function applyMixins(mixins, res) {
    var i = 1, mixin;
    while(mixin = mixins[i++]) {
        res?
            isFunction(mixin)?
                inherit.self(res, mixin.prototype, mixin) :
                inherit.self(res, mixin) :
            res = isFunction(mixin)?
                inherit(mixins[0], mixin.prototype, mixin) :
                inherit(mixins[0], mixin);
    }
    return res || mixins[0];
}

/**
* Creates class
* @exports
* @param {Function|Array} [baseClass|baseClassAndMixins] class (or class and mixins) to inherit from
* @param {Object} prototypeFields
* @param {Object} [staticFields]
* @returns {Function} class
*/
function inherit() {
    var args = arguments,
        withMixins = isArray(args[0]),
        hasBase = withMixins || isFunction(args[0]),
        base = hasBase? withMixins? applyMixins(args[0]) : args[0] : emptyBase,
        props = args[hasBase? 1 : 0] || {},
        staticProps = args[hasBase? 2 : 1],
        res = props.__constructor || (hasBase && base.prototype.__constructor)?
            function() {
                return this.__constructor.apply(this, arguments);
            } :
            hasBase?
                function() {
                    return base.apply(this, arguments);
                } :
                function() {};

    if(!hasBase) {
        res.prototype = props;
        res.prototype.__self = res.prototype.constructor = res;
        return extend(res, staticProps);
    }

    extend(res, base);

    res.__parent = base;

    var basePtp = base.prototype,
        resPtp = res.prototype = objCreate(basePtp);

    resPtp.__self = resPtp.constructor = res;

    props && override(basePtp, resPtp, props);
    staticProps && override(base, res, staticProps);

    return res;
}

inherit.self = function() {
    var args = arguments,
        withMixins = isArray(args[0]),
        base = withMixins? applyMixins(args[0], args[0][0]) : args[0],
        props = args[1],
        staticProps = args[2],
        basePtp = base.prototype;

    props && override(basePtp, basePtp, props);
    staticProps && override(base, base, staticProps);

    return base;
};

var defineAsGlobal = true;
if(typeof exports === 'object') {
    module.exports = inherit;
    defineAsGlobal = false;
}

if(typeof modules === 'object') {
    modules.define('inherit', function(provide) {
        provide(inherit);
    });
    defineAsGlobal = false;
}

if(typeof define === 'function') {
    define(function(require, exports, module) {
        module.exports = inherit;
    });
    defineAsGlobal = false;
}

defineAsGlobal && (global.inherit = inherit);

})(this);

(function(global) {
    var utils = {};

    var catAjax = function(params, ctx) {
        params.data.cmd || (params.data.cmd = 'category_ajax_api');

        $.ajax({
            url: 'ind.pl',
            type: params.type || 'GET',
            data: params.data,
            processData: typeof params.processData == 'boolean' ? params.processData : true,
            cache: false,
            dataType: 'json',
            success: function(data) {
                if (data.status === 'OK') {
                    params.success.apply(ctx || this, arguments);
                }
            },
            error: function() {
                params.error && params.error.apply(ctx || this, arguments);
            }
        });
    };

    var reverse = function(s) {
        var o = '';
        for (var i = s.length - 1; i >= 0; i--) o += s[i];

        return o;
    };

    var prettyNumber = function(n, j) {
        var s = n.toString();

        return reverse(reverse(s).match(/.{1,3}/g).join(j || ','));
    };

    var linkAtoms = function(text) {
        var atoms = text.split(/([\[\/])(\.[^\]\/]+)/ig);

        return '';
    };

    var replaceBrackets = function(s) {
        return s.replace(/</g, '&lt;').replace(/>/g, '&gt;')
    };

    var replaceRange = function(s, start, end, fn) {
        return s.substring(0, start) + fn(s.substring(start, end)) + s.substring(end);
    };

    var getCatUrl = function(catid, urlOpts) {
        return 'ind.pl?cmd=show_phrases&id=' + catid + urlOpts;
    };

    var getListUrl = function(id, urlOpts) {
        return window.location.protocol + '//' + window.location.hostname + '/cgi/ind.pl?cmd=edit_phrase_list&act=showphl&phlid=' + id + urlOpts;
    };

    var getSearchBannersUrl = function(phrase) {
        return 'ind.pl?cmd=search_banners&do_search=1&phrase_text=' + encodeURI(phrase);
    };

    var onclickToString = function(params) {
        return ' onclick="return ' + JSON.stringify(params).replace(/\"/g, '\'') + '" ';
    };

    var onclickParams = function(params) {
        return 'return ' + JSON.stringify(params).replace(/\"/g, '\'');
    };

    var parseViewdblistoptsstr = function(string) {
        if (!string) {
            return {};
        }

        var params = {};

        $.trim(string)
            .split('|')
            .forEach(function(bunch) {
                var splitedBunch = bunch.split(/_/i),
                    paramName = splitedBunch[0],
                    options = splitedBunch[1];

                if (options) {
                    params[paramName] = _.uniq((params[paramName] || []).concat(options.split(';')));
                }
            });

        return params;
    };

    var compactViewdblistoptsstr = function(string, newParams) {
        var result = [],
            parsed = parseViewdblistoptsstr(string);

        if (newParams) {
            _.keys(newParams)
                .forEach(function(paramName) {
                    parsed[paramName]  = _.uniq(newParams[paramName] || []);
                });
        }

        if (parsed) {
            result =
                _.keys(parsed)
                .map(function(paramName) {
                    if (parsed[paramName].length) {
                        return paramName + '_' + parsed[paramName].join(';');
                    } else {
                        return false;
                    }
                })
                .filter(function(value) { return !!value });
        }

        return result.join('|');
    };

    var updateViewdblistoptsstr = function(element, newParams) {
        if (newParams) {
            element = $(element);
            element.val(compactViewdblistoptsstr(element.val(), newParams))
        }
    };

    var createAutocomplete = function(params, callback, ctx) {
        return params.elem.autocomplete({
            serviceUrl: 'ind.pl',
            params: {
                cmd: 'category_ajax_api',
                action: 'searchCategories',
                lang: params.lang
            },
            width: params.width,
            paramName: 'text',
            dataType: 'json',
            noCache: true,
            transformResult: function(response) {
                return {
                    suggestions: response.categories.map(function(item) {
                        return { value: item.CategoryName, data: item.CatID };
                    })
                };
            },
            triggerSelectOnValidInput: false,
            onSelect: function () {
                callback.apply(ctx || this, arguments);
            }
        });
    };

    var submitForm = function(request, formParams, extraStringParams) {
        var data = request || {},
            params = formParams,
            elemTag = params.elemTag || '<input/>',
            form = $('<form/>', {
                action: params.url,
                method: params.type || 'POST',
                target: params.target,
                ENCTYPE: params.enctype,
                name: params.name,
                style: 'display: none;'
            });

        Object.keys(data).forEach(function(paramName) {
            var paramValue = data[paramName];

            if (!Array.isArray(paramValue))
                paramValue = [paramValue];

            paramValue.forEach(function(value) {
                form.append($(elemTag, {
                    name: paramName,
                    value: value
                }));
            });
        });

        form.appendTo($('body')).submit().remove();
    };

    var o_o = (function() {
        var counter = 0,
            instances = {},
            classActions = {},
            create = function(domElem, params) {
                var id = ++counter,
                    classInstance = inherit(
                        classActions[params.o_o],
                        {
                            id: id,
                            domElem: domElem,
                            params: params,
                            _elems: {},
                            elems: function(selector) {
                                return this._elems[selector] || (this._elems[selector] = $(selector, this.domElem));
                            },
                            elem: function(selector) {
                                return (this._elems[selector] || (this._elems[selector] = $(selector, this.domElem))).first();
                            }
                        });

                domElem.attr('o_o', id);

                return instances[id] = new classInstance();
            };

        return {
            get: function(elem, params) {
                var domElem = $(elem),
                    id = domElem.attr('o_o');

                return id ? instances[id] : create(domElem, params);
            },
            getInstances: function() {
                return instances;
            },
            getInstance: function(id) {
                return instances[id];
            },
            getClass: function(name) {
                return classActions[name] || null;
            },
            decl: function(className, props, staticProps) {
                if (typeof className == 'string') {
                    classActions[className] = inherit(props, staticProps);
                } else {
                    classActions[className.className] = inherit(classActions[className.baseClass], props, staticProps);
                }
            },
            go: function() {
                var _this = this;

                $('.o_o-init').each(function(index, elem) {
                    _this.get(elem, elem.onclick()).init();
                });
            }
        }
    }());

    $('.do-it').on('click', function() {
        if ($(this).hasClass('btn_spinner_visible')) return;

        var params = this.onclick();

        o_o.get(this, params)[params.action](params);
    });

    utils.o_o = o_o;
    utils.catAjax = catAjax;
    utils.getCatUrl = getCatUrl;
    utils.getSearchBannersUrl = getSearchBannersUrl;
    utils.replaceRange = replaceRange;
    utils.linkAtoms = linkAtoms;
    utils.replaceBrackets = replaceBrackets;
    utils.prettyNumber = prettyNumber;
    utils.reverse = reverse;
    utils.createAutocomplete = createAutocomplete;
    utils.onclickToString = onclickToString;
    utils.onclickParams = onclickParams;
    utils.parseViewdblistoptsstr = parseViewdblistoptsstr;
    utils.compactViewdblistoptsstr = compactViewdblistoptsstr;
    utils.updateViewdblistoptsstr = updateViewdblistoptsstr;
    utils.submitForm = submitForm;
    utils.getListUrl = getListUrl;

    global.utils || (global.utils = utils);

    $(document).ready(function() {
        o_o.go();
    });

}(this));
