(function() {
    var PAGE_PARAMS = $('.page-params')[0] && $('.page-params')[0].onclick();
    var GRAMMAR_MODE = AceGrammar.getMode({
        "RegExpID": "dsfsdf",
        "Style": {
             "comment": "comment"
        },
        "Lex": {
            // подсветка коментариев
            "comment": {
                "type": "comment",
                "tokens":[
                    ["=>", null],
                    ["*>", null],
                    ["=!>", null]
                ]
            }
        },
        "Syntax": {
            "js": "comment | keyword"
        },
        "Parser": [["js"]]
    });

    utils.o_o.decl({ className: 'phrase-editor-actions', baseClass: 'spinner' }, {

        init: function() {
            var that = this;

            this._phraseEditorElem = this.domElem.closest('.phrase-editor');

            // MACRO JSON_ajax_actions (edit_phrase_list_actions.tmpl)
            this._buildActions(editPhraseListActions, editPhraseListTitles, actionsSequence);
            this._initTabs();

            // действия из владок «Файлы», «Фильтры» и т.д.
            this.elems('.phrase-editor-actions__action')
                .on('click', function() {
                    that._doAction(this.onclick());
                });

            // действие «сохранить список»
            $('.phrase-editor__save-list', this._phraseEditorElem)
                .on('click', function() {
                    that._saveList();
                });

            // действие «Сохранить список фраз для категории»
            $('.phrase-editor__save-category', this._phraseEditorElem)
                .on('click', function() {
                    that._submitForm({
                        actinf: 'catid_' + that.params.catid,
                        act: '_web_change_category_phrases'
                    }, {
                        target: '_blank'
                    });
                });

            // диалоговое окно параметров одно на все блоки фраз,
            // во время открытия окна происходит подписка конкретного блока с фразами на событие «submit-param»
            $("#ParamPhraseEditorDialog")
                .on('hidden', function() {
                    $(this).unbind('submit-param');
                });
        },

        /**
         * Сохраняет список фраз
         * @returns {Promise}
         * @private
         */
        _saveList: function() {
            return this._submitAjax({ method: 'save' })
                .then(function(data) {
                    return this.addListLink(data.phraseListID);
                });
        },

        /**
         * Добавляет инпут с ссылкой на сохраненный список
         * @param {String} id - id сохраненного списка
         * @returns {Promise}
         */
        addListLink: function(id) {
            var deferred = $.Deferred();

            if (!this._phraseListId) {
                this._phraseListId = id;
                this._phraseEditorElem
                    .append('Ссылка на список:', $().$input({
                            type: 'text',
                            'class': 'phrase-editor__list-link',
                            value: utils.getListUrl(id, PAGE_PARAMS.urlOpts)
                        }));
            } else {
                $('.phrase-editor__list-link', this.domElem)
                    .val(utils.getListUrl(id, PAGE_PARAMS.urlOpts));

                this._phraseListId = id;
            }

            deferred.resolveWith(this, [id]);

            return deferred.promise();
        },

        /**
         * Подписывается на действия владок «Редактирование», «Категории» и т.д.
         * @private
         */
        _initTabs: function() {
            var that = this,
                wrap = this.domElem.closest('.phrase-editor-wrap'),
                tabs = this._tabs = $('.phrase-editor-tabs', wrap),
                input = $('.phrase-editor-tabs__input', wrap);

            $('.phrase-editor-tabs__action', tabs)
                .on('click', function() {
                    that._doTabAction($(this).data('action'), input.val());
                });
        },

        /**
         * В зависимости от параметров выполняет действия с владок «Редактирование», «Категории» и т.д.
         * @param {Object} action
         * @param {String} action.name - название метода
         * @param {String} [action.type] - тип вкладки
         * @param {String} [action.target] - target параметр формы('blank')
         * @param {String} value - значение инпута из текущей вкладки
         * @private
         */
        _doTabAction: function(action, value) {
            var editor = this.getEditor(),
                breakpointsText = [];

            if (action.name == 'mark-phrase') {
                var regExp = new RegExp(value, 'ig');

                // Промаркировать фразы, соответствующие шаблону
                editor.session.doc
                    .getAllLines()
                    .forEach(function(text, index) {
                        if (text.match(regExp)) {
                            editor.session.setBreakpoint(index);
                        }
                    });
            } else if (action.name == 'clear-marked') {

                // Снять выделения фраз
                editor.session
                    .clearBreakpoints();
            } else if (action.name == 'delete-selected-categs-phrases') {

                // Удалить выбранные фразы
                editor.session
                    .getBreakpoints()
                    .forEach(function(hasBreakpoint, index) {
                        if (!!hasBreakpoint) {
                            breakpointsText.push(editor.session.getLine(index));
                        }
                    });

                this._submitForm({
                    act: '_categs_delphrases',
                    phrases_text: breakpointsText.join('\n')
                }, {
                    target: '_blank'
                });
            } else if (action.target == 'blank') {
                // Действия ведущие на cmd отличный от edit_phrase_list открывает в новой владке
                this._submitForm({ act: action.name }, { target: '_blank' });
            } else if (action.type == 'lists') {
                // Действия вкладки «Списки»
                this._doListsAction(action.name);
            } else if (action.type == 'categories') {
                // Действия вкладки «Категории»
                this._doCategoriesAction(action.name);
            } else {
                this._submitAjax({
                    method: action.name,
                    'arguments': JSON.stringify([value])
                });
            }
        },

        /**
         * Выполняет действия с владки «Категории»
         * @param {String} method - метод
         * @private
         */
        _doCategoriesAction: function(method) {
            var checkbox = $('.phrase-editor-tabs__exact-matching-flag', this._tabs),
                input = $('.phrase-editor-tabs__categ-input', this._tabs);

            this._submitAjax({
                method: method,
                'arguments': JSON.stringify([input.val(), checkbox.prop('checked') ? 1 : 0])
            });
        },

        /**
         * Выполняет действия с владки «Списки»
         * @param {String} method - метод
         * @private
         */
        _doListsAction: function(method) {
            var select = $('.phrase-editor-tabs__select-b', this._tabs),
                index = select.val() - 1,
                that = this;

            this.getActionsInstanceByIndex(index)
                ._saveList()
                .then(function(id) {
                    that
                        ._submitAjax({
                            method: method,
                            'arguments': JSON.stringify([id])
                        })
                        .then(function(data) {
                            this.addListLink(data.phraseListID)
                        })
                });
        },

        /**
         * Находит экземпляр phrase-editor по индексу
         * @param {Number} index - номер редактора
         * @returns {o_o}
         */
        getActionsInstanceByIndex: function(index) {
            var phraseEditor = $('.phrase-editor').eq(index),
                actionsElem = $('.phrase-editor-actions', phraseEditor);

            return utils.o_o.getInstance(actionsElem.attr('o_o'));
        },

        /**
         * Отправляет форму
         * @param {Object} options - параметры запроса
         * @param {Object} optionsForm - параметры формы
         * @private
         */
        _submitForm: function(options, optionsForm) {
            var params = this.params,
                formParams = {
                    elemTag: '<textarea/>',
                    enctype: 'multipart/form-data'
                },
                request = {
                    cmd: params.cmd,
                    nltype: params.nltype,
                    viewoptionsstr: params.viewoptionsstr
                };

            request.retpath = '';
            request.prevphlid = params.prevphlid;
            request.prevdelphlid = params.prevdelphlid;
            request.nosavingdata = params.nosavingdata;
            request.phrases_text = this.getEditor().getValue();

            _.extend(request, options);
            optionsForm && _.extend(formParams, optionsForm);

            // если на странице всего один редактор выполняем действие в том же окне
            if ($('.phrase-editor').length == 1) {
                formParams.target = undefined;
            }

            utils.submitForm(request, formParams);
        },

        /**
         * Ajax-запрос
         * @param {Object} params - параметры запроса
         * @param {Boolean} isFormData - флаг processData для $.ajax
         * @returns {Promise}
         * @private
         */
        _submitAjax: function(params, isFormData) {
            var deferred = $.Deferred(),
                editor = this.getEditor(),
                that = this;

            this.addSpinner(this.domElem);

            if (isFormData) {
                params.append('action', 'handlePhraseList');
                params.append('text', editor.getValue());
                params.append('cmd', 'category_ajax_api');
            } else {
                params.action = 'handlePhraseList';
                params.text = editor.getValue();
            }

            utils.catAjax({
                data: params,
                type: 'POST',
                processData: !isFormData,
                success: function(data) {
                    editor.setValue(data.text);
                    that.removeSpinner(that.domElem);
                    deferred.resolveWith(this, [data]);
                },
                error: function(error) {
                    alert('Ошибка, попробуйте еще раз');
                    that.removeSpinner(that.domElem);
                    deferred.rejectWith(this, [error]);
                }
            }, this);

            return deferred.promise();
        },

        /**
         * Выполняет действия владок «Файлы», «Фильтры» и т.д.
         * @param {Object} options - параметры метода
         * @private
         */
        _doAction: function(options) {
            var that = this;

            if (!options.type) {
                options.target == 'blank' ?
                    this._submitForm({ act: options.name }, { target: '_blank' }) :
                    this._submitAjax({ method: options.name });
            } else if (options.type == 'param') {
                // модальное окно для ввода параметров
                $('#ParamPhraseEditorDialog')
                    .modal('show')
                    .on('submit-param', function(e, data) {
                        that._submitAjax({
                            'arguments': JSON.stringify([data.value]),
                            method: options.name
                        });
                    });
            } else if (options.type == 'file') {
                // загружает файл
                this._actionFile(options);
            } else if (options.type == 'export') {
                // экспортирует фразы в файл
                this._actionExport(options);
            }
        },

        /**
         * Действие загрузки файла
         * @param {Object} options - параметры метода
         * @private
         */
        _actionFile: function(options) {
            var that = this,
                input = $().$input({
                    type: 'file',
                    'class': 'phrase-editor-actions__file-input',
                    autocomplete: 'off',
                    style: 'display: none;'
                });

            // получает данные из файла
            input.on('change', function(e) {
                var file = e.target.files[0],
                    fr = new FileReader();

                fr.onload = function() {
                    that._submitAjax({
                        method: options.name,
                        'arguments': JSON.stringify([input.val(), fr.result])
                    });
                };

                fr.readAsText(file);
                //fr.readAsDataURL(file);
            });

            this.domElem.append(input);

            input.click();
        },

        /**
         * Действие экспорт фраз в файл
         * @param options
         * @private
         */
        _actionExport: function(options) {
            this._submitForm({ act: options.name }, options.target == 'blank' && { target: '_blank' });
        },

        _editor: null,

        /**
         * Получает экземпляр ace-редактра
         * @returns {ace}
         */
        getEditor: function() {
            return this._editor ||
                (this._editor = ace.edit($('.phrase-editor__ace', this.domElem.closest('.phrase-editor'))[0]));
        },

        _buildActions: function(actions, titles, sequence) {
            this.domElem.append($().$ul(
                sequence
                    .filter(function(name) {
                        return !!actions[name];
                    })
                    .map(function(name) {
                        return $().$li([
                            $().$a([
                                titles[name] || name
                            ], {
                                'data-toggle': 'dropdown',
                                'class': 'dropdown-toggle'
                            }),
                            this._buildTree(actions[name])
                        ], {
                            'class': 'dropdown'
                        });
                    }, this),
                    {
                        'class': 'nav nav-pills phrase-editor-actions__nav'
                    }));
        },

        _buildTree: function(items) {
            return $().$ul(
                items.map(function(item) {
                    var liClass = {};

                    item.sublist && (liClass = { 'class': 'dropdown-submenu' });
                    item.cmdname == '---' && !item.sublist && (liClass = { 'class': 'divider' });

                    return $().$li([
                        item.elem ?
                            $().$span([
                                $().$span(item.cmdtitle || item.cmdname, { 'class': 'phrase-editor-actions__setting-title' }),
                                $().$span(item.elem)
                            ], {
                                'class': 'phrase-editor-actions__setting'
                            }) :
                            $().$a([
                                item.cmdtitle || item.cmdname
                            ], {
                                href: '#',
                                'class': 'phrase-editor-actions__action',
                                onclick: utils.onclickParams({
                                    title: item.cmdtitle || item.cmdname,
                                    name: item.cmdname,
                                    filefield: item.filefield,
                                    target: item.target,
                                    type: item.type
                                })
                            }),
                        item.sublist && this._buildTree(item.sublist)
                    ], liClass)
                }, this),
                { 'class': 'dropdown-menu' });
        }
    }, {

        _searchActions: null,

        getSearchActions: function() {
            if (this._searchActions) {
                return this._searchActions;
            }

            var that = this;

            this._searchActions = $().$div([
                    $().$input({
                        type: 'text',
                        'class': 'search-actions__input',
                        placeholder: 'Search',
                        autocomplete: 'off'
                    }),
                    $().$i({ 'class': 'icon-remove search-actions__close' })
                ], { 'class': 'search-actions', style: 'display: none;' });

            $('body').append(this._searchActions);

            $('.search-actions__close', this._searchActions).on('click', function() {
                that._searchActions.hide();
            });

            $('.search-actions__input', this._searchActions)
                .autocomplete({
                    lookup: this.getSearchData(editPhraseListActions),
                    onSelect: function (suggestion) {
                        var actionsInstance = that.getActionsInstance();

                        if (actionsInstance) {
                            actionsInstance._doAction(suggestion.data);
                            that.getSearchInput().val('');
                            that._searchActions.hide();
                        }
                    }
                });

            $(document).keyup(function(e) {
                if (e.keyCode === 27) {
                    that._searchActions.hide();
                    that._editor && that._editor.focus();
                }
            });

            return this._searchActions;
        },

        getActionsInstance: function() {
            if (this._editor) {
                var phraseEditor = $(this._editor.container).closest('.phrase-editor'),
                    actionsElem = $('.phrase-editor-actions', phraseEditor);

                return utils.o_o.getInstance(actionsElem.attr('o_o'));
            } else {
                return null;
            }
        },

        getSearchData: function(actions) {
            var result = [],
                getData = function(items) {
                    items.forEach(function(item) {
                        if (item.cmdname != '---') {
                            item.cmdname && result.push({
                                data: {
                                    name: item.cmdname,
                                    type: item.type
                                },
                                value: item.cmdtitle || item.cmdname
                            });
                        }

                        if (item.sublist) {
                            item.sublist && getData(item.sublist);
                        }
                    });
                };

            _.keys(actions)
                .forEach(function(name) {
                    getData(actions[name]);
                });

            return result;
        },

        getSearchInput: function() {
            if ($('.search-actions')) {
                this.getSearchActions();
            }

            return $('.search-actions__input', this._searchActions);
        },

        setEditor: function(editor) {
            this._editor = editor;
        }

    });

    utils.o_o.decl('phrase-editor', {
        init: function() {
            var that = this;

            this._createEditor();
            this._createBottomActions();

            this.elems('.phrase-editor__extra-action')
                .on('click', function() {
                    var params = that.params,
                        editor = ace.edit(that.elem('.phrase-editor__ace')[0]),
                        type = this.onclick().type,
                        formParams = {
                            elemTag: '<textarea/>',
                            enctype: 'multipart/form-data'
                        },
                        request = {
                            cmd: params.cmd,
                            act: '_saveinf',
                            nltype: params.nltype,
                            viewoptionsstr: params.viewoptionsstr
                        };

                    if (type == 'delete-and-open' || type == 'open') {
                        var needDelete = type == 'delete-and-open' && confirm('Вы действительно хотите удалить выделенные фразы из списка?'),
                            breakpoints = editor.session.getBreakpoints(),
                            result = [];

                        breakpoints.forEach(function(hasBreakpoint, index) {
                            if (!!hasBreakpoint) {
                                result.push(editor.session.getLine(index));
                            }
                        });

                        if (needDelete) {
                            for (var i = breakpoints.length; i >= 1; i--) {
                                if (!!breakpoints[i - 1]) {
                                    editor.session.clearBreakpoint(i - 1);
                                    editor.selection.moveTo(i - 1);
                                    editor.selection.selectLine();
                                    editor.remove();
                                }
                            }
                        }

                        formParams.target = '_blank';

                        request.actinf = '';
                        request.spparam1 = '';
                        request.phrases_text = result.join('\n');

                        utils.submitForm(request, formParams);
                    } else if (type == 'save-to-link') {
                        request.retpath = '';
                        request.prevphlid = params.prevphlid;
                        request.prevdelphlid = params.prevdelphlid;
                        request.nosavingdata = params.nosavingdata;
                        request.phrases_text = editor.getValue();

                        utils.submitForm(request, formParams);
                    } else if (type == 'append') {
                        var cursor = editor.getCursorPosition();

                        that.getAppendCategoryInstance()
                            .show({
                                instance: that,
                                phrase: editor.session.getLine(cursor.row),
                                row: cursor.row
                            });
                    } else if (type == 'help') {
                        $('#ace-shortcuts').modal('show');
                    }
                });
        },

        _replacePhrase: function(phrase, category) {
            phrase = phrase.replace(/\s*=>.*/g, '');

            return phrase + ' => ' + category;
        },

        appendCategory: function(type, text) {
            var editor = ace.edit(this.elem('.phrase-editor__ace')[0]),
                Range = ace.require("ace/range").Range,
                cursor = editor.getCursorPosition(),
                newPhrase,
                rows = [],
                range;

            if (type == 'single') {
                range = new Range(cursor.row, 0, cursor.row, Number.MAX_VALUE);
                newPhrase = this._replacePhrase(editor.session.getLine(cursor.row), text);

                editor.session.replace(range, newPhrase);
            } else {
                if (type == 'all') {
                    rows = editor.session.doc.getAllLines();
                } else {
                    rows = editor.session.getBreakpoints()
                }

                rows.forEach(function(needReplace, index) {
                    if (!!needReplace) {
                        range = new Range(index, 0, index, Number.MAX_VALUE);
                        newPhrase = this._replacePhrase(editor.session.getLine(index), text);

                        editor.session.replace(range, newPhrase);
                    }
                }, this);
            }
        },

        getAppendCategoryInstance: function(index) {
            return utils.o_o.getInstance($('#append-category-to-phrases').attr('o_o'));
        },

        _createBottomActions: function() {
            this.domElem.append(
                $().$div([
                    this.params.catid && $('.phrase-editor').length == 1 ?
                        $().$a('Сохранить список фраз для категории', {
                            'class': 'btn btn-mini phrase-editor__save-category',
                            href: '#',
                            title: 'Заменяет список фраз категории на новый список'
                        }) :
                        '',
                    $().$a('сохранить список', {
                        'class': 'btn btn-mini phrase-editor__save-list',
                        href: '#',
                        title: 'Закрепить изменения. Отправляет текущее состояние фраз на сервер. После этого ссылку на эту страницу можно копировать - по ней будет открываться текущее состояние фраз.'
                    }),
                    $().$div([
                        $().$span([
                            $().$i({ 'class': 'icon-share' })
                        ], {
                            'class': 'phrase-editor__extra-action',
                            onclick: utils.onclickParams({ type: 'delete-and-open' }),
                            title: 'Открыть  помеченные фразы в новом окне. Из текущего списка удаляются.'
                        }),
                        $().$span([
                            $().$i({ 'class': 'icon-share-alt' })
                        ], {
                            'class': 'phrase-editor__extra-action',
                            onclick: utils.onclickParams({ type: 'open' }),
                            title: 'Открыть  помеченные фразы в новом окне.'
                        }),
                        $().$span([
                            $().$i({ 'class': 'icon-plus' })
                        ], {
                            'class': 'phrase-editor__extra-action',
                            onclick: utils.onclickParams({ type: 'append' })
                        }),
                        $().$span([
                            $().$i({ 'class': 'icon-question-sign' })
                        ], {
                            'class': 'phrase-editor__extra-action',
                            onclick: utils.onclickParams({ type: 'help' })
                        })
                        //$().$a([
                        //    $().$i({ 'class': 'icon-hdd' })
                        //], {
                        //    'class': 'phrase-editor__extra-action',
                        //    href: '#',
                        //    onclick: utils.onclickParams({ type: 'save-to-link' }),
                        //    title: 'Закрепить изменения. Отправляет текущее состояние фраз на сервер. После этого ссылку на эту страницу можно копировать - по ней будет открываться текущее состояние фраз.'
                        //})
                    ], {
                        'class': 'phrase-editor__extra-wrap'
                    })
                ], {
                    'class': 'phrase-editor__extra'
                }));
        },

        _createEditor: function() {
            var editor = ace.edit(this.elem('.phrase-editor__ace')[0]),
                showSearch = $('<i class="icon-search phrase-editor__show-search"></i>');
                that = this;

            editor.getSession().setMode(GRAMMAR_MODE);

            editor.setTheme('ace/theme/chrome');
            editor.on('guttermousedown', function(e, editor) {
                var target = e.domEvent.target,
                    row = e.getDocumentPosition().row;

                $(target).hasClass('ace_breakpoint') ?
                    editor.session.clearBreakpoint(row) :
                    editor.session.setBreakpoint(row);
            });

            editor.setPrintMarginColumn(10000);

            editor.commands.addCommand({
                name: 'searchPhraseCommand',
                bindKey: { win: "Ctrl-Alt-M", mac: "Command-Option-N" },
                exec: function(editor) {
                    that.showSearchActions(editor);
                }
            });

            $('.phrase-editor-actions', this.domElem).append(showSearch);

            showSearch.on('click', function() {
                that.showSearchActions(editor);
            });

        },

        _getEditorActions: function() {
            return utils.o_o.getClass('phrase-editor-actions');
        },

        showSearchActions: function(editor) {
            var searchActions = this._getEditorActions().getSearchActions();

            $(editor.container)
                .append(searchActions);

            this._getEditorActions()
                .setEditor(editor);

            searchActions.show();

            this._getEditorActions()
                .getSearchInput().focus().val('');
        }
    });

    utils.o_o.decl('append-category-to-phrases', {

        init: function() {
            var that = this,
                searchElem = this.elem('.append-category-to-phrases__search');


            searchElem.on('input', $.debounce(300, this._search).bind(this));

            this.elems('.append-category-to-phrases__action')
                .on('click', function() {
                    that._editorOptions.instance
                        .appendCategory(this.onclick().type, searchElem.val());

                });
        },

        _editorOptions: null,

        show: function(options) {
            this._editorOptions = options;

            this.elem('.append-category-to-phrases__phrase')
                .val(options.phrase.replace(/=>.*/g, ''));

            $('#append-category-to-phrases').modal('show');
        },

        _search: function(e) {
            this._currentCategory = null;

            utils.catAjax({
                data: {
                    cmd: 'category_ajax_api',
                    action: 'searchCategories',
                    lang: PAGE_PARAMS.lang,
                    text: $(e.target).val()
                },
                success: function(data) {
                    this._buildCategoriesList(data.categories);
                },
                error: function() {
                    console.log(arguments);
                }
            }, this);
        },

        _buildCategoriesList: function(categories) {
            var container = this.elem('.append-category-to-phrases__list'),
                that = this;

            $('.append-category-to-phrases__category-id', this.domElem)
                .unbind('click');

            container.empty();

            if (categories.length) {
                container.append(
                    categories.map(function(category) {
                        return $().$div([
                            $().$span(category.CatID, {
                                onclick: utils.onclickParams({ id: category.CatID, name: category.CategoryName }),
                                'class': 'append-category-to-phrases__category-id'
                            }),
                            $().$a(category.CategoryName, {
                                href: utils.getCatUrl(category.CatID, PAGE_PARAMS.urlOpts),
                                target: '_blank'
                            })
                        ], {
                            'class': 'append-category-to-phrases__item'
                        })
                    }));

                $('.append-category-to-phrases__category-id', this.domElem)
                    .on('click', function() {
                        that._onCategoryIdClick(this.onclick());
                    });
            } else {
                container.html('Ничего не найдено');
            }
        },

        _currentCategory: null,

        _onCategoryIdClick: function(category) {
            this._currentCategory = category;

            this.elem('.append-category-to-phrases__search')
                .val(category.name);
        }

    });

    utils.o_o.decl('add-phrase-editor', {
        init: function() {
            var that = this;

            this.domElem.on('click', function() {
                that._buildEditor();
            });
        },

        _buildEditor: function() {
            var phraseEditor,
                editorActions,
                treeCount = 0,
                tabs,
                tree;

            tree = $().$div([
                phraseEditor = $().$div([
                    editorActions = $().$div({
                        'class': 'phrase-editor-actions o_o-init',
                        onclick: utils.onclickParams({ o_o: 'phrase-editor-actions' })
                    }),
                    $().$div({ 'class': 'phrase-editor__ace' })
                ], {
                    'class': 'phrase-editor o_o-init',
                    onclick: utils.onclickParams({ o_o: 'phrase-editor' })
                })
            ], { 'class': 'phrase-editor-wrap' });

            this.domElem.before(tree);

            treeCount = $('.phrase-editor').length;
            tabs = $('.phrase-editor-tabs').eq(0).clone();

            $('.tab-pane', tabs).each(function(index) {
                $(this).attr({ id: 'tab' + treeCount + index });
            });

            $('.nav__link', tabs).each(function(index) {
                $(this).attr({ href: '#tab' + treeCount + index });
            });

            phraseEditor.after(tabs);

            $('.phrase-editor-tabs__select-b').append($().$option(treeCount, { value: treeCount }));

            utils.o_o.get(phraseEditor, phraseEditor[0].onclick()).init();
            utils.o_o.get(editorActions, editorActions[0].onclick()).init();
        }

    });

})();
