package BaseForm;

use base (qw(ObjLib::Obj));

use Encode qw(from_to);

sub error {
    my ($self, $err) = @_;
    print STDERR "form parse error $err\n";
}

sub html_encode {
    my ($str) = @_;

    return unless defined($str);

    for ($str) {
        #s/&/&amp;/g;
        s/</\&lt;/g;
        s/>/\&gt;/g;
        s/\`/&#96;/g;
        s/"/&quot;/g;
        s/'/&#39;/g; # http://www.w3.org/TR/html4/sgml/entities.html IE не показывает &apos; в XHTML
    };

    return $str;
};

sub getlast {
    my ($self, $fld) = @_;
    if($self->{'__arrayref'}{$fld}){
        my @arr = reverse @{$self->{'__arrayref'}{$fld}};
        return shift @arr;
    }
    return undef;
}

sub getfldlist {
    my ($self, $fld) = @_;
    if($self->{'__arrayref'}{$fld}){
        return [ @{$self->{'__arrayref'}{$fld}} ];
    }
    return [];
}

sub parse {
    my ($self) = @_;

    my @pairs = ();
    $self->clear;
    my $delplus = 1;
    if ($ENV{'REQUEST_METHOD'} eq 'GET' || $ENV{'REQUEST_METHOD'} eq 'HEAD') {
        @pairs = split(/&/, $ENV{'QUERY_STRING'});
    } elsif (($ENV{'REQUEST_METHOD'} eq 'POST') && ($ENV{CONTENT_TYPE} =~ m/multipart\/form\-data\;/)) {
        ($ENV{'CONTENT_LENGTH'} < 500 * 1024 * 1024) || return $self->error(414);
        my $indata;
        binmode(STDIN);
        read(STDIN, $indata, $ENV{'CONTENT_LENGTH'});
        my ($spliter, $end, $data) = $indata =~ m/^([^ \r\n]+)([\r\n]{1,2})(.*?)\2\1--.?.?$/s;

        foreach my $block (split(/$end\Q$spliter\E$end/, $data)) {
            my ($header, $content) = split($end.$end, $block, 2);
	        
 	    # kostyl inserted 28.07.2013
            Encode::_utf8_on($content);
            Encode::_utf8_on($header);

            my %header;
            foreach my $line (split(/($end)|(\s*;\s*)/,$header)) {
                my ($name, $value) = split(/=|:\s*/,$line, 2);
                $value =~ s/^"?(.*?)"?$/$1/;
                $header{$name} = $value;
            }

            if ($header{filename}) {
                $self->{$header{name}} = $content;

                $self->_unescape(\$header{filename});
                html_encode(\$header{filename});

                $self->{$header{name} . '_filename'} = $header{filename};
                $self->{$header{name} . '_filename'} = $1 if $header{filename} =~ /([^\\\/]+)$/;
            }elsif ($header{name}) {
	        # kostyl
                Encode::_utf8_on($content);
                $self->_unescape(\$content, plus_change => 0 );
                utf8::upgrade($content);
                html_encode(\$content);
                $self->{$header{name}} = join(', ', ( $self->{$header{name}} || (), $content ) );
                push( @{ $self->{__arrayref}{$header{name}} ||= [] },  $content );
            };
        };
    }elsif ($ENV{'REQUEST_METHOD'} eq 'POST') {
        my $buffer;
        read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
        $delplus = 1;
        @pairs = split(/&/, $buffer);
    } else {
        return $self->error(405);
    };
    $self->{'__arrayref'} ||= {};
    foreach my $pair (@pairs) {

	# kostyl
	Encode::_utf8_on($pair);
	# /kostyl

        my ($name, $value) = split(/=/, $pair, 2);
        $value = '' unless (defined $value);

        $self->{'__arrayref'}{$name} ||= [];

        $self->_unescape(\$name);
        $self->_unescape(\$value, plus_change => $delplus);

        #Удаление мусора
        my $sname  = $name;
        my $svalue = $value;
        $name = html_encode($name);
        $value = html_encode($value);

        push(@{$self->{'__arrayref'}{$name}}, $value);

        if ($self->{$name} && ($value ne '')) {
            $self->{$name} .= ", $value";
            $self->{__origin}{$sname} .= ", $svalue";
        } else {
            $self->{$name} = $value;
            $self->{__origin}{$sname} = $svalue;
        };
    };

    return 1;
};

sub clear {
    my ($self) = @_;

    delete $self->{$_} foreach keys %$self;
};


sub as_hashref {
    my ($self) = @_;

    return {%$self};
};

sub _unescape {
    my ($self, $text, %opts) = @_;

    $opts{plus_change} = 1 unless defined $opts{plus_change};

    # kostyl
    Encode::_utf8_on($$text);
    # / kostyl

    $$text =~ tr/+/ / if $opts{plus_change};
    $$text =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

    from_to($$text, 'cp1251', 'UTF-8') unless eval { Encode::decode_utf8($$text, Encode::FB_CROAK); 1; };

    utf8::decode($$text);
};


=head2 get_array_for_name_with_number

B<Параметры:> 1) $ с назаванием параметра

B<Возвращаемое значение:> 1) $ с ссылкой на список значений, у которых ключ - это переданный скаляр + номер

Пример. Есть вот такая форма:

    $VAR1 = bless( { 
                     'mirror2' => '2',
                     'ID' => '148715',
                     'saving' => '1',
                     'cmd' => 'campaign_edit',
                     'mirror1' => '1',
                     'mirror3' => '3',
                     'act' => 'edit_mirrors'
                   }, 'Cmds::Base::Form' );

В то случае, если сказать
    LogDump $self->form->get_array_for_name_with_number("mirror");

то будет возвращена ссылка на список (1, 2, 3);

=cut

sub get_array_for_name_with_number {
    my ($self, $param) = @_;

    my $result = [];
#    foreach (sort_strings_with_numbers(keys %$self)) {
    foreach (keys %$self) {
        if ( /^$param\d+$/ ) {
            push @$result, $self->{$_};
        }
    }

    return $result; 
}

1;

