package BlackboxSimple;

use warnings;

use File::Basename qw(dirname);
use Cwd qw(abs_path);

use LWP::UserAgent;
use HTTP::Request;
use XML::Simple;
use URI::Escape qw(uri_escape_utf8);
use Time::HiRes;
use POSIX qw/strftime/;
use Utils::Hosts qw/get_host_role/;
use Utils::Common qw/get_options/;

use lib dirname(abs_path(__FILE__)).'/../lib';
use Utils::Hosts;

use Net::INET6Glue::INET_is_INET6; # future is here

our $BB_LOGIN        = 'accounts.login.uid';
our $BB_EMAIL        = 'account_info.email.uid';
our $BB_FIO          = 'account_info.fio.uid';
our $BB_NICKNAME     = 'account_info.nickname.uid';


# Стандартный Перловый агент
sub get_ua {
    return LWP::UserAgent->new(
        timeout => 10,
        agent => "Yandex::Blackbox/perl/1.00",
    );
}

# Возврщает основную часть урла (на который будет происходить запрос в Паспорт) и хедеры запроса
sub get_request_params {
    my %res = {};

    # Определяем атрибуты для авторизации в Паспорте, если они есть в 'Hosts.pm'. Иначе устанавливаем по-умолчанию в зависимости от ситуации
    my $host_info = Utils::Hosts::get_host_info();

    # Значения по-умолчанию
    $res{pass_host} = "blackbox.yandex.net";
    if ($host_info->{test} or $host_info->{test_blackbox}) {
        $res{pass_host} = 'blackbox-mimino.yandex.net';
    }

    $res{auth_domain} = "yandex.ru";
    $res{additional_headers} = [];
    my $use_tvm = 0;

    # При надобности переинициалируем эти значения, если они прописаны в конфигурации роли/хоста в 'Hosts.pm'
    if (exists $host_info->{"passport_auth"}) {
        $res{pass_host} = $host_info->{"passport_auth"}->{"pass_host"};
        $res{auth_domain} = $host_info->{"passport_auth"}->{"auth_domain"};
        $use_tvm = $host_info->{"passport_auth"}->{"use_tvm"};
    }

    # Если используем TVM для хождения в Паспорт, извлекаем свежий Service-тикет из соответствующей папки и отправляем его в специальном хедере
    if ($use_tvm) {
        my $underline_auth_domain = $res{auth_domain};
        $underline_auth_domain =~ s/\./\_/g;
        my $service_ticket_file = $Utils::Common::options->{secrets}->{server_dir} . "/tvm/$underline_auth_domain" . "_service_ticket";

        open my $fh, "<", $service_ticket_file
            or die "Could not open $service_ticket_file: $!";
        my $service_ticket = <$fh>;
        close($fh);

        $res{additional_headers} = ["X-Ya-Service-Ticket" => $service_ticket];
    }

    my $ip = $ENV{'REMOTE_ADDR'};
    if (($ip eq "::1") or ($ip eq "127.0.0.1")) {
        $ip = (split '\,', $ENV{'HTTP_X_FORWARDED_FOR'})[-1];
    }
    $res{ip} = uri_escape_utf8($ip);

    return \%res;
}

# Запрос в Паспорт с помощью метода "userinfo" для получения информации о логине пользователя
sub userinfo_request {
    my $bb_func = shift;
    my $bb_args = shift;

    my $req_params = get_request_params();
    my $url = "http://$req_params->{pass_host}/blackbox/"
              ."?method=userinfo"
              ."&userip=".$req_params->{ip}
              ."&$bb_func=$bb_args";

    my $ua = get_ua();
    my $req = HTTP::Request->new('GET', $url, $req_params->{additional_headers});

    my $resp = $ua->request($req);
    if ($resp->is_success) {
        return $resp->as_string;
    } else {
        die "Blackbox Error: " . $resp->status_line;
    }
}

sub get_login {
	my $result = "";
	my $data = get_user_data();
	if (exists($data->{dbfield}{'accounts.login.uid'})) {
		$result = $data->{dbfield}{'accounts.login.uid'};
	};
	return $result;
}

sub get_user_data {
    # делаем http запрос
    my $ua = get_ua();
    
    my $session_id = 0;
    if ( $ENV{'HTTP_COOKIE'} =~ /Session_id=([^;]+)/ ) {
    	$session_id = $1;
    }

    my $cookies = $ENV{'HTTP_COOKIE'};
    $cookies =~ s/\;/;<br>/g;

    my $req_params = get_request_params();

    # Составляем запрос к Паспорту и отправляем его
    my $url = "http://$req_params->{pass_host}/blackbox/"
              ."?host=$req_params->{auth_domain}"
              ."&regname=yes"
              ."&userip=".$req_params->{ip}
              ."&dbfields=".uri_escape_utf8(join(",", $BB_LOGIN, $BB_EMAIL, $BB_FIO))
              ."&sessionid=".uri_escape_utf8($session_id);

    # выполнение запроса
    my $req = HTTP::Request->new('GET', $url, $req_params->{additional_headers});
    print STDERR $req->as_string if $DEBUG;

    # пытаемся послать запрос несколько раз с разными таймаутами
    my $resp;
    for my $timeout (2, 5) {
        $ua->timeout($timeout);
        my $ts = Time::HiRes::time();
        $resp = $ua->request($req);
        if ($resp->is_success) {
            last;
        }
    }
    print STDERR $resp->as_string if $DEBUG;

    if ($resp->is_success) {
        # парсим полученный XML
        my $simple = XML::Simple->new();
        my $res = eval {
            XML::Simple::XMLin($resp->content, ForceArray => ['dbfield', 'address'], SuppressEmpty => 1);
        };
        if ($@ || !defined $res || !defined $res->{status}) {
            if ($res->{error} && ($res->{error} ne "OK")) {
                 die "Blackbox error: '$res->{error}'\n";
            }
            die "BlackboxSimple.pm: XML parse error\n";
        }


        # перерабатываем статусы
        $res->{valid} = $res->{status}->{id} == 0 || $res->{status}->{id} == 1;
        $res->{renew} = $res->{status}->{id} == 1;

        unless ($res->{status}{content} =~ /^(?:NOAUTH|EXPIRED|NEED_RESET|VALID|INVALID|NEED_RESIGN)$/i) {
            print STDERR Carp::longmess;
            die "Blackbox: Invalid status returned: ".$res->{status}{content}." id:".$res->{status}{id};
        }

        # переделываем аттрибуты для удобства
        if (my $dbf = $res->{dbfield}) {
            for my $field (keys %{$dbf}) {
                $dbf->{$field} = $dbf->{$field}->{content};
            }
        }

        $res->{'uid'} = $res->{'uid'}{'content'} if ref $res->{'uid'} eq 'HASH';

        return $res;
    } else {
        die "Blackbox http error: " . $resp->status_line;
    }
}

1;
