package Cmds::AdminInterface;

use utf8;

use base qw(Cmds::Base);
use JSON qw(to_json from_json);
use Data::Dumper;
use List::Util qw(sum min max minstr maxstr);
use Encode;

use Utils::DB qw();
use Utils::Sys qw(uniq);
use BM::Monitor::Utils qw();
use BM::Monitor::Logs;
use BM::Resources;
use Utils::Hosts qw( get_hosts get_host_role get_host_info get_short_hostname get_curr_host );

use strict;

sub monitor_errors :CMDH {
    my ($proj, $vars) = @_;

    my $from_Time_default = $proj->dates->next_n_date(-1, 'db');
    my $to_Time_default = $proj->dates->next_n_date(0, 'db');

    my $form = $proj->form;
    my $uniq_type = $form->{flt_UniqType};
    my $fld_uniq =  $uniq_type eq 'Role'  ?  'ErrorIDUniqReduceHost'  :
        $uniq_type eq 'Host'  ?  'ErrorIDUniq'  :
        'ErrorIDUniq';   # TODO - без уникализации

    return {
        title => "Errors in logs    [" . $proj->dates->cur_date('db_time') . "]",
        readonly => 1,
        default_field_params => {
            shlist => 1,
            inlinefilter => { group => 0, },
        },
        fldselection => 1,
        fields => [
            #{ name => 'ErrorID', },
            { name => 'project', },
            { name => 'HostRole', },
            { name => 'HostGroup', },
            { name => 'Host', },
            { name => 'File', showmacro => 'bigcuttext_withoutlink' },
            { name => 'ErrorTime', shlist => 0, },
            { name => 'PID', },
            #{ name => 'count', },
            { name => 'ErrorInfo', },
            { name => 'Count', title => 'cc', align => 'right', },
            { name => 'FirstErrorTime', },
            { name => 'LastErrorTime', },
            { name => 'ErrorText', filter_html => 1, },
            { name => 'ErrorTextUniq', filter_html => 1, },
        ],  # ErrorID Host File ErrorTime PID ErrorText ErrorInfo ErrorTextUniq
        filters => [
               { field => 'UniqType', name => 'UniqType', grp => 1,
                    hide_count => 1,  disable_deselect => 1,
                    extgrp => sub { [
                            #{ UniqType => '0' },   # TODO вернуть
                            { UniqType => 'Host' },
                            { UniqType => 'Role' },
                    ] },
               },
               #{ field => 'IsUniq', name => 'IsUniq', use_other_filters => 1, like => 0, grp => 1, selectnames => { 1 => 'Uniq only', 0 => 'Duplicate only', }, }, # TODO вернуть?
               { field => 'Subscription', name => 'Filter', grp => 1,
                    extgrp => sub {
                        my $subscriptions = BM::Monitor::Logs::get_subscriptions;
                        return [
                            (map { { Subscription => "User:$_" } }          uniq sort map { @{ $_->{users} // [] } } @$subscriptions ),
                            (map { { Subscription => "Subscription:$_" } }  uniq sort map { $_->{title} // () } @$subscriptions ),
                        ]
                    },
                    hide_count => 1,
               },
               { field => 'project', name => 'project', use_other_filters => 1, like => 0, grp => 1, multi => 1, multiselect_include_select_all => 1, },
               { field => 'HostRole', name => 'Host role', use_other_filters => 1, like => 0, grp => 1, multi => 1, multiselect_include_select_all => 1, },
               { field => 'HostGroup', name => 'Host group', use_other_filters => 1, like => 0, grp => 1, multi => 1, multiselect_include_select_all => 1, },
               { field => 'Host', name => 'Host', use_other_filters => 1, like => 0, grp => 1, multi => 1, multiselect_include_select_all => 1, },
               { field => 'File', name => 'File', use_other_filters => 1, like => 0, grp => 1, multi => 1, multiselect_include_select_all => 1, },
               { field => 'script_name', name => 'script_name', use_other_filters => 1, like => 0, grp => 1, multi => 1, multiselect_include_select_all => 1, },
               #{ field => 'ErrorTextUniq', name => 'ErrorTextUniq', use_other_filters => 1, like => 0, grp => 1, },   # TODO: почему не всегда работает? Не обрабатываются спец.символы?
               { field => 'ErrorInfo', name => 'ErrorInfo', use_other_filters => 1, like => 0, grp => 1, },
               { field => 'ErrorTime', name => 'ErrorTime', use_other_filters => 1, type => 'date2', },
        ],
        extlists => [
            {
                cmd => 'monitor_errors_data',
                using => $fld_uniq,
                title => 'Errors',
                addparams => {
                    main_id_field => $fld_uniq,
                },
                addelemparams => {
                    "flt_$fld_uniq" => $fld_uniq,
                },
                addfilterparams => {
                    'flt_from_ErrorTime' => 'ErrorTime >= ',
                    'flt_to_ErrorTime' => 'ErrorTime <= ',
                },
            },
        ],
        search => { fields => [ "ErrorText", ], name => 'text', },
        default_filter => {
            # IsUniq => 1,  # TODO вернуть?
            from_ErrorTime => $from_Time_default,
            to_ErrorTime => $to_Time_default,
        },
        order_by => 'LastErrorTime desc',
        pager => { name => 'p', cc => 200, },
        #transmit_url_params => [qw[ light_interface ]],

        action_onlist => sub {
            my ($proj, $el) = @_;
        },

        getlistflt => sub {
            my ($self, %prm) = @_;
            my $proj = $self->proj;
            $proj->log("monitor_errors getlistflt ...");
            my $dbh = $proj->monitoring_dbh;

            my @where = ();
            my @where_keys = grep { $_ =~ / [><]= $/ }  keys %{$prm{filter}};  # for date2 filter, such as   'ErrorTime >= ' => '2014-01-01',  'ErrorTime <= ' => '2014-01-05 23:59:59'
            push @where, "$_'" . $prm{filter}->{$_} . "'"   for @where_keys;
            my $where = (scalar @where)  ?  ' where ' . join(' and ', @where)  :  '';

            #my $light_interface = $proj->form->{light_interface};
            my $light_interface = 1;

            my $out = [];
            $proj->log("light_interface: $light_interface");
            if ($light_interface) {
                my $stm = join(" ",
                    "select *, count(*) Count, min(ErrorTime) FirstErrorTime,  max(ErrorTime) LastErrorTime",
                    "from MonitorErrors",
                    "$where",
                    "group by $fld_uniq",
                    "order by LastErrorTime desc",
                );
                $proj->log("List_SQL($stm) ...");
                $out = $dbh->List_SQL($stm);
                $proj->log("List_SQL($stm) done: " . (scalar @$out));
            } else {
                # Старый вариант cmd=monitor_errors  TODO - окончательно перейти на новый
                my $stm = "select * from MonitorErrors $where order by ErrorTime desc";
                $proj->log("List_SQL($stm) ...");
                $out = $dbh->List_SQL($stm);
                $proj->log("List_SQL($stm) done: " . (scalar @$out));

                my %error2str_prm;
                my $uniq_type = $prm{filter}{UniqType};
                if ($uniq_type eq 'Host') {
                    # default behaviour
                } elsif ($uniq_type eq 'Role') {
                    $error2str_prm{reduce_host} = 1;
                } else {
                    $error2str_prm{keep_str} = 1;
                }

                $proj->log("add_aux_fields_to_events_list...");
                BM::Monitor::Utils::add_aux_fields_to_events_list($out, event_type => 'error');

                my (%count, %first_times, %last_times);
                $proj->log("Processing data ...");
                for my $el (@$out) {    # perl -wle 'my @a=( {1=>2}, {3=>4}, {5=>6}, {7=>8}, {9=>10});   my $i=0; while($i<=$#a){ if($a[$i]{3} or $a[$i]{7} ){splice @a, $i, 1 }else{ $i++ } };  print Dumper(\@a)'
                    my $str = BM::Monitor::Logs::error2str($el, %error2str_prm);
                    $el->{ErrorTextUniq} = $str;
                    if (not $count{$str}) {
                        $el->{IsUniq} = 1;
                        $count{$str} = 1;
                        $last_times{$str} = $el->{ErrorTime};
                    } else {
                        $count{$str} += 1;
                    }
                    $first_times{$str} = $el->{ErrorTime};
                }
                $proj->log("Processing data done");

                $proj->log("Adding fields ...");
                for my $el (@$out) {
                    my $str = $el->{ErrorTextUniq};
                    $el->{Count} = $count{$str};
                    $el->{FirstErrorTime} = $first_times{$str};
                    $el->{LastErrorTime} = $last_times{$str};
                    $el->{HostRole} = $el->{host_role};   # get_host_role($el->{Host});
                    $el->{HostGroup} = (get_host_info($el->{Host}) || {})->{group};
                }
                $proj->log("Adding fields done");
            }

            my $subscription_flt = $prm{filter}{Subscription};
            if ($subscription_flt) {
                $proj->log("subscription ...");
                my $subscriptions = BM::Monitor::Logs::get_subscriptions;
                if ($light_interface) {
                    BM::Monitor::Logs::convert_keys_format($subscriptions, 'db');
                }

                my $filters = [];
                if ($subscription_flt =~ m/^User:(.*)$/) {
                    $filters = BM::Monitor::Utils::get_subscriptions_filters($proj, $subscriptions, user => $1);
                } elsif ($subscription_flt =~ m/^Subscription:(.*)$/) {
                    $filters = BM::Monitor::Utils::get_subscriptions_filters($proj, $subscriptions, title => $1);
                }
                $proj->log("filter_list ...");
                my $keys = [qw[ Host file project host_role file_template script_name ErrorInfo ErrorTime ErrorText ]];  # ErrorTextUniq host_short
                $out = BM::Monitor::Utils::filter_list($out, $filters, keys => $keys ) || [];
                $proj->log("sort ...");
                $out = [ sort { $b->{ErrorTime} cmp $a->{ErrorTime} } @$out ];
            }

            $proj->log("kostyl for filtering ...");
            for my $fld (qw[ UniqType Subscription ]) {
                # kostyl for filtering
                $_->{$fld} = $prm{filter}{$fld}   for @$out;
            }

            $proj->log("Adding fields ...");
            for my $el (@$out) {
                $el->{Host} =~ s/\.yandex\.ru$//;
            }
            $proj->log("Adding fields done");

            return $out;
        },
    }
}

sub monitor_errors_data :CMDH {
    my ($proj, $vars) = @_;

    my $from_Time_default = $proj->dates->next_n_date(-1, 'db');
    my $to_Time_default = $proj->dates->next_n_date(0, 'db');

    my $main_id_field = $proj->form->{main_id_field} // 'ErrorIDUniq';

    return {
        title => "Errors in logs    [" . $proj->dates->cur_date('db_time') . "]",
        table => 'MonitorErrors',
        readonly => 1,
        default_field_params => {
            shlist => 1,
            inlinefilter => { group => 0, },
        },
        #fldselection => 1,
        fields => [
            { name => $main_id_field, shlist => 0, },
            #{ name => 'project', },
            #{ name => 'HostRole', },
            #{ name => 'HostGroup', },
            { name => 'Host', width => 120, },
            { name => 'File', showmacro => 'bigcuttext_withoutlink', width => 220, },
            { name => 'ErrorTime', width => 200, },
            #{ name => 'PID', width => 80, },
            #{ name => 'ErrorInfo', width => 50, },
            { name => 'ErrorText', filter_html => 1, },
        ],
        filters => [
            { field => $main_id_field, name => $main_id_field, },
            { field => 'ErrorTime', name => 'ErrorTime', use_other_filters => 1, type => 'date2', },
        ],

        default_filter => {
            from_ErrorTime => $from_Time_default,
            to_ErrorTime => $to_Time_default,
        },

        transmit_url_params => [qw[ main_id_field ]],
        pager => { name => 'p', cc => 50, },
        order_by => 'ErrorTime desc',

        action_onlist => sub {
            my ($proj, $el) = @_;
            $el->{Host} =~ s/\.yandex\.ru$//;
        },
    };
}

sub menu : CMD {
    my ($proj, $vars) = @_;
    $vars->{template} = 'bmfront-main.tmpl';
}

sub get_signed_url : CMD {
    my ($proj, $vars) = @_;

    my $url = $ENV{HTTP_REFERER};
    my $query = ($url =~ m/(\?.*)$/)[0];
    my $sign = $proj->get_sign(query => $query);
    $proj->dd([
        $url,
        $query,
        "$url&sign=$sign",
    ]);

    return {};
}

sub resources : CMDH {
    my ($proj, $vars) = @_;

    return {
        title => 'Resources',
        readonly => 1,
        default_field_params => {
            shlist => 1,
            inlinefilter => { group => 0, },
        },
        fields => [
            (map {{ title => $_, name => $_, }} qw[ Host role group project   Resource   ProducerHost ]),
        ],
        filters => [
            (map {{ field => $_, title => $_, grp => 1, use_other_filters => 1, multi => 1, multiselect_include_select_all => 1, }} qw( Host role group project   Resource   ProducerHost )),
        ],

        action_onlist => sub {
            my ($proj, $el) = @_;
            $el->{project} ||= "_";  # kostyl для multiselect-фильтра
        },

        getlistflt => sub {
            my ($self, %prm) = @_;
            my $proj = $self->proj;

            my $list = [];

            for my $host (sort(get_hosts())) {
                $proj->log("host: $host");
                my $host_info = get_host_info($host);
                for my $resource (
                    BM::Resources::get_required_resources($proj, $host),
                    BM::Resources::get_required_resources_db($host),
                ) {
                    my $resource_data = $BM::Resources::resources{$resource};
                    my $producer_host = get_resource_producer($host, $resource_data->{producer});
                    if (0) {
                        my $paths_arr = [
                            $resource_data->{dir} || (),
                            @{ $resource_data->{files} || [] },
                        ];
                        my $dir_root = $Utils::Common::options->{dirs}{root};
                        s/^$dir_root//   for @$paths_arr;
                    }

                    push @$list, {
                        Resource => $resource,
                        #Paths => join("<br>", @$paths_arr),
                        Host => $host,
                        ProducerHost => $producer_host,
                        (
                            project => "",
                            %$host_info,
                        ),
                    };
                }
            }

            return $list;
        },
    };
}

sub resources_list : CMDH {
    my ($proj, $vars) = @_;

    return {
        title => 'Resources',
        readonly => 1,
        default_field_params => {
            shlist => 1,
            inlinefilter => { group => 0, },
        },
        fields => [
            (map {{ title => $_, name => $_, }} qw[
                    Resource files dir min_bytes producer aux_producer db_path dont_check_mtime dont_check_mtime_files max_allowed_hours_old project
            ]),
        ],
        filters => [
            (map {
                    { field => $_, title => $_, grp => 1, use_other_filters => 1, multi => 1, multiselect_include_select_all => 1, }
            } qw( Resource producer )),
        ],

        action_onlist => sub {
            my ($proj, $el) = @_;
            $el->{project} ||= "_";  # kostyl для multiselect-фильтра
        },

        getlistflt => sub {
            my ($self, %prm) = @_;
            my $proj = $self->proj;

            my $list = [];

            for my $resource (sort keys %BM::Resources::resources) {
                #$proj->log("resource: $resource");
                my $resource_data = $BM::Resources::resources{$resource};
                my $el = {
                    Resource => $resource,
                    %$resource_data,
                };
                for my $key (qw[ files dont_check_mtime_files ]) {
                    $el->{$key} = join(" <br> ", sort @{ $el->{$key} || [] });
                }
                for my $key (qw[ files dir dont_check_mtime_files ]) {
                    next unless $el->{$key};
                    my $bm_path = $Utils::Common::options->{dirs}{root};
                    $el->{$key} =~ s!$bm_path/*!!g;
                    $el->{$key} =~ s!/+!/!g;
                }
                for my $key (qw[ producer aux_producer ]) {
                    next unless $el->{$key};
                    $el->{$key} = get_short_hostname($el->{$key});
                }
                push @$list, $el;
            }

            return $list;
        },
    };
}

# Тестируем запуск скриптов из CMD
sub noauth_test_fcgi : CMDH {

    my $sleep_time = 60;    # seconds
    my $res = `(date; sleep $sleep_time; date) 2>&1 >> /opt/broadmatching/log/test_fcgi.log`;

    return {
        title => "test_fcgi",
    }
}

sub noauth_test_fcgi_1 : CMD {

    my $host = `hostname --fqdn`;
    chomp $host;
    my $time = POSIX::strftime("%Y-%m-%d %H:%M:%S", localtime);

    print "Content-type: text/html\n\n";
    print "time:($time) hostname:($host)\n";
}

sub noauth_test_dblist : CMDH {
    return {
        fix_sql_problem => 0,
        readonly => 1,
        fields => [
            { name => 'fld1', shlist => 1, filter_html => 1 },
            { name => 'fld2', shlist => 1, },
        ],
        getlistflt => sub {
            return [
                {
                    fld1 => 'Value1<test>',
                    fld2 => 'Value2<test>',
                },
            ];
        },
    };
}

# ! НЕ удалять (используется в работе ansible)
sub send_bmclient_key : CMD {
    my ($proj, $vars) = @_;
    print "Content-type: text/html\n\n";

    if (! $vars->{form}->{host}) {
        print "RESULT: FAIL (no 'host' get-parameter)\n";
        return;
    }

    my $host_info = get_host_info($vars->{form}->{host});
    if (! $host_info->{host}) {
        print "RESULT: FAIL (unknown host '$vars->{form}->{host}')\n";
        return;
    }

    my $log = `/opt/broadmatching/scripts/utils/ssh_id_push.pl --hosts $host_info->{host} 2>&1`;
    if ($log =~ /SSH_ID_PUSH_OK/) {
        print "RESULT: OK\n";
    } else {
        print "RESULT: FAIL\n$log\n";
    }
}


1;
