package Cmds::AnalysePhraseList;

use utf8;

use base qw(Cmds::Base);

use JSON;
use Data::Dumper;
use POSIX qw(strftime);
use Time::HiRes qw/gettimeofday tv_interval/;
use Encode;

use Utils::XLS;
use WebCommon;

sub analyse_phrase_list : CMDBS {
    my ($proj, $vars) = @_;

    return {
        idfield => 'ID',
        readonly => 1,
        title => 'Анализ списка фраз',
        fix_sql_problem => 0,
        logchanges => 1,
        auth => 'login',
        showid => 0, 
        table => 'analyse_phrase_list',
        search => { fields => [ 'phrase', ], name => 'text', like => 1, },
        default_inlinefilter_params => {
            group_by_add_fields => ['count(*) tt', "concat(sum(IF(UserState, 0, 1)), '/', sum(IF(UserState, 1, 0))) gdbd" ],
            fields => [
                { name => 'tt', title => 'count', shlist => 1,   inlinefilter => { },  },
                { name => 'gdbd', title => 'count', shlist => 1, inlinefilter => { },  },
            ],
        },
        fields => [
            {  title => 'Login', shlist => 0,
               grp => [
                    { name => 'Login',       shlist => 1, disable_edit => 1, autoedit => sub { $proj->{login} }, },
                    { name => 'date',        shlist => 1, disable_edit => 1, autoedit => sub { $proj->dates->cur_date('db_time') }, showmacro => 'space2nbsp', },
               ],
            },
            { name => 'UpdateTime',    shlist => 0, ftype => 'timestamp', },
            { name => 'PhraseListID',  shlist => 0, ftype => 'varchar(40)', addform=>1, },
            { name => 'UserState', title => '',  shlist => 1, show_good_bad => 1, mass_change => 1,  }, 
            { name => 'phrase', title => 'Фраза',  shlist => 1, width => 300, inline => 1, 
                  inlinefilter => { group => 1, },
            },
            { name => 'grp_count', title => 'count',  shlist => 1, },
            { name => 'snorm_phr', title => 'snorm',  shlist => 0, 
                  autoedit => sub { 
                      my ($proj, $h) = @_;
                      return defined $h->{phrase} ? $proj->phrase($h->{phrase})->snorm_phr : undef;
                  }, 
            },
            { name => 'text_content_type', shlist => 0, 
                  autoedit => sub { 
                      my ($proj, $h) = @_;
                      return defined $h->{phrase} ? $proj->phrase($h->{phrase})->text_content_type : undef;
                  }, 
            },
            { name => 'categs', title => 'Категории', shlist => 1, addform => 1, 
                  inlinefilter => { group => 1, },
                  autoedit => sub { 
                      my ($proj, $h) = @_;
                      return defined $h->{phrase} ? join('/', $proj->phrase($h->{phrase})->get_minicategs) : undef;
                  }, 
            },
            { name => 'desc', title => 'Комментарий', shlist => 1, edlist => 1, inline => 1, width => 150, },
            { name => 'wide', shlist => 1, show_good_bad_readonly => 1, inlinefilter => {}, },
            { name => 'porn', shlist => 1, show_good_bad_readonly => 1, inlinefilter => {}, },
        ],
        filters => [
               { field => 'text_content_type', grp=>1, name => 'Тип', use_other_filters => 1, },
               { field => 'Categs', grp=>1, name => 'Категории', use_other_filters => 1, },
               { field => 'UserState', grp=>1, name => 'Статус', use_other_filters => 1, },
        ],
        pager => { name => 'p', cc => 1000, },
    };
}

sub insert_phrase_list : CMD {
    my ($proj, $vars) = @_;

    my $form = $proj->form;
    my $phlid = $form->{'phlid'};
    my $phl = $proj->get_phrase_list($phlid);

    my $dbt = $proj->dbtable('test_analyse_phrase_list', 'ID');

    my $phlurl = join("&", 
        "ind.pl?cmd=test_analyse_phrase_list", 
        "PhraseListID=".$phlid,
        "viewoptionsstr=".$form->{viewoptionsstr}."|delim_$nltype",
    );

    $proj->do_redirect( $phlurl ) if $dbt->Count({ PhraseListID => $phlid });  

    #$proj->dd($phl);

    my $grp = $phl->group_phrases_light;

    my $curdate = $proj->dates->cur_date('db_time');
    my @arr = map {{
        login => $proj->{login},
        date  => $curdate,
        phrase => $_->text,
        grp_count => 0+@{$grp->{$_->snorm_phr}},
        snorm_phr => $_->snorm_phr,
        PhraseListID => $phlid,
        text_content_type => $_->text_content_type,
        wide => $_->is_wide_phrase ? 'bad' : '',
        porn => $_->is_porno_phrase ? 'bad' : '',
        categs => join('/', $_->get_minicategs),
    }} @$phl;
    $dbt->Add(\@arr);

    #Заполняем индекс для быстрого поиска элементов в группах
    my $indtbl = $proj->dbtable('test_analyse_phrase_list_index', 'ID'); 
    my $elems = $dbt->List({ PhraseListID => $phlid });
    my $sn2id = {};
    $sn2id->{ $_->{snorm_phr} } .= $_->{ID}.',' for @$elems;
    my @indarr = ();
    for my $gr (keys %$grp){
        my @grids = grep {$_} split ',', $sn2id->{ $gr };
        for my $elid ( map {grep {$_} split( ',', $sn2id->{ $_ })} @{$grp->{$gr}}){
            push(@indarr, { group_id => $_, elem_id => $elid }) for @grids; 
        }
    }
    $indtbl->Add(\@indarr);

    $proj->do_redirect( $phlurl ); 
}

sub test_analyse_phrase_list : CMDH {
    return {
        base => 'analyse_phrase_list',
        table => 'test_analyse_phrase_list',
        search => { fields => [ 'phrase', ], name => 'text', like => 1, 
            extsearch => { cmd => 'test_analyse_phrase_list_phrs', params => { 'PhraseListID' => 'PhraseListID' }, },
        }, 
        add_filter => { 'grp_count > ' => '0' },
        extlists => [
            { cmd => 'test_analyse_phrase_list_phrs', using => 'flt_fsnorm', title => 'Phrases' },
        ],
        order_by => ' -grp_count, ID',
        group_by => 'snorm_phr',
        bottom_buttons => [
            { title => 'Получить хорошие фразы', url => '?cmd=test_analyse_phrase_get_good', addformparams => { 'phlid' => 'PhraseListID' }, },
        ],
    };
}

sub test_analyse_phrase_list_phrs : CMDH {
    my ($proj, $vars) = @_;

    #$proj->dd($proj->form);
    return {
        base => 'analyse_phrase_list',
        table => 'test_analyse_phrase_list',
        filters => [
               {  name => 'Текст', field => 'fsnorm', 
                      extfilter => sub { 
                          my ($proj, $text) = @_;
                          my $list = $proj->dbtable('test_analyse_phrase_list_index')->List({ group_id =>  $text });
                          my @ids = map { $_->{'elem_id'} } @$list;
                          #my @wrds = split ' ', $el->{'snorm_phr'};
                          #my $flt = '%'.join('%', @wrds).'%';
                          ##$proj->dd($el); 
                          ##return { id => [ map { "$_" } @$phl ] };
                          #return { 'snorm_phr LIKE ' => $flt, PhraseListID => $el->{'PhraseListID'} };
                          return { ID => \@ids, };
                      } 
               },
        ],
        order_by => ' -grp_count',
        #add_filter => { 'grp_count > ' => '0' },
    };
}

sub test_analyse_phrase_get_good :CMD {
    my ($proj, $vars) = @_;
    my $form = $proj->form;
    if($form->{'phlid'}){
        my $dbt = $proj->dbtable('test_analyse_phrase_list');
        #$dbt->{sql_dd_log} = 1;
        my $list = $dbt->List({ 
            PhraseListID => $form->{'phlid'}, 
            'UserState !=' => 'bad', 
        });
        my @arr = map { $_->{phrase} } @$list;
        #$proj->dd(\@arr, $list, $form->{'phlid'});
        my $phl = $proj->phrase_list(\@arr);
        $proj->save_phrase_list($phl);
        $proj->do_redirect( join("&", 
            "ind.pl?cmd=edit_phrase_list", 
            "act=showphl",
            "phlid=".$phl->cache_id,
            "viewoptionsstr=".$form->{viewoptionsstr},
        ));
    }
}


sub test_analyse_phrase_list_mdf :CMD {
    return {
        base => 'analyse_phrase_list',
        table => 'test_analyse_phrase_list',
        filters => [
               {  name => 'Текст', field => 'fsnorm', 
                      extfilter => sub { 
                          my ($proj, $text) = @_;
                          my $list = $proj->dbtable('test_analyse_phrase_list_index')->List({ group_id =>  $text });
                          my @ids = map { $_->{'elem_id'} } @$list;
                          #my @wrds = split ' ', $el->{'snorm_phr'};
                          #my $flt = '%'.join('%', @wrds).'%';
                          ##$proj->dd($el); 
                          ##return { id => [ map { "$_" } @$phl ] };
                          #return { 'snorm_phr LIKE ' => $flt, PhraseListID => $el->{'PhraseListID'} };
                          return { ID => \@ids, };
                      } 
               },
        ],
        order_by => ' -grp_count',
        #add_filter => { 'grp_count > ' => '0' },
    };
}


sub anphrlist : CMDBS {
    my ($proj, $vars) = @_;

    my $form = $proj->form;
    my $phlid = $form->{'phlid'};
    my $phl = $proj->get_phrase_list($phlid);

    my @arr = ();
    for my $ph (@$phl){
        my $h = {
            text      => $ph->text,
            norm_phr  => $ph->norm_phr,
            snorm_phr => $ph->snorm_phr,
            categs    => join( '/', $ph->get_minicategs ),
            lnth      => length($ph->text),
        };
    }

}




sub lite_insert_phrase_list : CMD {
    my ($proj, $vars) = @_;

    my $form = $proj->form;
    my $phlid = $form->{'phlid'};
    my $phl = $proj->get_phrase_list($phlid);

    my $dbt = $proj->dbtable('lite_analyse_phrase_list', 'ID');

    my $phlurl = join("&", 
        "ind.pl?cmd=lite_analyse_phrase_list", 
        "PhraseListID=".$phlid,
        "viewoptionsstr=".$form->{viewoptionsstr}."|delim_$nltype",
    );

    $proj->do_redirect( $phlurl ) if $dbt->Count({ PhraseListID => $phlid });  

    #$proj->dd($phl);

#=h
    #my $grp = $phl->group_phrases_light;
    #Находим список всех подфраз из этого же списка
    my $fh = { map { $_->snorm_phr => $_ } @$phl }; 
    for my $ph (@$phl){
       my $snorm = $ph->snorm_phr;
       my @subphrs = grep { $_ ne $snorm } grep {$fh->{$_}} map {@$_} $ph->all_snorm_subphrases_list_arrayref(6);
       @subphrs = keys %{{ map {$_=>1} @subphrs }};
       $ph->{subphrases} = join '/', sort @subphrs;

#$proj->dd($ph->all_snorm_subphrases_list_arrayref, $ph->{subphrases});
    }
#=cut

    $phl->cache_search_count;

    my $curdate = $proj->dates->cur_date('db_time');
    my @arr = map {{
        login              => $proj->{login},
        date               => $curdate,
        phrase             => $_->text,
        subphrases         => $_->{subphrases},
        textlength         => length($_->text),
        textlengthgrp      => int(length($_->text)/5)+1,
        #grp_count          => 0+@{$grp->{$_->snorm_phr}},
        search_count       => $_->get_search_count,
        norm_phr           => $_->norm_phr,
        snorm_phr          => $_->snorm_phr,
        words              => $_->wordcount,
        PhraseListID       => $phlid,
        text_content_type  => $_->text_content_type,
        wide               => $_->is_wide_phrase ? 'bad' : '',
        porn               => $_->is_porno_phrase ? 'bad' : '',
        categs             => join('/', $_->get_minicategs),
    }} @$phl;
    $dbt->Add(\@arr);

    $proj->do_redirect( $phlurl ); 
}

sub lite_analyse_phrase_list : CMDH {
    my ($proj, $vars) = @_;

    return {
        idfield => 'ID',
        readonly => 1,
        title => 'Анализ списка фраз',
        fix_sql_problem => 1,
        logchanges => 1,
        auth => 'login',
        showid => 0, 
        table => 'lite_analyse_phrase_list',
        search => { fields => [ 'phrase', ], name => 'text', like => 1, },
        default_inlinefilter_params => {
            group_by_add_fields => ['count(*) tt', "concat(sum(IF(UserState, 0, 1)), '/', count(*)) gdbd" ],
            fields => [
#                { name => 'tt',   title => 'count', shlist => 1,   inlinefilter => { },  },
                { name => 'gdbd', title => 'Gd/Tl', shlist => 1, inlinefilter => { },  },
            ],
        },
        stat_fields => [
            { name => 'search_count', title => 'Search', after => 'textlengthgrp', },
            #{ name => 'textlength', title => 'Дл', before => 'textlengthgrp', },
        ],
        grpselection => 1,
        fldselection => 1,
        fields => [
            {  title => 'Login', shlist => 0,
               grp => [
                    { name => 'Login',       shlist => 1, disable_edit => 1, autoedit => sub { $proj->{login} }, },
                    { name => 'date',        shlist => 1, disable_edit => 1, autoedit => sub { $proj->dates->cur_date('db_time') }, showmacro => 'space2nbsp', },
               ],
            },
            { name => 'UpdateTime',    shlist => 0, ftype => 'timestamp', },
            { name => 'PhraseListID',  shlist => 0, ftype => 'varchar(40)', addform=>1, },
            { name => 'UserState', title => 'State',  shlist => 1, show_good_bad => 1, mass_change => 1,  }, 
            { name => 'phrase', title => 'Фраза',  shlist => 1, width => 300, inline => 1, 
                  inlinefilter => { group => 1, },
            },
            { name => 'subphrases', title => 'Подфразы',  shlist => 1, inlinefilter => { group => 1, }, },
            { name => 'textlength', title => 'Дл',  shlist => 1, 'showmacro' => 'format_number', align => 'right', inlinefilter => { group => 1, }, },
            { name => 'textlengthgrp', title => 'ДлГ',  shlist => 1, 'showmacro' => 'format_number', align => 'right', inlinefilter => { group => 1, }, },
            { name => 'words', title => 'Слов',  shlist => 1, 'showmacro' => 'format_number', align => 'right', inlinefilter => { group => 1, }, },
            #{ name => 'grp_count', title => 'count',  shlist => 1, },
            #{ name => 'search_count', title => 'Search',  shlist => 1, },
            { name => 'norm_phr', title => 'norm',  shlist => 0, fldslcthide => 1, },
            { name => 'snorm_phr', title => 'snorm',  shlist => 0, fldslcthide => 1,
#                  autoedit => sub { 
#                      my ($proj, $h) = @_;
#                      return defined $h->{phrase} ? $proj->phrase($h->{phrase})->snorm_phr : undef;
#                  }, 
            },
            { name => 'text_content_type', shlist => 1, title => 'Тип',
                  autoedit => sub { 
                      my ($proj, $h) = @_;
                      return defined $h->{phrase} ? $proj->phrase($h->{phrase})->text_content_type : undef;
                  }, 
            },
            { name => 'categs', title => 'Категории', shlist => 1, addform => 1, 
                  inlinefilter => { group => 1, },
                  autoedit => sub { 
                      my ($proj, $h) = @_;
                      return defined $h->{phrase} ? join('/', $proj->phrase($h->{phrase})->get_minicategs) : undef;
                  }, 
            },
            { name => 'desc', title => 'Комментарий', shlist => 1, edlist => 1, inline => 1, width => 150, },
            { name => 'wide', shlist => 1, show_good_bad_readonly => 1, inlinefilter => {}, },
            { name => 'porn', shlist => 1, show_good_bad_readonly => 1, inlinefilter => {}, },
        ],
        topmenu => [ { title => 'Данные', sublist => [
                           { title => 'Пересчитать значение параметров', name => 'remake', redir_action => sub {
                                      my ($self, $lst1, $lst2, $prmsh) = @_;
                                      my $phlid = $self->proj->form->{PhraseListID};
                                      $self->dbt->DelList({ PhraseListID => $phlid }) if $phlid;
                                      return join("&", 
                                             "?cmd=lite_insert_phrase_list",
                                             "phlid=".$phlid,
                                             "viewoptionsstr=".$self->proj->form->{viewoptionsstr},
                                      );
                                 },
                           },
                     ], },
                   ],
        bottom_menu => [ { title => 'Выгрузка', sublist => [
                           { title => 'Выгрузка в список фраз', name => 'edit_phrase_list', addfilters => 1, url => "?cmd=lite_analyse_phrase_list&act=edit_phrase_list&filtered=1", open_in_new_tab => 1, },
                           { title => 'Выгрузка в Excel', name => 'xls', addfilters => 1, url => "?cmd=lite_analyse_phrase_list&act=xls&filtered=1", open_in_new_tab => 1, },
                     ], },
                   ],
        data_import_export => {
            no_import => 1,
            export => {
                headers => 1,
                filtered => 1,
            },
            list => [qw[ phrase search_count categs ]],
        },
        filters => [
               { field => 'text_content_type', multi=>1, grp=>1, name => 'Тип', use_other_filters => 1, },
               { field => 'Categs', grp=>1, multi=>0, name => 'Категории', use_other_filters => 1, },
               { field => 'UserState', grp=>1, name => 'Статус', use_other_filters => 1, },
        ],
        pager => { name => 'p', cc => 1000, },
    };
}

1;



