package Cmds::Base;

use vars qw/$cmdslist/ ;

use Data::Dumper;

BEGIN {
    $cmdslist = {};
    $cmdshlist = {};
    $cmdsbslist = {};
    $cmdsfldlist = {};

    $cronslist = {};

    $specprojfuncs = {};
}

sub _cmds_list    { return $cmdslist;   }
sub _cmds_h_list  { return $cmdshlist;  }
sub _cmds_bs_list { return $cmdsbslist; }
sub _cmds_fld_list { return $cmdsfldlist; }

sub _crons_list { return $cronslist; }

sub _specprojfuncs_hash { return $specprojfuncs; }

sub CMD : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {   
        my $tt = scalar(*$symbol);
        $tt =~ /(::)?([^:]*)$/;
        my $name = $2;
        $cmdslist->{$name} = $referent;
    }
}

sub CMDH : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {   
        my $tt = scalar(*$symbol);
        $tt =~ /(::)?([^:]*)$/;
        my $name = $2;
        my $f = sub {
            my ($proj, $vars) = @_;
            my $tinf = $referent->($proj, $vars);
            $tinf->{'cmdh_data'} = $data;
            $vars->{'tinf'} = $tinf;
            
            $proj->dblist({ vars => $vars })->make;
            delete $proj->{__cmdh_make_cache__};
        };
        $cmdslist->{$name} = $f;
        $cmdshlist->{$name} = $referent;
    }
}

sub CMDBS : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {   
        my $tt = scalar(*$symbol);
        $tt =~ /(::)?([^:]*)$/;
        my $name = $2;
        $cmdsbslist->{$name} = $referent;
    }
}

sub CMDFLD : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {   
        my $tt = scalar(*$symbol);
        $tt =~ /(::)?([^:]*)$/;
        my $name = $2;
        $cmdsfldlist->{$name} = $referent;
    }
}

sub CRON : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {   
        my $tt = scalar(*$symbol);
        $tt =~ /(::)?([^:]*)$/;
        my $name = $2;
        $cronslist->{$name} = $referent;
    }
}

sub CRONLIGHTTASKS : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {   
        my $tt = scalar(*$symbol);
        $tt =~ /(::)?([^:]*)$/;
        my $name = $2;
        $specprojfuncs->{CRONLIGHTTASKS}->{$name} = $referent;
    }
}

sub CRONLIGHTWORKER : ATTR(CODE) {
    my ($package, $symbol, $referent, $attr, $data, $phase, $filename, $linenum) = @_;
    {   
        my $tt = scalar(*$symbol);
        $tt =~ /(::)?([^:]*)$/;
        my $name = $2;
        $specprojfuncs->{CRONLIGHTWORKER}->{$name} = $referent;
    }
}

1;
