package Cmds::BasePhraseBlock;

use strict;
use utf8;
use open ':utf8';

use base qw(ObjLib::Obj);

use List::Util qw(min);

__PACKAGE__->mk_accessors(qw(
    lang
    cat_id
    proj
));

sub reset_phrase_list_id {
    my ($self) = shift;

    my ($lang, $cat_id, $proj) = ($self->lang, $self->cat_id, $self->proj);
    $proj->Do_SQL("
        update
            " . $proj->categories_dict->db_table . "
        set
            PhraseListID = NULL
        where
            CatID = ? and Language = ?
    ", [$cat_id, $lang]);
}

sub set_phrase_list_id {
    my ($self, $phrase_list_id) = @_;

    my ($lang, $cat_id, $proj) = ($self->lang, $self->cat_id, $self->proj);
    $proj->Do_SQL("
        update
            " . $proj->categories_dict->db_table . "
        set
            PhraseListID = ?
        where
            CatID = ? and Language = ?
    ", [$phrase_list_id, $cat_id, $lang]);
}

sub get_phrase_list_id {
    my ($self) = shift;

    my ($lang, $cat_id, $proj) = ($self->lang, $self->cat_id, $self->proj);
    return $proj->List_SQL("
        select
            PhraseListID
        from
            " . $proj->categories_dict->db_table . "
        where
            CatID = ? and Language = ?
    ", [$cat_id, $lang])->[0]{PhraseListID};
}

sub get_block_phrase_list {
    my ($self) = shift;

    my ($lang, $cat_id, $proj) = ($self->lang, $self->cat_id, $self->proj);
    my $phrase_list_id = $self->get_phrase_list_id;
    $phrase_list_id = $self->cache_block_phrases if !$phrase_list_id;
    return $self->proj->get_phrase_list($phrase_list_id);
}

sub get_block_phrases {
    my ($self, $page_size, $page_index) = @_;
    
    my ($lang, $cat_id, $proj) = ($self->lang, $self->cat_id, $self->proj);
    my $phrase_list = $self->get_block_phrase_list;
    $page_size ||= $phrase_list->count;
    $page_index ||= 0;

    my $start = $page_size * $page_index;
    my $finish = min($phrase_list->count - 1, $start + $page_size - 1);
    $phrase_list = $phrase_list->lsort(sub {lc($_)})->splice_list($start, $page_size);
    my %is_user_phrase = map {$_->{InitialPhraseID} => 1} @{$proj->get_user_phrases($cat_id, $lang)};
    return [ map {
        {
            phrase      => "$_",
            phraseState => $is_user_phrase{$proj->get_user_phrase_id("$_")} ? 'userPhrase' : 'dictPhrase',
            atomsInfo   => $proj->retrieve_atoms_from_text("$_"),
        }
    } @$phrase_list ];
}

sub search_block_phrases {
    my ($self, $reg_expr) = @_;

    my ($lang, $cat_id, $proj) = @{$self}{qw(lang cat_id proj)};
    my $block_phrase_list = $self->get_block_phrase_list;
    my $phrase_list = $block_phrase_list->lgrep(sub { m/$reg_expr/i })->lsort(sub {lc($_)});
    my %is_user_phrase = map {$_->{InitialPhrase} => 1} @{$proj->get_user_phrases($cat_id, $lang)};
    return [ map {
        {
            phrase      => "$_",
            phraseState => $is_user_phrase{"$_"} ? 'userPhrase' : 'dictPhrase',
            atomsInfo   => $proj->retrieve_atoms_from_text("$_"),
        },
    } @$phrase_list ];
}

1;
