package Cmds::BaseRelationBlock;

use strict;
use utf8;
use open ':utf8';

use base qw(ObjLib::Obj);

use List::Util qw(min);

__PACKAGE__->mk_accessors(qw(
    cat_id
    proj
));

sub get_image_categories {
    my ($self) = shift;
    
    my ($cat_id, $proj) = @{$self}{qw(cat_id proj)};
    return $proj->categs_tree->get_minicateg_nephews($proj->get_category_name($cat_id));
}

sub get_domain_categories {
    my ($self) = shift;
    
    my ($cat_id, $proj) = @{$self}{qw(cat_id proj)};
    return $proj->categs_tree->get_domain_nephews($proj->get_category_name($cat_id));
}

1;
