package Cmds::BinaryRelation;

use strict;
use utf8;
use open ':utf8';
use Data::Dumper;
use base qw(ObjLib::Obj);

sub init {
    my $self = shift;

    for my $datum (@{$self->{data}}) {
        my ($domain_element, $range_element) = @{$datum}[qw/0 1/];
        $self->{domain2range}{$domain_element}{$range_element} = 1;
        $self->{range2domain}{$range_element}{$domain_element} = 1;
    }
}

sub get_domain {
    my ($self, $range_element) = @_;

    return [sort keys %{$self->{range2domain}{$range_element}}];
}

sub get_range {
    my ($self, $domain_element) = @_;

    return [sort keys %{$self->{domain2range}{$domain_element}}];
}

sub is_related {
    my ($self, $domain_element, $range_element) = @_;

    return $self->{domain2range}{$domain_element}{$range_element};
}

1;
