package Cmds::BroadMatch;
use utf8;

use base qw(Cmds::Base);

use JSON;
use Data::Dumper;
use POSIX qw(strftime);
use Time::HiRes qw/gettimeofday tv_interval/;
use Encode;
use IO::Compress::Gzip qw( gzip );
use IO::Uncompress::Gunzip qw( gunzip $GunzipError );
use DBI qw(:sql_types);
use List::Util qw(min sum);
use Utils::Sys qw(uniq md5int);
use Utils::XLS;
use WebCommon;


my @bmtask_modes = qw( safe normal wide auto );
my %bmtask_mode2bmmode = (
    safe => 'safe',
    normal => 'normal',
    wide   => 'normal',  # deprecate drf.maximum; set it to bmtasks as normal

    auto   => 'safe',  # 'Авторасширение' отправляем в привязку как 'safe'
);

my %bmtask_mode2shortname = (
    'safe' => 'Мин.',
    'normal' => 'Опт.',
    'wide' => 'Макс.',
    'default' => 'Дир.',
    'auto' => 'Авт.',
    '' => '',
);
my %bmtask_mode2name = (
    'safe' => 'Минимальный',
    'normal' => 'Оптимальный',
    'wide' => 'Максимальный',
    '' => '',
    'default' => 'Установленный в Директе',
    'auto' => 'Авторасширение',
    '__all' => '',  # TODO
);

sub get_tasks_state {
    return 'frozen';
}

sub bmbannerstable : CMD {
    my ($proj, $vars) = @_;

#$proj->dd('dDDDD');
    #BannerID  	CampaignID  	ClientID  	Title  	Body  	URL
    $vars->{tinf} = {
        readonly => 1,
        title => 'Список баннеров с BM',
        table => 'Banners',
        #table => 'AprilCategoryStat',
        #fields => [ { name => 'URL', edlist => 1, } ],
        pager => { name => 'p', cc => 20, },
        fields => [
            { name => 'BannerID', shlist => 1, },
            { name => 'CampaignID', shlist => 1, },
            { title => 'BannerInf', shlist => 1,
                 grp => [
                     { name => 'Title', shlist => 1, },
                     { name => 'Body', shlist => 1, },
                     { name => 'URL', shlist => 1, showmacro => 'exturl', },
                 ],
            },
            { title => 'BM', shlist => 1, showmacroel => 'show_btn_field',
                  geturl => sub { my ($el, $f) = @_; return '?cmd=broadmatch&bid='.$el->{'BannerID'}; }
                },
        ],
        filters => [
               {  name => 'Текст', field => 'textsearch',
                      extfilter => sub {
                          my ($proj, $text) = @_;
                          my $phl = $proj->phrase_list([$text])->get_banners_by_text_phrases(10000);
                          return { BannerID => [ map { "$_" } @$phl ] };
                      } },
        ],
        NN => 1,
        #extlists => [
        #    { cmd => 'problemurls', using => 'ParentID', title => 'Urls' },
        #],
    };

    $proj->dblist({ vars => $vars })->make;
}

sub bannerstable : CMDH {
    return {
        readonly => 1,
        title => 'Список баннеров',
        toptext => 'А вам точно нужно сюда? Может быть, <a href="https://catmedia.yandex.ru/cgi/ind.pl?cmd=search_banners">поиск по баннерам</a> подойдёт больше?',
        fields => [
            { name => 'id', shlist => 1, },
            { title => 'campaign_id', shlist => 1,
                    grp => [
                        { name => 'campaign_id', shlist => 1, },
                        { title => 'uid', name => 'uid', shlist => 1, },
                        { title => 'bsid', name => 'bs_banner_id', shlist => 1, },
                        { title => 'active_flag', name => 'active_flag', shlist => 1, },
                        { title => "lang", name => 'lang', shlist => 1, },
                    ],
                },
            { fieldmacro => 'banner_field_geo_showinf banner_id', },
            { fieldmacro => 'banner_current_categs_showinf', },
            { title => 'BM', shlist => 1, showmacroel => 'show_btn_field',
                  geturl => sub { my ($el, $f) = @_; return '?cmd=broadmatch&bid='.$el->{'id'}; }
                },
        ],
        filters => [
               {  name => 'Текст', field => 'textsearch',
                      extfilter => sub {
                          my ($proj, $text) = @_;
                          my $phl = $proj->phrase_list([$text])->get_banners_by_text_phrases(50);
                          return { bid => [ map { "$_" } @$phl ] };
                      } },
               {  name => 'id', field => 'bid', list => 1, },
               {  name => 'campaign_id', field => 'cid', list => 1, },
               {  name => 'uid', field => 'uid', list => 1, },
               {  name => 'bsid', field => 'BannerID', list => 1, },
        ],
        NN => 1,
        getlist => sub {
            my ($self, %prm) = @_;
            my $proj = $self->proj;

            my $filter = $prm{filter} // {};

            # если фильтров нет, покажем одну страничку баннеров из начала таблицы
            $filter = { bid => [1..35] } unless scalar keys %$filter;

            # выбираем primary-ключ начиная с самых узких
            my ($key_field) = grep { $filter->{$_} } qw/bid BannerID cid uid/;

            # в ключевых таблицах есть все нужные поля, поэтому все условия накладываем сразу на ключевую таблицу
            my $key_condition = join(" and ", map {
                "$_ in (". join(",", @{ $filter->{$_} }) . ")"
            } keys %$filter);

            # получаем баннеры из динтаблиц
            return $proj->bf->get_banner_dbhashes(
                key_field => $key_field,
                key_condition => $key_condition,
            );
        },
    };
}

# В логинах из Директа заменяем точки на дефисы и приводим всё к нижнему регистру
sub correct_login {
    my ($login) = @_;
    $login =~s/(.)/\L$1/g; # перевод в нижний регистр
    $login =~s/\./-/g; # заменяем точки на дефисы
    return $login;
}

#Проверка фильтрации родных фраз баннеров фильтрами для ДРФ
sub native_phrases_filter_tasks :CMDH {
    return {
        title => 'Проверка фильтрации на родных фразах баннеров',
        table => 'native_phrases_filter_tasks',
        idfield => 'SetID',
        fix_sql_problem => 1,
        inline_edit => 0,
        disable_del => 1,
        compact_inline_add => 1,
        onclick => 'extlists',
        readonly => 1,
        fields => [
            {  name => 'Login',       shlist => 1, disable_edit => 1, autoedit => sub { my ($proj, $h) = @_; $proj->{login} }, },
            {  name => 'date',        shlist => 1, disable_edit => 1, autoedit => sub { my ($proj, $h) = @_; $proj->dates->cur_date('db_time') }, showmacro => 'space2nbsp', },
            {  name => 'title', shlist => 1, },
            {  name => 'random_count', default => 200, edlist => 1, shlist => 0, },
            {  name => 'campaigns',  edlist => 1, shlist => 0, ftype => 'textarea', },
            {  name => 'banners',  edlist => 1, shlist => 0, ftype => 'textarea', },
            {  name => 'good',  edlist => 0, shlist => 1,  },
            {  name => 'bad',  edlist => 0, shlist => 1,  },
        ],
        action_onadd => sub {
            my ($proj, $id, $data) = @_;

            my $bf = $proj->bf;

            my $bnl = $bf->banner_list;

            if( $data->{campaigns} ){ #Получаем баннеры из списка кампаний
                my @cmps = grep {$_} split(/\D+/, $data->{campaigns});
                $bnl += $bf->banner_list( $bf->campaigns2banners(\@cmps) );
            }

            if( $data->{banners} ){ #Баннеры из списка баннеров
                my @bnrs = grep {$_} split(/\D+/, $data->{banners});
                $bnl += $bf->banner_list( \@bnrs );
            }

            if( $data->{random_count} && ! $bnl->count ){ #Случаные активные баннеры
                $bnl += $bf->random_active_banners($data->{random_count});
            }

            my $dbt_bnrs = $proj->dbtable('native_phrases_filter_tasks_banners');
            my $dbt_phrs = $proj->dbtable('native_phrases_filter_tasks_banners_phrs');

            my $goodbnr = 0;
            my $badbnr  = 0;

            for my $bn ( @$bnl ) {
                    my $phl = $bn->phl;
                    next unless @$phl;

                    $bn->{fltlog} = 1; #Включаем дополнительный лог фильтрации

                    my @gd = ();
                    my @bd = ();
                    for my $ph (@$phl){

                        my @categs = $ph->get_minicategs;
                        my $ctphs = [ map {{ category => $_->[0], phrase => $_->[1], }} map { @$_ } $ph->get_categs_phrases ];

                        my $h = {
                            SetID        => $id,
                            banner_id    => $bn->id,
                            phrase => $ph->text,
                	    CategoriesString => join('/', @categs),
                            CategPhrases => $proj->serial($ctphs),
                            rsn          => '',
                            fltlog       => '',
                        };

                        #my $rsn = $bn->phrsfilterreason($ph);
                        my $rsn = $bn->moderate_phrsfilterreason($ph);
                        unless($rsn){
                            $h->{state} = 'good';
                            push(@gd, $h);
                            next;
                        }
                        $h->{state}  = 'bad';
                        $h->{rsn}    = '['.$rsn.']';
                        $h->{fltlog} = $ph->{fltlog};
                        push(@bd, $h);
                    }

                    my @categs = $bn->get_minicategs;
                    my $ctphs = [ map {{ category => $_->[0], phrase => $_->[1], }} map { @$_ } $bn->get_categs_phrases ];

                    my $hh = {
                        SetID        => $id,
                        banner_id    => $bn->id,
                	CategoriesString => join('/', @categs),
                        CategPhrases => $proj->serial($ctphs),
                        good         => @gd+0,
                        bad          => @bd+0,
                        state        => (@bd ? 'bad' : 'good'),
                    };

                    @bd ? $badbnr++ : $goodbnr++ ;


                    my $sbid = $dbt_bnrs->Add($hh);
                    $_->{SetBannerID} = $sbid for @gd, @bd;

                    #$proj->dd([@gd, @bd]);

                    $dbt_phrs->Add([@gd, @bd]);
            }
            $proj->dbtable('native_phrases_filter_tasks', 'SetID')->Edit($id, { good => $goodbnr, bad => $badbnr, });
        },
        extlists => [
            { cmd => 'native_phrases_filter_tasks_banners', using => 'SetID', title => 'Banners' },
        ],
        order_by => 'SetID desc',
    };
}

sub native_phrases_filter_tasks_banners :CMDH {
    return {
        title => 'Проверка фильтрации на родных фразах баннеров',
        table => 'native_phrases_filter_tasks_banners',
        idfield => 'ID',
        fix_sql_problem => 1,
        readonly => 1,
        default_field_params => { shlist => 1, },
        fields => [
            {  name => 'SetID', addform => 1, },
            {  name => 'banner_id', },
            {  show_banner_inf => 'banner_id', },
            {  name => 'CategoriesString', showmacro => 'catlist2links', shlist => 0, },
            {  name => 'CategPhrases', title => '', fieldmacro => 'page_categ_phrases_field', shlist => 0, },
            {  name => 'good', },
            {  name => 'bad', },
            {  name => 'state', title => 'Статус', inlinefilter => {}, show_good_bad_readonly => 'good/bad', },
        ],
        filters => [
            { title => 'Статус', field => 'state', grp => 1, use_other_filters => 1, },
        ],
        default_filter => { state => 'bad', },
        extlists => [
            { cmd => 'native_phrases_filter_tasks_banners_phrs', using => 'SetBannerID', title => 'Banners' },
        ],
    };
}

sub native_phrases_filter_tasks_banners_phrs :CMDH {
    return {
        title => 'Проверка фильтрации на родных фразах баннеров',
        table => 'native_phrases_filter_tasks_banners_phrs',
        idfield => 'ID',
        fix_sql_problem => 1,
        readonly => 1,
        default_field_params => { shlist => 1, },
        fields => [
            {  name => 'SetID',  shlist => 0, },
            {  name => 'banner_id', shlist => 0, },
            {  name => 'SetBannerID', addform => 1, shlist => 0, },
            {  name => 'CategoriesString', showmacro => 'catlist2links', shlist => 0, },
            {  name => 'CategPhrases', title => '', fieldmacro => 'page_categ_phrases_field', shlist => 0, },
            {  name => 'phrase', },
            {  name => 'rsn', },
            {  name => 'state', show_good_bad_readonly => 'good/bad', },
            {  name => 'fltlog', showmacro => 'addcatlinks' },
        ],
    };
}

sub native_phrases_filter_moderation :CMDH {
    my $hopt = {
        title => 'Проверка фильтрации родных фраз баннеров',
        description => 'Отчёт для проверки автомодерации фраз по эталонной выборке лучших модераторов Директа.',
        table => 'native_phrases_filter_moderation',
        idfield => 'ID',
        fix_sql_problem => 1,
        readonly => 1,
        default_field_params => { shlist => 1, },
        fields => [
            {  name => 'banner_id', shlist => 1, inlinefilter => { group => 1, }, },
            {  title => 'Banner', grp => [
                {  name => 'title', shlist => 1, },
                {  name => 'body', shlist => 1, },
                {  name => 'domain', shlist => 1, },
            ], },
            {  name => 'phrase', shlist => 1, },
            {  name => 'modflag', shlist => 1, },
            {  name => 'SetBannerID', addform => 1, shlist => 0, },
            {  name => 'BnrCategoriesString', showmacro => 'catlist2links', shlist => 0, },
            {  name => 'BnrCategPhrases', title => '', fieldmacro => 'page_categ_phrases_field', shlist => 0, },
            {  name => 'CategoriesString', showmacro => 'catlist2links', shlist => 0, },
            {  name => 'CategPhrases', title => '', fieldmacro => 'page_categ_phrases_field', shlist => 0, },
            {  name => 'CategDiffLog', title => '', shlist => 0, },
            {  name => 'CategDiffLogMD5', title => '', shlist => 0, },
            {  name => 'rsn', },
            {  name => 'state', show_good_bad_readonly => 'good/bad', },
            {  name => 'fltlog', showmacro => 'addcatlinks' },
        ],
        filters => [
               { field => 'state', name => 'state', grp => 1, },
               { field => 'rsn',   name => 'rsn', grp => 1, },
               { field => 'CategDiffLogMD5',  name => 'CategDiffLog', textfield => 'CategDiffLog', grp => 1, order_by_count => 1, },
               { field => 'modflag',   name => 'modflag', grp => 1, use_other_filters => 1, },
        ],
        pager => { name => 'p', cc => 20, },
        bottom_actions => [ {
            title => '5000 случайных в XLS',
            name => 'xls_report_5000',
            ellist => 1,
            ellist_limit => 5000,
            ellist_order_by => 'RandID',
            xls => 1,
            action => sub {
                my ($self, $lst1, $lst2, $prmsh, $fltrs, $ellist) = @_;
                return [ map { [ @{$_}{ qw{ banner_id title body domain phrase modflag state rsn } } ] } @$ellist ];
            },
        } ],
        new_data => sub {
                    my ($proj, $cmdh, $cc) = @_;
                    my $bnl = $proj->bf->random_active_banners($cc);
                    for my $bn (@$bnl){
                        my $st = join "\t", @{$bn}{qw{ id title body site_domain }}, $bn->phl->tmap(sub { s/:.*//; $_ }), '' ;
                        $cmdh->{add_new_line}->($proj, $cmdh, $st);
                    }
        },
        add_new_line => sub { #Добавление новой строки в таблицу в формате "banner_id title body domain phrases modflag"
                    my ($proj, $cmdh, $line) = @_;

                    #my $dbt_phrs = $proj->dbtable('native_phrases_filter_moderation');
                    my $dbt_phrs = $proj->dbtable($cmdh->{'table'});

                    $line =~ s/\n//;
                    my %h = ();
                    @h{qw{ id title body domain phrases modflag }} = split("\t", $line);
                    $h{targetting} = '';

                    print Dumper(\%h);
                    #exit;

                    my $bn = $proj->bf->lbanner({ %h });


                    my $phl = $bn->phl;
                    return unless @$phl;

$proj->dd($phl);

                    $bn->{fltlog} = 1; #Включаем дополнительный лог фильтрации

                    my @gd = ();
                    my @bd = ();
                    for my $ph (@$phl){

                        my @categs = $ph->get_minicategs;
                        my $ctphs = [ map {{ category => $_->[0], phrase => $_->[1], }} map { @$_ } $ph->get_categs_phrases ];

                        my $h = {
                            banner_id    => $h{id},
                            title        => $h{title},
                            body         => $h{body},
                            domain       => $h{domain},
                            modflag      => $h{modflag},
                            phrase       => $ph->text,
                	    CategoriesString => join('/', sort @categs),
                            CategPhrases => $proj->serial($ctphs),
                            CategDiffLog => '',
                            rsn          => '',
                            fltlog       => '',
                            RandID       => rand(10000000),
                        };

                        my $rsn = $bn->moderate_phrsfilterreason($ph);
                        unless($rsn){
                            $h->{state} = 'good';
                            push(@gd, $h);
                            next;
                        }
                        $h->{state}  = 'bad';
                        $h->{rsn}    = '['.$rsn.']';
                        $h->{fltlog} = $ph->{fltlog};
                        push(@bd, $h);
                    }

                    my @categs = $bn->get_minicategs;
                    my $ctphs = [ map {{ category => $_->[0], phrase => $_->[1], }} map { @$_ } $bn->get_categs_phrases ];

                    my $BnrCategoriesString = join('/', sort @categs);
                    my $BnrCategPhrases     = $proj->serial($ctphs);

                    for my $h ( @gd, @bd ){
                        $h->{BnrCategoriesString} = $BnrCategoriesString;
                        $h->{BnrCategPhrases} = $BnrCategPhrases;
                        $h->{CategDiffLog} = $BnrCategoriesString.' => '.$h->{CategoriesString} if $h->{rsn} =~ /_badminictg/;
                        $h->{CategDiffLogMD5} = md5int($h->{CategDiffLog});
                    }

                    $dbt_phrs->Add([@gd, @bd]);
$proj->dd(\@bd, $cmdh->{'table'});
#exit;

        },
    };
    return $hopt;
}

1;
