package Cmds::Categs;

use utf8;

use base qw(Cmds::Base);
use Encode;
use List::Util qw(min);
use Text::Iconv;
use Data::Dumper;
use URI::Escape;
use Utils::Sys qw(format_number h2sa);
use Time::HiRes qw(gettimeofday tv_interval);
use Utils::Sys qw(md5int);
use Utils::Urls;
use Utils::XLS qw(array2xls xls2array xlsx2array xls_edit_line xls_lines_list);
use Utils::Array qw(array_intersection);
use JSON qw(to_json from_json);

sub noauth_mapping_mdev : CMD {
    my ($proj, $vars) = @_;
    my $filename = $proj->options->{dirs}{dicts} . '/apps/apps_hierarchy';
    my $text = $proj->file($filename)->text;
    $text =~ s/\#.*?\n/\n/g;
    my $trf = sub { my $t = $_[0]; $proj->categs_tree->get_minicateg_directid_by_catid($t); };
    $text =~ s/(^|\n)([a-z0-9]+)/$1.$trf->($2)/ge;
    $vars->{text} = $text;
}

sub noauth_bscateg_goalid_mapping : CMD {
    my ($proj, $vars) = @_;
    #Дополнительная информация о GoalID из отдельного словаря
    my $filename_goals = $proj->options->{dirs}{dicts} . '/apps/bscateg_goalid_mapping';
    my %glh = map { split(/\t/, $_, 2) } split /\n/, $proj->file($filename_goals)->text;
    #$proj->dd(\%glh);
    my $filename = $proj->options->{dirs}{dicts} . '/apps/apps_hierarchy';
    my $text = $proj->file($filename)->text;
    $text =~ s/\#.*?\n/\n/g;
    my $trf = sub { my $t = $_[0]; $proj->categs_tree->get_minicateg_directid_by_catid($t); };
    $text =~ s/(^|\n)([a-z0-9]+)\t([^\t]+)\t/$1.$trf->($2)."\t$3\t".$glh{$trf->($2)}."\t"/ge;
    $text =~ s/\tCateg\t/\tCateg\tGoalID\t/; #Добавляем заголовок для GoalID
    $vars->{text} = $text;
}

sub noauth_mapping_mobAppsCategs2OrdinaryCategs : CMD {
    my ($proj, $vars) = @_;
    my $filename = $proj->options->{dirs}{dicts} . '/apps/mobAppsCategs2OrdinaryCategs';
    my $text = $proj->file($filename)->text;
    $text =~ s/\#.*?\n/\n/g;
    my $trf = sub { my $t = $_[0]; $proj->categs_tree->get_minicateg_directid_by_catid($t); };
    $text =~ s/(^|\n)([a-z0-9]+)/$1.$trf->($2)/ge;
    $vars->{text} = $text;
}

sub get_categs_list : CMDH {
    my ($proj, $vars) = @_;

    return {
        readonly => 1,
        title => 'Список категорий',
        idfield => 'CatIDLang',
        getlistflt => sub {
            my ($self, %prm) = @_;
            my $proj = $self->proj;

            my $lang = $proj->current_lang;
            my $flist = $proj->List_SQL("
                select
                    CONCAT(CatID, '_', Language) CatIDLang,
                    CatID,
                    CONCAT(ParentID, '_', Language) ParentIDLang,
                    ParentID,
                    CategoryName,
                    Language lang
                from CatalogiaBrief
                     left join CatalogiaDict using(CatID)
                where not IsAtom
            ");

            my $flags_list = $proj->List_SQL("
                select
                    CatID,
                    group_concat(Flag) as Flags
                from CatalogiaFlags
                group by CatID
            ");

            my %flags_map = map { $_->{CatID} => $_->{Flags} } @$flags_list;
            for my $item (@$flist) {
                $item->{Flags} = $flags_map{$item->{CatID}};
            }

            my $lngs = {};
            push @{ $lngs->{$_->{lang}} //= [] }, $_ for @$flist; #Раскладываем по языкам

            my @res = ();
            for my $lng ( keys %$lngs ){
                my $list = $lngs->{$lng};

                # Прокидывание флагов по детям
                my $pre_result = {}; #Раскладываем категории в хэш массивов по родителю
                for my $el ( @$list ){
                    $el->{NotTranslated} = ( $lang ne 'ru' && $el->{CategoryName} =~ /[а-яА-Я]/ ) ? 1 : 0;

                    $pre_result->{$el->{CatID}}{$_} = $el->{$_} for keys %$el; #Дети могли оказаться в массиве раньше родителей - нельзя просто присвоить хэш
                    push @{$pre_result->{ $el->{ParentID} }{Children}}, $el->{CatID};
                    $pre_result->{ $el->{ParentID} }{ChildrenCount}++;

                    if($el->{CategoryName} !~ / _ /) {
                        $pre_result->{$el->{ParentID}}{HasNonVirtualChild} = 1;
                    }
                }
                my $result = [];

                #Если были указаны неправильные родители - эти категории потеряются, так как там строится дерево
                _UploadChildren( 0, $pre_result, $result, 0 ); #Нужно для прокидывание флагов родителей по детям

                $list = $result; #Список с уже прокинутыми флагами
                #/ Прокидывание флагов по детям

                my %cth = map { $_->{CategoryName} => $_ } @$list;
                my $vrtlist = [grep {$_->{CategoryName} =~ / _ /} @$list];
                $list = [grep {$_->{CategoryName} !~ / _ /} @$list]; #Удаляем виртуалки из общего списка, так как будет отображать их иначе

                $_->{CategoryName} =~ /^(.*) _ (.*)$/ ? (($_->{VtCategoryName}, $_->{MnCategoryName}) = ($1, $2)) : 0 for @$vrtlist;
                $cth{$_->{MnCategoryName}}{virtlst} .= $_->{VtCategoryName}.'=>'.$_->{CatID}.'=>'.$_->{Flags}.'/' for @$vrtlist;

                push(@res, @$list);
            }

            @res = grep {$_->{CatIDLang}} @res; #Убираем дубли корневых директорий из разных языков

            return \@res;
        },
        extlists => [
            { cmd => 'get_categs_list', using => 'ParentIDLang', },
        ],
        extlists_count_field => 'ChildrenCount',
        cache_getlistflt => { cache_time => 12 * 60 * 60 },
        lang_field => 'lang',
        hide_fields_titles => 1,
        default_field_params => { shlist => 1, },
        fields => [
            { name => 'CatID', showmacro => 'showcatid', },
            { name => 'ParentID', addform => 1, shlist => 0, },
            { name => 'ParentIDLang', addform => 1, shlist => 0, },
            { name => 'CategoryName', showmacroel => 'show_url_field', showmacro => 'showcategnametext', geturl => sub {
                my ($el, $f) = @_;
                return '?cmd=show_phrases&id='.$el->{CatID};
            }, },
            { name => 'Flags', showmacro => 'showcategflags', },
            { name => 'virtlst', showmacro => 'showvirtcategslist', },
        ],
        default_filter => { ParentIDLang => ['0_ru','0_en','0_tr'], },
        pager => { cc => 200, },
    };
}

# СatID, hash of tags
sub _UploadChildren {
    my ( $id, $hash, $result, $level ) = @_;
    $hash->{$id}{Level} = $level;
    $hash->{$id}{Prefix} = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' x ( $level - 1);
    push @$result, $hash->{$id};
    for my $ch_id ( @{$hash->{$id}{Children}} ) {

        # если вообще нужно что-то делать с тэгами
        if ( $hash->{$id}{Tags} ) {
            # вычисляем тэги всех родителей
            my $pid = $id;
            my $parent_tags = {};
            my $p_count = 0;
            while ( $pid || $p_count++ > 1000 ) {
                my $p_tags = { map { $_ => 1 } grep { /\S/ } split /\s+/, $hash->{$pid}{Tags} };
                $parent_tags = { %$parent_tags, %$p_tags };
                $pid = $hash->{$pid}{ParentID};
            }

            my $child_tags  = { map { $_ => 1 } grep { /\S/ } split /\s+/, $hash->{$ch_id}{Tags} };
            my $result_tags = { %$child_tags };
            for my $parent_tag ( keys %$parent_tags ) {

                 # если у ребенка есть "выключающий тэг", то два тэга уничтожаются, иначе родительский тэг прокидывается ребенку
                 if ( !exists( $result_tags->{"-".$parent_tag} ) ) {
                     $result_tags->{$parent_tag} = 1;
                 } else {
                     delete $result_tags->{"-".$parent_tag};
                 }
            }
            $hash->{$ch_id}{Tags} = join(' ', sort {$a cmp $b} keys %$result_tags);
        }
        _UploadChildren( $ch_id, $hash, $result, $level + 1 );
    }
}

sub parse_categs_phrases {
    my ($proj, $vars, $allow_empty_categs) = @_;
    my $form = $proj->form;
    my $text = $form->{phrases_text};
    $text =~ s/(^|\n)#[^\n]*(\n|$)/\n/g;
    sub del_nommes { my $t = shift; $t =~ s/,/ /g; return $t; }
    $text =~ s/=>([^\n]*)(\n|$)/'=>'.del_nommes($1).$2/ge;
    $text =~ s/(?:(?:\r?\n|,)\s*)+/\n/g; #Перевод строки - тоже разделитель
    $text =~ s/\s*,\s*/\n/g; #Перевод строки - тоже разделитель
    my $phl = $proj->phrase_list;  #->get_minicateg_by_id
    my @data = map { [ $_->[0], $_->[1] ? $phl->get_minicateg_id_lang($_->[1], $vars->{viewoptions}{lang}) : "" ] }
        map { [ split /\s*=>\s*/, $_ ] }
        grep {$allow_empty_categs || /=>/}
        split "\n", $text;
    my $h = {};
    $h->{$_->[1]} .= $_->[0]."," for @data;
    $h->{$_} = $proj->phrase_list($h->{$_}) for keys %$h;
    $proj->save_phrase_list($_) for values %$h;
    $h->{$_} = $h->{$_}->cache_id for keys %$h;
    return $h;
}

sub add_categs_phrases : CMD {
    my ($proj, $vars) = @_;
    my $form = $proj->form;
    my $h = parse_categs_phrases($proj, $vars, 0);
    my $phsdata = '';
    my $i = 0;
    for my $ct (keys %$h){
        $i++;
        $phsdata .= '&phlid'.$i."=".$h->{$ct}.'&catid'.$i."=".$ct . "&action$i=Add";
    }
#    print Dumper($h);
#    exit;
    $proj->do_redirect(join("&",
        "ind.pl?cmd=edit_user_phrases$phsdata",
        "viewoptionsstr=".$form->{viewoptionsstr},
    ));
}

sub delete_category : CMD {
    my ($proj, $vars) = @_;
    my $categ_id = $proj->form->{id};

    if($categ_id) {
        my $categ_name = $proj->get_category($categ_id, 'ru')->{CategoryName};
        $proj->add_user_phrase($categ_id, $categ_name, "ru", "DeleteCategory");
    }

    $proj->do_redirect(join("&",
        "ind.pl?cmd=show_phrases",
        "id=$categ_id",
        "viewoptionsstr=".$proj->form->{viewoptionsstr}
    ));
}

sub delete_phrases : CMD {
    my ($proj, $vars) = @_;
    my $lang = $vars->{viewoptions}{lang} || 'ru';
    my $categ = $proj->get_category($vars->{viewoptions}{curcatid}, $lang);
    my $form = $proj->form;
    my @items;
    my @phrases;
    my $i;

    for($i = 1; defined($form->{"catid$i"}) && defined($form->{"phlid$i"}); $i++) {
        my ($catid, $phlid) = map{$form->{$_ . $i}} qw(catid phlid);
        my $phl = $proj->get_phrase_list($phlid);
        my $from_categ = $form->{"fromcatid$i"} ? $proj->get_category($form->{"fromcatid$i"}) : $categ;
        my $to_categ = $proj->get_category($catid, $lang);

        if($form->{do_delete}) {
            for my $phr ($phl->phrases) {
                $proj->add_user_phrase(
                    $from_categ->{CatID},
                    $phr->text,
                    $lang,
                    "Delete",
                    $form->{"comment_" . $proj->get_user_phrase_id($phr->text)}
                );

                if($to_categ) {
                    $proj->add_user_phrase($to_categ->{CatID}, $phr->text, $lang, "Add");
                }
            }
        } else {
            push @items, {
                i           => $i,
                from_categ  => $from_categ,
                phlid       => $phlid,
                to_categ    => $to_categ,
            };

            push @phrases, {
                id          => $proj->get_user_phrase_id($_->text),
                text        => $_->text,
                from_categ  => $from_categ,
                to_categ    => $to_categ
            } for $phl->phrases;
        }
    }

    if($proj->form->{do_delete}) {
        $proj->do_redirect(join("&",
            "ind.pl?cmd=edit_phrase_list",
            "id=" . $categ->{CatID},
            "viewoptionsstr=".$proj->form->{viewoptionsstr},
        ));
    }

    $vars->{phrases} = \@phrases;
    $vars->{category} = $categ;
    $vars->{items} = \@items;
    $vars->{template} = "delete_phrases.tmpl";
}



sub save_user_phrases : CMD {
    my ($proj, $vars) = @_;

    my $lang = $vars->{viewoptions}{lang} || 'ru';
    $proj->current_lang($lang);

    my $result = [];
    my $input = [ ["lang", $lang] ];
    my $saved = 0;
    my $do_save = $proj->form->{do_save};
    my @bad_phrases;
    my @all_categs;

    # список всех упоминаемых категорий
    if(!$do_save) {
        for my $key_name (sort keys %{$proj->form}) {
            my ($i) = $key_name =~ /^phlid(\d+)$/;
            next if !$i || !$proj->form->{"catid$i"};

            my $phlid = $proj->form->{"phlid$i"};
            my $phl = $proj->get_phrase_list($phlid);

            my %h;
            for my $phr ($phl->phrases) {
                $h{$_}++ for $phr->get_minicategs;
            }

            push @all_categs, $_ for
                sort{$a->{CategoryName} cmp $b->{CategoryName}}
                map{$proj->get_category_by_name($_, $lang)}
                keys %h;
        }
    }

    my %done_ids;
    for my $key_name (sort keys %{$proj->form}) {
        my ($i) = $key_name =~ /^phlid(\d+)$/;
        next if !$i || !$proj->form->{"catid$i"};

        my $phlid = $proj->form->{"phlid$i"};
        my $phl = $proj->get_phrase_list($phlid);
        my $categ = $proj->get_category($proj->form->{"catid$i"}, $lang);

        # проверяем, что категория задана корректно
        if(!$categ) {
            push @bad_phrases, $_->text for $phl->phrases;
            next;
        }

        push @$input, [$_, $proj->form->{$_}] for ("phlid$i", "catid$i");

        for my $phr ($phl->phrases) {
            my $id = "phr" . $phlid . "_" . $proj->get_user_phrase_id($phr->text);

            # пропускаем дублирующиеся фразы
            next if $done_ids{$id};
            $done_ids{$id}++;

            # сохранение фразы
            if($do_save) {
                next if !$proj->form->{$id};

                $categ = $proj->get_category($proj->form->{"categ_$id"}, $lang);
                next if !$categ;

                my $user_comment = $proj->form->{"comment_$id"};
                $proj->add_user_phrase($categ->{CatID}, $phr->text, $lang, undef, undef, $user_comment);
                $saved++;
            }

            my $warnings = [];
            my $h = $phr->clean_minicategs_subphrases_hash;
            my $exact = join "/", sort map{$phr->category_from_ru($_)} keys %{$h->{$phr->snorm_phr} || {}};

            push @$warnings, "Широкая фраза (".($phr->widephr ? "содержится в словаре широких фраз" : "все слова широкие").")"
                if $phr->is_wide_phrase;
            push @$warnings, "Уже содержится в категориях ($exact)" if $exact;
            push @$result, {
                ID          => $id,
                Text        => $phr->text,
                snorm_phr   => (($phr->text !~ /\[/) ? $phr->snorm_phr : "<i>атом</i>"),
                Category    => $categ,
                Categories  => [$categ, grep{$categ->{CatID} ne $_->{CatID}} @all_categs],
                CurrCategs  => join("/", map{$phr->category_from_ru($_)} $phr->get_minicategs),
                Warnings    => $warnings
            };
        }
    }

    if(@bad_phrases) {
        $vars->{bad_phrases} = join ",", @bad_phrases;
    }

    $vars->{saved} = $saved;
    $vars->{input} = $input;
    $vars->{phrases} = $result;
    $vars->{template} = "save_user_phrases.tmpl";
}

sub virtual_category_list : CMDH {
    my ($proj, $vars) = @_;

    my $list = $proj->List_SQL("
        select
            CatalogiaVirtualDict.ID,
            CatalogiaVirtualDict.CatID,
            CatalogiaVirtualDict.CategoryName,
            CatalogiaVirtualBrief.Flags,
            CatalogiaVirtualDict.CategoryPhrases
        from
            CatalogiaVirtualDict
        inner join
            CatalogiaVirtualBrief on CatalogiaVirtualDict.CatID = CatalogiaVirtualBrief.CatID
        where
            CatalogiaVirtualDict.Language = ?
        ", [ $vars->{viewoptions}{lang} ]
    );

    my $array_diff = sub {
        my ($a, $b) = @_;
        my %arr1 = map{$_ => 1} @{$a};
        my %arr2 = map{$_ => 1} @{$b};
        my $result;
        $result->{$_} = 0 for grep{!$arr2{$_}} @{$a};
        $result->{$_} = 1 for grep{!$arr1{$_}} @{$b};
        return $result
    };

    my $apply_moderation = sub {
        my ($el) = @_;
        my $moderation_list = $proj->List_SQL("
            select
                InitialPhrase, Action
            from
                CatalogiaPhrases
            where
                CatID = ? and Language = ? and Status = ?
            ", [ $el->{CatID}, $vars->{viewoptions}{lang}, 'New' ]
        );
        my %phrases = map{$_ => 1} (split /,/, $el->{CategoryPhrases});
        $phrases{$_->{InitialPhrase}} = 1 for grep{$_->{Action} eq 'VAdd'}    @{$moderation_list};
        $phrases{$_->{InitialPhrase}} = 0 for grep{$_->{Action} eq 'VDelete'} @{$moderation_list};
        my @phrases = grep{$phrases{$_}} (keys %phrases);
        $el->{CategoryPhrases} = join (',', @phrases);
        return $el;
    };

    my $table = {
        title => 'Виртуальные категории',
        readonly => 1,  # По просьбе Тани. TODO: зачем было сделано right_edit_virtual_categs? !$proj->user->rights->{right_edit_virtual_categs},
        getlist => sub {
            my ($self, %prm) = @_;
            return $list;
        },
        getlistelem => sub {
            my ($proj, $id) = @_;
            my @elem_list = grep{$_->{ID} eq $id} @{$list};
            $elem_list[0] = $apply_moderation->($elem_list[0]);
            return $elem_list[0];
        },
        idfield => 'ID',
        default_field_params => { shlist => 1, },
        fields => [
            { name => 'CatID',  title => 'CatID', },
            { name => 'CategoryName', title => 'Имя&nbsp;категории', },
            { name => 'Flags',  title => 'Список&nbsp;флагов', showmacro => 'comma2commaspace', },
            { name => 'CategoryPhrases', title => 'Список&nbsp;фраз', showmacro => 'categphrases', ftype => 'bigtextarea',
              showsubel => sub {
                my ($el, $f) = @_;
                return $apply_moderation->($el)->{CategoryPhrases};
              },
            },
        ],
        editlistelem => sub {
            my ($proj, $id, $new_value) = @_;
            my $cat_id = $new_value->{CatID};
            my $old_value = $apply_moderation->((grep{$_->{ID} eq $id} @{$list})[0]);
            my $moderation_list = $proj->List_SQL("
                select
                    InitialPhrase, Action
                from
                    CatalogiaPhrases
                where
                    CatID = ? and Language = ? and Status = ?
                ", [ $cat_id, $vars->{viewoptions}{lang}, 'New' ]
            );
            my $phrases_moderation_list = {
                map{
                    $_->{InitialPhrase} => 1
                } grep{
                    $_->{Action} eq 'VAdd' || $_->{Action} eq 'VDelete'
                } @{$moderation_list}
            };
            my $phrases_to_moderate = $array_diff->(
                [split /,/, $old_value->{CategoryPhrases}],
                [split /,/, $new_value->{CategoryPhrases}]
            );
            for (keys %{$phrases_to_moderate}) {
                my $action = $phrases_to_moderate->{$_} ? 'VAdd' : 'VDelete';
                $proj->add_user_phrase($cat_id, $_, $vars->{viewoptions}{lang}, $action)
                    if (!$phrases_moderation_list->{$_});
            }
           },
    };
    return $table;
}


sub domain_flags_list : CMDH {
    my ($proj, $vars) = @_;

    sub prepare_data {
        my ( $proj, $data ) = @_;
        my @domains = ();
        if (exists $data->{Domain} ) {
            foreach my $domain ( split /\s*,\s*/, $data->{Domain} ) {
                $domain =~ s/^\s*//;
                $domain =~ s/\s*$//;
                $domain =~ s/#.*$//;
                $domain =~ s/#[^?]*\?/\?/;
                $domain = lc($domain);
                my $urlpage = $proj->page($proj->page(url_to_unicode($domain))->fixed_url);
                if ( $urlpage->domain ) {
                    $domain = $urlpage->domain;
                }
                else {
                    #это может быть tld, поэтому проверяем регуляркой. Не подходит - обнуляем
                    if ( $domain !~ /^\w+$/ ) {
                        $domain = '';
                    }
                }

                if ( $data->{Mode} eq 'Domain' ) {
                }
                elsif ( $data->{Mode} eq 'Path' ) {
                    my $page = $proj->page($urlpage->domain_path);
                    $domain .= $page->uri if $page->uri ne '/';
                }
                elsif ( $data->{Mode} eq 'Params' ) {
                    $domain .= $urlpage->uri if $urlpage->uri ne '/';
                }
                push @domains, $domain;
            }
            $data->{Domain} = join(',', @domains);
        }
        if (exists $data->{Flags} ) {
            $data->{Flags} =~ s/^\s*//;
            $data->{Flags} =~ s/\s*$//;
            my @flags = split /\s*,\s*/, $data->{Flags};
            $_ =~ s/^([_])// for @flags;
            $_ =~ s/^[-]([_])/-/ for @flags;
            $data->{Flags} = join ',', @flags;
        }
    }

    my $table = {
        title => 'Флаги модерации для доменов и URL',
        edittitle => sub { my ($self, $el) = @_; return 'Флаги модерации для '.$el->{Domain}; },
        table => 'CatalogiaDomainFlags',
        readonly => !$proj->user->rights->{right_edit_domain_flags},
        idfield => 'ID',
        fix_sql_problem => 1,
        default_field_params => { shlist => 1, },
        fields => [
            { name => 'Domain',  title => 'URL', disable_edit => 1, },
            { name => 'Mode', title => 'Режим', shlist => 0, ftype => 'select',
                  selectlist => [
                          { name => 'Только домен', value => 'Domain', default => 1 },
                          { name => 'Домен и путь', value => 'Path' },
                          { name => 'Домен, путь и параметры', value => 'Params' },
                      ],
                  inline => 1,
                  edlist => 1,
            },
            { name => 'Flags',  title => 'Список&nbsp;флагов', },
            { name => 'Comment',  title => 'Комментарий', ftype => 'widetextarea', },
            {  name => 'Login', autoedit => sub { $proj->{login} }, title => 'Автор&nbsp;последней&nbsp;модификации', },
            {  name => 'MDate', autoedit => sub { $proj->dates->cur_date('db_time') }, title => 'Дата&nbsp;последней&nbsp;модификации', },
        ],
        multi_add_by_field => { field => 'Domain', delim => '\s*,\s*', },
        search => { fields => [ 'Domain', ], name => 'text', title => 'Поиск', },
        checkform => { action => sub {
            my ($self, $h) = @_;
            my $proj = $self->proj;
            prepare_data($proj, $h);
            for my $domain (split /\s*,\s*/, $h->{Domain}  ) {
                if (!defined $proj->form->{id}) { #отсутствие айдишника отличает создание строки от редактирования
                    return "Не удалось определить домен" unless $domain;
                    my $lst = $proj->dbtable('CatalogiaDomainFlags')->List({Domain => $domain});
                    return "Домен $domain уже существует" if @$lst;
                }
            }
            #проверка на противоречия
            my %uniq  = map { $_ => 1 } split /\s*,\s*/, $h->{Flags};
            for (keys %uniq) {
                if ($_ !~ /^[-]/ && $uniq{"-$_"}) {
                    return "Флаг $_ присутствует и с минусом, и без";
                }
            }
            #проверка на существование флага
            my @all_flags = @{$proj->get_flags_list};
            $_->{Flag} =~ s/^([_])// for @all_flags;
            my %all_flags_hash = map {$_->{Flag} => 1} @all_flags;
            my @flags = split /\s*,\s*/, $h->{Flags};
            $_ =~ s/^([-])// for @flags;
            my $error_flags = join ', ', grep {!$all_flags_hash{$_}} @flags;
            return "Обнаружены несуществующие флаги: $error_flags" if $error_flags;
            return '';
        } },
        action_before_add => sub {
            my ($proj, $data) = @_;
            prepare_data($proj, $data);
        },
        action_before_edit => sub {
            my ($proj, $id, $data) = @_;
            prepare_data($proj, $data);
        },
        pager => { cc => 200, },
    };
    return $table;
}

sub get_flag_categs : CMD {
    my ($proj, $vars) = @_;
    my $flag = $proj->form->{flag};

    $vars->{Categories} = $proj->get_flag_categories($flag);
    $vars->{template} = "get_flag_categs.tmpl";
}

sub get_atoms_list_old : CMD {
    my ($proj, $vars) = @_;
    my $num_visible = 10;

    my $atoms = $proj->get_atoms_list($vars->{viewoptions}{lang});
    my $root_atoms = [];
    my $id2atom = { map{$_->{CatID} => $_} @$atoms };

    for my $atom (@$atoms) {
        $atom->{IsDeleted} = $proj->is_category_deleted($atom->{CatID});
        $atom->{children} ||= [];

        my $parent = $id2atom->{$atom->{ParentID}};
        if($parent) {
            push @{$parent->{children} ||= []}, $atom;
        } else {
            push @$root_atoms, $atom;
        }

        my @phrases = split ",", $atom->{CategoryPhrases};
        $atom->{VisiblePhrases} = join ", ", @phrases[0..min($#phrases, $num_visible - 1)];
        if(@phrases > $num_visible) {
            $atom->{InvisiblePhrases} = join ", ", @phrases[$num_visible..$#phrases];
        }
    }

    $vars->{root_atoms} = $root_atoms;
    $vars->{atoms} = $atoms;
    $vars->{template} = "get_atoms_list.tmpl";
}

sub get_atoms_list : CMDH {
    my ($proj, $vars) = @_;
=h
    {
      'Flags' => '',
      'VisiblePhrases' => 'Ваккум-аспирация, Медикаментозное прерывание, абборт, аборт безоперационный, аборт операционный, аборт операция, абортивный таблетка, беременность избавляться, беременность прерывание, медаборт',
      'children' => [],
      'CategoryName' => '.Аборт',
      'CategoryPhrases' => 'Ваккум-аспирация,Медикаментозное прерывание,абборт,аборт безоперационный,аборт операционный,аборт операция,абортивный таблетка,беременность избавляться,беременность прерывание,медаборт,медикаментозный аборт,мефегин,мефепристон,мефигин,мефипрестон,мефипристон,мини-аборты,мифепрестон,мифипристон,мифолиан,пинкрафтон,постенор,фармааборт,фармаборты,фармакологический аборт,фармоаборт,фармооборт,хирургический аборт',
      'IsAtom' => 1,
      'IsDeleted' => undef,
      'ParentID' => 'abase',
      'CatID' => 'a024'
    },
=cut
    return {
        readonly => 1,
        title => 'Словари и атомы',
        idfield => 'CatID',
        getlistflt => sub {
            my ($self, %prm) = @_;
            my $num_visible = 10;

            my $atoms = $proj->get_atoms_list($vars->{viewoptions}{lang});
            my $root_atoms = [];
            my $id2atom = { map{$_->{CatID} => $_} @$atoms };

            for my $atom (@$atoms) {
                $atom->{IsDeleted} = $proj->is_category_deleted($atom->{CatID});
                $atom->{children} ||= [];

                my $parent = $id2atom->{$atom->{ParentID}};
                if($parent) {
                    push @{$parent->{children} ||= []}, $atom;
                } else {
                    push @$root_atoms, $atom;
                    $atom->{root} = 1;
                }

                my @phrases = split ",", $atom->{CategoryPhrases};
                $atom->{VisiblePhrases} = join ", ", @phrases[0..min($#phrases, $num_visible - 1)];
#                if(@phrases > $num_visible) {
#                    $atom->{InvisiblePhrases} = join ", ", @phrases[$num_visible..$#phrases];
#                }
            }

            $_->{count} = @{$_->{children} || []} for @$atoms;

#$proj->dd($atoms);
            return $atoms;
        },
        extlists => [
            #{ cmd => 'get_atoms_list_new', addelemparams => { 'ParentID' => 'CatID', },  },
            { cmd => 'get_atoms_list', using => 'ParentID', },
        ],
        extlists_count_field => 'count',
        hide_fields_titles => 1,
        default_field_params => { shlist => 1, },
#        onclick => 'inline_extlists',
        fields => [
#            { name => 'CatID', },
#            { name => 'count', },
            { name => 'ParentID', addform => 1, shlist => 0, },
            { name => 'CategoryName', showmacroel => 'show_url_field', geturl => sub {
                my ($el, $f) = @_;
                return '' if ($el->{CatID} eq 'ahmn')||($el->{CatID}=~/^__homonym_/);
                return '?cmd=show_phrases&id='.$el->{CatID};
            }, },
        ],
        default_filter => { ParentID => '0', },
        pager => { cc => 200, },
    };
}

sub get_flags_list : CMD {
    my ($proj, $vars) = @_;

    $vars->{flags} = $proj->get_flags_list_full;
    for my $flag (@{$vars->{flags}}) {
        if($flag->{Flag} =~ /^_/ || $flag->{Flag} eq 'asocial') {
            $flag->{CatalogiaFlag} = $flag->{Flag};
            $flag->{CatalogiaFlag} =~ s/^_//;
        }
        my $no_underscore_flag = $flag->{Flag};
        $no_underscore_flag =~ s/^_//;
        $flag->{PlusWords} = join", ", $proj->catalogia_markers->get_marker_plus_phrases($flag->{Flag});
        $flag->{MinusWords} = join", ", $proj->catalogia_markers->get_marker_minus_phrases($flag->{Flag});
        $flag->{CatID} = $proj->get_category_id('.'.$flag->{Flag});
    }
    $vars->{template} = "get_flags_list.tmpl";
}

sub categs_tools : CMD {
    my ($proj, $vars) = @_;

    if ($proj->form->{unpack_click} eq "true") {

        my $categ_id = $proj->form->{unpack_category_id};
        my $lang = $proj->form->{language};

        my $ru_categ = (grep{$_->{CatID} eq $categ_id} @{$proj->get_categories_list_lang('ru')})[0];
        my $lang_categ = (grep{$_->{CatID} eq $categ_id} @{$proj->get_categories_list_lang($lang)})[0];

        my @phrase_list0 = map{s/^\s+|\s+$//g; $_} grep{!/[А-Яа-я]/} split ",", $ru_categ->{CategoryPhrases};

        my %done_phrases;
        my $arr = $proj->user_phrases->List([
            [Language => $lang],
            [Action => "Add"],
            [Status => "!=" => "Declined"],
            [Status => "!=" => "Done"]
        ]);
        for my $h (@$arr) {
            push @{$done_phrases{$h->{CatID}} ||= []}, $h->{InitialPhrase};
        }
        my %phrase_list1 =
            map{$_ => 1}
            map{s/^\s+|\s+$//g; $_}
            (@{$done_phrases{$categ_id} || []}, split (",", $lang_categ->{CategoryPhrases}));

        my @to_infuse = grep{!$phrase_list1{$_}} @phrase_list0;

        my $flt = {map { $_->{Phrase} => 1} @{$proj->hidden_phrases->List({ Phrase => \@to_infuse, CategoryId => $categ_id, Language => $lang })}};
        my @hidden_phrases = grep {$flt->{$_}} @to_infuse;
        my @displayed_phrases = grep {!$flt->{$_}} @to_infuse;

        my %hidden_phrases = map{my $buff = $proj->get_user_phrase_id($_); s/"/&quot;/g; s/</&lt;/g; s/>/&gt;/g; $_ => $buff} @hidden_phrases;
        my %displayed_phrases = map{my $buff = $proj->get_user_phrase_id($_); s/"/&quot;/g; s/</&lt;/g; s/>/&gt;/g; $_ => $buff} @displayed_phrases;



        my @hidden_phrases_json = map{"{\"phrase\":\"" . $_ . "\"," . "\"phraseId\":\"" . $hidden_phrases{$_} . "\"}"} keys(%hidden_phrases);
        my @displayed_phrases_json = map{"{\"phrase\":\"" . $_ . "\"," . "\"phraseId\":\"" . $displayed_phrases{$_} . "\"}"} keys(%displayed_phrases);
        print "Content-Type: text/plain; charset=utf-8\n\n";
        print "{\"hidden_phrases\":[" . join(",", @hidden_phrases_json) . "],\n";
        print "\"displayed_phrases\":[" . join(",", @displayed_phrases_json) . "]}\n";

        exit 0;
    }

    if ($proj->form->{hide_used}) {
        my $categ = $proj->form->{hidden_category};
        my $phr   = $proj->form->{hidden_phrase};

        # kostyl
        $phr =~ s/\&quot;/\"/g;
        $phr =~ s/&lt;/</g;
        $phr =~ s/&gt;/>/g;
        # /kostyl

        my $lang  = $proj->form->{language};
        if ($proj->form->{hide_used} eq 'hide') {
            $proj->hidden_phrases->Add({CategoryId => $categ, Phrase => $phr, Language => $lang});
        } else {
            $proj->List_SQL("delete from HiddenPhrases where CategoryId = ? and Language = ? and Phrase = ?;", [$categ, $lang, $phr]);
        }

        print STDOUT "Content-Type: text/plain; charset=utf-8\n\n";
        print STDOUT "hi!\n";

        exit 0;
    }

    # вливание фраз без кириллицы в en/tr
    if($proj->form->{infuse_latin}) {
        my $lang = $vars->{viewoptions}{lang};
        my @phlids;
        my @catids;

        my $ru_categs = $proj->get_categories_list_lang("ru");
        my %lang_categs = map{$_->{CatID} => $_} @{$proj->get_categories_list_lang($lang)};
        my @updated_categs;
        my $do_infuse = $proj->form->{do_infuse};

        # фразы, которые уже добавлены, но ещё не внесены в словари
        my %done_phrases;
        my $arr = $proj->user_phrases->List([
                [Language => $lang],
                [Action => "Add"],
                [Status => "!=" => "Declined"],
                [Status => "!=" => "Done"]
            ]);
        for my $h (@$arr) {
            push @{$done_phrases{$h->{CatID}} ||= []}, $h->{InitialPhrase};
        }
        for my $ru_categ (@$ru_categs) {
            next if $ru_categ->{CategoryName} =~ /\s_\s|^\./;

            # фразы, которые потенциально можно влить (1)
            my @latin = map{s/^\s+|\s+$//g; $_} grep{!/[А-Яа-я]/} split ",", $ru_categ->{CategoryPhrases};

            if(@latin) {
                my $lang_categ = $lang_categs{$ru_categ->{CatID}};

                # фразы, которые уже есть в словарях + добавленные через интерфейс (2)
                my %phrases = map{$_ => 1}
                    map{s/^\s+|\s+$//g; $_}
                    (@{$done_phrases{$ru_categ->{CatID}} || []}, split (",", $lang_categ->{CategoryPhrases}));

                # пересечение (1) и (2)
                my @to_infuse = grep{!$phrases{$_}} @latin;

                my $flt = { map { $_->{Phrase} => 1} @{$proj->hidden_phrases->List({ Phrase => \@to_infuse, CategoryId => $ru_categ->{CatID}, Language => $lang })} };
                my @hidden_phrases = grep {$flt->{$_}} @to_infuse;
                my @displayed_phrases = grep {!$flt->{$_}} @to_infuse;

                if(@displayed_phrases || @hidden_phrases) {
                    if($do_infuse && $proj->form->{"categ_" . $ru_categ->{CatID}}) {
                        $proj->add_user_phrase($ru_categ->{CatID}, $_, $lang) for @displayed_phrases;
                    } else {
                        if (0) {
                            my @hidden_phrases_info;
                            foreach (@hidden_phrases) {
                                push @hidden_phrases_info, {phraseValue => $_, phraseId => $proj->get_user_phrase_id($_)};
                            }

                            my @displayed_phrases_info;
                            foreach (@displayed_phrases) {
                                push @displayed_phrases_info, {phraseValue => $_, phraseId => $proj->get_user_phrase_id($_)};
                            }

                            $lang_categ->{HiddenPhrases} = [@hidden_phrases_info];
                            $lang_categ->{DisplayedPhrases} = [@displayed_phrases_info];
                        }
                        # $lang_categ->{CategoryId} = $ru_categ->{CatID};
                        my $lang_categ_info = {CatID                => $lang_categ->{CatID},
                                               CatName              => $lang_categ->{CategoryName},
                                               HiddenPhraseCount    => scalar @hidden_phrases,
                                               DisplayedPhraseCount => scalar @displayed_phrases,
                                               };
                        # $proj->dd($lang_categ_info);
                        push @updated_categs, $lang_categ_info;
                    }
                }
            }
        }
        $vars->{updated_categs} = [sort{$a->{CatName} cmp $b->{CatName}} @updated_categs];
        $vars->{lang} = $proj->{viewoptions}{lang};
    }
    $vars->{template} = "categs_tools.tmpl";
}

sub siblings : CMDH {
    my ($proj, $vars) = @_;

    return {
        title => 'Siblings',
        readonly => 1,
        table => 'Siblings',
        idfield => 'GroupID',
        default_field_params => { shlist => 1, },
        fields => [
               {  name => 'GroupName', title => 'Имя группы'},
               {  name => 'Categories', title => 'Категории', },
        ],
        order_by => 'GroupName',
        pager => { name => 'p', cc => 100, },
        search => { fields => [ 'Categories' ], name => 'text', },
        filters => [
               {  name => 'Категории', field => 'Categories' },
        ],
    };
}

sub search_category_by_atom : CMD {
    my ($proj, $vars) = @_;

    $vars->{title} = 'Поиск категорий, содержащих заданный атом во фразах';

    if($proj->form->{do_search}) {
        $proj->current_lang($vars->{viewoptions}{lang});
        my $atom = $proj->form->{'atom'};
        my $list = $proj->List_SQL("
            select distinct CategoryName from  CatalogiaDict where CategoryPhrases REGEXP concat('(/|\\\\[)', ?, '(/|\\\\])')
        ", [$atom]);
        my @categories = map {$_->{'CategoryName'}} @$list;
        $vars->{categs} = [ grep{$_} map{$proj->get_category_by_name($_, $vars->{viewoptions}{lang}) } @categories ];
        $vars->{atom} = $atom
    }
    $vars->{template} = "search_category_by_atom.tmpl";
}

sub search_category_by_snorm :CMD {
    my ($proj, $vars) = @_;

    $vars->{title} = 'Поиск по подфразам с учётом синонимов в правилах категорий';

    if($proj->form->{do_search}) {
        $proj->current_lang($vars->{viewoptions}{lang});
        my @snorm_list = split / /, $proj->form->{snorm};
        my @found = map{[$proj->phrase($_)->search_category_by_snorm]} @snorm_list;
        my @categ_list = @{array_intersection(@found)};
        if( $proj->form->{atoms} ){
            @categ_list = grep { /^\./} @categ_list;
        }else{
            @categ_list = grep {!/^\./} @categ_list;
        }
        $vars->{categs} = [ grep{$_} map{$proj->get_category_by_name($_, $vars->{viewoptions}{lang}) } @categ_list ];
        $vars->{snorm} = $proj->form->{snorm};
    }
    $vars->{template} = "search_category_by_snorm.tmpl";
}

sub add_category_error : CMD {
    my ($proj, $vars) = @_;
    my $form = $proj->form;
    $vars->{template} = "Lists/message.tmpl";

    my $message = $form->{message};

    $vars->{title} = "Ошибка";
    $vars->{text} = "Ошибка при добавлении категории: " . $message;
}

sub add_category : CMD {
    my ($proj, $vars) = @_;

    my $return_error = sub {
        my $proj = shift;
        my $message = shift;

        return $proj->do_redirect(join("&",
            "ind.pl?cmd=add_category_error",
            "message=" . uri_escape_utf8($message),
            "viewoptionsstr=" . $proj->form->{viewoptionsstr}
        ));
    };

    my $title = $proj->form->{title};
    $title =~ s/^\s+|\s+$//g;

    return $return_error->($proj, "Empty category name") if !$title;
    return $return_error->($proj, "Bad category name '$title': slashes not allowed") if $title =~ m#[/\\]#;

    my $parent_id = $proj->form->{parent_id};
    return $return_error->($proj, "Empty parent_id") if (!$parent_id);

    # если это маркер, название должно являться одним из маркеров
    if ( ( $parent_id =~ /^amarker/ ) && !( grep { $_->{Flag} eq $title } @{$proj->get_flags_list} ) ) {
        return $return_error->($proj, "Can't add marker: no such marker");
    }

    # если это атом, то название должно начинаться с точки
    my $parent = $proj->get_category_full($parent_id);
    if($parent && $parent->{IsAtom} && $title !~ /^\./) {
        $title = ".$title";
    }

    my $category = $proj->get_category_by_name($title);
    my $categ_id;

    if($category) {
        $categ_id = $category->{CatID};
    } else {
        my $i = md5int($title . time()) % 10_000_000;

        my %ids = map{$_->{CatID} => 1} @{$proj->get_new_categories};

        $categ_id = $parent_id;
        $categ_id =~ s/(\d.+)//;
        for(; $ids{$categ_id} || $proj->get_category(sprintf("%s%04d", $categ_id, $i)); $i++) {
        }
        $categ_id = sprintf "%s%04d", $categ_id, $i;
        my $user_comment = $proj->form->{"add-category-user-comment"} // '';

        $proj->add_user_phrase("$categ_id:$parent_id", $title, "ru", "AddCategory", undef, $user_comment);
        $proj->add_category_description($categ_id, "ru", $proj->login, $user_comment);
    }

    $proj->do_redirect(join("&",
        "ind.pl?cmd=show_phrases",
        "id=$categ_id",
        "viewoptionsstr=".$proj->form->{viewoptionsstr}
    ));
}

1;
