package Cmds::Crons;

use utf8;
use open ':utf8';

use base qw(Cmds::Base);

use List::Util qw(sum);
use JSON qw(to_json from_json);
use Data::Dumper;
use POSIX qw(strftime);
use Time::HiRes qw/gettimeofday tv_interval/;
use Time::Local qw(timelocal);
use Encode;
use Utils::Sys qw(uniq do_safely);
use Utils::Hosts qw(get_curr_host);
use BM::SolomonClient;
use Cmds::DynBanners;

sub feed_banners_tasks :CRON {
    my ($proj) = @_;

    $proj->log("feed_banners_tasks BEG");

    my @hosts = Cmds::DynBanners::get_production_hosts();
    my $curr_host = get_curr_host();
    
    my $tbltsk = $proj->dbtable('feed_tasks', 'ID', 'bannerland_dbh');

    my @arr = map {$_->{ID}} map {@$_} $tbltsk->List2( filter => { state => 'New' }, gfields => ['ID'], );

    $proj->log("feed_banners_tasks new tasks: ".@arr);
    
    my @frd = ();
    for my $host_index (0..$#hosts) {
        my $host_re = $hosts[$host_index];

        if($curr_host =~ /$host_re/) {
            @frd = grep{Cmds::DynBanners::check_task_host($proj, $_, $host_index)} @arr;
        }
    }
    $proj->log("feed_banners_tasks frd tasks: ".@frd);

#    while( my $tsk = shift @{ $tbltsk->List2( filter => { state => 'New' }, limit => 1 ) }){
    if(@frd){
        $proj->log("optimcamp_tasks begin ".$frd[0]);
        Cmds::Feeds::_generate_feed_banners($proj, $frd[0]); 
        $proj->log("optimcamp_tasks end ".$frd[0]);
    }

    $proj->log("feed_banners_tasks END");
#    }
} 

sub feed_banners_tasks_dyn :CRON {
    my ($proj) = @_;
    __feed_banners_tasks($proj, 'dyn');
}

sub feed_banners_tasks_perf :CRON {
    my ($proj) = @_;
    __feed_banners_tasks($proj, 'perf');
}

sub __feed_banners_tasks {
    my ($proj, $type) = @_;

    $proj->log("feed_banners_tasks BEG");

    my @hosts = Cmds::DynBanners::get_production_hosts();
    my $curr_host = get_curr_host();
    
    my $tbltsk = $proj->dbtable('feed_tasks', 'ID', 'bannerland_dbh');

    my @arr = map {$_->{ID}} map {@$_} $tbltsk->List2( filter => { state => 'New' }, gfields => ['ID'], );

    $proj->log("feed_banners_tasks new tasks: ".@arr);
    
    my @frd = ();
    for my $host_index (0..$#hosts) {
        my $host_re = $hosts[$host_index];

        if($curr_host =~ /$host_re/) {
            @frd = grep{Cmds::DynBanners::check_task_host($proj, $_, $host_index)} @arr;
        }
    }
    $proj->log("feed_banners_tasks frd tasks: ".@frd);

    #Разделяем обработчики на две части
    if($type eq 'dyn'){
        @frd = grep { $_->{domain} } @frd;
    }else{
        @frd = grep { ! $_->{domain} } @frd;
    }

#    while( my $tsk = shift @{ $tbltsk->List2( filter => { state => 'New' }, limit => 1 ) }){
    if(@frd){
        $proj->log("optimcamp_tasks begin ".$frd[0]);
        Cmds::Feeds::_generate_feed_banners($proj, $frd[0]); 
        $proj->log("optimcamp_tasks end ".$frd[0]);
    }

    $proj->log("feed_banners_tasks END");
#    }
} 

sub feed_tasks_cmp :CRON {
    my ($proj) = @_;

    $proj->log("feed_tasks_cmp BEG");

    my @hosts = Cmds::DynBanners::get_production_hosts();
    my $curr_host = get_curr_host();
    
    my $tbltsk = $proj->dbtable('feed_tasks_cmp', 'ID', 'bannerland_dbh');

    my @arr = map {$_->{ID}} map {@$_} $tbltsk->List2( filter => { state => 'New' }, gfields => ['ID'], );

    $proj->log("feed_tasks_cmp new tasks: ".@arr);
    
    my @frd = ();
    for my $host_index (0..$#hosts) {
        my $host_re = $hosts[$host_index];

        if($curr_host =~ /$host_re/) {
            @frd = grep{Cmds::DynBanners::check_task_host($proj, $_, $host_index)} @arr;
        }
    }
    $proj->log("feed_tasks_cmp frd tasks: ".@frd);

    if(@frd){
        $proj->log("feed_tasks_cmp begin ".$frd[0]);

        Cmds::Feeds::_generate_feed_banners_cmp($proj, $frd[0]); 

        $proj->log("feed_tasks_cmp end ".$frd[0]);
    }

    $proj->log("feed_tasks_cmp END");
}

#Забирание тасков медиапланеров из CRM
sub renew_mp_tasks :CRON {
#sub renew_mp_tasks :CMD {
    my ($proj) = @_;

    eval {
        my $dbt = $proj->dbtable('mp_crm_tasks');

        my $lstlist = $dbt->List_SQL('select max(created_on) md from mp_crm_tasks');
        my $lastdate = '2014-10-20 11:11:11';
    #    $lastdate = $lstlist->[0]{md} if @$lstlist && $lstlist->[0]{md};

        $proj->dd( $lastdate, );
        #my $exturl = 'http://tcrm-myt.yandex-team.ru:33804/mediaOrders?date_from='; #beta
        my $exturl = 'http://xmlrpc-crm.yandex.ru:33804/mediaOrders?date_from=';  #prod
        $exturl .= $lastdate;
        #my $text = $proj->page('http://xmlrpc-crm.yandex.ru:33804/mediaOrders?date_from='.$lastdate)->tt;
        my $text = $proj->page($exturl)->tt;
        return unless $text;
        my $data = $proj->json_obj->decode($text);
        $_->{created_on} = $proj->dates->trdate('mpcrmjson', 'db_time', $_->{created_on}) for @$data;
        $_->{status} = 'New' for @$data;

        # проверяем, что данные действительно новые
        $proj->log(scalar(@$data) . " new orders");
        my $new_data = [];
        my %good_fields = map{$_ => 1} qw(order_id created_on campaign order_type status);
        for my $item (@$data) {
            next if !$item->{campaign};

            my $old_item = $dbt->Get("order_id", $item->{order_id});

            if($old_item) {
                $proj->log($item->{order_id} . " already exists");
            } else {
                # исправляем формат
                my @bad_fields = grep{!$good_fields{$_}} keys %$item;
                delete $item->{$_} for @bad_fields;

                push @$new_data, $item;
            }
        }
    
        $dbt->Add($new_data);
    };

    if($@) {
        $proj->SendMail({
            from      => "no_reply\@yandex-team.ru",
            mail_list => "mp_crm_tasks",
            subject   => "Ошибки при оптимизации кампаний из очереди CRM",
            body      => "Не удалось обработать новые заявки: $@",
        });
    }
}

sub qtests_checking :CRON {
    my ($proj) = @_;

    my $opt = $proj->options->{QTests};

    #$proj->log("File: " . $opt->{results_file} );
    open my $file_out, ">> ".$opt->{results_file}   or do {
        $proj->log("ERROR: Could not open results_file (".$opt->{results_file}.")");
    };

    my @list = $proj->_qtestslist;
    my $text = "QTESTS ".$proj->host_role."\n";
    my @failed;
    for my $qtel (@list){
        my ($name, $qt) = @$qtel;
        $proj->log("QTest($name) ...");
        my %res;
        %res = do_safely( sub { %{ $qt->($proj) } }, timeout => 5*60, no_die => 1, ); 
        $res{status} //= "ERROR: Undefined status!";
        $res{description} //= "";
        $text .= "STATUS $name " . $res{status} . "\n";
        $proj->log("QTest($name): status='" . $res{status} . "' description='" . $res{description} . "'");
        my $has_error = $res{status} =~ /error/i;
        print $file_out join("\t", 
            $proj->dates->cur_date('db_time'), 
            $name,
            ($has_error ? "1" : "0"),    # 0 - OK, 1 - ошибка
        )."\n";
        if ($has_error) {
            push @failed, $name;
            $proj->log("WARN: QTest($name) failed: ".$res{status});
        } else {
            $proj->log("QTESTS_${name}_OK");
            BM::SolomonClient->new()->set_success_script_finish("qtests_${name}");
        }
    }
    close $file_out;
    #print Dumper($proj->host_info);
    #print Dumper([ text => $text, (($text =~ /error/i) ? "ERR" : "OK" )]);
    #return;

    my $is_ok = $text =~ /error/i ? 0 : 1;

    if ($is_ok) {
        $proj->log("QTESTS_OK");
        BM::SolomonClient->new()->set_success_script_finish("qtests_checking");
    } else {
        $proj->log("WARN: There was some errors in QTests: @failed");

        $proj->SendMail({
                    from => 'no_reply@yandex-team.ru',
                    to => 'bm-dev@yandex-team.ru',
                    subject => "QTests ".join(' ', @{$proj->host_info}{qw{ host role desc }} ),
                    body => $text,
        });
    }
}

sub test_compare_orders :CRON {
    my ($proj) = @_;
    my $to = $proj->dates->cur_date('direct'); 
    my $from = $proj->dates->cur_date('direct', -(3600*24*365)); 
    my $order_id = '7078026';

    my $url = 'http://bsfastexport.yandex.ru/export/direct-aggregated-stat-uni.cgi?stat_type=phrase&format=1&date_to='.$to.'&date_from='.$from.'&order_id='.$order_id.'&groupby=UpdateTime,BannerID,PhraseID';
    my $statdata = $proj->page($url)->tt;
    my @lines = split "\n", $statdata;
#    print "$statdata\n";
#    print "Current lines: ".scalar(@lines)."\n\n";

    my $page = $proj->page('http://bsfastexport.yandex.ru/export/master-report.cgi');
    $page->{additional_headers} = { 'Content-Type' => 'application/json' };
    $page->{timeout} = 600;
    my $qry = qq({"date_from":"$from","date_to":"$to","order_ids":[$order_id],"group_by":["BannerID","PhraseID","TargetType","ContextType","OrderID"],"group_by_date":"day","currency":"YND_FIXED","with_discount":0,"with_vat":0});
    my $json_text_response = $page->tt_post($qry);
    my $hresponse = $proj->deserial( $json_text_response )->[0];
    my $fieldnames = $hresponse->{header};
    my $fieldvalues = $hresponse->{data};
    print join("\t", @$fieldnames)."\n";
    for my $a ( @$fieldvalues ){
        print join("\t", @$a)."\n";
    }
#    print "New lines: ".scalar(@$fieldvalues)."\n";
}

sub update_tasks_summary {
    my ($perf, $proj) = @_;
    my $DynPerf = $perf ? "Perf" : "Dyn";
    $proj->bannerland_dbh->Do_SQL("DROP TABLE IF EXISTS ${DynPerf}TasksDirectSummaryTmp");
    $proj->bannerland_dbh->Do_SQL('
        CREATE TABLE `'.${DynPerf}.'TasksDirectSummaryTmp` (
            `Date` datetime,
            `BannerID` bigint,
            `OrderID` int NOT NULL DEFAULT 0,
            `Domain` varchar(200),
            `Shows` int,
            `Clicks` int,
            `Cost` bigint,
            `SessionNum` int,
            `Bounces` int,
            `PrGoodMultiGoal` float,
            PRIMARY KEY (`Date`, `BannerID`, `OrderID`)
        ) CHARSET=utf8 ;
    ');
    my $tasks = $proj->bannerland_dbh->List_SQL("SELECT distinct(OrderID),Domain FROM ${DynPerf}Tasks WHERE OrderID>0");
    my $to = $proj->dates->cur_date('direct');
    my $from = $proj->dates->cur_date('direct', $perf ? -(3600*62*24) : -(3600*100*24));
    my $table = $proj->dbtable("${DynPerf}TasksDirectSummaryTmp", undef, "bannerland_dbh");
    my $max_chunk_size = $perf ? 1000 : 10000;
    my @OrderIDs = map $_->{OrderID}, @$tasks;
    my %OrderID2Domain = map { $_->{OrderID} => $_->{Domain} } @$tasks;
    my $page = $proj->page('http://bsfastexport.yandex.ru/export/master-report.cgi');
    $page->{additional_headers} = { 'Content-Type' => 'application/json' };
    $page->{timeout} = 600;
    my $date2entry = {};
    while ( my @chunk = splice( @OrderIDs, 0, $max_chunk_size-1 ) ){
        my $ids = join(',', map { qq("$_")  } @chunk);
        my $query = qq({"date_from":"$from","date_to":"$to","order_ids":[$ids],"group_by":["OrderID", "BannerID"],"group_by_date":"day","currency":"YND_FIXED","with_discount":0,"with_vat":0,"countable_fields":["Shows", "Clicks", "Cost", "SessionNum", "Bounces", "PrGoodMultiGoal"]});
        my $json_text_response = $page->tt_post($query) || die "master report return nothing";
        my $hresponse = $proj->deserial( $json_text_response )->[0];
        my $fieldnames = $hresponse->{header};
        my $fieldvalues = $hresponse->{data};
        for my $line ( @$fieldvalues ){
            next if @$line < @$fieldnames;
            my %h = map{$fieldnames->[$_] => $line->[$_]} 0..$#$line;
            my $date = $h{UpdateTime};
            $date =~ s/-//g;
            my $banner_id = $h{BannerID};
            my $order_id = $h{OrderID};
            my $key = $order_id . $date . $banner_id;
            my $domain = $OrderID2Domain{$order_id};
            $date2entry->{$key} ||= { Date => $date, BannerID => $banner_id, OrderID => $order_id, Domain => $domain, };
            $date2entry->{$key}{$_} = $h{$_} for qw(Shows Clicks Cost SessionNum Bounces PrGoodMultiGoal);
        }
    }
    $table->Add([ values %$date2entry ]);
    $proj->bannerland_dbh->Do_SQL("CREATE INDEX Date ON ${DynPerf}TasksDirectSummaryTmp (`Date`, `Domain`, `OrderID`)");
    $proj->bannerland_dbh->Do_SQL("DROP TABLE IF EXISTS ${DynPerf}TasksDirectSummaryOld");
    $proj->bannerland_dbh->Do_SQL("RENAME TABLE ${DynPerf}TasksDirectSummary TO ${DynPerf}TasksDirectSummaryOld, ${DynPerf}TasksDirectSummaryTmp TO ${DynPerf}TasksDirectSummary");
}

sub update_dyn_tasks_summary :CRON {
    update_tasks_summary 0,@_;
}

sub update_perf_tasks_summary :CRON {
    update_tasks_summary 1,@_;
}

sub update_dyn_domains :CRON {
    my ($proj) = @_;

    $proj->bannerland_dbh->Do_SQL("drop table if exists DynDomainsTmp");
    $proj->bannerland_dbh->Do_SQL('
        CREATE TABLE `DynDomainsTmp` (
            `ID` int not null auto_increment,
            `Domain` varchar(200),
            PRIMARY KEY (`ID`)
        ) CHARSET=utf8 ;
    ');

    my $tasks = $proj->dyntask({})->get_all_tasks_from_yt_table();
    my $domains = { map{$_->{Resource}{Domain} => 1} @$tasks };

    $proj->log(scalar(keys %$domains) . " domains");
    $proj->dbtable("DynDomainsTmp", undef, "bannerland_dbh")->Add([ map{ { Domain => $_ } } keys %$domains ]);
    $proj->bannerland_dbh->Do_SQL("drop table if exists DynDomainsOld");
    $proj->bannerland_dbh->Do_SQL("rename table DynDomains to DynDomainsOld, DynDomainsTmp to DynDomains");
}

sub aggregate_dyn_tasks_monitor :CRON {
    my ($proj) = @_;
    Cmds::DynBanners::aggregate_dyn_tasks_monitor($proj, 1);
}

1;
