package Cmds::DataBases;

use utf8;

use base qw(Cmds::Base);
use Data::Dumper;

use Coro;

sub docs :CMDH {
    my ($proj, $vars) = @_;

    return {
        title => 'Документация на отрисовку таблиц через DBList (CMDH)',
        readonly => 1,
        default_field_params => { shlist => 1, showmacro => 'space2nbsp', },
        getlistflt => sub {
            my ($self, %prm) = @_;
            return [
                { param => 'base',  value => 'Взять все настройки от уже ранее описанной структуры. Это может быть любой описанный CMDH или CMDBS. Поля можно переопределить. Новые fields не перезапишут старый список, а будут добавлены к нему.', },
                { param => 'alter_field_titles => {}', value => 'Поменять заголовки полей у той таблицы, от которой наследуемся.', },
                { param => 'title', value => 'Заголовок страницы', },
                { param => 'toptext', value => 'Текст, отображаемый под заголовком', },
                { param => 'bottomtext', value => 'Текст, отображаемый под таблицей', },
                { param => 'table', value => 'Название таблицы', },
                { param => 'idfield', value => 'Главное поле элемента в базе. По нему выбираются элементы для редактирования.', },
                { param => 'dbhname', value => 'Брать таблицу не из текущей базы данных, а из указанной. Имена dbh прописаны в проджекте.', },
                { param => 'extdbhname', value => 'Брать название текущей базы данных из этого поля из form. Имена dbh прописаны в проджекте. Нужно для общих интерфейсов просмотра таблиц баз данных.', },
                { param => 'fix_sql_problem', value => 'Проверяет правильность таблицы. Если её нет - создаст, если есть неизвестные поля - добавит в таблицу.', },
                { param => 'readonly', value => 'Только на чтение. Убирает редактирование, добавление новых элементов и удаление.', },
                { param => 'disable_del', value => 'Отключить удаление строк.', },
                { param => 'disable_add', value => 'Отключить добавление новых строк.', },
                { param => 'inline_add', value => 'Форма добавления перед списком.', },
                { param => 'multi_add_by_field', value => 'Для добавления сразу нескольких элементов. По указанному полю разбивает его по разделителю и каждое из получившихся значений делает значением этого поля при вставке. Значения, возвращающие false, выкидываются.',
                     arrayparams => [
                         { param => 'field', value => 'Поле, где может быть множество значений.', },
                         { param => 'delim', value => 'Разделитель. Может быть регулярным выражением.', },
                     ],
                },
                { param => 'save_button', value => 'Настройка кнопки добавления.',
                     arrayparams => [
                         { param => 'title', value => 'Текст на кнопке.', },
                         { param => 'right', value => 'Отображать правее формы.', },
                     ],
                },
                { param => 'select_elems', value => 'Показывать колонку выбора элементов (checkbox для каждой строки). Идентификаторы строк - значения поля из idfield. Отмечаются только отображаемые элементы. Не поддерживает листалку.',
                     arrayparams => [
                         { param => 'binary', value => 'Показывать две колонки. Может быть полезно для бинарных операций.', },
                         { param => 'right', value => 'Отображать справа.', },
                     ],
                },
                { param => 'compact_inline_add', value => 'Форма добавления, спрятанная под плюсом.', },
                { param => 'compact_extlist_addform', value => 'Если форма добавления загружается через extlists, то отображать её спрятанной под плюсом.', },
                { param => 'onclick', value => 'что будет при клике на конкретный элемент: edit, inline_edit, inline_extlists, extlists, extlistsnewwnd', },
                { param => 'action_onlist', value => 'Модификация уже полученных элементов списка перед отрисовкой',
                },
                { param => 'action_onedit', value => 'Действие, которое будет выполнено после редактирования элемента (будет выполнено после записи в таблицу отредактированного элемента)',
                      textexample => 'action_onedit => sub { my ($proj, $id, $h) = @_; },',
                },
                { param => 'action_before_edit', value => 'Действие, которое будет выполнено перед редактированием элемента - можно менять сохранемый хэш',
                      textexample => 'action_onedit => sub { my ($proj, $id, $h) = @_; },',
                },
                { param => 'keep_edit_form_after_saving => 1/0', value => 'Оставаться в форме редактирования после сохранения.', },
                { param => 'redir_url_after_add_and_edit_actions', value => 'Урл, на который нужно редиректить после добавлений или редактирований', },
                { param => 'grpselection => 1/0', value => 'Выбор сразу нескольких полей для группировки.', },
                { param => 'fldselection => 1/0', value => 'Выбор отображаемых полей. Позволяет часть полей сделать невидимыми и указать для них fldslcthide - их отображение можно будет включить по необходимости. ', },
                { param => 'fields => []', value => 'Массив хэшей с описанием полей',
                     arrayparams => [
                         { param => 'name', value => 'Название поля в таблице', },
                         { param => 'title', value => 'Текстовый заголовок поля', },
                         { param => 'ftype', value => 'Тип поля. Например: select, checkbox и т.д.. Добавлен multiselect для множественного выбора. Если не указано - обычное текстовое поле.',
                             arrayparams => [
                                 { param => 'select', value => 'Последовательная "прокрутка" по клику значений из selectlist. Рекомендуется использовать для малого количества вариантов в selectlist (до 3). На большом количестве значений при быстром переключении иногда багает. Работает, если для поля задано inline => true', },
                                 { param => 'dropdown', value => 'Выпадающий список со значениями из selectlist. Рекомендуется использовать для большого количества вариантов в selectlist (больше 3). Работает, если для поля задано inline => true', },
                                 { param => 'radio', value => 'Список радио-кнопок со значениями из selectlist. Работает, если для поля задано inline => true', },
                                 { param => 'checkbox', value => 'Выбор бинарного значения.', },
                                 { param => 'multiselect', value => 'Выпадающий список значений со множественным выбором. Значения берутся из selectlist.', },
                                 { param => 'textarea', value => 'Текстовое поле.', },
                                 { param => 'bigtextarea', value => 'Большой текст.', },
                                 { param => 'curtime', value => 'Текущее время.', },
                                 { param => 'ajaxbtn', value => 'Рисует кнопку, при нажатии которой автоматически заполняется значение. Использует дополнительные параметры настройки. Нужно, чтобы исходя из уже заполненных полей дозаполнить оставшиеся.',
                                       arrayparams => [
                                           { param => 'cmd', value => 'название вызова', },
                                           { param => 'get_fields', value => 'список полей, которые нужно передавать для вызова из заполненных полей', },
                                           { param => 'result_field', value => 'поле, в которое нужно записать результат', },
                                           { param => 'fid', value => 'уникальный идентификатор кнопки', },
                                       ],
                                 },
                                 { param => 'file', value => 'Выбор файла.', },
                                 { param => 'view', value => 'Поле только для просмотра, нельзя редактировать.', },
                                 { param => 'hidden', value => 'Скрытое поле.', },
                             ],
                         },
                         { param => 'dbtype', value => 'Явно указываем тип поля в базе. Полезно в сочетании с fix_sql_problem.', },
                         { param => 'selectlist', value => 'Выбор вариантов для поля типа select. Вместо массива можно передать указатель на хэш { значение => текстовое_название } и указатель на функцию (на вход проето ($self)), возвращающую либо хэш, либо массив.',
                             textexample => "selectlist => [ { name => 'good',      value => '',   default => 1,  color => '#00FF00', }, { name => 'bad',       value => 'bad', color => '#cd261b', textcolor => '#FFFFFF', }, ],",
                             arrayparams => [
                                 { param => 'name', value => 'Название', },
                                 { param => 'value', value => 'Значение, сохраняемое в базу', },
                                 { param => 'default', value => 'Дефолтное значение', },
                                 { param => 'color', value => 'Цвет фона для инлайнового редактирования', },
                                 { param => 'rights', value => 'Отображать ли пункт в зависимости от прав', },
                                 { param => 'textcolor', value => 'Цвет текста для инлайнового редактирования', },
                             ],
                         },
                         { param => 'shlist', value => 'Нужно ли это поле показывать при отрисовке списка.', },
                         { param => 'fldslcthide', value => 'Не показывать поле, но его отображение можно включить. Имеет смысл при shlist => 0 и fldselection.', },
                         { param => 'edlist', value => 'Нужно ли это поле показывать при редактировании элемента.', },
                         { param => 'multigrp => []', value => 'Ссылка на массив полей того же стиля, что и fields. В получаемых данных значение поля с этим именем - не текст, а ссылка на массив хэшей, которые тоже нужно отрисовать таблицей. Используется, например, для отрисовки лога категоризации.', example => 'http://catmedia.yandex.ru/ind.pl?cmd=bannerstable', },
                         { param => 'grp => []', value => 'Ссылка на массив полей того же стиля, что и fields. Отрисовывает указанный список полей в этой колонке вертикально. Так отображаются, например, тексты баннеров.', example => 'http://catmedia.yandex.ru/ind.pl?cmd=bannerstable', },
                         { param => 'hide_empty_line', value => 'Имеет смысл для полей в grp. Не отрисовывать пустую строчку, если у поля нет значения.', },
                         { param => 'compact_grp', value => 'Имеет смысл для grp. Строки группы разворачиваются по клику. В свернутом виде отрисовывается поле из name.', },
                         { param => 'showmacro', value => 'Указываем макрос для отрисовки поля. Если для отрисовки макроса требуется больше одного поля, их можно явно указать { showmacro => "banners_categs_diff_result ID State" }.',
                             arrayparams => [
                                 { param => 'catname2link', value => 'По названию категории отрисовать ссылку на неё. Подхватывается язык из viewoptions.', },
                                 { param => 'catlist2links', value => 'Список категорий через слэш как список ссылок на категории. Подхватывается язык из viewoptions.', },
                                 { param => 'catid2caturl', value => 'По номеру категории отрисовать ссылку на неё.', },
                                 { param => 'categphrase', value => 'Отрисовать фразу категорий, экранирую угловые скобки.', },
                                 { param => 'categphrases', value => 'Отрисовать фразу категорий, экранирую угловые скобки. Добавляем пробелы после запятых, чтобы была возможность переноса строк.', },
                                 { param => 'exturl', value => 'Отрисовка внешнего урла. Скрывает реферрера при переходе.', },
                                 { param => 'showurlimage', value => 'Отрисовка урла картинки. Не скрывает реферрер.', },
                                 { param => 'italictext', value => 'Отображение текста курсивом.', },
                                 { param => 'bigcuttext', value => 'Обрезает длинный текст, добавляя ссылку на просмотр полной версии.', },
                                 { param => 'bigcuttext_withoutlink', value => 'Обрезает длинный текст, не добавляя ссылку на просмотр полной версии.', },
                                 { param => 'bscost', value => 'Отрисовка цены, указанной в милионных долях доллара (формат денег, принятый в БК).' },
                                 { param => 'space2nbsp', value => 'Вывод без переноса по пробелам.' },
                                 { param => 'comma2commaspace', value => 'Добавляет пробелы после запятых, чтобы работали переносы для длинных строк.' },
                                 { param => 'format_number', value => 'Отображение чисел с разделением тысяч и миллионов пробелами.' },
                             ],
                         },
                         { param => 'showsubel => sub', value => 'Вызывает функцию для каждого отображаемого элемента.',
                           textexample => 'showsubel => sub { my ($el, $f) = @_; return $proj->bf->lbanner( { map { $_ => $el->{$_} } qw{ title body phrases url } } )->get_categs_phrases_hlist },',
                         },
                         { param => 'showsubprojel => sub', 'При отрисовке поля для получения значения вызвать функцию. На вход ($proj, $el, $f), на выходе - то значение, которое должно быть отрисовани. Если сочетать с параметрами multi и multigrp, то можно возвращать массив хэшей для отрисовки вложенной таблички.',  },
                         { param => 'showmacroel', value => 'Указываем макрос для отрисовки поля. Макрос получает (el, f).',
                             arrayparams => [
                                 { param => 'show_btn_field', value => 'Отрисовать кнопку. По клику открывается новое окно. Урл берётся из поля geturl. Если geturl возвращает пустую строку - кнопка не отрисовывается. Если указано поле icon (например icon=>"search", iconfile=>"banners.gif"), то вместо кнопки рисуется соответствующая иконка. ',
                                     arrayparams => [
                                         { param => 'desc', value => 'Описание для кнопки, которое будет появляться при наведении.', },
                                         { param => 'samewindow', value => 'При клике открывать в том же окне.', },
                                     ],
                                 },
                                 { param => 'show_inline_btn_field', value => 'Отрисовать кнопку. По клику ничего не открывается. Если указать параметр hide_on_click, то при клике кнопка будет пропадать. ', },
                                 { param => 'show_url_field', value => 'Текст будет ссылаться на урл, описанный в geturl. ', },
                                 { param => 'show_list_inline_edit_field', value => 'Поле можно редактировать прямо в таблице. Если указана опция repeat_previous_btn, то появляется кнопка для повторной вставки последнего добавленного значения. Используется, например, на модерации, где большое количество однотипных вставок.', },
                                 { param => 'show_list_inline_readonly_field', value => 'Отрисовать поле типа select только на чтение. Выбирает цвет в зависимости от значение. Можно указать еще одно поле через "get_text_from_field", из которого будет взята подпись.', },
                                 { param => 'show_list_inline_select_field', value => 'Для полей типа select. Редактируется по клику прямо в таблице.', },
                             ],
                         },
                         { param => 'geturl', value => 'Указатель на функцию, возвращающую url. На вход ($el, $f), где $el - хэш элемента, $f - хэш настроек поля. Если ничего не возвращает, то ссылка не отображается. Имеет смысл для showmacroel=>"show_btn_field" и showmacroel=>"show_url_field"', },
                         { param => 'after', value => 'Переставить это поле после поля с указанным name. Позволяет поставить поле в определённое место при наследовании списков с помощью base.', },
                         { param => 'before', value => 'Переставить это поле перед полем с указанным name. Позволяет поставить поле в определённое место при наследовании списков с помощью base.', },
                         { param => 'redefine_base', value => 'Убирает из списка полей предка base поля с тем же name или extname', },
                         { param => 'delete_base', value => 'Убирает из списка полей предка base поля с тем же name или extname. Новый элемент не добавляет.', },
                         { param => 'update_base', value => 'Если у предка base есть поле с тем же name или extname, его параметры будут перезаписаны ',
                              textexample => 'fields => [ { name => "group", title => "Новое_название_поля", update_base => 1, } ]   # Меняем title поля с name="group", сохраняя все остальные его параметры', },
                         { param => 'width', value => 'Ширина поля в пикселях.', },
                         { param => 'align', value => 'left/center/right куда прижимать содержимое', },
                         { param => 'onchange_reload_extlists', value => 'Не работает. При изменении перезагружать подсписок. Пока работает только для show_list_inline_select_field.', },
                         { param => 'mass_change', value => 'Кнопка массового изменение для show_list_inline_select_field.', },
                         { param => 'addform', value => 'Если поле есть в form, то оно автоматически будет добавлено в фильтрацию для списка.', },
                         { param => 'forced_addform', value => 'Как addform, но сохраняет значение полей для отправки данных Add и Edit.', },
                         { param => 'inline', value => 'Инлайновое редактирование поля. Зависит от типа поля. Дефолтное - просто редактирование текста. Для select - аяксовая переключалка по клику.', },
                         { param => 'maxlength', value => 'Для inline edit ограничивает количество символов. Полезно для редактирования title или body баннера.', },
                         { param => 'autoedit => sub ($proj, $h)', value => 'При создании поля и редактировании значение вычисляется вызовом функции.', },
                         { param => 'disable_edit', value => 'Нередактируемое поле. Удобно сочетать с autoedit, если значения должны генерироваться только при создании. Например, логин создавшего или время создания.',
                               textexample => '{ name => "date",        shlist => 1, disable_edit => 1, autoedit => sub { $proj->dates->cur_date("db_time") }, showmacro => "space2nbsp", }' },
                         { param => 'disable_add', value => 'Поля нет в форме добавления. Это может быть, например, статус элемента, который не имеет смысла при добавлении нового объекта.', },
                         { param => 'extsql', value => 'Получение дополнительных данных с помощью указанного SQL. В результате выполнения должно быть поле, совпадающее по названию с idfield - по нему значения приклеются к текущим. Удобно использовать для подсчёта статистик. Можно джойнить по нескольким полям. Тогда в SQL в сравнении указываются несколько полей, а вместо поля записывается указатель на массив полей',
                               textexample => '{ extsql => ["select * from SetsBannersCategoriesTest where (SetID, BannerID) in (?)", ["SetID","BannerID"]], multi => "phlist", },',
                         },
                         { param => 'extname', value => 'Имя поля не из таблицы. Оно может быть получено, например, от какого-либо вызова extsql. Необязательно, чтобы extsql был в том же поле.', },
                         { param => 'multi', value => 'Ожидаем от extsql много значение - поле, в которое будет сохранён массив хэшей. Иначе - ожидается однозначное соответствие с переписыванием полей в текущие элементы списка. ',
                               textexample => '{ extsql => ["select * from SetsBannersCategoriesTest where (SetID, BannerID) in (?)", ["SetID","BannerID"]], multi => "phlist", },',
                         },
                         { param => 'show_campaign_inf', value => 'Название поля с номером кампании - по нему будет отрисована информация о кампании.', textexample => '{ show_campaign_inf => "campaign_id" }', },
                         { param => 'show_banner_inf', value => 'Название поля с номером баннера - по нему будет отрисована информация о кампании.', textexample => '{ show_banner_inf => "banner_id", },', },
                         { param => 'show_banner_current_categs', value => 'Текущая категоризация баннеров.', textexample => '{ show_banner_current_categs => "banner_id", },', },
                         { param => 'show_banner_saved_categs', value => 'Взять из поля уже сохраненную информацию о категоризации. Для сохранения информации в нужном формате $proj->serial( $bnrobj->get_categs_phrases_hlist ) ', textexample => ' { name => "ctgs_phs", shlist => 1, show_banner_saved_categs => "ctgs_phs", },', },
                         { param => 'manual_category', value => 'Редактируемое поле для указания категории, во время ввода выводит подсказку с названиями категорий.', },
                         { param => 'show_good_bad', value => 'Выбиралка good/bad. Добавляет необходимые параметры для выбора состояний good и bad. Можно явно указать названия для плохого и хорошего варианта через слэш  show_good_bad => "good/bad" или указателем на массив show_good_bad => [ "good", "bad" ] ', },
                         { param => 'show_good_bad_readonly', value => 'Выбиралка good/bad. Только на чтение. Можно изменить подписи, указав не 2, а 4 параметра show_good_bad_readonly => [ $good, $bad, $goodvl, $badvl ].', },
                         { param => 'extedit => 1/0', value => 'Дополнительные поля для редактирования. Спрятаны за дополнительный клик.', },
                         { param => 'exteditfld => sub', value => 'Внешняя функция редактирования поля. На вход ($self, $id, $key, $value). Вызывается и для Add, и для Edit. В случае Add значение id от только что добавленного элемента.', },
                         { param => 'inlinefilter => {}', value => 'Добавляем выбор сортировки и опционально группировки для поля. Все поля, кроме группируемого, прячутся. Полезно ещё посмотреть на опцию default_inlinefilter_params.',
                               arrayparams => [
                                   { param => 'group => 1/0', value => 'Включение возможности группировки по полю.', },
                                   { param => 'data_field_name', value => 'Название поля, по которому сортировка/группировка. Имеет смысл для полей с grp', },
                               ],
                         },
                         { param => 'onclick', value => 'Можно указать поведение по клику не только для строки, но и для конкретной ячейки.', },
                         { param => 'filter_html => 1/0', value => 'Отображать корректно фразы в угловых скобках и т.п. (Применяет к тексту поля FILTER html - <a href="http://www.template-toolkit.org/docs/manual/Filters.html#section_html">http://www.template-toolkit.org/docs/manual/Filters.html#section_html</a>)', },
                         { param => 'decorator => sub', value => '($el, $f) Возвращает хэш настроек стилей отображения ячейки.',
                               arrayparams => [
                                   { param => 'background', value => 'Цвет фона ячейки.', },
                               ],
                         },
                         { param => 'editformsearchurl', value => 'Отображение лупы страва от поля добавления или редактирования. По клику на неё текущее значение доклеивается к указанному урлу и этот урл открывается в новом окне.', },
                         { param => 'if_grpd = {}', value => 'Хэш параметров, которые будут дописаны к полю, если в viewdblistoptsstr включена группировка по этому полю.', },
                     ],
                },
                { param => 'default_field_params', value => 'Хэш дефолтных настроек, которые будут применены ко всем полям в fields. Если у поля указано своё значение, то оно перезаписано не будет. Например, удобно указать свойство { shlist => 1, }, чтобы все поля сразу отображались. ', },
                { param => 'default_inlinefilter_params => {}', value => 'Дополнительные настройки для inlinefilter.',
                      arrayparams => [
                          { param => 'group_by_add_fields => []', value => 'Добавляет дополнительные данные для группировок', },
                          { param => 'fields => []', value => 'Добавляет дополнительные поля для группировок', },
                      ],
                },
                { param => 'stat_fields => []', value => 'Список полей статистики, которые автоматически будут добавлены в fields с правильным форматированием. Это может быть массив как строк, так и хэшей. Строки рассматриваются и форматируются как поля типа int. Если строки называются Shows, Clicks или Cost, то для них автоматически приписываются соответствующие роли и добавляются производные поля от их сочетания. Поля правильно обрабатываются при группировках. ',
                      arrayparams => [
                          { param => 'title', value => 'Заголовок поля', },
                          { param => 'name',  value => 'Название', },
                          { param => 'align', value => 'К какому краю прижимать.', },
                          { param => 'showmacro', value => 'Макрос отображения.',
                              arrayparams => [
                                  { param => 'format_number', value => 'Для полей типа int.', },
                                  { param => 'format_number_2', value => 'Для чисес с точностью до 2 знака после запятой.', },
                                  { param => 'bscost', value => 'Для денег в формате БК ($1 = 1 000 000).', },
                              ],
                          },
                          { param => 'stattype', value => 'Роль поля. Из очевидных Shows, Clicks, Cost, CTR, CPM, CPC. Если описаны поля соответствующих ролей, то автоматически добавляются производные от них (CTR, CPM, CPC). При этом производные поля будут правильно считаться при группировках.', },
                          { param => 'stgrptype', value => 'Нужно, если поле - сложное выражение. Например, для CTR это будет stgrptype => "#Clicks#/#Shows#*100". В ## указываются типы полей (stattype). И для группировок это будут суммы, а для обычных выборок - просто значения полей.', },
                      ],
                      textexample => 'stat_fields => [qw{ Shows Clicks Cost }, { name => "MyCPM", stgrptype => "#Cost#/#Shows#*1000", }],',
                },
                { param => 'norm_params => {}', value => 'Хэш параметров для нормировки данных',
                    arrayparams => [
                        { param => 'add_norm_filter => {}',  value => '', },
                        { param => 'norm_keys => []',  value => '', },
                        { param => 'norm_fields => []',  value => '', },
                        { param => 'default_field_params => {}',  value => '', },
                    ],
                    textexample => 'norm_params => { add_norm_filter => { SourceID => 1 },  norm_keys => [qw( SourceID TypeID SlotID EventsDate )],  norm_fields => [ qw( Shows Clicks Cost )],  default_field_params => { unit => "percent", }, }, ',
                },
                { param => 'txtfields', value => 'Можно указать просто список названий полей через пробел, если их все предполагается отрисовывать одинаково. Например: "host role group ip test resources desc".', },
                { param => 'hide_fields_titles => 1/0', value => 'Спрятать заголовки столбцов.', },
                { param => 'getlist => sub', value => 'Альтернатива указыванию таблицы table. Значение - указатель на функцию. На вход она получает ($self, %prm). %prm - настройки фильтрации для dbtable. На выходе ожидается массив хэшей для отрисовки.', },
                { param => 'getlistflt => sub', value => 'Работает как и getlist, по позволяет накладывать листалки и фильтрации поверх получаемого списка. Реализованы не все возможности фильтрации.', },
                { param => 'cache_getlistflt => {}', value => 'Кэширует данные от getlistflt в базе данных. И все запросы на отрисовку идут к таблице. При использовании этого параметра важно прописывать все dbtype в fields, чтобы поля в кэш-таблице были того же типа и правильно отрабатывал order_by и другие команды.',
                    arrayparams => [
                        { param => 'cache_time',  value => 'На сколько времени кэшировать (в минутах). Если не задано, то кэширует на 10 минут.', },
                    ],
                },
                { param => 'editlistelem => sub', value => 'Редактирование элемента, если не указан table. На вход получает ($proj, $id, $hchanges). Нужно для выдачи getlist, если нужно реализовать ещё и редактирование. Требует ещё и описания getlistelem, чтобы отрисовать форму редактирования. Необходимо указать idfield, так как нужен идентификатор поля, по которому отбирается элемент.', },
                { param => 'addlistelem => sub', value => 'Добавление элемента, если не указан table. На вход получает ($proj, $id, $hadd). Нужно для выдачи getlist, если нужно реализовать ещё и добавление.', },
                { param => 'getlistelem => sub', value => 'Получение элемента, если не указан table. На вход получает ($proj, $id). Нужно для выдачи getlist, если нужно реализовать ещё и редактирование. Используется для отрисовки формы для редактирования.', },
                { param => 'Moderate => {}', value => 'Переопределяет операции редактирования, добавления, удаления и т.д..',
                     arrayparams => [
                         { param => 'Add',  value => '($self, $id, $h) Добавление нового элемента.', },
                         { param => 'Edit', value => '($self, $id, $h) Редактирование элемента.', },
                         { param => 'Get',  value => '($self, $id) Получение конкретного элемента.', },
                         { param => 'Del',  value => '($self, $id) Удаление элемента.', },
                         { param => 'List', value => '($self, $list, $prms) Изменение полученного списка.', },
                     ],
                },
                { param => 'grfield', value => 'Не влияет на отбор, а только на отрисовку. Собирает поля с одинаковыми значениями указанных полей в группы. Наприме: "project group".', example => 'http://catmedia.yandex.ru/ind.pl?cmd=hosts', },
                { param => 'grfield_reverse', value => 'Поменять порядок на обратный для опции grfield', },
                { param => 'grfieldreport', value => 'Для выводимых на странице элементов выводит ссылки для быстрого перехода вверху страницы.', },
                { param => 'search', value => 'Добавляет поле аяксового поиска элементов.',
                     arrayparams => [
                         { param => 'fields', value => 'Указатель на массив названий полей, по которым искать.', },
                         { param => 'name', value => 'Название параметра урла, в котором будет передаваться поисковый запрос.', },
                         { param => 'like', value => 'Искать по включению, а не по точному соответствию.', },
                         { param => 'extsearch => {}', value => 'Вывести ещё и результат поиска по другому CMD.',
                               arrayparams => [
                                   { param => 'cmd', value => 'Название cmd, к которому нужно обращаться.', },
                                   { param => 'params', value => 'Хэш соответствия полей form и названий полей дочернего cmd, в которые нужно перенести значения.', },
                               ],
                         },
                     ],
                },
                { param => 'fld_orders', value => 'Нужен для добавления возможности изменения порядка полей. Добавляется специальный фильтр с помощью filters, который отвечает за изменения порядка отображения полей.',
                    arrayparams => [
                        { param => 'title', value => 'Название фильтра, который будет отвечать за изменение порядка полей' },
                        { param => 'orders', value => "Список возможных порядков полей. Пример orders => [ { name => 'usual', title => 'Обычный', order => undef}, { name => 'Compact', title => 'Компактный', order => [ qw /SetID IDs Phrase/ ] }]",
                            arrayparams => [
                                { param => 'name', value => 'Значение, которое будет пробрасываться через url' },
                                { param => 'title', value => 'Значение, которое будет видеть пользователь в фильтре' },
                                { param => 'order', value => 'Порядок полей, которые хотим отображать. Нужно указывать name поля или extname'}
                            ]
                        }
                    ]
                },
                { param => 'filters => []', value => 'Массив фильтров. Добавляет фильтры выбора над списком.',
                     textexample => '{ field => "UserState", grp=>1, name => "Статус", use_other_filters => 1, },',
                     arrayparams => [
                         { param => 'title', value => 'Заголовок фильтра.', },
                         { param => 'name', value => 'То же, что и title. Устарело, не рекомендуется использовать', },
                         { param => 'field', value => 'Название поля в таблице.', },
                         { param => 'extfilter => sub($proj, $text)', value => 'Внешний фильтр. Функция должна возвращать указатель на хэш ограничений для фильтрации.', },
                         { param => 'like', value => '1/0 ', },   # TODO
                         { param => 'grp', value => '1/0 Выводит выпадающий список текущих значений с частотами. Если поле типа select уже описано в fields, то будут отрисованы не значения, а названия.', },
                         { param => 'textfield', value => 'Для grp. Брать текст для отрисовки из другого поля. Может быть полезно, если текст для группировочного поля слишком длинное или содержит произвольные символы.', },
                         { param => 'textmacro => sub', value => 'Для grp. Макрос для отрисовки названия. ($proj, $val)', },
                         { param => 'order_by_count', value => '1/0 Если фильтр grp, то сортировать не по названию, а по количеству элементов.', },
                         { param => 'multi', value => '1/0 Выводит multiselect-список. Отображает названия и частоты аналогично типу grp.', },
                         { param => 'list', value => '1/0 Позволяет указывать несколько вариантов через запятую. Поиск идёт только по точному совпадению.', },
                         { param => 'use_other_filters', value => 'Влияют ли текущие выбранные фильтры на значения для пунктов grp.', },
                         { param => 'extgrp', value => 'SUB Альтернативный список для выбора. Указатель на функцию, возвращающую список хэшей вида { myfield => $_, cc => "122" } - пункты выбора.', },
                         { param => 'selectnames&nbsp;=>&nbsp;{}', value => 'Имеет смысл только с grp. Для части значений можно дать другое название. Это будет полезно, например, если пустое значение поля должно иметь название. Можно указать только те значения, которые нужно переименовать.', },
                         { param => 'type', value => 'Нужно для специальных типов полей',
                             arrayparams => [
                                 { param => 'date',    value => 'Фильтрация датой.', },
                                 { param => 'date2',   value => 'Фильтрация диапазоном дат.', },
                                 { param => 'tabs',    value => 'Выводит фильтр в виде табов.', },
                                 { param => 'hidden',  value => 'Скрытый фильтр. Нужен, чтобы можно было настроить внешнюю фильтрации через параметры урла без вывода этого фильтра в интерфейсе.', },
                             ],
                         },
                         { param => 'top_tabs',     value => '1/0 Для фильтра в виде табов: отображать этот фильтр над остальными фильтрами', },
                         { param => 'cmdslc => {}', value => 'Переключалка CMDS. Другие параметры можно не указывать. Значение - хэш соответствия названий и значений cmd.', textexample => q"{ cmdslc => { 'Лог 1' => 'red_button_log_lll', 'Лог 2' => 'red_button_log_lll_2', }, },", },
                         { param => 'disable_deselect', value => 'Для grp не выводить вариант отключения фильтра. Имеет смысл, если ещё указывается дефолтное значение фильтра.', },
                         { param => 'width', value => 'Задаёт ширину поля в пикселях. Работает не для всех типов фильтров, а только для поля ввода.', },
                         { param => 'hide_count', value => 'Для фильтра типа grp или multi - не выводить количества элементов.', },
                         { param => 'multiselect_include_select_all', value => '1/0 Для фильтра типа multi - выводить пункт "Select all"', },
                         { param => 'ignore_boundary_spaces', value => '1/0 Пробелы и другие разделители в начале и конце строки для поиска не будут учитываться', },
                         { param => 'typeahead => sub',   value => 'Функция поиска при наборе значения поля фильтрации',
                            textexample => ' typeahead => sub { my ($proj, $text, $tinf) = @_;  return [ map { "$_".$text } ( 11111, 1111111111111, 22222222, 22222, 33333) ]; } ',
                         },
                     ],
                },
                { param => 'default_filter => {}', value => 'Фильтр по умолчанию. Для диапазонных полей ключи должны начинаться с from_имяполя и to_имяполя.', },
                { param => 'add_filter => {}', value => 'Принудительные фильтры', },
                { param => 'joinedfilter => 1/0', value => 'Фильтры будут объединены в единую форму.', },
		{ param => 'extlists => []', value => 'Внешние вложенные списки, подгружаемые аяксом по требованию.',
                     arrayparams => [
                         { param => 'cmd', value => 'Параметр cmd для вызова. Это тоже должен быть DBList.', },
                         { param => 'using', value => 'Параметр в запросе в который будет вставлено значение из idfield.', },
                         { param => 'title', value => 'Название подключаемого источника для отображения в списке.', },
                         { param => 'addparams', value => 'Хэш дополнительных параметров, которые нужно вставить в урл запроса при получении данных. Например:  addparams => { myfilterparam => "good" }', },
                         { param => 'addelemparams', value => 'Хэш дополнительных параметров, которые нужно вставить в урл запроса при получении данных. Значение берётся из текущего элемента. Например:  addelemparams => { "Domain" => "Domain" }', },
                         { param => 'addfilterparams', value => 'Хэш дополнительных параметров, которые нужно вставить в урл запроса при получении данных. Значение берётся из фильтров. Например:  addfilterparams => { "ExtParam" => "FilterName" }', },
                         { param => 'openned', value => 'Сразу открываются раскрытыми. Аяксовые вызовы подсписков отправляются сразу после отрисовки основного списка.', },
                         { param => 'edit_openned', value => 'Отображать подсписок при заходе в редактирование элемента.', },
                     ],
                },
                { param => 'extlists_count_field', value => 'Поле, в котором хранится количество элементов подсписка. Если указано, то не рисует раскрытие списка при нулевом значении.', },
                { param => 'pager', value => 'Листалка списка. ',
                     textexample => '{ name => "p", cc => 1000, }',
                     arrayparams => [
                         { param => 'name', value => 'Название параметра урла, в котором будет передаваться номер страницы.', },
                         { param => 'cc', value => 'Количество элементов на странице.', },
                     ],
                },
                { param => 'fixed_header => 1/0', value => 'Закреплять ли заголовок таблицы при прокручивании страницы или нет', },
                { param => 'topmenu => []', value => 'Меню над списком.',
                     arrayparams => [
                         { param => 'title', value => 'Заголовок пункта.', },
                         { param => 'url',   value => 'Урл, по которому будет переход. Если указан addformparams, то часть параметров будут взяты из урла.', },
                         { param => 'addformparams,', value => 'Берёт данные из запроса и дописывает в урл. Имеет смысл только с url.', },
                         { param => 'name', value => 'Название действия.', },
                         { param => 'action => sub', value => 'Ссылка на функцию действия. На вход приходит ($self, $lst1, $lst2, $prmsh). $lst1 и $lst2 - списки выбранных элементов. Пока для меню не подхватываются. $prmsh - список дополнительных настроек (наример, выбранный файл, если указан параметр filefield)', },
                         { param => 'filefield', value => 'Название поля файла. При клике на пункт перед выполнением действия будет предложено выбрать файл. Выбранный файл в функиии action можно будет получить через $prmsh.', },
                         { param => 'redir_action => sub', value => 'После выполнения действия возвращается ссылка, куда нужно редиректить.'},
                         { param => 'confirm', value => 'Текст подтверждения перед выполнением действия.'},
                         { param => 'sublist => []', value => 'Подменю со списком пунктов того же формата.'},
                     ],
                },
                { param => 'edittopmenu => []', value => 'Меню для редактирования элемента. Описание как для topmenu.', },
                { param => 'bottom_buttons => []', value => 'Список кнопок, которые нужно показывать под списком. ',
                     arrayparams => [
                         { param => 'title', value => 'Название кнопки.', },
                         { param => 'url', value => 'Путь, куда переходить по клику.', },
                         { param => 'inline', value => '1/0 Отображать содержимое заданного url на текущей странице. В url полезно использовать act=AjaxSearch.',
                            textexample =>  'inline => 1,  url => "?cmd=bmtasks_cmp_snorm_phrs_info&act=AjaxSearch&flt_BMTasks_ID=$id&flt_task_id=$task_id", '
                         },
                         { param => 'addformparams', value => 'Добавляет параметры из form в вызов. Хэш соответствия параметров.', },
                     ],
                },
                { param => 'data_import_export => {}', value => 'Подключение пакетной загрузки и выгрузки данных (TXT и XLS).',
                      arrayparams => [
                         { param => 'list => []', value => 'Список полей, которые должны загружаться и выгружаться.', },
                         { param => 'no_import', value => '1/0   Загрузка данных недоступна', },
                         { param => 'export => {}', value => 'Настройки для выгрузки',
                            arrayparams => [
                                { param => 'file_name', value => 'Имя файла для выгрузки', },
                                { param => 'headers', value => '1/0   Добавить в выгружаемый файл заголовки столбцов', },
                                { param => 'sort', value => 'Поле сортировки для выгрузки.', },
                                { param => 'use_grp', value => '1/0   Использовать группировку', },
                                { param => 'filtered', value => '1/0   Использовать выбранные фильтры', },
                                { param => 'readable_CategPhrases => []', value => 'Преобразовать поле, содержащее фразы категорий ( массив хешей, содержащих поля category и phrase ) из json в формат "фраза1"=>"категория1" / "фраза2"=>"категория2"', },
                                { param => 'readable_tagging_mode', value => '1/0   Поле Mode в том же виде, что и на странице разметки (\'Правильная разметка\', \'Нет категории\', т.д.), иначе - так же, как в базе, со служебными значениями (\'good\',\'uncat\', т.д.)', },
                                { param => 'lang_for_categs', value => '1/0   Переводить ли название категорий на язык сета. Если lang_for_categs = 0, категории написаны на русском языке; если lang_for_categs = 1, категории написаны на языке сета', },
                                { param => 'split_banner_data_field', value => '1/0   Разбить поле Data, содержащее body, title, phrases, url, на эти отдельные столбцы'  },
                                { param => 'readable_checked_state' , value => '1/0   Для интерфейса диффа: преобразовать поля базы в читаемый формат'},
                                { param => 'readable_diff_categs', value => '1/0   Для интерфейса диффа: преобразовать названия старой и новой категории в читаемый формат, если они хранятся в виде массива хешей' },
                            ],
                         },
                         { param => 'no_menu', value => '1/0   Не добавлять на страницу меню "Файлы"', },
                     ],
                },
                { param => 'bottom_actions => []', value => 'Список действий, которые можно выполнять с выбранными элементами списка. В функцию передаются две строки выбранных элементов, хэш значений дополнительных полей и хэш текущих значений фильтров.',
                     textexample => '
                         bottom_actions => [
                             { title => "Послать письмом", name => "sendemail", action => sub {
                                     my ($self, $lst1, $lst2, $prmsh, $fltrs, $ellist) = @_;
                                 },
                                 fields => [
                                     { name => "Name", title => "Name", edlist => 1 },
                                     { name => "BannersCount", title => "Count", edlist => 1, disable_edit => 1 },
                                 ],
                             },
                         ],',
                     arrayparams => [
                         { param => 'title', value => 'Название кнопки.', },
                         { param => 'name', value => 'Имя действия.', },
                         { param => 'disabled => 1/0', value => 'Если не 0, то кнопка будет disabled.', },
                         { param => 'disabled_comment => text', value => 'Если кнопка disabled, то рядом с ней будет выведен комментарий, указанный в параметре disabled_comment.', },
                         { param => 'action => sub', value => 'Указатель на функию, получающую ($self, $lst1_выбранный_список, $lst2_вторая_колонка_выбора, $prmsh_хэш_дополнительных_параметров).', },
                         { param => 'redir_action => sub', value => 'Указатель на функию. Должна возвращать урл для редиректа.', },
                         { param => 'fields', value => 'Поля в том же формате, что и для добавления элементов в список. Будут отрисованы рядом с кнопкой, если для действия нужны дополнительные параметры.', },
                         { param => 'inline', value => 'Выполнить действие локально, перегрузив только текущий список аяксом.', },
                         { param => 'open_in_new_tab', value => 'Выполнить действие с открытием в новом табе.', },
                         { param => 'confirm', value => 'Текст подтверждения в случае нажатия. Нельзя использовать одинарные кавычки. Если нужно - только двойные.', },
                         { param => 'ellist => 1/0',  value => 'Нужно ли заполнять ellist. ellist - массив хэшей полного списка элементов с учётом фильтрации, но без листалки. ', },
                         { param => 'ellist_limit',  value => 'Ограничение на количество элементов ellist.', },
                         { param => 'ellist_order_by',  value => 'Сортировка для элементов ellist. Имеет смысл с ellist_limit.', },
                         { param => 'xls',  value => 'На выходе массив массивов (не массив хэшей!!!), который нужно вернуть в формате XLS. Из массива хэшей можно преобразовать так: return [ map { [ @{$_}{ qw{ banner_id title body domain phrase modflag state rsn } } ] } @$ellist ]; ', },
                         { param => 'message_text => text', value => 'После нажатия кнопки, перед выполнением действия, будет выведено сообщение, заданное в параметре message_text', },
                         { param => 'addformparams', value => 'Добавляет параметры из form в вызов. Хэш соответствия параметров.', },
                         #{ param => 'message_type', value => 'Если значение - "error", то выводится сообщение, описанное в message_text, но действие не выполняется.', },   # TODO  To be refactored?
                     ],
                },
                { param => 'bottom_views => []', value => 'Вывести дополнительную информацию под списком: будут выведены div, в которые будут загружены заданные url.',
                     textexample => 'bottom_views => [ { url => "?cmd=lemmer_fix_view&act=AjaxSearch", },   { url => "?cmd=docs" },  ]',
                     arrayparams => [
                         { param => 'url', value => 'Путь для отображения', },
                         { param => 'click_to_load', value => 'Загружать только по клику', },
                     ],
                },
                { param => 'top_views => []', value => 'Аналогично bottom_views, но дополнительные div будут выведены сразу после заголовка страницы',
                },
                { param => 'checkform', value => 'Предупреждения и проверки при добавлении и редактировании элементов.',
                     arrayparams => [
                         { param => 'action => sub', value => 'Функция проверки правильности заполнения формы перед отправкой. На вход ($self, $h), где $h - данные формы; возвращает строку.  Если функция вернула непустую строку, то пользователю будет показано сообщение.  Если эта строка начинается с "confirm " (например, "confirm &nbsp;  Are you sure?"), то пользователю будет показано предупреждение с возможностью продолжить или отклонить отправку формы (текст подтверждения &mdash; часть строки после "confirm ").  В остальных случаях, если строка не пуста, будет выведено сообщение и форма не будет отправлена.  Для разрешения отправки формы нужно вернуть пустую строку.', },
                     ],
                },
                { param => 'order_by', value => 'Сортировка элементов.',
                     textexample => 'order_by => "-sbcount",',
                },
                { param => 'group_by', value => 'Группировка элементов.',
                     textexample => 'group_by => "snorm_phr",',
                },
                { param => 'group_by_count_field', value => 'Если есть group_by, то под этим именем добавить count(*).',
                     textexample => 'group_by_count_field => "cc",',
                },
                { param => 'group_by_add_fields => []', value => 'Если есть group_by. Можно добавить дополнительные группировочные поля.',
                     textexample => 'group_by_add_fields => ["count(distinct catgrp) cc"],',
                },
                { param => 'complicated_add_fields => []', value => 'Если нет group_by. Можно добавить дополнительные составные поля.',
                     textexample => 'group_by_add_fields => ["IF( Shows > 1000, 1, 0) camp_size"],',
                },
                { param => 'logchanges', value => '1/0 Включить логирование изменений в другую таблицу. Если таблицы для лога нет, при fix_sql_problem она будет создана. И добавление полей в родительскую таблицу будет отражаться и в таблице логов.', },
                { param => 'showid', value => 'Отображать ли idfield в списке.', },
                { param => 'NN', value => 'Отображать ли номера строк в списке.', },
                { param => 'empty_result_text', value => 'Писать указанный текст, когда отображаемый список пустой.', },
                { param => 'transmit_url_params => []', value => 'Список параметров, которые будут прокинуты в url. При отладке может быть полезно использовать    transmit_url_params => [qw( debug sqldebug )]', },
                { param => 'create_on_view_if_not_exists', value => 'Создавать элемент при первом обращение на просмотр, если его не было.', },
                { param => 'create_on_edit_if_not_exists', value => 'Создавать элемент при первом обращение на редактировании, если его не было.', },
                { param => 'charts', value => 'Хэш параметров для отрисовки графиков. Если данные получены из getlistflt и возникают проблемы при отображении графиков, можно использовать кэширование (например,  cache_getlistflt => { cache_time => 1 } )',
                    arrayparams => [
                        { param => 'date_field', value => 'Название поля. Для всех графиков по оси X будут данные из этого поля. Формат данных - дата YYYY-MM-DD. Если нужно отображать время с большей точностью, можно указать флаг precise_date_axis', },
                        { param => 'split_field', value => 'Название поля, по которому будут разбиты данные на графиках.', },
                        { param => 'default_filter', value => 'Фильтр по умолчанию.', },
                        { param => 'default_chart_params', value => 'Хэш дефолтных настроек, которые будут применены ко всем графикам. Если у графика указано своё значение, то оно перезаписано не будет. Например,             default_chart_params => { selectlist => \%sourcesById, legend => 1, chartdiv_style => \'height: 400px;\', }.', },
                        { param => 'list', value => 'Массив хэшей с параметрами графиков.',
                            arrayparams => [
                                { param => 'title', value => 'Заголовок', },
                                { param => 'dtvalue', value => 'Поле, из которого берутся данные', },
                                { param => 'precise_date_axis', value => 'Отображать время по оси X с точностью до секунды', },
                                { param => 'getlist => sub', value => 'Возвращает альтернативный массив хэшей, по которому будет отрисовываться график. На вход ($proj).', },
                                { param => 'js_settings', value => 'Текстовая строка настроек js отрисовки графика. Документация на <a href="http://amcharts.com" target=_blank>amcharts.com</a>',
                                      textexample => '
                                            "categoryAxis": {
                                                "labelRotation": -90,
                                            },
                                            "type": "xy",
                                            "categoryField": "Shows",
                                            "valueAxes": [
                                                {
                                                    "position": "left",
                                                    "autoGridCount": true,
                                                },
                                                {
                                                    "position": "bottom",
                                                    "autoGridCount": true,
                                                },
                                            ],
                                            "graphs": [{
                                                "type": "line",
                                                "valueField": "Cost",
                                                "xField": "Shows",
                                                "yField": "Cost",
                                            } ],
                                      ',
                                },
                                { param => 'settings', value => 'Настройки отрисовки графика в виде перловой структуры. Опции те же, что и в js.', },
                                { param => 'chartdiv_style', value => 'Настройки стиля для графика в формате параметра style в HTML. Например, chartdiv_style => "height: 400px; width: 600px;"', },
                                { param => 'legend => 1/0', value => 'Отображать легенду около графиков.', },
                                { param => 'selectlist', value => 'Хэш { значение => текстовое_название }. Задает названия графиков в легенде. Полезно в сочетании с split_field и legend => 1. ', },
                                { param => 'type', value => 'Уже описанный формат графиков. Есть simple_line и multilines.', },
                                #{ param => 'type', value => 'Уже описанный формат графиков. Есть simple_line и multilines. Для multilines можно указать flist=>[] со списком полей, которые нужно отобразить на графике.', },
                                { param => 'flist', value => 'Если есть multilines. Список полей, которые нужно отобразить на графике.',
                                    arrayparams => [
                                        { param => 'name', value => 'Имя поля.', },
                                        { param => 'value', value => 'Название поля в таблице.', },
                                        { param => 'axis_format', value => 'Если есть axes. suffix - отображать на оси значений числа в суффиксной записи (10000 -> 10K), scientific - в научной нотации (10000 -> 1e5)', },
                                        #{ param => '', value => '.', },
                                    ],
                                },
                                { param => 'axes', value => 'Используется вместе с multilines. Для каждого графика использовать свою ось значений.', },
                                { param => 'text_html', value => '', },
                                { param => 'optimize_data_for_amcharts', value => '', },
                                #{ param => '', value => '.', },
                            ],
                        },
                    ],
                },

            ];
        },
        fields => [
            { name => 'param', title => 'Настройка', inlinefilter => {}, },
            { title => 'Значение', grp => [
                { name => 'value', },
                { name => 'textexample', hide_empty_line => 1, },
                { name => 'arrayparams', hide_empty_line => 1, multigrp => [
                      { name => 'param', title => 'Настройка', },
                      { title => 'Значение', grp => [
                          { name => 'value', },
                          { name => 'textexample', hide_empty_line => 1, },
                          { name => 'arrayparams', hide_empty_line => 1, multigrp => [
                                { name => 'param', title => 'Настройка', },
                                { title => 'Значение', grp => [
                                    { name => 'value', },
                                    { name => 'textexample', hide_empty_line => 1, },
                                    { name => 'example', title => 'Пример', hide_empty_line => 1, showmacro => 'exturl', },
                                    { name => 'arrayparams', hide_empty_line => 1, multigrp => [
                                          { name => 'param', title => 'Настройка', },
                                          { title => 'Значение', grp => [
                                              { name => 'value', },
                                              { name => 'textexample', hide_empty_line => 1, },
                                              { name => 'example', title => 'Пример', hide_empty_line => 1, showmacro => 'exturl', },
                                          ]},
                                    ]},
                                ]},
                          ]},
                          { name => 'example', title => 'Пример', hide_empty_line => 1, showmacro => 'exturl', }
                      ]},
                ]},
                { name => 'example', title => 'Пример', hide_empty_line => 1, showmacro => 'exturl', }
            ]},
        ],
        filters => [
            { field => 'param', title => 'Настройка', like => 1, },
        ],
        #search => { fields => ['param'], name => 'text', like => 1, },
    };
}

sub envs :CMDH {
    return {
        title => '%ENVS',
        readonly => 1,
        txtfields => 'param value',
        default_field_params => { shlist => 1, },
        getlist => sub {
            return [ map {{ param => $_, value => $ENV{$_} }} keys %ENV ];
        },
    };
}

sub host_role :CMD {
    my ($proj, $vars) = @_;
    $vars->{text} = $proj->host_role;
}

sub showtabledesc :CMD {
    my ($proj, $vars) = @_;

    my $txt = 'Field    | Type    | Null | Key | Default | Extra';
    $txt =~ s/\|//g;

    my $table = $proj->form->{'table'} || $proj->form->{'Name'};

    $vars->{tinf} = {
        title => 'Информация по таблице '.$table,
        readonly => 1,
        txtfields => $txt,
        extdbhname => 'dbhname',
        getlist => sub {
            my ($self, %prm) = @_;
            my $lst = $self->dbt->List_SQL('DESC '.$table);
            return $lst;
        },
        default_field_params => { shlist => 1, showmacro => 'space2nbsp', },
    };

    $proj->dblist({ vars => $vars })->make;
}

sub showtablekeys :CMD {
    my ($proj, $vars) = @_;

    my $txt = 'Table    | Non_unique | Key_name | Seq_in_index | Column_name | Collation | Cardinality | Sub_part | Packed | Null | Index_type | Comment | Index_comment';
    $txt =~ s/\|//g;

    my $table = $proj->form->{'table'};

    $vars->{tinf} = {
        title => 'Информация по ключам таблицы '.$table,
        readonly => 1,
        extdbhname => 'dbhname',
        txtfields => $txt,
        getlist => sub {
            my ($self, %prm) = @_;
            my $lst = $self->dbt->List_SQL('show keys from '.$table);
            return $lst;
        },
        default_field_params => { shlist => 1, showmacro => 'space2nbsp', },
    };

    $proj->dblist({ vars => $vars })->make;
}

sub showtableelems :CMDH {
    my ($proj, $vars) = @_;

    my $table = $proj->form->{'table'};
    $vars->{tinf} = {
        base  => 'table',
        title => 'Содержимое таблицы '.$table,
        table => $table,
        default_filtersoptions => '&table='.$table,
    };
}

sub showprocesslist :CMD {
    my ($proj, $vars) = @_;

    my $txt = '| Id    | User     | Host                         | db   | Command     | Time  | State                                                                 | Info                                                    | Rows_sent | Rows_examined | Rows_read ';
    $txt =~ s/\|//g;

    my $table = $proj->form->{'table'} || $proj->form->{'Name'};

    $vars->{tinf} = {
        title => 'Список процессов',
        readonly => 1,
        txtfields => $txt,
        extdbhname => 'dbhname',
        getlist => sub {
            my ($self, %prm) = @_;
            my $lst = $self->dbt->List_SQL('show processlist');
            return $lst;
        },
        default_field_params => { shlist => 1, wshowmacro => 'space2nbsp', },
    };

    $proj->dblist({ vars => $vars })->make;
}

sub noauth_sleep :CMD {
    my ($proj, $vars) = @_;

    my $form = $proj->form;
    my $timeout = $form->{sleep} // 10;

    sleep($timeout);

    $vars->{text} = "sleep:".$timeout;
}

sub sleep :CMD {
    my ($proj, $vars) = @_;

    my $form = $proj->form;
    my $timeout = $form->{sleep} // 10;

    sleep($timeout);

    $vars->{text} = "sleep:".$timeout;
}

1;
