package Cmds::Dicts;

use utf8;

use base qw(Cmds::Base);
use Data::Dumper;


sub testdictsdirs : CMDH {
    my ($proj, $vars) = @_;

    return {
        base => 'dirs',    
        title => 'Словари для контекстов',
        table => 'TestDictsDirs',
        #fields => [ { name => 'URL', edlist => 1, } ],
        fields => [
            { name => 'ccc', extname => 'ccc', title => 'DDD', table => 'TestDicts', using => 'ParentID', value => 'count(*)',
              edlist => 0, },
        ],
        extlists => [
            { cmd => 'testdicts', using => 'ParentID', title => 'Dicts' },
        ],        
    };
}

sub testdicts : CMDH {
    my ($proj, $vars) = @_;

    return {
        base => 'dirslist',    
        title => 'Словари',
        table => 'TestDicts',
        logchanges => 1,
        fields => [ 
            { name => 'DictName', edlist => 1, showmacroel => 'show_list_inline_edit_field', },
            { name => 'DictNameSh', edlist => 1, showmacroel => 'show_list_inline_edit_field', },
            { name => 'Text',     edlist => 1, shlist => 0, ftype => 'bigtextarea' },
            { name => 'CatID',    edlist => 1, shlist => 1, ftype => 'typeahead', 
                  typeahead => sub {
                      my ($proj, $text) = @_;
                      my $list = $proj->search_categs($text);
                      return [ map { $_->{'CategoryName'} } @$list ];
                      #return ['aaaaaa', 'bbbbbb'] 
                  }, 
                  #showmacroel => 'show_list_inline_typeahead_field',
                  showmacroel => 'show_list_inline_edit_field',
            },
            { name => 'TextType', title => 'Тип', shlist => 1, ftype => 'select',
                  selectlist => [ 
                          { name => 'Слова', value => '', default => 1, color => '#FF0000' },
                          { name => 'Фразы', value => 'phrases', color => '#00FF00' },
                      ], 
                  showmacroel => 'show_list_inline_select_field',
            },
            { name => 'FltType', title => 'Действия', shlist => 1, ftype => 'select',
                  selectlist => [ 
                          { name => 'Ничего не делать', value => '', default => 1 },
                          { name => 'Всегда удалять из хвостиков', value => 'del', },
                          { name => 'Удалять, если не было в баннере', value => 'chdel',     },
                      ], 
                  showmacro => 'italictext',
            },
            { name => 'FltContext', title => 'Контексты', shlist => 1, ftype => 'select',
                  selectlist => [ 
                          { name => 'Ничего не делать', value => '', default => 1 },
                          { name => 'Не учитывать в пересечении', value => 'del', },
                      ], 
                  showmacro => 'italictext',
            },
            { name => 'Comment',  edlist => 1, ftype => 'textarea', showmacroel => 'show_list_inline_edit_field' },
        ],
        filters => [
               {  name => 'Действия', field => 'TextType', typeahead => sub { my ($proj, $text, $tinf) = @_;  return [ map { "$_".$text } ( 11111, 1111111111111, 22222222, 22222, 33333) ] }, hgrp => 1, hlike => 0 },
        ], 
    };
}

sub testdictslog : CMDH {
    my ($proj, $vars) = @_;

    return {
        base => 'loglist',    
        title => 'Лог изменений словарей',
        table => 'Log_TestDicts',
        #Нужен, так как в родительской таблице поля могут пропадать
        alter_field_titles => {
            login => 'Логин',
            elemid => 'El', 
        },
    };
}

sub categslist : CMDH {
    my ($proj, $vars) = @_;

    return {
        title => 'Список категорий',
        readonly => 1,
        table => 'CatalogiaBrief',
        idfield => 'CatID',
        showid => 0,
        default_field_params => { shlist => 1, },
        fields => [
               {  name => 'CatID', },
               {  name => 'ParentID', },
               {  name => 'Flags', },
               {  name => 'IsAtom', },
        ],
        order_by => 'CatID',
        tree => { 
                  #first_level_filter => { ParentID => '0', },
                  all_level_filter => { IsAtom => '0', 'CatID NOT LIKE' => 'v%' },
                  grpfields => [
                      { field => 'CatID', prnt_field => 'ParentID', first_level_prnt => '0', wtype => 'catid',
                            #Добавляем дополнительную информацию
                            add_fields => [
                                { name => 'CategoryName', table => 'CatalogiaDict', using => 'CatID', 
                                  add_filter => { Language => $vars->{viewoptions}{lang} } },
                            ],
                            showmacro => "catinf2link CategoryName CatID",
                          },
                  ],
                  pager => { name => 'p', cc => 20, },
              },
        pager => { name => 'p', cc => 200, },
        #search => { fields => [ 'Words', 'FltType', ], name => 'text', }, 
#        filters => [
#               {  name => 'Логин', field => 'Login', grp => 1 },
#               {  name => 'CatID', field => 'CatID' },
#        ], 
    };
}

sub testdirs : CMDH {
    my ($proj, $vars) = @_;

    return {
        base => 'dirs',    
        title => 'Работа с урлами',
        table => 'TestDirs2',
        #fields => [ { name => 'URL', edlist => 1, } ],
        extlists => [
            { cmd => 'problemurls', using => 'ParentID', title => 'Urls' },
        ],        
    };
}


1;
