package Cmds::Feeds;

use strict;
use utf8;

use base qw(Cmds::Base);
use Encode;
use List::Util qw(min);
use Text::Iconv;
use Data::Dumper;
use URI::Escape;
use Utils::Sys qw(format_number h2sa);
use Time::HiRes qw(gettimeofday tv_interval time);
use Utils::Hosts qw(get_curr_host get_hosts);
use Utils::Sys qw(md5int);
use Utils::XLS qw(array2xls xls2array xlsx2array xls_edit_line xls_lines_list);
use JSON::XS;

use BM::BannersMaker::Tasks::BasePerfTask;

sub feed_tasks : CMDH {
    my ($proj, $vars) = @_;

    return {
        title => 'Генерация баннеров по фиду',
        dbhname => 'bannerland_dbh',
        table => 'feed_tasks',
        rights => 'right_feeds_tasks',
        readonly => 1,
        idfield => 'ID',
        showid => 1,
        compact_inline_add => 1,
        onclick => 'extlists',
        fix_sql_problem => 1,
        save_button => { title => 'Поставить задачу', right => 1, },
        default_field_params => { shlist => 1, edlist => 0, },
        fields => [
               {  name => 'Login', autoedit => sub { $proj->{login} }, shlist => 1, },
               {  name => 'date', autoedit => sub { $proj->dates->cur_date('db_time') }, },
               {  name => 'name', title => 'Name', edlist => 1, },
               {  name => 'feed_url', title => 'FeedUrl', edlist => 1, },
               {  name => 'host', title => 'host', edlist => 0, },
               {  name => 'feed_file',
                      edlist => 1,
                      title => 'Upload File',
                      ftype => 'file',
                      filenamefield => 'FeedFileName',
                      shlist => 0,
               },
               {  name => 'domain', title => 'Domain', edlist => 1, },
               {  name => 'filters', title => 'Filters', edlist => 1, ftype => 'bigtextarea' },
               {  name => 'banners_body', title => 'Banners Body', edlist => 1, },
               {  name => 'offer_limit',  title => 'Offer limit', default => 1000, edlist => 1, },
               {  name => 'metainf', meta => 1, shlist => 0 },
               {  name => 'state', autoedit => sub { 'New' }, },
               {  name => 'statinf', shlist => 0, },
               {  name => 'gentype', title => 'Generation type', shlist => 1, adlist => 1, edlist => 1, ftype => 'select',
                  selectlist => [
                          { name => 'dyn',      value => '',     default => 1,  color => '#00FF00', },
                          { name => 'perf',      value => 'perf', color => '#0000FF', },
                      ],
               },
               {  name => 'business_type', title => 'Business type', shlist => 1, adlist => 1, edlist => 1, ftype => 'select',
                  selectlist => [
                          { name => 'не выбран',    value => '',    default => 1,  color => '#00FF00', },
                          { name => 'retail',   value => 'retail',  color => '#00FF00', },
                          { name => 'realty',   value => 'realty',  color => '#0000FF', },
                          { name => 'hotels',   value => 'hotels',  color => '#0000FF', },
                          { name => 'auto',     value => 'auto',    color => '#0000FF', },
                          { name => 'flights',  value => 'flights', color => '#0000FF', },
                          { name => 'news',     value => 'news',    color => '#0000FF', },
                          { name => 'other',    value => 'other',   color => '#0000FF', },
                      ],
               },
               {  name => 'use_as_name', title => 'Тег UseAsName', edlist => 1, },
               {  name => 'use_as_body', title => 'Тег UseAsBody', edlist => 1, },
               {  name => 'experimental_gen', title => 'Experimental generation', ftype => 'checkbox', edlist => 1, },
           ],
        filters => [
               {  name => 'Логин', field => 'Login', grp => 1 },
               {  name => 'state', field => 'state', grp => 1 },
               {  name => 'feed_url', field => 'feed_url', like => 1,  },
        ],
        default_filter => { 'Login' => $proj->{login} },
        order_by => '-ID',
        extlists => [
            { cmd => 'feed_tasks_banners', using => 'task_id', title => 'Phrases', addelemparams => { campaign_id => 'campaign_id', }, },
        ],
        pager => { name => 'p', cc => 40, },
    };
}

sub feed_tasks_cmp : CMDH {
    my ($proj, $vars) = @_;

    return {
        title => 'Сравнение генерации баннеров',
        dbhname => 'bannerland_dbh',
        table => 'feed_tasks_cmp',
        rights => 'right_feeds_tasks',
        readonly => 1,
        idfield => 'ID',
        showid => 1,
        compact_inline_add => 1,
        onclick => 'extlists',
        fix_sql_problem => 1,
        save_button => { title => 'Поставить задачу', right => 1, },
        default_field_params => { shlist => 1, edlist => 0, },
        fields => [
               {  name => 'Login', autoedit => sub { $proj->{login} }, shlist => 1, },
               {  name => 'date', autoedit => sub { $proj->dates->cur_date('db_time') }, },
               {  name => 'name', title => 'Name', edlist => 1, },
               {  name => 'feed_url', title => 'Feed_Url', edlist => 1, },
               {  name => 'host', title => 'host', edlist => 0, },
               {  name => 'domain', title => 'Domain', edlist => 1, },
               {  name => 'source_to_canonical', title => 'Source map', edlist => 1, ftype => 'bigtextarea' },
               {  name => 'source_to_yabs', title => 'Source to yabs map', edlist => 1, ftype => 'bigtextarea' },
               {  name => 'product_limit',  title => 'Product limit', edlist => 1, },
               {  name => 'metainf', meta => 1, shlist => 0 },
               {  name => 'state', autoedit => sub { 'New' }, },
               {  name => 'offer_xml_tag', title => 'Offer xml tag', shlist => 1, edlist => 1},
               { name => 'experimental_gen', title => 'Experimental generation', ftype => 'checkbox', edlist => 1, },
           ],
        filters => [
               {  name => 'Логин', field => 'Login', grp => 1 },
               {  name => 'state', field => 'state', grp => 1 },
               {  name => 'feed_url', field => 'feed_url', like => 1,  },
        ],
        default_filter => { 'Login' => $proj->{login} },
        order_by => '-ID',
        extlists => [
            { cmd => 'feed_tasks_banners_cmp', using => 'task_id', },
        ],
        pager => { name => 'p', cc => 40, },
    };
}

sub feed_tasks_dyn : CMDH {
    {
        base => 'feed_tasks',
        rights => '',
        title => 'Тестовая генерация баннеров для динамических баннеров',
        fields => [
#               {  name => 'feed_file', delete_base => 1, },
#               {  name => 'feed_url', delete_base => 1, },
               {  name => 'experimental_gen', delete_base => 1, },
               {  name => 'gentype',  update_base => 1, autoedit => sub { '' }, edlist => 0, shlist => 0, },
           ],
        filters => [
               {  field => 'Login', delete_base => 1, },
               {  name => 'state', update_base => 1, use_other_filters => 1, },
#               {  name => 'feed_url', delete_base => 1, },
               {  name => 'domain', field => 'domain', like => 1,  },
        ],
    };
}

sub feed_tasks_banners : CMDH {
    my ($proj, $vars) = @_;

    my $set_info = "";
    my $tab_tag = '&ensp;';
    if ($vars and exists ($vars->{form}) and (exists $vars->{form}->{task_id})) {
        my $task_id = $vars->{form}->{task_id};
        if ($task_id) {
            my $request = "select feed_url, business_type, filters, gentype, use_as_name, bannercount_native, bannercount_dse from feed_tasks where ID = $task_id";
            my $dbt = $proj->dbtable('feed_tasks', 'ID', 'bannerland_dbh');
            my $res = $dbt->List_SQL($request);
            if (@$res) {
                $res = $res->[0];
                $set_info = join('<br>',
                    "<strong>FeedUrl:</strong> $tab_tag $res->{feed_url}",
                    "<strong>Business type:</strong> $tab_tag $res->{business_type}",
                    "<strong>Gentype:</strong> $tab_tag $res->{gentype}",
                    "<strong>UseAsName:</strong> $tab_tag $res->{use_as_name}",
                    "<strong>UseAsBody:</strong> $tab_tag $res->{use_as_body}",
                    ($res->{filters}) ? "<strong>Filters:</strong> $tab_tag $res->{filters}" : "",
                    "<strong>Native generation banners count:</strong> $tab_tag $res->{bannercount_native}",
                    "<strong>DSE generation banners count:</strong> $tab_tag $res->{bannercount_dse}",
                );
            }
        }
    }

    return {
        title => 'Список баннеров',
        toptext => qq[
            <div style="height: 3"> $set_info </div>
        ],
        dbhname => 'bannerland_dbh',
        table => 'feed_tasks_banners',
        #rights => 'right_feeds_tasks',
        readonly => 1,
        idfield => 'ID',
        showid => 0,
        fix_sql_problem => 1,
        default_field_params => { shlist => 1, edlist => 0, },
        fields => [
               {  name => 'task_id',       shlist => 0, addform => 1, },
               {  name => 'state', title => '',  shlist => 1, ftype => 'select', width=>60, mass_change => 1, iwonchange_reload_extlists => 1,
                  selectlist => [
                          { name => 'unkn',      value => '',     default => 1,  color => '#CCCCCC', },
                          { name => 'good',      value => 'good', color => '#00FF00', },
                          { name => 'warn',      value => 'warn', color => '#FFFF00', },
                          { name => 'bad',       value => 'bad', color => '#cd261b', textcolor => '#FFFFFF', },
                      ],
                  inline => 1,
                  edlist => 1,
                  inlinefilter => { group => 1, },
               },
               {  name => 'phrase_source', title => 'Phr source',  shlist => 1, inlinefilter => { group => 1, }, },
               {  name => 'phrase',        title => 'Phrase', shlist => 1, inlinefilter => { group => 1, }, },
               {  name => 'state_title', title => '',  shlist => 1, ftype => 'select', width=>60, mass_change => 1, iwonchange_reload_extlists => 1,
                  selectlist => [
                          { name => 'unkn',      value => '',     default => 1,  color => '#CCCCCC', },
                          { name => 'good',      value => 'good', color => '#00FF00', },
                          { name => 'warn',      value => 'warn', color => '#FFFF00', },
                          { name => 'bad',       value => 'bad', color => '#cd261b', textcolor => '#FFFFFF', },
                      ],
                  inline => 1,
                  edlist => 1,
                  inlinefilter => { group => 1, },
               },
               {  name => 'title_source', title => 'Title source',  shlist => 1, inlinefilter => { group => 1, }, },
               {  name => 'title',         title => 'Title', shlist => 1, inlinefilter => { group => 1, }, },
               {  name => 'advtype', shlist => 1, inlinefilter => { group => 1, }, },
               {  name => 'comment', shlist => 1, inline => 1, edlist => 1, inlinefilter => { group => 0, }, },
               {  name => 'url',           title => 'Url', shlist => 1, showmacro => 'exturl', inlinefilter => { group => 0, },},
               {  name => 'rand_id',       shlist => 0, edlist => 0, },
           ],
        filters => [
               {  name => 'Phrase state', field => 'state', grp => 1, use_other_filters => 1, },
               {  name => 'Phrase source', field => 'phrase_source', grp => 1, use_other_filters => 1, },
               {  name => 'Title source', field => 'title_source', grp => 1, use_other_filters => 1, },
        ],
        topmenu => [
            { title => 'Данные', sublist => [
                 { title => 'Пересчитать', name => 'regen', addformparams => { task_id => 'task_id', },
                   url => '?cmd=feed_tasks_regen',
                 },
                 { title => 'Остановить', name => 'stoptask', addformparams => { task_id => 'task_id', },
                   url => '?cmd=feed_tasks_stop',
                 },
                 { title => 'Перемешать', name => 'randtask', addformparams => { task_id => 'task_id', },
                   url => '?cmd=feed_tasks_rand',
                 },
            ], },
        ],
        extlists => [
            {
                cmd => 'feed_tasks_banners_phrases',
                #using => 'task_id',
                #title => 'Phrases',
                addelemparams => { phrase => 'phrase', match_type => 'match_type', },
                #addparams => {
                #    flt_rank => $flt_rank,
                #    flt_changes => $flt_changes,
                #},
            },
        ],
        data_import_export => {
            no_import => 1,
            export => {
                headers => 1,
                filtered => 1,
            },
            list => [qw[ phrase title url ]],
        },
        order_by => 'rand_id, -ID',
        pager => { name => 'p', cc => 400, },
    };
}

sub feed_tasks_banners_cmp : CMDH {
    my ($proj, $vars) = @_;

    return {
        title => 'Сравнение баннеров',
        dbhname => 'bannerland_dbh',
        table => 'feed_tasks_banners_cmp',
        readonly => 1,
        idfield => 'ID',
        showid => 0,
        fix_sql_problem => 1,
        default_field_params => { shlist => 1, edlist => 0, },
        fields => [
               {  name => 'task_id',       shlist => 0, addform => 1, },
               {  name => 'phrase',        title => 'Phrase', shlist => 1, },
               {  name => 'title',         title => 'Title', shlist => 1, },
               {  name => 'advtype', shlist => 1, },
               {  name => 'url',           title => 'Url', shlist => 1, showmacro => 'exturl', },
               {  name => 'type',       shlist => 1,},
               {  name => 'add_data',  title => 'Additional data', shlist => 1,},
           ],
        filters => [
               {  name => 'type', field => 'type', grp => 1, use_other_filters => 1, },
        ],
        order_by => 'url',
        pager => { name => 'p', cc => 400, },
    };
}

sub feed_tasks_banners_phrases :CMDH {
    my ($proj, $vars) = @_;
    return {
        title => 'Список вариантов фраз',
        #dbhname => 'bannerland_dbh',
        #table => 'feed_tasks_banners',
        readonly    => 1,
        getlistflt => sub {
            my ($self, %prm) = @_;

            my $proj = $self->proj;
            my $text = $proj->form->{phrase};
            #my $phl = $proj->phrase_list($text." => ".$proj->form->{match_type});
            my $phl = $proj->phrase_list($text);
            $phl = $phl->get_search_syns if $proj->form->{match_type} ne 'norm';
            $phl = $phl->cache_search_count;
            $phl = $phl->lgrep(sub {$_->get_search_count})->sort_phrases_search_count;

            return [
                map { {phrase => "$_", cc => $_->get_search_count} } @$phl
            ];
        },
        fields => [
            { name => "phrase", shlist => 1, },
            { name => "cc", shlist => 1, },
            {
                width => 100,
                shlist => 1,
                showsubel   => sub {
                    my ($el, $f) = @_;
                    my $text = $el->{phrase};
                    my $uritext = uri_escape_utf8($text);
                    return join('',
                               map { ref($_) eq 'ARRAY' ? "<a target=\"_blank\" href=\"".$_->[1]."\" style='margin:0px 5px 0px 0px;'><img style=\"max-width: none;\" src='/".$_->[0]."' width=16 border=0></a>" : $_ }
                               "<div style='width:32'><nobr>",
                               [ 'wordstat.gif', 'https://wordstat.yandex.ru/#!/?words='.$uritext ],
                               [ 'banners2.gif', $proj->macros->get_macros->{get_url_search_banners}->($text) ],
                               [ 'ph_gr.gif',    "?cmd=get_phrase_info&viewoptionsstr=$vars->{viewoptionsstr}&phrase_text=$uritext" ],
                               [ 'yndx_gr.gif',  "http://yandex.ru/yandsearch?text=$uritext" ],
                               [ 'ggl_gr.gif',   $proj->macros->get_macros->{hidereferer}->("https://www.google.ru/#q=$uritext") ],
                               "</nobr></div>",
                           );
                },
            },
        ],
    };
}

sub feed_tasks_regen :CMD {
    my ($proj, $vars) = @_;

    my $task_id = $proj->form->{task_id};

    my $form = $proj->form;

    my $tbl = $proj->dbtable('feed_tasks', 'ID', 'bannerland_dbh');
    $tbl->Edit($task_id, { state => 'New', });
    $tbl->Edit($task_id, { Login => $proj->{login}, });


    $proj->do_redirect(join("&",
        "ind.pl?cmd=feed_tasks",
        "viewoptionsstr=".$form->{viewoptionsstr},
    ));

}

sub feed_tasks_stop :CMD {
    my ($proj, $vars) = @_;

    my $task_id = $proj->form->{task_id};

    my $form = $proj->form;

    my $tbl = $proj->dbtable('feed_tasks', 'ID', 'bannerland_dbh');
    $tbl->Edit($task_id, { state => 'Stopped', });
    $tbl->Edit($task_id, { Login => $proj->{login}, });


    $proj->do_redirect(join("&",
        "ind.pl?cmd=feed_tasks",
        "viewoptionsstr=".$form->{viewoptionsstr},
    ));

}

sub feed_tasks_rand :CMD {
    my ($proj, $vars) = @_;

    my $form = $proj->form;

    my $task_id = $form->{task_id};
    $task_id =~ s/\D+//g;

    if($task_id){
        $proj->bannerland_dbh->Do_SQL("update feed_tasks_banners set rand_id = FLOOR(rand() * 1000000) where task_id = $task_id ");
    }

    $proj->do_redirect(join("&",
        "ind.pl?cmd=feed_tasks_banners&act=List",
        "task_id=$task_id",
        "viewoptionsstr=".$form->{viewoptionsstr},
    ));

}

sub _generate_feed_banners {
    my ($proj, $task_id, $datadbg, $dbgbnr) = @_;

    $proj->log("_generate_feed_banners beg");
    my $beg = $proj->curtime;

    $datadbg ||= 0;
    our $dbg = 1;
    our $ourproj = $proj;

    my $tbltsk = $proj->dbtable('feed_tasks', 'ID', 'bannerland_dbh');
    my $tblbnr = $proj->dbtable('feed_tasks_banners', 'ID', 'bannerland_dbh');

    my $tsk = $tbltsk->Get($task_id);

    my $host = get_curr_host();
    if($tsk->{host} ne $host){
        $tbltsk->Edit($task_id, {
            host => $host,
        });
    }

    my $tskname = $tsk->{name};
    $tskname =~ s/[#\n\t]//g if ($tskname);

    my $prev_experimental_product_mode;
    if ( $tsk->{experimental_gen} ){
        $prev_experimental_product_mode = $proj->set_experimental_product_mode(1);
    }

    my $offer_limit = $tsk->{offer_limit} || 10000;

    my %feed_params = ();

    # get & parse feed_params

    # filters & specurl
    my $specurl = '';
    if($tsk->{filters}) {
        my $data;
        eval {$data = JSON::XS->new->decode($tsk->{filters});};
        if ($@) {
            print STDERR "bad filter json; error message '$@'\n";
            $tbltsk->Edit($task_id, { State => 'Fail', });
            return '';
        }

        $feed_params{filters} = { 1 =>  $data->{filters}};
        print STDERR "filters: " . Dumper($feed_params{filters});
        $specurl = $data->{specurl};
    }

    if($tsk->{feed_url}){
        # if feed by url...
        $feed_params{url} = $tsk->{feed_url};
    }elsif($tsk->{feed_file}){
        # if feed by content...
        my $tempfile = $proj->get_tempfile("interface_banners_generation", UNLINK => 1);
        open F, '>'.$tempfile;
        binmode(F);
        print F $tsk->{feed_file};
        close F;
        $feed_params{extfile} = $tempfile;
    }elsif($tsk->{domain}) {
        # if feed by spider...
        my $site = $proj->site($tsk->{domain});
        my $feed_data = $specurl ? $site->get_url_tskv_feed($specurl) : $site->get_site_tskv_feed;
        my $tempfile = $proj->get_tempfile("interface_banners_generation", UNLINK => 1);
        open F, '>'.$tempfile;
        binmode(F);
        print F $feed_data;
        close F;
        $feed_params{extfile} = $tempfile;
        #$feed_params{data} = $feed_data;
        #$feed_params{datatype} = 'offers_tskv';
    }else{
        # else error
        print STDERR "not enough data\n";
        $tbltsk->Edit($task_id, { State => 'Fail', });
        return '';
    }

    my $fd = $proj->feed( \%feed_params );

    $proj->log("delete old data");
    #Удаляем старые данные
    if(!$datadbg){
        $tblbnr->DelList({ task_id => $task_id });
    }

    my $status = '';

    my $feedcount = $fd->get_total_offers_count;
    unless ( $feedcount ){
        $status = 'Fail';
        $tbltsk->Edit($task_id, { State => 'Fail', });
    }

    my $get_temp_file = sub {
        my $prefix = shift;
        my $filename = $proj->get_tempfile($prefix, UNLINK => 1,
            DIR => $Utils::Common::options->{dirs}{banners_generation_files});
        return $filename;
    };

    #Случайно переставляем строки, чтобы упростить анализ
    my $filetskv_mpd_tmp = $fd->offers_tskv_mpd_file->{filename};
    my $filetskv_mpd_tmp_shuffed = &$get_temp_file('offers_tskv_mpd');
    `shuf -n $offer_limit $filetskv_mpd_tmp > $filetskv_mpd_tmp_shuffed`;
    my ($ignore_native_by_business_type, $ignore_dse) = (0, 0);
    my $perf_or_dyn_task = ( $tsk->{gentype} eq 'perf' ) ? $proj->perftask({}) : $proj->dyntask({});
    ($ignore_native_by_business_type, $ignore_dse) = BM::BannersMaker::Tasks::BasePerfTask::get_generation_flags_for_business_type($tsk->{business_type}) if ($tsk->{gentype} eq 'perf');

    my $dse_fd;
    my $filetskv_mpd = $filetskv_mpd_tmp_shuffed;
    if (($tsk->{gentype} eq 'perf') and not $ignore_dse) {
        # дописываем merge key
        $filetskv_mpd = &$get_temp_file('offers_tskv_mpd');
        $perf_or_dyn_task->add_merge_keys($filetskv_mpd_tmp_shuffed, $filetskv_mpd);

        if (($proj->file($filetskv_mpd)->wc_l < 1) and ($proj->file($filetskv_mpd_tmp_shuffed)->wc_l)) {
            # не получилось доклеить merge ключи, оставляем начальный файл без изменений
            $filetskv_mpd = $filetskv_mpd_tmp_shuffed;
        }
    }

    my $textdata = $proj->file( $filetskv_mpd )->head_lines( $offer_limit );
    $fd = $proj->feed( { data => $textdata, datatype => 'offers_tskv' } );
    $feedcount = $fd->get_total_offers_count;

    if (($tsk->{gentype} eq 'perf') and not $ignore_dse) {
        # создание dse-фида
        my $product_url = $fd->get_first_product_url;
        my ($dse_feed_filename, $dse_feed_filename_unsorted);
        my $product_domain = $proj->page($product_url)->domain;
        if ($product_domain) {
            my $dse_options = $proj->options->{DynSources}->{dse};
            $dse_feed_filename_unsorted = $perf_or_dyn_task->get_source_file(
                name             => 'source_dse',
                yt_path          => $dse_options->{yt_path_domain},
                sec_level_domain => $perf_or_dyn_task->get_source_key($product_domain),
                add_str => "product_type=dse\t",
                directory_path => $Utils::Common::options->{dirs}{banners_generation_files},
            );
            $dse_feed_filename = &$get_temp_file('dse_feed');
            $perf_or_dyn_task->add_merge_keys($dse_feed_filename_unsorted, $dse_feed_filename);
            unlink $dse_feed_filename_unsorted;
        }
        $dse_fd = BM::BannersMaker::Tasks::PerfMergeFeed->new({ proj => $proj, filename => $dse_feed_filename }) if ($dse_feed_filename);
    }

    $fd->{use_as_name} = $tsk->{use_as_name} if ($tsk->{use_as_name});

    my $cc = 0;
    my ($ccc, $ccc_native, $ccc_dse) = (0, 0, 0);
    my $pc = 0;
    $fd->iter_init;
    while(defined( my $ptl = $fd->next_ptl_pack(100, check_required_fields => ( $tsk->{gentype} eq 'perf' ? 1:0 )))) {
        $pc += $ptl->count;
        $proj->log("_next_ptl_pack $pc / $feedcount");
        for my $pt (@$ptl){
            $cc++;

            my $pt_dse;
            $pt_dse = $dse_fd->get_by_key($pt->{merge_key}) if ($dse_fd);
            my ($arr, $arr_dse) = ([], []);
            my @lst = ();

            my @final_arr;
            if ( $tsk->{gentype} eq 'perf' ) {
                $arr = $pt->perf_banners unless ($ignore_native_by_business_type && $pt->is_base_product);
                $arr_dse = $pt_dse->perf_banners if ($pt_dse);

                push @final_arr, { phrase => '', title => $pt->_MULTIDOT_END_NON_EMPTY($pt->{use_as_name}), template => 'use_as_name', title_source => 'use_as_name'} if ($pt->{use_as_name});
                push @final_arr, { %$_, template => 'native', title_source => 'native' } for @$arr;
                push @final_arr, { %$_, template => 'dse', title_source => 'dse'} for @$arr_dse;
            } else {
                $arr = $pt->dyn_banners unless ($ignore_native_by_business_type && $pt->is_base_product);
                $arr_dse = $pt_dse->dyn_banners if ($pt_dse);

                push @final_arr, { %$_, template => 'native', title_source => 'native' } for @$arr;
                push @final_arr, { %$_, template => 'dse', title_source => 'dse'} for @$arr_dse;
            }
            for my $el (@final_arr){
                push(@lst, {
                    task_id => $task_id,
                    phrase => $el->{phrase},
                    title  => $el->{title},
                    advtype => $pt->ad_type,
                    url    => $pt->url,
                    match_type => $pt->match_type,
                    phrase_source => $el->{template},
                    title_source => $el->{title_source},
                });
            }
            $tblbnr->Add(\@lst);
            $ccc += @lst;
            $ccc_native += @$arr;
            $ccc_dse += @$arr_dse;
        }
    }

    my $end = $proj->curtime;

    $proj->log("_generate_feed_banners  $beg  - $end, $ccc banners generated");

    $proj->log("_generate_feed_banners send email");

    if (($tsk->{send_email} || 1) && !$datadbg) {
        my $email_to = $proj->login2email($tsk->{Login});
        if (not $email_to) {
            #$proj->log("ERROR: void email");
        } else {
            my $body = "
                        Результат обработки фида:
                        http://catmedia.yandex.ru/ind.pl?cmd=feed_tasks_banners&act=List&task_id=$task_id

                        Начало:    $beg
                        Окончание: $end

                        Товаров:   ".$feedcount."
                        Баннеров:  $ccc
            ";
            $body =~ s/\n +/\n/g;

            my $res = $proj->SendMail({
                from => 'no_reply@yandex-team.ru',
                to => $email_to,
                #bcc => 'skreling@yandex-team.ru',   # To be removed  TODO
                subject => "Обработка фида ".$task_id." $status - $tskname",
                body => $body,
            });
        }
    }

    $status ||= 'Done';
    $tbltsk->Edit($task_id, {
        State => $status,
        begintime => $beg,
        endtime => $end,
        offercount => $feedcount,
        bannercount => $ccc,
        bannercount_native => $ccc_native,
        bannercount_dse => $ccc_dse,
    });

    if ( $tsk->{experimental_gen} ){
        $proj->set_experimental_product_mode( $prev_experimental_product_mode );
    }

    $proj->log("_generate_feed_banners end");

}

sub _hash_to_unique_string {
    my $hash_ref = shift;
    my @sorted_keys = sort keys(%$hash_ref);
    my $res = '{';
    for (@sorted_keys) {
        $res .= "$_=>";
        my $value = $hash_ref->{$_};
        if (ref($value) eq "HASH") {
            $res .= _hash_to_unique_string($value);
        } else {
            $res .= "$value";
        }
        $res .= ",";
    }
    $res .= "}";
    return $res;
}

sub _generate_feed_banners_cmp {
    my ($proj, $task_id) = @_;

    $proj->log("_generate_feed_banners_cmp beg");
    my $beg = $proj->curtime;

    our $dbg = 1;
    our $ourproj = $proj;

    my $tbltsk = $proj->dbtable('feed_tasks_cmp', 'ID', 'bannerland_dbh');
    my $tblbnr = $proj->dbtable('feed_tasks_banners_cmp', 'ID', 'bannerland_dbh');

    my $tsk = $tbltsk->Get($task_id);

    my $host = get_curr_host();
    if($tsk->{host} ne $host){
        $tbltsk->Edit($task_id, {
            host => $host,
        });
    }

    my $tskname = $tsk->{name};
    $tskname =~ s/[#\n\t]//g;

    my $product_limit = $tsk->{product_limit} || 5000;

    my $prev_experimental_product_mode;
    if ( $tsk->{experimental_gen} ){
        $prev_experimental_product_mode = $proj->set_experimental_product_mode(1);
    }

    my $fd = '';
    my $fd_smart = '';

    if($tsk->{feed_url} && $tsk->{source_to_canonical} && $tsk->{source_to_yabs} && $tsk->{offer_xml_tag}){
        $fd = $proj->feed($tsk->{feed_url});
        my $page = $proj->page( $tsk->{feed_url} );
        my $text = $page->tt;
        $fd_smart = $proj->fdm->test_smartmap($text, $tsk->{source_to_canonical}, $tsk->{source_to_yabs}, $tsk->{offer_xml_tag} );
    } else {
        print STDERR "not enough data\n";
        $tbltsk->Edit($task_id, { State => 'Fail', });
        return '';
    }


    $proj->log("delete old data");
    $tblbnr->DelList({ task_id => $task_id });

    my $status = '';

    my $feed_count = $fd->get_total_offers_count;
    my $feed_smart_count = $fd_smart->get_total_offers_count;
    if ($feed_count == 0 && $feed_smart_count == 0) {
        $proj->log("both feeds are empty");
        $status = 'Fail';
        $tbltsk->Edit($task_id, { State => 'Fail', });
        return '';
    }

    $proj->log("feed: $feed_count");
    $proj->log("smart feed: $feed_smart_count");

    my $phrase_url = {};
    $proj->log("feed process beg");
    my $diff_minus = 0;
    my $pc = 0;
    my $cc = 0;
    while(defined( my $ptl = $fd->next_ptl_pack(100) )) {
        $pc += $ptl->count;
        $proj->log("_next_ptl_pack $pc / $feed_count");
        for my $pt (@$ptl){
            $cc++;
            if ($cc > $product_limit) {
                last;
            }
            my $arr = $pt->perf_banners;
            my $add_data = _hash_to_unique_string($pt->{additional_data});
            for my $el (@$arr){
                $phrase_url->{$el->{phrase}.';'.$pt->url} = {
                    task_id => $task_id,
                    phrase => $el->{phrase},
                    title  => $el->{title},
                    advtype => $pt->ad_type,
                    url    => $pt->url,
                    match_type => $pt->match_type,
                    type => 'feed',
                    add_data => $add_data
                };
                $diff_minus += 1;
            }
        }
        if ($cc > $product_limit) {
            last;
        }
    }
    $proj->log("feed process end");

    $proj->log("feed smart process beg");
    my $diff_plus = 0;
    $pc = 0;
    $cc = 0;
    while(defined( my $ptl = $fd_smart->next_ptl_pack(100) )) {
        $pc += $ptl->count;
        $proj->log("_next_ptl_pack $pc / $feed_smart_count");
        for my $pt (@$ptl){
            $cc++;
            if ($cc > $product_limit) {
                last;
            }
            my $arr = $pt->perf_banners;
            my $add_data = _hash_to_unique_string($pt->{additional_data});
            for my $el (@$arr){
                my $key = $el->{phrase}.';'.$pt->url;
                if ($phrase_url->{$key} && $phrase_url->{$key}->{add_data} == $add_data) {
                    delete $phrase_url->{$key};
                    $diff_minus -= 1;
                } else {
                    $phrase_url->{$key} = {
                        task_id => $task_id,
                        phrase => $el->{phrase},
                        title  => $el->{title},
                        advtype => $pt->ad_type,
                        url    => $pt->url,
                        match_type => $pt->match_type,
                        type => 'smart feed',
                        add_data => $add_data
                    };
                    $diff_plus += 1;
                }
            }
        }
        if ($cc > $product_limit) {
            last;
        }
    }
    $proj->log("feed smart process end");

    $proj->log("add diff to db");

    my @values = values(%$phrase_url);
    $tblbnr->Add(\@values);

    my $end = $proj->curtime;

    $proj->log("_generate_feed_banners_cmp  $beg  - $end");

    $proj->log("_generate_feed_banners_cmp send email");

    my $email_to = $proj->login2email($tsk->{Login});
    if ($email_to) {
        my $body = "
                    Результат сравнения фидов:
                    http://catmedia.yandex.ru/ind.pl?cmd=feed_tasks_banners_cmp&act=List&task_id=$task_id

                    Начало:    $beg
                    Окончание: $end

                    Удалено старых:   $diff_minus
                    Добавлено новых:  $diff_plus
        ";
        $body =~ s/\n +/\n/g;

        my $res = $proj->SendMail({
            from => 'no_reply@yandex-team.ru',
            to => $email_to,
            subject => "Сравнение баннеров ".$task_id." $status - $tskname",
            body => $body,
        });
    }

    $status ||= 'Done';
    $tbltsk->Edit($task_id, {
        State => $status,
        begintime => $beg,
        endtime => $end,
        diff_minus => $diff_minus,
        diff_plus => $diff_plus,
    });

    if ( $tsk->{experimental_gen} ) {
      $proj->set_experimental_product_mode( $prev_experimental_product_mode );
    }

    $proj->log("_generate_feed_banners_cmp end");

}

##Type	Text	Title	Body	Url	Flags	Age	Domain	Categories	PhraseID	Lang	CTR	PCTR	SpecPlaceFlag	OnlyYandexFlag	Direct2BSData
#      norm	text_test	title_test	body_test	url_test	42	84	ya.ru		21	kz	97	79	1	0	{"OrderID": 24, "ParentExportIDs": [ 48 ]}
#      snorm	text test2	title_test2	body_test2	url_test2	422	842	ya2.ru		212	tt	972	792	0	1	{"OrderID": 24, "ParentExportIDs": [ 48 ]}
#      substr	text test3	title_test2	body_test2	url_test2	423	842	ya2.ru		213	ru	973	793	1	1	{"OrderID": 24, "ParentExportIDs": [ 48 ]}
#      #End

sub feed_files_data : CMDH {
    my ($proj, $vars) = @_;
    my $bannerland_master_host = [get_hosts(role => "bannerland", master => 1)]->[0];

    return {
        title => 'Анализ файлов фидов',
        dbhname => 'bannerland_dbh',
        table => 'feed_files_data',
        #rights => 'right_feeds_tasks',
        readonly => 1,
        idfield => 'ID',
        showid => 1,
        compact_inline_add => 1,
        onclick => 'extlistsnewwnd',
        fix_sql_problem => 1,
        save_button => { title => 'Поставить задачу', right => 1, },
        default_field_params => { shlist => 1, edlist => 0, },
        fields => [
               {  name => 'Login', autoedit => sub { $proj->{login} }, shlist => 1, },
               {  name => 'date', autoedit => sub { $proj->dates->cur_date('db_time') }, },
               {  name => 'name', title => 'Name', edlist => 1, },
               {  name => 'feed_url', title => 'Feed_Url', edlist => 1, },
               {  name => 'feed_file',
                      edlist => 1,
                      title => 'Upload_File',
                      ftype => 'file',
                      filenamefield => 'FeedFileName',
                      shlist => 0,
               },
               {  name => 'domain', title => 'Domain', edlist => 1, },
               {  name => 'remote_cmd', shlist => 0, ftype => 'checkbox', edlist => 1, default => '0', title => "Скачивать через $bannerland_master_host. Костыль для внешних источников, которые хотели конечный список разрешенных ip для скачивания.", },
               {  name => 'lines_limit',  title => 'lines_limit', default => 1000, edlist => 1, },
               {  name => 'metainf', meta => 1, shlist => 0 },
#               {  name => 'state', autoedit => sub { 'New' }, },
               {  name => 'filesize', },
               {  name => 'statinf', shlist => 0, },
           ],
        filters => [
               {  name => 'Логин', field => 'Login', grp => 1 },
#               {  name => 'state', field => 'state', grp => 1 },
               {  name => 'feed_url', field => 'feed_url', like => 1,  },
        ],
        default_filter => { 'Login' => $proj->{login} },
        order_by => '-ID',
        pager => { name => 'p', cc => 40, },
        action_before_add => sub {
            my ($proj, $data) = @_;
            if($data->{feed_url}){
                if($data->{remote_cmd}){
                    my $url = $data->{feed_url};
                    $url =~ s/'/'"'"'/g;
                    my $res = $proj->read_sys_cmd_bash_remote("$bannerland_master_host", qq!wget -O- -q '$data->{feed_url}'!);
                    $data->{feed_file} = $res;
                    $data->{filesize} = length($res);
                    #my $res = $proj->read_sys_cmd_bash_remote("$bannerland_master_host", qq!wget -O- -q 'http:://ya.ru'!);
                    #my $res = $proj->read_sys_cmd_bash_remote("$bannerland_master_host", qq!date!);
                    #$proj->dd($res);
                    #$proj->dd("ZZZZZZZZZZZZZZ");
                    #exit;
                }else{
                    $data->{feed_file} = $proj->page($data->{feed_url})->tt;
                    $data->{filesize} = length($data->{feed_file});
                }
            }
        },
        extlists => [
            {
                cmd => 'feed_files_data_head_fxd',
                addelemparams => { ID => 'ID', },
            },
        ],
    };
}

sub feed_files_data_head_fxd :CMD {
    my ($proj, $vars) = @_;
    my $id = $proj->form->{ID} || 0;
    my $lst = $proj->dbtable('feed_files_data', undef, 'bannerland_dbh')->List({ ID => $id });
    my $text = '';
    if(@$lst){
        my $tsk = shift @$lst;
        my $lmt = 100*$tsk->{lines_limit};
        $lmt = 100 * $proj->form->{lines_limit} if $proj->form->{lines_limit};
        $text = substr($tsk->{feed_file}, 0, 100*$lmt);
    }
    $text =~ s/\<(?!\/)/\n\</g;
    $text =~ s/\n\s*\n/\n/g;
    $vars->{template} = 'text_plain.tmpl';
    $vars->{is_pre} = 1;
    $vars->{text} = $proj->detect_charset->text2utf8( $text );
}


1;
