package Cmds::Fields;

use utf8;

use base qw(Cmds::Base);
use Data::Dumper;
use List::MoreUtils qw(uniq);

########################################################
# Прототипы
########################################################

#Отрисовка баннера для по полям
sub banner_field_showinf : CMDFLD {
    my ($proj, $f, $prms ) = @_;
    return {
            title => 'BannerInf',
            shlist => 1,
            grp => [
                     { name => 'title', shlist => 1, },
                     { name => 'title_extension', shlist => 1, },
                     { name => 'body', shlist => 1, },
                     { name => 'phrases', shlist => 1, showmacro => 'bigcuttext', },
                     { name => 'url', shlist => 1, showmacro => 'exturl', },
                 ],
    };
}

#Добавлены данные по категориям Яндекс.Каталога
sub banner_field_geo_showinf : CMDFLD {
    my ($proj, $f, $prms ) = @_;
    require geobaselite;
    my $h = banner_field_showinf(@_);
    push( @{$h->{grp}}, { name => 'targetting', shlist => 1,
         showsubel => sub {
             my ($el, $f) = @_;
             my $regions = $el->{'targetting'};
             #return '' unless $regions;
             $regions = [grep {$_} split(",", $regions)];
             my $geo2name = sub { $_[0] =~ /^(-)?(.+)/; return $1.($geobaselite::Region{$2}->{name}) };
             return "\[".$el->{'targetting'}."\] ".(@$regions ? join(", ", map{ $geo2name->($_) } @$regions) : "все");
         },
    });
    return $h;
}

sub _extend_list_with_banners {
    my $proj = shift;
    my $list = shift;
    my $list_key = shift;
    my $key_field = shift;
        
    my @keys = uniq grep { defined $_ } map { $_->{$list_key} } @$list;
    return $list unless scalar @keys;

    my $yt_key_field = $proj->bf->fields_mapping->{mysql2yt}->{$key_field};
    my $banners = $proj->bf->get_banner_dbhashes(
        key_field => $yt_key_field,
        key_condition => "$yt_key_field in (" . join(",", @keys) . ")"
    );

    my %banners_by_key = map { $_->{$key_field} => $_ } @$banners;
    for my $el (@$list) {
        my $banner = $banners_by_key{ $el->{$list_key} } or next;
        $el->{$_} = $banner->{$_} for keys %$banner;
    }

    return $list;
}

#Получение информации о баннере из динтаблицы banners_extended
sub banner_field_getinf : CMDFLD {
    my ($proj, $f, $prms ) = @_;
    my $banner_field = $prms->[0] || 'banner_id';
    return {
        extsub => sub {
            my $list = shift;
            return _extend_list_with_banners($proj, $list, $banner_field, "id");
        },
    };

}

#Получение данных и отрисовка баннера
sub page_categ_phrases_field : CMDFLD {
    my ($proj, $f, $prms ) = @_;
    return {
        realname  => $f->{'name'},
        name  => $f->{'name'}.'_list',
        multi => $f->{'name'}.'_list',
        showsubprojel => sub {
               my ($proj, $el, $f) = @_;
               return $proj->deserial( $el->{ $f->{'realname'} });
            },
        shlist => 1,
        multigrp => [
                      { name => 'category', shlist => 1, ftype => 'category', showmacro => 'catname2link', },
                      { name => 'phrase',   shlist => 1, },
                      { name => 'tags',   shlist => 1, },
        ],
    };
}

#Получение данных и отрисовка баннера
sub banner_field : CMDFLD {
    my ($proj, $f, $prms ) = @_;
    return banner_field_getinf(@_), banner_field_showinf(@_);
}

#Получение информации о баннере из динтаблицы banners_extended по BannerID (bs_banner_id)
sub bsbanner_field_getinf : CMDFLD {
    my ($proj, $f, $prms ) = @_;
    my $banner_field = $prms->[0] || 'bs_banner_id';
    return {
        extsub => sub {
            my $list = shift;
            return _extend_list_with_banners($proj, $list, $banner_field, "bs_banner_id");
        },
    };

}

#Получение данных и отрисовка баннера по bs_banner_id
sub bsbanner_field : CMDFLD {
    my ($proj, $f, $prms ) = @_;
    return bsbanner_field_getinf(@_), banner_field_showinf(@_);
}

#Отрисовка текущей категоризации баннера
sub banner_current_categs_showinf : CMDFLD {
    my ($proj, $f, $prms ) = @_;
#    return banner_field_getinf(@_), {
    return {
            multi => 'categs',
            name  => 'categs',
            title => 'Categories',
            showsubel => sub {
               my ($el, $f) = @_;
               my $bnr = $proj->bf->lbanner( { map { $_ => $el->{$_} } qw{ title body phrases url } } );
               my $arr = $bnr->get_categs_phrases_hlist;
               #$proj->dd($bnr->title, $bnr->body, [$bnr->get_minicategs], $bnr->get_categs_phrases_hlist);
               push( @$arr, { category => $_, phrase =>  $_ }) for grep { / _ / } $bnr->get_minicategs;
               #$proj->dd($arr);
               return $arr;
            },
            shlist => 1,
            multigrp => [
                      { name => 'category', shlist => 1, ftype => 'category', showmacro => 'catname2link', },
                      { name => 'phrase',   shlist => 1, },
                  ],
    };
}

sub banner_current_categs : CMDFLD {
    my ($proj, $f, $prms ) = @_;
    return banner_field_getinf(@_), banner_current_categs_showinf(@_);
}

sub good_bad : CMDFLD {
    my ($proj, $f, $prms ) = @_;
    return {
            ftype => 'select',
            dbtype => "varchar(40) NOT NULL DEFAULT ''",
            width => 70,
            selectlist => [
                          { name => $f->{gb}{good},      value => $f->{gb}{goodvl},   default => 1,  color => '#00FF00', },
                          { name => $f->{gb}{bad},       value => $f->{gb}{badvl}, color => '#cd261b', textcolor => '#FFFFFF', },
                      ],
            inline  => 1,
            edlist  => 1,
    };
}

sub good_bad_readonly : CMDFLD {
    my ($proj, $f, $prms ) = @_;
    return {
            ftype => 'select',
            dbtype => "varchar(40) NOT NULL DEFAULT ''",
            width => 70,
            selectlist => [
                          { name => $f->{gb}{good},      value => $f->{gb}{goodvl},   default => 1,  color => '#00FF00', },
                          { name => $f->{gb}{bad},       value => $f->{gb}{badvl}, color => '#cd261b', textcolor => '#FFFFFF', },
                      ],
            showmacroel => 'show_list_inline_readonly_field',
    };
}

sub neutral_good_bad : CMDFLD {
    my ($proj, $f, $prms ) = @_;
    my $field = $prms->[0] || 'UserState';
    return {
                'inline' => 1,
                'selectlist' => [
                  {
                    'color' => '#CCCCCC',
                    'value' => '',
                    'name' => 'neutral',
                    'default' => 1
                  },
                  {
                    'color' => '#00FF00',
                    'value' => 'good',
                    'name' => 'good',
                  },
                  {
                    'color' => '#cd261b',
                    'value' => 'bad',
                    'name' => 'bad',
                    'textcolor' => '#FFFFFF'
                  }
                ],
                'width' => 70,
                'disable_add' => 1,
                'edlist' => 1,
                'shlist' => 1,
                'name' => $field,
                'showmacroel' => 'show_list_inline_select_field',
                'addform' => 1,
                'dbtype' => 'varchar(40) NOT NULL DEFAULT \'\'',
                'title' => 'UserState',
                'ftype' => 'select'
            };
}

sub phrase_categs_showinf :CMDFLD {
    my ($proj, $f, $prms ) = @_;
    my $name = $f->{name} || $f->{extname};
    return {
            multi => 'categs',
#            name  => 'categs',
            extname  => $name,
            title => 'PhrCtgs',
            showsubel => sub {
               my ($el, $f) = @_;
               my $ph = $proj->phrase( $el->{$name} );
               return $ph->get_categs_phrases_hlist;
            },
            shlist => 1,
            multigrp => [
                      { name => 'category', shlist => 1, ftype => 'category', showmacro => 'catname2link', },
                      { name => 'phrase',   shlist => 1, },
                  ],
    };

}


#Получение данных и отрисовка баннера
sub page_phrase_count_field : CMDFLD {
    my ($proj, $f, $prms ) = @_;
    my $phrase_field = $prms->[0] || 'phrase';
    return {
        title  => 'Частоты',
        name  => $f->{'name'}.'_counts',
        showsubprojel => sub {
               my ($proj, $el, $f) = @_;
               my $text = $el->{$phrase_field};
               $text =~ s/#.*//;
               return '' unless $text;
               my $ph = $proj->phrase($text);
               return join('/', $ph->get_search_query_count, $ph->get_search_count, $ph->get_bnr_count ) ;
            },
    };
}

1;
