package Cmds::HierarchicalRelation;

use strict;
use utf8;
use open ':utf8';
use Data::Dumper;

use constant {
    SINGLE      => 'Single',
    FULL        => 'Full',
    SINGLE_ANTI => 'SingleAnti',
    FULL_ANTI   => 'FullAnti',
};

use base qw(ObjLib::ProjPart);

sub init {
    my $self = shift;

    for my $element (@{$self->{data}}) {
        my ($cat_id, $property, $type) = @{$element}[qw(0 1 2)];
        $self->{cat_id_to_properties}{$type}{$cat_id}{$property} = 1;
        $self->{property_to_cat_ids}{$type}{$property}{$cat_id} = 1;
    }
}

sub get_influential_properties {
    my ($self, $cat_id) = @_;

    my $proj = $self->proj;
    my @properties = ();
    my %used = ();
    my $parent_id = $cat_id;
    while ($parent_id) {
        for my $property (keys %{$self->{cat_id_to_properties}{&FULL}{$parent_id}}) {
            push @properties, [$property, &FULL, $parent_id] if !$used{$property};
            $used{$property} = 1;
        }
        for my $property (keys %{$self->{cat_id_to_properties}{&FULL_ANTI}{$parent_id}}) {
            push @properties, [$property, &FULL_ANTI, $parent_id] if !$used{$property};
            $used{$property} = 1;
        }
        $parent_id = $proj->get_parent_id($parent_id);
    }
    for my $property (keys %{$self->{cat_id_to_properties}{&SINGLE}{$cat_id}}) {
        push @properties, [$property, &SINGLE, $cat_id];
    }
    for my $property (keys %{$self->{cat_id_to_properties}{&SINGLE_ANTI}{$cat_id}}) {
        push @properties, [$property, &SINGLE_ANTI, $cat_id];
    }
    
    return \@properties;
}

sub get_properties {
    my ($self, $cat_id) = @_;

    my $influential_properties = $self->get_influential_properties($cat_id);
    my %properties = map {
        $_ => 1
    } map {
        $_->[0]
    } grep {
        $_->[1] eq &FULL || $_->[1] eq &SINGLE
    } @$influential_properties;
    $properties{$_} = 0 for grep {$_->[1] eq &SINGLE_ANTI} @$influential_properties;
    
    return [sort grep {$properties{$_}} keys %properties];
}

sub get_categories {
    my ($self, $property, $anti_flag) = @_;

    my $proj = $self->proj;
    my %cat_ids = ();
    my $type = $anti_flag ? FULL_ANTI : FULL;
    for my $cat_id (keys %{$self->{property_to_cat_ids}{$type}{$property}}) {
        $cat_ids{$cat_id} = 1;
        my @bfs_queue = map {$_->{CatID}} @{$proj->get_category_children($cat_id)};
        while (@bfs_queue) {
            my $child_id = shift @bfs_queue;
            next if $self->{property_to_cat_ids}{&FULL}{$property}{$child_id};
            next if $self->{property_to_cat_ids}{&FULL_ANTI}{$property}{$child_id};
            $cat_ids{$child_id} = 1;
            push @bfs_queue, $_ for map {$_->{CatID}} @{$proj->get_category_children($child_id)};
        }
    }
    $type = $anti_flag ? SINGLE_ANTI : SINGLE;
    my $type_anti = $anti_flag ? SINGLE : SINGLE_ANTI;
    $cat_ids{$_} = 1 for keys %{$self->{property_to_cat_ids}{$type}{$property}};
    $cat_ids{$_} = 0 for keys %{$self->{property_to_cat_ids}{$type_anti}{$property}};

    return [sort grep {$cat_ids{$_}} keys %cat_ids];
}

1;
