package Cmds::InterestsMapping;

use utf8;

use base qw(Cmds::Base);
use Encode;
use List::Util qw(min);
use Text::Iconv;
use Data::Dumper;
use URI::Escape;
use Utils::Sys qw(format_number h2sa);
use Time::HiRes qw(gettimeofday tv_interval);
use Utils::Sys qw(md5int);
use Utils::XLS qw(array2xls);

our $interests_mapping_table_name = 'interests_mapping';

sub interests_mapping :CMDH {
    my ($proj, $vars) = @_;
    return {
        title => 'Маппинг для Интересов (Рекламный Дзен)',
        table => $interests_mapping_table_name,
        readonly => 1,
        idfield => 'ID',
        debug => 0,
        # запускаемся без разграничения прав (но с r/o версиями)
        # breqwas@, CATALOGIA-1230, 29.10.2018
        # rights => 'right_edit_interests_mapping',
        fix_sql_problem => 0,
        logchanges => 1,
        delonly => 1,
        default_field_params => { shlist => 1, },
        group_by_add_fields => [ "max(UpdateTime) MaxUpdateTime" ],
        fields => [
            { name => 'mapped_name', title => 'mapped_name (todo: придумать название)', edlist => 1, dbtype => "varchar(255) DEFAULT ''", inlinefilter => {}, }, 
            { name => 'UpdateTime', dbtype => 'timestamp', shlist => 0, autoedit => sub { $proj->dates->cur_date('db_time') }, },
            { extname => 'MaxUpdateTime', dbtype => 'timestamp', title => 'UpdateTime', autoedit => sub { $proj->dates->cur_date('db_time') }, inlinefilter => {}, },
            { extsql => ["select mapped_name, count(*) cc from $interests_mapping_table_name where mapped_name in (?) group by mapped_name", 'mapped_name'],
              extname => 'cc',
            },
            { name => 'categ', title => 'Категория', shlist => 0, wmanual_category => 1, edlist => 1, addform => 1, dbtype => "varchar(255) DEFAULT ''", },
        ],
        filters => [
               { field => 'mapped_name',  name => 'mapped_name (todo: придумать название)', use_other_filters => 1, like => 1, },
        ],
        group_by => 'mapped_name',
        extlists => [
            { cmd => 'interests_mapping_categs', using => '', addelemparams => { 'mapped_name' => 'mapped_name', }, },
            { cmd => 'interests_mapping_categs', act => 'AddForm', using => '', addelemparams => { 'mapped_name' => 'mapped_name', }, },
        ],
        pager => { name => 'p', cc => 50, },
        topmenu => [
            { title => 'Данные', sublist => [
                { 
                    title => 'Залить новый маппинг', name => 'newmapping',
                    filefield => 'mappingfile',
                    action => sub {
                        my ($self, $lst1, $lst2, $prmsh) = @_;
                        my $proj = $self->proj;
                          
                        my $data = $proj->xls2arr($prmsh->{'mappingfile'}, $prmsh->{'mappingfile_filename'});
                    
                        return unless $data && (@{$data->[0]} > 0);
                    
                        $data = $data->[0]; #берем данные только с первой страницы 

                        $data = [ map {
                            my @cols = split(m/\t/, $_);
                            @cols = map { s/(^\s+|\s+$)//g; $_ } @cols;
                            {
                                categ => $cols[0],
                                direct_id => $cols[1],
                                mapped_name => $cols[2],
                            }
                        } @$data ];
                          
                        my @bad_ids;
                        my @unknown_categs;
                        my @good_mappings;
                        for my $item (@$data) {
                            my $direct_id = $proj->categs_tree->get_minicateg_directid($item->{categ});
                            if (!defined($direct_id)) {
                                push @unknown_categs, $item;
                            } elsif ($direct_id != $item->{direct_id}) {
                                push @bad_ids, $item;
                            } else {
                                push @good_mappings, $item;
                            }
                        }

                        # todo: как-то показывать пользователю непустые unknown_categs и bad_ids
                          
                        if (@good_mappings > 1000) {
                            delete $_->{direct_id} for @good_mappings;

                            # переложили старые данные в бэкап
                            $proj->Do_SQL("DROP TABLE IF EXISTS ${interests_mapping_table_name}_old_data");
                            $proj->Do_SQL("CREATE TABLE ${interests_mapping_table_name}_old_data LIKE $interests_mapping_table_name");
                            $proj->Do_SQL("INSERT INTO ${interests_mapping_table_name}_old_data SELECT * FROM $interests_mapping_table_name");

                            # почистили текущую таблицу, добавили новые данные
                            $proj->Do_SQL("DELETE FROM $interests_mapping_table_name");
                            $proj->dbtable($interests_mapping_table_name)->Add(\@good_mappings);

                            # вернули старые времена обновления для строк, у которых маппинг не поменялся
                            # update interests_mapping new left join interests_mapping_old_data old using(categ) set new.UpdateTime = if(old.mapped_name = new.mapped_name, old.UpdateTime, new.UpdateTime)
                            $proj->Do_SQL("
                                update ${interests_mapping_table_name} new
                                left join ${interests_mapping_table_name}_old_data old using(categ)
                                set
                                    new.UpdateTime = if(
                                        old.mapped_name = new.mapped_name,
                                        old.UpdateTime,
                                        new.UpdateTime
                                    )
                            ");
                        }
                    },
                },
                { title => 'Выгрузить соответствие в XLS', url => '?cmd=interests_mapping_xls', },
                { title => 'Список категорий с маппингами', url => '?cmd=interests_mapping_categsinf', },
            ] },
        ],
    };
}

sub interests_mapping_r :CMDH {
    my ($proj, $vars) = @_;
    my $hh = interests_mapping($proj, $vars);
    delete($hh->{$_}) for qw(rights);
    $hh->{topmenu} = [
            { title => 'Данные', sublist => [
                { title => 'Выгрузить соответствие в XLS', url => '?cmd=interests_mapping_xls', },
                { title => 'Список категорий с маппингами', url => '?cmd=interests_mapping_categsinf_r', },
            ] },
    ];
    $hh->{extlists}[0]{cmd} = 'interests_mapping_categs_r';
    delete $hh->{extlists}[1];
    return $hh;
}

sub interests_mapping_categs :CMDH {
    return {
        table => 'interests_mapping',
        readonly => 1,
        # запускаемся без разграничения прав (но с r/o версиями)
        # breqwas@, CATALOGIA-1230, 29.10.2018
        # rights => 'right_edit_interests_mapping',
        idfield => 'ID',
        debug => 0,
        save_button => { title => 'Добавить категорию', right => 1, },
        show_del => 1,
        delonly => 1,
        compact_inline_add => 1,
        default_field_params => { shlist => 1, },
        order_by => "SUBSTRING_INDEX(categ, ' _ ', -1), LENGTH(categ)",
        logchanges => 1,
        fields => [
            { name => 'mapped_name', addform => 1, shlist => 0, ftype=>'hidden', }, 
            { name => 'categ', title => 'Категория', edlist => 1, showmacro => 'catname2link', ftype => 'typeahead', 
                  typeahead => sub {
                      my ($proj, $text) = @_;
                      my $list = $proj->search_categs($text);
                      return [ map { $_->{'CategoryName'} } @$list ];
                  },
            }, 
        ],
        select_elems => { binary => 0, right => 0, },

        add_filter => { 'categ !=' => '' },
        pager => { name => 'p', cc => 20, },
    };
}

sub interests_mapping_categs_r :CMDH {
    my ($proj, $vars) = @_;
    my $hh = interests_mapping_categs($proj, $vars);
    delete($hh->{$_}) for qw(bottom_actions show_del delonly compact_inline_add select_elems rights);
    return $hh;
}

sub interests_mapping_xls :CMD {
    my ($proj, $vars) = @_;

    my $list = $proj->List_SQL("select categ, mapped_name from interests_mapping order by mapped_name, categ");
    $list = [ map {[
        $_->{categ},
        $proj->categs_tree->get_minicateg_directid($_->{categ}),
        $_->{mapped_name},
    ]} @$list ];
    
    $vars->{'_return_real_xls'} = 'd_catalogia_interests_mapping_mapping_'.$proj->dates->cur_date('db').'.xls';
    $vars->{text} = array2xls($list); 
}

sub interests_mapping_categsinf :CMDH {
    return {
        table => 'interests_mapping',
        title => 'Соответствие категорий и маппингов',
        # rights => 'right_edit_interests_mapping',
        readonly => 1,
        idfield => 'ID',
        order_by => "SUBSTRING_INDEX(categ, ' _ ', -1), LENGTH(categ)",
        logchanges => 1,
        default_inlinefilter_params => {
            group_by_add_fields => ['count(*) tt', ],
            fields => [
                { name => 'tt', title => 'count', shlist => 1,   inlinefilter => { },  },
            ],
        },
        default_field_params => { shlist => 1, },
        fields => [
            { name => 'categ', edlist => 1, showmacro => 'catname2link', inlinefilter => { group => 1 }, }, 
            { name => 'mapped_name', addform => 1, shlist => 1, ftype=>'hidden', inlinefilter => { group => 1 }, }, 
            { name => 'UpdateTime', inlinefilter => {}, },
        ],
        filters => [
               { field => 'categ', name => 'categ', like => 1, },
        ],
        pager => { name => 'p', cc => 50, },
        topmenu => [
            { title => 'Данные', sublist => [
                { title => 'Выгрузить соответствие в XLS', url => '?cmd=interests_mapping_xls', },
                { title => 'Маппинг для Интересов', url => '?cmd=interests_mapping', },
            ] },
        ],
    };
}

sub interests_mapping_categsinf_r :CMDH {
    my ($proj, $vars) = @_;
    my $hh = interests_mapping_categsinf($proj, $vars);
    $hh->{topmenu} = [
            { title => 'Данные', sublist => [
                { title => 'Выгрузить соответствие в XLS', url => '?cmd=interests_mapping_xls', },
                { title => 'Маппинг для Интересов', url => '?cmd=interests_mapping_r', },
            ] },
    ];
    delete($hh->{$_}) for qw(rights);
    return $hh;
}


1;
