package Cmds::MediaGroups;

use utf8;

use base qw(Cmds::Base);
use Encode;
use List::Util qw(min);
use Text::Iconv;
use Data::Dumper;
use URI::Escape;
use Utils::Sys qw(format_number h2sa);
use Time::HiRes qw(gettimeofday tv_interval);
use Utils::Sys qw(md5int);
use Utils::XLS qw(array2xls array2xlsx xls2array xlsx2array xls_edit_line xls_lines_list);

sub del_virt_pref { my $t = $_[0]; $t =~ s/^.+ _ //g; return $t }

our $mediagroups_table_name = 'categs_mediagroups';
#our $mediagroups_table_name = 'test_categs_mediagroups';

sub mediagroups :CMDH {
    my ($proj, $vars) = @_;
    return {
        title => 'Группы категорий для аналитических отчётов (MediaGroups)',
        table => $mediagroups_table_name,
        readonly => 1,
        idfield => 'ID',
        debug => 0,
        rights => 'right_edit_mediagroups',
        #compact_inline_add => 1,
        fix_sql_problem => 0,
        logchanges => 1,
        NN => 1,
        #group_by => 'Category',
        delonly => 1,
        default_field_params => { shlist => 1, },
        group_by_add_fields => [ "max(UpdateTime) MaxUpdateTime" ],
        fields => [
            { name => 'mediagroup', title => 'Группа категорий', edlist => 1, dbtype => "varchar(255) DEFAULT ''", inlinefilter => {}, },
            { name => 'UpdateTime', dbtype => 'timestamp', shlist => 0, autoedit => sub { $proj->dates->cur_date('db_time') }, },
            { extname => 'MaxUpdateTime', dbtype => 'timestamp', title => 'UpdateTime', autoedit => sub { $proj->dates->cur_date('db_time') }, inlinefilter => {}, },
            { name => 'virt', title => 'Виртуальные категорий', edlist => 1, shlist => 0, dbtype => "varchar(255) DEFAULT ''",
                  autoedit => sub { my ($proj, $h) = @_; return $h->{ categ } =~ / _ / ? 'yes' : 'no' },
            },
            { extsql => ['select mediagroup, count(*) cc from '.$mediagroups_table_name.' where mediagroup in (?) group by mediagroup', 'mediagroup'],
              extname => 'cc',
            },
            { name => 'categ', title => 'Категория', shlist => 0, wmanual_category => 1, edlist => 1, addform => 1, dbtype => "varchar(255) DEFAULT ''", },
            #{ name => 'UserState', show_good_bad => 1, dbtype => "varchar(255) DEFAULT ''", ftype=>'hidden', disable_add => '1', addform => 0, },
        ],
        filters => [
               { field => 'mediagroup',  name => 'Группа категорий', use_other_filters => 1, like => 1, },
               { field => 'virt', name => 'Виртуальные', grp => 1, selectnames => { 'yes' => 'виртуальные', 'no' => 'не виртульные' }, },
        ],
        group_by => 'mediagroup',
        default_filter => { virt => 'no', },
        extlists => [
            #{ cmd => 'mediagroups_categs', act => 'AddForm', using => '', addelemparams => { 'mediagroup' => 'mediagroup', }, },
            { cmd => 'mediagroups_categs', using => '', addelemparams => { 'mediagroup' => 'mediagroup', }, addfilterparams => { 'flt_virt' => 'virt', } },
        ],
        pager => { name => 'p', cc => 50, },
        topmenu => [
            { title => 'Данные', sublist => [
                {
                      title => 'Залить новый маппинг', name => 'newmapping',
                      filefield => 'mappingfile',
                      action => sub {
                          my ($self, $lst1, $lst2, $prmsh) = @_;
                          my $proj = $self->proj;
                          #my $h = { MediaGroup => $prmsh->{NewGroup} };
                          #my @arr = map { [  $_, $h ] } split ',', $lst1;
                          ##$self->dtact_multiedit(\@arr);
                          ##$proj->dd('FFFF');
                          ##$proj->dd($proj->form, $prmsh->{'mappingfile_filename'});
                          #$proj->dd($prmsh->{'mappingfile_filename'});
                          ##print '['.$prmsh->{'mappingfile'}.']';
                          ##$proj->dd($proj->xls2arr($prmsh->{'mappingfile'}, $prmsh->{'mappingfile_filename'}));

                          my $data = $proj->xls2arr($prmsh->{'mappingfile'}, $prmsh->{'mappingfile_filename'});

                          return unless $data && (@{$data->[0]} > 0);

                          $data = $data->[0]; #берем данные только с первой страницы

                          #my %mpg = map { $_->[0] => $_->[1] } map  { [ split( "\t", $_) ] } grep { !/Article/ } @$data;
                          #У одной категории может быть несколько медиагрупп
                          my %mpg = ();
                          push( @{$mpg{ $_->[0] } ||= []}, $_->[1] ) for map  { [ split( "\t", $_) ] } grep { !/Article/ } @$data;

                          #$proj->dd(\%mpg);

                          my @arr = map { { categ => $_, mediagroup => ($mpg{ $_ } || $mpg{ del_virt_pref($_) } || ['UNKNOWN']), virt => ( / _ / ? 'yes' : 'no' ), } }
                              grep {! /^\./}
                              map { $_->{'CategoryName'} }
                              @{ $proj->categories_dict->List( {Language => 'ru', }, ['CategoryName'] )};

                          #Раскрываем массивы медиагрупп в плоский список
                          my @narr = ();
                          for my $pr (@arr){
                              for my $mg (@{$pr->{mediagroup}}){
                                  my %h = %$pr;
                                  $h{mediagroup} = $mg;
                                  push(@narr, \%h);
                              }
                          }
                          @arr = @narr;

                          #$proj->dd(\@arr);
                          #return;

                          if(@arr > 1000){
                              $proj->Do_SQL('DROP TABLE '.$mediagroups_table_name.'_old_data');
                              $proj->Do_SQL('CREATE TABLE IF NOT EXISTS '.$mediagroups_table_name.'_old_data LIKE '.$mediagroups_table_name);
                              $proj->Do_SQL('INSERT INTO '.$mediagroups_table_name.'_old_data SELECT * FROM '.$mediagroups_table_name);
                              $proj->Do_SQL('DELETE FROM '.$mediagroups_table_name);
                              $proj->dbtable($mediagroups_table_name)->Add(\@arr);
                          }
                          #$proj->dd('FFF'. @$data);

                      },
                },
                { title => 'Выгрузить соответствие в XLS', url => '?cmd=mediagroups_xls', },
                { title => 'Список категорий с группами', url => '?cmd=mediagroups_categsinf', },
                { title => 'Подавление категорий', url => '?cmd=mediagroups_fix', },
            ] },
        ],
    };
}


sub mediagroups_r :CMDH {
    my ($proj, $vars) = @_;
    my $hh = mediagroups($proj, $vars);
    #delete($hh->{$_}) for qw(topmenu);
    delete($hh->{$_}) for qw(rights);
    $hh->{topmenu} = [
            { title => 'Данные', sublist => [
                { title => 'Выгрузить соответствие в XLS', url => '?cmd=mediagroups_xls', },
                { title => 'Список категорий с группами', url => '?cmd=mediagroups_categsinf_r', },
            ] },
    ];
    $hh->{extlists}[0]{cmd} = 'mediagroups_categs_r';
    return $hh;
}

sub mediagroups_categs :CMDH {
    #my ($proj, $vars) = @_;
    #$proj->dd($proj->form);
    return {
        table => $mediagroups_table_name,
        readonly => 1,
        rights => 'right_edit_mediagroups',
        idfield => 'ID',
        debug => 0,
        save_button => { title => 'Добавить категорию', right => 1, },
        #fix_sql_problem => 1,
        #group_by => 'Category',
        show_del => 1,
        delonly => 1,
        compact_inline_add => 1,
        default_field_params => { shlist => 1, },
        order_by => "SUBSTRING_INDEX(categ, ' _ ', -1), LENGTH(categ)",
        logchanges => 1,
#        show_sublist_inline_add => 1,
        fields => [
            #{ name => 'ID', },
            #{ name => 'UserState', show_good_bad => 1, ftype=>'hidden', disable_add => '1', addform => 1, },
            { name => 'mediagroup', addform => 1, shlist => 0, ftype=>'hidden', },
            { name => 'categ', title => 'Категория', edlist => 1, showmacro => 'catname2link', },
            { name => 'virt', addform => 1,  title => 'Виртуальные категорий', edlist => 1, shlist => 0, dbtype => "varchar(255) DEFAULT ''",
                  autoedit => sub { my ($proj, $h) = @_; return $h->{ categ } =~ / _ / ? 'yes' : 'no' },
            },
            #{ title => 'EEEEE', extname => 'sss', shlist => 1, showmacroel => 'show_list_inline_checkbox', },
            #{ name => 'categ', manual_category => 1, },
        ],
        filters => [
               { field => 'virt', name => 'virt', },
        ],
        default_filter => { virt => '     ', },
        select_elems => { binary => 0, right => 0, },
        bottom_actions => [
            { title => 'Перенести категории', name => 'movecategs', action => sub {
                    my ($self, $lst1, $lst2, $prmsh) = @_;
                    my @ids = split ',', $lst1;
                    if(@ids){
                        $self->proj->dbtable($mediagroups_table_name, 'ID')->Edit( \@ids, { mediagroup => $prmsh->{'Name'} } );
                    }
                },
                inline => 1,
                fields => [
                    { name => "Name", title => 'Группа', edlist => 1, typeaheadfield => 'mediagroup', },
                ],
                confirm => 'Вы действительно хотите перенести категории?',
            },
        ],
        #select_elems => { buttons => {},  right => 1, },
        add_filter => { 'categ !=' => '' },
        #default_filter => { UserState => '', },
        pager => { name => 'p', cc => 20, },
    };
}

sub mediagroups_categs_r :CMDH {
    my ($proj, $vars) = @_;
    my $hh = mediagroups_categs($proj, $vars);
    delete($hh->{$_}) for qw(bottom_actions show_del delonly compact_inline_add select_elems rights);
    return $hh;
}

#sub mediagroups_xls_old :CMD {
#    my ($proj, $vars) = @_;
#
#    my $list = $proj->List_SQL("select categ, mediagroup from ".$mediagroups_table_name." order by mediagroup, categ");
#    $list = [ map {[ $_->{categ}, $_->{mediagroup} ]} @$list ];
#    sub _real_ctg { my $t = $_[0]; $t =~ s/.+ _ (.+)$/$1 www/; return $t; }
#    $list = [ map {$_->[0]} sort { ($a->[0][1] cmp $b->[0][1]) || ($a->[1] cmp $b->[1]) } map { [$_, _real_ctg($_->[0])] } @$list ];
#
#    $vars->{'_return_real_xls'} = 'd_catalogia_mediagroups_mapping_'.$proj->dates->cur_date('db').'.xls';
#    $vars->{text} = array2xls($list);
#}

sub mediagroups_xls :CMD {
    my ($proj, $vars) = @_;

    my $list = $proj->List_SQL("select categ, mediagroup from ".$mediagroups_table_name." order by mediagroup, categ");
    $list = [ map {[ $_->{categ}, $_->{mediagroup} ]} @$list ];
    sub _real_ctg { my $t = $_[0]; $t =~ s/.+ _ (.+)$/$1 www/; return $t; }
    $list = [ map {$_->[0]} sort { ($a->[0][1] cmp $b->[0][1]) || ($a->[1] cmp $b->[1]) } map { [$_, _real_ctg($_->[0])] } @$list ];

    $vars->{'_return_real_xls'} = 'd_catalogia_mediagroups_mapping_'.$proj->dates->cur_date('db').'.xlsx';
    $vars->{text} = array2xlsx($list);
}

sub mediagroups_categsinf :CMDH {
    return {
        table => $mediagroups_table_name,
        title => 'Соответствие категорий и групп',
        rights => 'right_edit_mediagroups',
        readonly => 1,
        idfield => 'ID',
        order_by => "SUBSTRING_INDEX(categ, ' _ ', -1), LENGTH(categ)",
        logchanges => 1,
        default_inlinefilter_params => {
            group_by_add_fields => ['count(*) tt', ],
            fields => [
                { name => 'tt', title => 'count', shlist => 1,   inlinefilter => { },  },
            ],
        },
        default_field_params => { shlist => 1, },
        fields => [
            { name => 'categ', edlist => 1, showmacro => 'catname2link', inlinefilter => { group => 1 }, },
            { name => 'mediagroup', addform => 1, shlist => 1, ftype=>'hidden', inlinefilter => { group => 1 }, },
            { name => 'UpdateTime', inlinefilter => {}, },
            { name => 'virt', addform => 1,  title => 'Виртуальные категорий', edlist => 1, shlist => 0, dbtype => "varchar(255) DEFAULT ''",
                  autoedit => sub { my ($proj, $h) = @_; return $h->{ categ } =~ / _ / ? 'yes' : 'no' },
                  inlinefilter => {},
            },
        ],
        filters => [
               { field => 'categ', name => 'categ', like => 1, },
               { field => 'virt',  name => 'virt', grp => 1, selectnames => { 'yes' => 'виртуальные', 'no' => 'не виртульные' }, },
        ],
        pager => { name => 'p', cc => 50, },
        topmenu => [
            { title => 'Данные', sublist => [
                { title => 'Выгрузить соответствие в XLS', url => '?cmd=mediagroups_xls', },
                { title => 'Группы категорий', url => '?cmd=mediagroups', },
                { title => 'Подавление категорий', url => '?cmd=mediagroups_fix', },
            ] },
        ],
    };
}

sub mediagroups_categsinf_r :CMDH {
    my ($proj, $vars) = @_;
    my $hh = mediagroups_categsinf($proj, $vars);
    $hh->{topmenu} = [
            { title => 'Данные', sublist => [
                { title => 'Выгрузить соответствие в XLS', url => '?cmd=mediagroups_xls', },
                { title => 'Группы категорий', url => '?cmd=mediagroups_r', },
            ] },
    ];
    delete($hh->{$_}) for qw(rights);
    return $hh;
}

sub mediagroups_fix :CMDH {
    my ($proj, $vars) = @_;

    return {
        table => 'mediagroups_fix',
        title => 'Соответствие категорий и групп',
        rights => 'right_edit_mediagroups',
        readonly => 0,
        idfield => 'ID',
        fix_sql_problem => 1,
        logchanges => 1,
        fields => [
            { name => 'title',  shlist => 1, },
            { name => 'rules',   edlist => 1, shlist => 0, ftype => 'bigtextarea' },
        ],
    };
}


sub brandgroups :CMDH {
    my ($proj, $vars) = @_;
    return {
        title => 'Группы доменов для брендов для аналитических отчётов',
        table => 'brandgroups',
        readonly => 1,
        rights => 'right_edit_mediagroups',
        idfield => 'ID',
        debug => 0,
        compact_inline_add => 1,
        fix_sql_problem => 0,
        logchanges => 1,
        delonly => 1,
        default_field_params => { shlist => 1, },
        group_by_add_fields => [ "max(UpdateTime) MaxUpdateTime" ],
        fields => [
            { name => 'brandgroup', title => 'Бренд', edlist => 1, dbtype => "varchar(255) DEFAULT ''", inlinefilter => {}, },
            { name => 'UpdateTime', dbtype => 'timestamp', shlist => 0, autoedit => sub { $proj->dates->cur_date('db_time') }, },
            { extname => 'MaxUpdateTime', dbtype => 'timestamp', title => 'UpdateTime', inlinefilter => {}, },
            { extsql => ['select brandgroup, count(*) cc from brandgroups where brandgroup in (?) group by brandgroup', 'brandgroup'],
              extname => 'cc',
            },
            { name => 'domain', title => 'Домен', shlist => 0, edlist => 1, addform => 1, dbtype => "varchar(255) DEFAULT ''", },
            { name => 'author', title => 'Автор', edlist => 1, autoedit => sub { $proj->login, } },
            #{ name => 'UserState', show_good_bad => 1, dbtype => "varchar(255) DEFAULT ''", ftype=>'hidden', disable_add => '1', addform => 0, },
        ],
        filters => [
               { field => 'brandgroup',  name => 'Группа категорий', use_other_filters => 1, like => 1, },
        ],
        group_by => 'brandgroup',
        extlists => [
            { cmd => 'brandgroups_domains', act => 'AddForm', using => '', addelemparams => { 'brandgroup' => 'brandgroup', }, },
            { cmd => 'brandgroups_domains', using => '', addelemparams => { 'brandgroup' => 'brandgroup', }, },
        ],
        pager => { name => 'p', cc => 50, },
        data_import_export => { list => [qw{ domain brandgroup author }], export => { sort => 'brandgroup', }, },
        topmenu => [
            { title => 'Данные', sublist => [
                  { title => 'Плоский список доменов и групп', url => '?cmd=brandgroups_domains_all' },
                  { title => 'Лог загрузкок данных', url => '?cmd=brandgroups_old_data' },
            ] },
        ],
    };
}

sub brandgroups_r :CMDH {
    my ($proj, $vars) = @_;
    my $hh = brandgroups($proj, $vars);
    #delete($hh->{$_}) for qw(topmenu);
    delete($hh->{$_}) for qw(rights compact_inline_add data_import_export);
    $hh->{data_import_export} =  { list => [qw{ domain brandgroup author }], export => { sort => 'brandgroup', }, no_import => 1, };
    $hh->{extlists} = [
            { cmd => 'brandgroups_domains_r', using => '', addelemparams => { 'brandgroup' => 'brandgroup', }, },
        ];
    $hh->{topmenu} = [
            { title => 'Данные', sublist => [
                { title => 'Плоский список доменов и групп', url => '?cmd=brandgroups_domains_all_r' },
            ] },
    ];
    return $hh;
}

sub brandgroups_domains :CMDH {
    my ($proj, $vars) = @_;
    #$proj->dd($proj->form);
    return {
        table => 'brandgroups',
        readonly => 1,
        idfield => 'ID',
        rights => 'right_edit_mediagroups',
        debug => 0,
        save_button => { title => 'Добавить домен', right => 1, },
        #fix_sql_problem => 1,
        show_del => 1,
        delonly => 1,
        compact_inline_add => 1,
        default_field_params => { shlist => 1, },
        order_by => "brandgroup",
        logchanges => 1,
#        show_sublist_inline_add => 1,
        fields => [
            { name => 'brandgroup', addform => 1, shlist => 0, ftype=>'hidden', },
            { name => 'domain', title => 'Домен', edlist => 1, },
            { name => 'author', title => 'Автор', edlist => 1, autoedit => sub { $proj->login, } },
        ],
        select_elems => { binary => 0, right => 0, },
        bottom_actions => [
            { title => 'Перенести домены', name => 'movedomains', action => sub {
                    my ($self, $lst1, $lst2, $prmsh) = @_;
                    my @ids = split ',', $lst1;
                    if(@ids){
                        $self->proj->dbtable('brandgroups', 'ID')->Edit( \@ids, { brandgroup => $prmsh->{'Name'} } );
                    }
                },
                inline => 1,
                fields => [
                    { name => "Name", title => 'Группа', edlist => 1, typeaheadfield => 'brandgroup', },
                ],
            },
        ],
        #select_elems => { buttons => {},  right => 1, },
        #default_filter => { UserState => '', },
        pager => { name => 'p', cc => 20, },
    };
}

sub brandgroups_domains_r :CMDH {
    my ($proj, $vars) = @_;
    my $hh = brandgroups_domains($proj, $vars);
    #delete($hh->{$_}) for qw(topmenu);
    delete($hh->{$_}) for qw(rights show_del delonly compact_inline_add bottom_actions select_elems);
    $hh->{topmenu} = [
            { title => 'Данные', sublist => [
                { title => 'Группы доменов', url => '?cmd=brandgroups_r' },
            ] },
    ];
    return $hh;
}

sub brandgroups_domains_all :CMDH {
    return {
        base => 'brandgroups_domains',
        title => 'Плоский список доменов и групп для аналитических отчётов',
        readonly => 1,
        data_import_export => { list => [qw{ domain brandgroup }], export => { sort => 'brandgroup', }, },
        topmenu => [
            { title => 'Данные', sublist => [
                  { title => 'Группы доменов для брендов', url => '?cmd=brandgroups' },
                  { title => 'Лог загрузкок данных', url => '?cmd=brandgroups_old_data' },
            ] },
        ],
        fields => [
            { name => 'domain',     title => 'Домен', shlist => 1, inlinefilter => { group => 1, }, redefine_base => 1, },
            { name => 'brandgroup', title => 'Группа категорий', shlist => 1, inlinefilter => { group => 1, }, redefine_base => 1, },
        ],
        filters => [
               { field => 'domain',  name => 'Домен', use_other_filters => 1, like => 1, },
               { field => 'brandgroup',  name => 'Группа категорий', use_other_filters => 1, like => 1, },
        ],
    };
}

sub brandgroups_domains_all_r :CMDH {
    my ($proj, $vars) = @_;
    return {
        base => 'brandgroups_domains_r',
        title => 'Плоский список доменов и групп для аналитических отчётов',
        readonly => 1,
        topmenu => [
            { title => 'Данные', sublist => [
                  { title => 'Группы доменов для брендов', url => '?cmd=brandgroups_r' },
            ] },
        ],
        fields => [
            { name => 'domain',     title => 'Домен', shlist => 1, inlinefilter => { group => 1, }, redefine_base => 1, },
            { name => 'brandgroup', title => 'Группа категорий', shlist => 1, inlinefilter => { group => 1, }, redefine_base => 1, },
        ],
        filters => [
               { field => 'domain',  name => 'Домен', use_other_filters => 1, like => 1, },
               { field => 'brandgroup',  name => 'Группа категорий', use_other_filters => 1, like => 1, },
        ],
    };
}

sub brandgroups_old_data :CMDH {
    return {
        title => 'Лог загрузкок данных',
        readonly => 1,
        table => 'brandgroups_old_data',
        fields => [
            { name => 'domain',     title => 'Домен', shlist => 1, inlinefilter => { group => 1, }, },
            { name => 'brandgroup', title => 'Группа категорий', shlist => 1, inlinefilter => { group => 1, }, },
            { name => 'UpdateTime', title => 'Попал в лог', shlist => 1, inlinefilter => { group => 1, }, },
        ],
        topmenu => [
            { title => 'Данные', sublist => [
                  { title => 'Группы доменов для брендов', url => '?cmd=brandgroups' },
                  { title => 'Плоский список доменов и групп', url => '?cmd=brandgroups_domains_all', },
            ] },
        ],
        filters => [
               { field => 'domain',  name => 'Домен', like => 1, },
               { field => 'brandgroup',  name => 'Группа категорий', like => 1, },
        ],
        order_by => 'UpdateTime desc',
        pager => { name => 'p', cc => 100, },
    };
}

sub noauth_brandgroups_report :CMD {
    my ($proj, $vars) = @_;
    my $lst = $proj->List_SQL("select * from brandgroups");
    $vars->{text} = join("", map { join("\t", @{$_}{qw{brandgroup domain}})."\n" } @$lst);
    #$proj->dd($proj->form);
}

sub mediagroups_brandgroups :CMDH {
    my ($proj, $vars) = @_;
    return {
        title => 'Группы брендов для индустрий',
        table => 'mediagroups_brandgroups',
        readonly => 1,
        idfield => 'ID',
        debug => 0,
        rights => 'right_edit_mediagroups',
        #compact_inline_add => 1,
        fix_sql_problem => 1,
        logchanges => 1,
        #group_by => 'Category',
        delonly => 1,
        default_field_params => { shlist => 1, },
        group_by_add_fields => [ "max(UpdateTime) MaxUpdateTime" ],
        fields => [
            { name => 'mediagroup', title => 'Индустрия', edlist => 1, dbtype => "varchar(255) DEFAULT ''", inlinefilter => {}, },
            { name => 'UpdateTime', dbtype => 'timestamp', shlist => 0, autoedit => sub { $proj->dates->cur_date('db_time') }, },
            { extname => 'MaxUpdateTime', dbtype => 'timestamp', title => 'UpdateTime', autoedit => sub { $proj->dates->cur_date('db_time') }, inlinefilter => {}, },
            { name => 'virt', title => 'Виртуальные категорий', edlist => 1, shlist => 0, dbtype => "varchar(255) DEFAULT ''",
                  autoedit => sub { my ($proj, $h) = @_; return $h->{ categ } =~ / _ / ? 'yes' : 'no' },
            },
            { extsql => ['select mediagroup, count(*) cc from mediagroups_brandgroups where mediagroup in (?) group by mediagroup', 'mediagroup'],
              extname => 'cc',
            },
            { name => 'brandgroup', title => 'Группа брендов', shlist => 0, wmanual_category => 1, edlist => 1, addform => 1, dbtype => "varchar(255) DEFAULT ''", },
            #{ name => 'UserState', show_good_bad => 1, dbtype => "varchar(255) DEFAULT ''", ftype=>'hidden', disable_add => '1', addform => 0, },
        ],
        filters => [
               { field => 'mediagroup',  name => 'Индустрия', use_other_filters => 1, like => 1, },
#              { field => 'virt', name => 'Виртуальные', grp => 1, selectnames => { 'yes' => 'виртуальные', 'no' => 'не виртульные' }, },
        ],
        group_by => 'mediagroup',
        default_filter => { virt => 'no', },
        extlists => [
            { cmd => 'brandgroups_mediagroups_sublist', using => '', addelemparams => { 'mediagroup' => 'mediagroup', }, addfilterparams => { 'flt_virt' => 'virt', } },
        ],
        pager => { name => 'p', cc => 50, },
        topmenu => [
            { title => 'Данные', sublist => [
                {
                      title => 'Залить новый маппинг', name => 'newmapping',
                      filefield => 'mappingfile',
                      action => sub {
                          my ($self, $lst1, $lst2, $prmsh) = @_;
                          my $proj = $self->proj;

                          my $data = $proj->xls2arr($prmsh->{'mappingfile'}, $prmsh->{'mappingfile_filename'});

#$self->proj->dd($data, $prmsh->{'mappingfile'}, $prmsh->{'mappingfile_filename'});
#$self->proj->dd($data,  $prmsh->{'mappingfile_filename'});
                          return unless $data && (@{$data->[0]} > 0);

                          $data = $data->[0]; #берем данные только с первой страницы

                          #my %mpg = map { $_->[0] => $_->[1] } map  { [ split( "\t", $_) ] } grep { !/Article/ } @$data;
                          #У одной категории может быть несколько медиагрупп
                          my %mpg = ();
                          push( @{$mpg{ $_->[0] } ||= []}, $_->[1] ) for map  { [ split( "\t", $_) ] } grep { !/Article/ } @$data;

                          #$proj->dd(\%mpg);

                          my @arr = map { { brandgroup => $_, mediagroup => ($mpg{ $_ } || $mpg{ del_virt_pref($_) } || ['UNKNOWN']), virt => ( / _ / ? 'yes' : 'no' ), } }
                              grep {! /^\./}
                              map { $_->{'brandgroup'} }
                              @{ $proj->dbtable('brandgroups', 'ID')->List2( filter => {}, gfields => ['brandgroup'], group_by => 'brandgroup', )};

                          #$proj->dd(\@arr);

                          #Раскрываем массивы медиагрупп в плоский список
                          my @narr = ();
                          for my $pr (@arr){
                              for my $mg (@{$pr->{mediagroup}}){
                                  my %h = %$pr;
                                  $h{mediagroup} = $mg;
                                  push(@narr, \%h);
                              }
                          }
                          @arr = @narr;

                          #$proj->dd(\@arr);
                          #return;

                          if(@arr > 1){
                              $proj->Do_SQL('DROP TABLE mediagroups_brandgroups_old_data');
                              $proj->Do_SQL('CREATE TABLE IF NOT EXISTS mediagroups_brandgroups_old_data LIKE mediagroups_brandgroups');
                              $proj->Do_SQL('INSERT INTO mediagroups_brandgroups_old_data SELECT * FROM mediagroups_brandgroups');
                              $proj->Do_SQL('DELETE FROM mediagroups_brandgroups');
                              $proj->dbtable('mediagroups_brandgroups')->Add(\@arr);
                          }
                          #$proj->dd('FFF'. @$data);

                      },
                },
                { title => 'Выгрузить соответствие в XLS', url => '?cmd=mediagroups_brandgroups_xls', },
                { title => 'Плоский список брендов и медиагрупп', url => '?cmd=mediagroups_brandgroups_all' },
#                { title => 'Список категорий с группами', url => '?cmd=mediagroups_categsinf', },
#                { title => 'Подавление категорий', url => '?cmd=mediagroups_fix', },
            ] },
        ],
    };
}

sub brandgroups_mediagroups_sublist :CMDH {
    #my ($proj, $vars) = @_;
    #$proj->dd($proj->form);
    return {
        table => 'mediagroups_brandgroups',
        readonly => 1,
        rights => 'right_edit_mediagroups',
        idfield => 'ID',
        debug => 0,
        save_button => { title => 'Добавить группу брендов', right => 1, },
        #fix_sql_problem => 1,
        #group_by => 'Category',
        show_del => 1,
        delonly => 1,
        compact_inline_add => 1,
        default_field_params => { shlist => 1, },
#        order_by => "SUBSTRING_INDEX(categ, ' _ ', -1), LENGTH(categ)",
        logchanges => 1,
#        show_sublist_inline_add => 1,
        fields => [
            #{ name => 'ID', },
            #{ name => 'UserState', show_good_bad => 1, ftype=>'hidden', disable_add => '1', addform => 1, },
            { name => 'mediagroup', addform => 1, shlist => 0, ftype=>'hidden', },
            { name => 'brandgroup', title => 'Группа брендов', edlist => 1, },
            { name => 'virt', addform => 1,  title => 'Виртуальные категорий', edlist => 1, shlist => 0, dbtype => "varchar(255) DEFAULT ''",
                  autoedit => sub { my ($proj, $h) = @_; return $h->{ brandgroup } =~ / _ / ? 'yes' : 'no' },
            },
            #{ title => 'EEEEE', extname => 'sss', shlist => 1, showmacroel => 'show_list_inline_checkbox', },
            #{ name => 'categ', manual_category => 1, },
        ],
        filters => [
               { field => 'virt', name => 'Виртуальные', grp => 1, selectnames => { 'yes' => 'виртуальные', 'no' => 'не виртульные' }, },
               #{ field => 'virt', name => 'virt',  },
        ],
#        default_filter => { virt => '     ', },
        select_elems => { binary => 0, right => 0, },
        bottom_actions => [
            { title => 'Перенести категории', name => 'movebrand', action => sub {
                    my ($self, $lst1, $lst2, $prmsh) = @_;
                    my @ids = split ',', $lst1;
                    if(@ids){
                        $self->proj->dbtable('mediagroups_brandgroups', 'ID')->Edit( \@ids, { mediagroup => $prmsh->{'Name'} } );
                    }
                },
                inline => 1,
                fields => [
                    { name => "Name", title => 'Группа', edlist => 1, typeaheadfield => 'mediagroup', },
                ],
                confirm => 'Вы действительно хотите перенести категории?',
            },
        ],
        #select_elems => { buttons => {},  right => 1, },
        add_filter => { 'brandgroup !=' => '' },
        #default_filter => { UserState => '', },
        pager => { name => 'p', cc => 20, },
    };
}

sub mediagroups_brandgroups_all :CMDH {
    return {
        base => 'brandgroups_mediagroups_sublist',
        title => 'Плоский список групп брендов и медиагрупп',
        readonly => 1,
        data_import_export => { list => [qw{ brandgroup mediagroup }], export => { sort => 'mediagroup', }, },
        topmenu => [
            { title => 'Данные', sublist => [
                  { title => 'Группы брендов для медиагрупп', url => '?cmd=mediagroups_brandgroups' },
            ] },
        ],
        fields => [
            { name => 'brandgroup',     title => 'Бренд', shlist => 1, inlinefilter => { group => 1, }, redefine_base => 1, },
            { name => 'mediagroup', title => 'Медиагруппа', shlist => 1, inlinefilter => { group => 1, }, redefine_base => 1, },
        ],
        filters => [
               { field => 'brandgroup',  name => 'Бренд', use_other_filters => 1, like => 1, },
               { field => 'mediagroup',  name => 'Медиагруппа', use_other_filters => 1, like => 1, },
        ],
        order_by => 'brandgroup',
    };
}

sub mediagroups_brandgroups_xls :CMD {
    my ($proj, $vars) = @_;

    my $list = $proj->List_SQL("select brandgroup, mediagroup from mediagroups_brandgroups order by mediagroup, brandgroup");
    $list = [ map {[ $_->{brandgroup}, $_->{mediagroup} ]} @$list ];

    $vars->{'_return_real_xls'} = 'd_catalogia_mediagroups_brandgroups_mapping_'.$proj->dates->cur_date('db').'.xls';
    $vars->{text} = array2xlsx($list);
}

sub noauth_mediagroups_brandgroups_report :CMD {
    my ($proj, $vars) = @_;
    my $lst = $proj->List_SQL("select * from mediagroups_brandgroups");
    $vars->{text} = join("", map { join("\t", @{$_}{qw{mediagroup brandgroup}})."\n" } @$lst);
    #$proj->dd($proj->form);
}


sub mediagroups_second_level :CMDH {
    my ($proj, $vars) = @_;
    return {
        title => 'Второй уровень медиагрупп',
        table => 'mediagroups_second_level',
        readonly => 1,
        idfield => 'ID',
        debug => 0,
        rights => 'right_edit_mediagroups',
        #compact_inline_add => 1,
        fix_sql_problem => 1,
        logchanges => 1,
        #group_by => 'Category',
        delonly => 1,
        default_field_params => { shlist => 1, },
        group_by_add_fields => [ "max(UpdateTime) MaxUpdateTime" ],
        fields => [
            { name => 'level2', edlist => 1, dbtype => "varchar(255) DEFAULT ''", inlinefilter => {}, },
            { name => 'UpdateTime', dbtype => 'timestamp', shlist => 0, autoedit => sub { $proj->dates->cur_date('db_time') }, },
            { name => 'virt', title => 'Виртуальные категорий', edlist => 1, shlist => 0, dbtype => "varchar(255) DEFAULT ''",
                  autoedit => sub { my ($proj, $h) = @_; return $h->{ categ } =~ / _ / ? 'yes' : 'no' },
            },
            { extname => 'MaxUpdateTime', dbtype => 'timestamp', title => 'UpdateTime', autoedit => sub { $proj->dates->cur_date('db_time') }, inlinefilter => {}, },
            { extsql => ['select level2, count(*) cc from mediagroups_second_level where level2 in (?) group by level2', 'level2'],
              extname => 'cc',
            },
            { name => 'mediagroup', shlist => 0, wmanual_category => 1, edlist => 1, addform => 1, dbtype => "varchar(255) DEFAULT ''", },
            #{ name => 'UserState', show_good_bad => 1, dbtype => "varchar(255) DEFAULT ''", ftype=>'hidden', disable_add => '1', addform => 0, },
        ],
        filters => [
               { field => 'mediagroup',  name => 'Медиагруппа', use_other_filters => 1, like => 1, },
#              { field => 'virt', name => 'Виртуальные', grp => 1, selectnames => { 'yes' => 'виртуальные', 'no' => 'не виртульные' }, },
        ],
        group_by => 'level2',
        default_filter => { virt => 'no', },
        extlists => [
            { cmd => 'mediagroups_second_level_sublist', using => '', addelemparams => { 'level2' => 'level2', }, addfilterparams => { 'flt_virt' => 'virt', } },
        ],
        pager => { name => 'p', cc => 50, },
        topmenu => [
            { title => 'Данные', sublist => [
                {
                      title => 'Залить новый маппинг', name => 'newmapping',
                      filefield => 'mappingfile',
                      action => sub {
                          my ($self, $lst1, $lst2, $prmsh) = @_;
                          my $proj = $self->proj;

                          my $crnt_table = 'mediagroups_second_level';

                          my $data = $proj->xls2arr($prmsh->{'mappingfile'}, $prmsh->{'mappingfile_filename'});

#$self->proj->dd($data, $prmsh->{'mappingfile'}, $prmsh->{'mappingfile_filename'});
#$self->proj->dd($data,  $prmsh->{'mappingfile_filename'});
                          return unless $data && (@{$data->[0]} > 0);

                          $data = $data->[0]; #берем данные только с первой страницы

                          #my %mpg = map { $_->[0] => $_->[1] } map  { [ split( "\t", $_) ] } grep { !/Article/ } @$data;
                          #У одной категории может быть несколько медиагрупп
                          my %mpg = ();
                          push( @{$mpg{ $_->[0] } ||= []}, $_->[1] ) for map  { [ split( "\t", $_) ] } grep { !/Article/ } @$data;

                          #$proj->dd(\%mpg);

                          sub clear_mediagroup_text { my $t = $_[0] ; $t =~ s/\s+\(РАЗНОЕ\)//; return $t;}

                          my @arr = map { { mediagroup => $_, level2 => ($mpg{ $_ } || $mpg{ del_virt_pref($_) } || $mpg{ clear_mediagroup_text($_) } || ['UNKNOWN']), virt => ( / _ / ? 'yes' : 'no' ), } }
                              grep {! /^\./}
                              map { $_->{'mediagroup'} }
                              @{ $proj->dbtable($mediagroups_table_name, 'ID')->List2( filter => {}, gfields => ['mediagroup'], group_by => 'mediagroup', )};

                          #$proj->dd(\@arr);

                          #exit;

                          #Раскрываем массивы медиагрупп в плоский список
                          my @narr = ();
                          for my $pr (@arr){
                              for my $mg (@{$pr->{level2}}){
                                  my %h = %$pr;
                                  $h{level2} = $mg;
                                  push(@narr, \%h);
                              }
                          }
                          @arr = @narr;

                          #$proj->dd(\@arr);
                          #return;

                          if(@arr > 1){
                              $proj->Do_SQL('DROP TABLE '.$crnt_table.'_old_data');
                              $proj->Do_SQL('CREATE TABLE IF NOT EXISTS '.$crnt_table.'_old_data LIKE '.$crnt_table);
                              $proj->Do_SQL('INSERT INTO '.$crnt_table.'_old_data SELECT * FROM '.$crnt_table);
                              $proj->Do_SQL('DELETE FROM '.$crnt_table);
                              $proj->dbtable($crnt_table)->Add(\@arr);
                          }
                          #$proj->dd('FFF'. @$data);

                      },
                },
                { title => 'Выгрузить соответствие в XLS', url => '?cmd=mediagroups_second_level_xls', },
#                { title => 'Плоский список брендов и медиагрупп', url => '?cmd=mediagroups_brandgroups_all' },
#                { title => 'Список категорий с группами', url => '?cmd=mediagroups_categsinf', },
#                { title => 'Подавление категорий', url => '?cmd=mediagroups_fix', },
            ] },
        ],
    };
}

sub mediagroups_second_level_sublist :CMDH {
    #my ($proj, $vars) = @_;
    #$proj->dd($proj->form);
    return {
        table => 'mediagroups_second_level',
        readonly => 1,
        rights => 'right_edit_mediagroups',
        idfield => 'ID',
        debug => 0,
        save_button => { title => 'Добавить медиагруппу', right => 1, },
        #fix_sql_problem => 1,
        #group_by => 'Category',
        show_del => 1,
        delonly => 1,
        compact_inline_add => 1,
        default_field_params => { shlist => 1, },
        order_by => "SUBSTRING_INDEX(mediagroup, ' _ ', -1), LENGTH(mediagroup)",
        logchanges => 1,
#        show_sublist_inline_add => 1,
        fields => [
            #{ name => 'ID', },
            #{ name => 'UserState', show_good_bad => 1, ftype=>'hidden', disable_add => '1', addform => 1, },
            { name => 'level2', addform => 1, shlist => 0, ftype=>'hidden', },
            { name => 'mediagroup', edlist => 1, },
            { name => 'virt', addform => 1,  title => 'Виртуальные медиагруппы', edlist => 1, shlist => 0, dbtype => "varchar(255) DEFAULT ''",
                  autoedit => sub { my ($proj, $h) = @_; return $h->{ mediagroup } =~ / _ / ? 'yes' : 'no' },
            },
            #{ title => 'EEEEE', extname => 'sss', shlist => 1, showmacroel => 'show_list_inline_checkbox', },
            #{ name => 'categ', manual_category => 1, },
        ],
        filters => [
               { field => 'virt', name => 'virt', },
        ],
        default_filter => { virt => '     ', },
        select_elems => { binary => 0, right => 0, },
        bottom_actions => [
            { title => 'Перенести медиагруппы', name => 'movecategs', action => sub {
                    my ($self, $lst1, $lst2, $prmsh) = @_;
                    my @ids = split ',', $lst1;
                    if(@ids){
                        $self->proj->dbtable('mediagroups_second_level', 'ID')->Edit( \@ids, { level2 => $prmsh->{'Name'} } );
                    }
                },
                inline => 1,
                fields => [
                    { name => "Name", title => 'Группа', edlist => 1, typeaheadfield => 'level2', },
                ],
                confirm => 'Вы действительно хотите перенести медиагруппу?',
            },
        ],
        #select_elems => { buttons => {},  right => 1, },
        add_filter => { 'mediagroup !=' => '' },
        #default_filter => { UserState => '', },
        pager => { name => 'p', cc => 20, },
    };
}

sub mediagroups_second_level_xls :CMD {
    my ($proj, $vars) = @_;

    my $list = $proj->List_SQL("select mediagroup, level2 from mediagroups_second_level order by level2, mediagroup");
    $list = [ map {[ $_->{mediagroup}, $_->{level2} ]} @$list ];

    $vars->{'_return_real_xls'} = 'd_catalogia_mediagroups_second_level_mapping_'.$proj->dates->cur_date('db').'.xls';
    $vars->{text} = array2xlsx($list);
}

1;
