package Cmds::NephewRelationBlock;

use strict;
use utf8;
use open ':utf8';

use base qw(Cmds::BaseRelationBlock);

use List::Util qw(min);

__PACKAGE__->mk_accessors(qw(
    cat_id
    proj
));

sub get_image_categories {
    my ($self, $lang) = @_;
    
    my ($cat_id, $proj) = @{$self}{qw(cat_id proj)};
    return $proj->get_image_nephews($cat_id, $lang);
}

sub get_domain_categories {
    my ($self, $lang) = @_;
    
    my ($cat_id, $proj) = @{$self}{qw(cat_id proj)};
    return $proj->get_domain_nephews($cat_id, $lang);
}

sub add_relation {
    my ($self, @cat_ids) = @_;

    my ($cat_id, $proj) = @{$self}{qw(cat_id proj)};
    $proj->add_user_phrase(
        $cat_id,
        $_,
        'ru',
        'AddNephew'
    ) for @cat_ids;
}

sub delete_relation {
    my ($self, @cat_ids) = @_;

    my ($cat_id, $proj) = @{$self}{qw(cat_id proj)};
    $proj->add_user_phrase(
        $cat_id,
        $_,
        'ru',
        'DeleteNephew'
    ) for @cat_ids;
}

1;
