package Cmds::Pages;

use strict;

use utf8;

use base qw(Cmds::Base);
use Encode;
use List::Util qw(min);
use Text::Iconv;
use Data::Dumper;
use URI::Escape;
use Utils::Sys qw(format_number h2sa uniq);
use Time::HiRes qw(gettimeofday tv_interval);
use Utils::Sys qw(md5int);
use Utils::Array qw(array_intersection);
use JSON qw(to_json from_json);
use List::Util 'shuffle';
use CatalogiaMediaProject;
use open ":utf8";


sub page_info : CMD {
    my ($proj, $vars) = @_;

    my $form = $proj->form;
    my $tblurlname = $proj->dbtable('url_name_types');

    if(defined($form->{'vtype'})){
        my $text = $form->{id};
        $text =~ s///;
        $tblurlname->Add({ text => $form->{id}, vtype => $form->{'vtype'}, }, {replace => 1,});
        $vars->{'text'} = 'Ok';
        return;
    }

    $BM::Pages::Page::url_name_types_table = 'url_name_types';
    my $data = {};
    my $url = $form->{url};
    if($url){
        if( $url =~ /^(http:\/\/)?[^\/\?]+$/ ){ #Урл сайта
            my $s = $proj->site($url);
            $data->{site} = $url;
            #my @arr = grep { ! /^-/ } qw{ mainpage domain -menu_filter_hash menu_pages mainpage_subpages };
            my @arr = grep { ! /^-/ } qw{ mainpage domain mainpage_subpages menu_filter_hash };
            for my $f (@arr){
                $data->{$f} = $s->$f();
            }
            #$data->{'first_level'} = $s->menu_pages->fix_the_deep_problem;
            #$data->{'get_mainpage_freqhash_suburls'} = $s->mainpage->get_mainpage_freqhash_suburls;
        }else{ #Обычный урл
            $url = "http://$url" if $url !~ /^https?:\/\//;
            my $p = $proj->page($url);
            $data->{url} = $url;
            $data->{title} = $p->title;
            $data->{tt} = $p->tt;
#            $data->{subpages} = [ map { $_->name.' => '.$_->url } map {@$_} $p->get_subpages  ];
            $data->{subpages} = [ @{$p->get_subpages} ];
            $data->{internal_subpages} = [ @{$p->get_internal_subpages} ];
            $data->{good_internal_subpages} = [ @{$p->get_internal_subpages->filter_metalinks->pack_urls} ];
        }
    }

    $vars->{cmd} = $form->{cmd};
    $vars->{url} = $form->{url};
    $vars->{data} = $data;
    $vars->{template} = 'page.tmpl';
}

sub page_phrases :CMDH {
    my ($proj, $vars) = @_;

    return {
        title => 'Фразы со страницы',
        idfield => 'id',
        readonly => 1,
        default_field_params => { shlist => 1, },
        #cache_getlistflt => 1,
        grfield => 'categs_text',
        grfieldreport => 1,
        fields => [
             { name => 'type', width => '300', },
             { name => 'data', showmacro => 'phrase_groups', },
        ],
        filters => [
            { field => 'url', width => '600', extfilter => sub { return {}; }, },
            #{ field => 'categs_text', grp => 1, title => 'categs', multi => 1, order_by_count => 1, },
            #{ field => 'flags_text', grp => 1, title => 'flags', multi => 1, order_by_count => 1, },
        ],
        #select_elems => {},
        getlistflt => sub {
            my ($self, %prm) = @_;
            my $url = $proj->form->{flt_url};
            if($url){
                $url = "http://$url" if $url !~ /^https?:\/\//;
                my $pg = $proj->page($url);
                return [
                    { type => 'pagephrase2', data => $proj->phrase_list($pg->page_phrases2)->subphrases_groups_format, },
                ];
            }
            return [];
        },
        wwwbottom_actions => [
                             { title => "Получить фразы для категории",
                               open_in_new_tab => 1,
                               name => "getcategphrases",
                               action => sub {
                                     my ($self, $lst1, $lst2, $prmsh, $fltrs, $ellist) = @_;
                                     my $proj = $self->proj;

                                     #my $rphl = $gphl->lmap(sub { $_.' => '.$prmsh->{Name} });
                                     #$proj->save_phrase_list($rphl);
                                     #$proj->do_redirect(join("&",
                                     #    "ind.pl?cmd=edit_phrase_list",
                                     #    "act=showphl",
                                     #    "phlid=".$rphl->cache_id,
                                     #));
                                     #$proj->dd( map { $_->title } @$bnl);
                                 },
                                fields => [
                                    { name => "Name", title => 'Категория', edlist => 1, ftype => 'typeahead', typeaheadurl => '?cmd=inline_search_categs&text=', },
                                ],
                             },
        ],
    };
}

1;
