package Cmds::PhraseBlock;

use strict;
use utf8;
use open ':utf8';

use base qw(Cmds::BasePhraseBlock);
use JSON qw(to_json from_json);

__PACKAGE__->mk_accessors(qw(
    lang
    cat_id
    proj
));

sub add_phrase {
    my ($self, $text, $user_comment) = @_;

    my ($lang, $cat_id, $proj) = ($self->lang, $self->cat_id, $self->proj);
    $proj->add_user_phrase($cat_id, $text, $lang, 'Add', '', $user_comment);
    $self->reset_phrase_list_id;
}

sub delete_phrase {
    my ($self, $text, $user_comment) = @_;

    my ($lang, $cat_id, $proj) = ($self->lang, $self->cat_id, $self->proj);
    $proj->add_user_phrase($cat_id, $text, $lang, 'Delete', '', $user_comment);
    $self->reset_phrase_list_id;
}

sub editing_phrases_warnings {
    my ($self, $added_phrases, $deleted_phrases) = @_;

    my ($lang, $cat_id, $proj) = ($self->lang, $self->cat_id, $self->proj);
    my $phrases = [];
    push @$phrases, {
        CatID           => $cat_id,
        Language        => $lang,
        Action          => 'Add',
        InitialPhrase   => $_,
    } for @$added_phrases;
    push @$phrases, {
        CatID           => $cat_id,
        Language        => $lang,
        Action          => 'Delete',
        InitialPhrase   => $_,
    } for @$deleted_phrases;
    $phrases = $proj->edit_user_phrases_warnings($phrases);
    return $phrases;
}

sub cache_block_phrases {
    my ($self) = shift;

    my ($lang, $cat_id, $proj) = ($self->lang, $self->cat_id, $self->proj);
    my $phrases = $proj->category_interface->get_phrases($cat_id, $lang, 'apply_moderation', source => 'db');
    my $phrase_list = $proj->phrase_list({phrases_arr => $phrases});
    $proj->save_phrase_list($phrase_list);
    $self->set_phrase_list_id($phrase_list->cache_id);
    return $phrase_list->cache_id;
}

1;
