package Cmds::Prototypes;

use utf8;

use base qw(Cmds::Base);
use Data::Dumper;

########################################################
# Прототипы
########################################################

sub dirs : CMDBS {
    my ($proj, $vars) = @_;

    my $login = $proj->{login};
    my $cur_date = $proj->dates->cur_date('db_time');
    my $lang = $vars->{viewoptions}{lang};
    #my $prnt_id = $proj->form->{'prnt_id'} || '';

    #$proj->Do_SQL("drop table TestDirs;");
    my $tinf = {
        title => 'Работа с директориями',
        default_act => 'Tree',
        readonly => 0,
        #table => 'ContextDicts',
        table => 'TestDirs',
        idfield => 'ID',
        fix_sql_problem => 1,
        showid => 0,
        add_filter => { Language => $lang }, 
        default_field_params => { shlist => 1, },
        fields => [
               {  name => 'ID', edlist => 0, },
               {  name => 'ParentID', ftype => 'hidden', shlist => 0 },
               {  name => 'Name', },
               {  name => 'Language', autoedit => sub { $lang }, },
               {  name => 'Login', autoedit => sub { $login }, },
               {  name => 'date', autoedit => sub { $cur_date }, },
        ],
        inline_add => 1,
        save_button => { title => 'Добавить', edit_title => 'Изменить', right => 1, },
        tree => {
                  edit_elms => 1,
                  grpfields => [
                      { field => 'ID', prnt_field => 'ParentID', first_level_prnt => '',
                            #Добавляем дополнительную информацию
                            add_fields => [
                                { 
                                  #name => 'Name', table => '', using => 'ID', 
                                  name => 'Name', 
                                  add_filter => { Language => $lang } 
                                },
                            ],
                            showmacro => "tree_showtext Name",
                      },
                  ],
                  pager => { name => 'p', cc => 20, },
              },
        order_by => ' ID desc ',
        #search => { fields => [ 'Name', ], name => 'text', }, 
    };

    return $tinf;
}

sub dirslist : CMDBS {
    my ($proj, $vars) = @_;
    
    my $tinf = {
        title => 'Проблемные урлы',
        #table => 'ProblemUrls',
        idfield => 'ID',
        fix_sql_problem => 1,
        readonly => 0,
        delonly => 1,
        inline_edit => 1,
        default_field_params => { shlist => 1, },
        fields => [ 
            { name => 'ParentID', ftype => 'hidden', addform => 1, shlist => 0 },
        ]
    };

    return $tinf;
}

sub loglist : CMDBS {
    my ($proj, $vars) = @_;
    
    my $tinf = {
        title => 'История изменений',
        #table => 'ProblemUrls',
        idfield => 'ID',
        fix_sql_problem => 0,
        readonly => 1,
        default_field_params => { shlist => 1, },
        NN => 1,
        add_log_fields => 1,
        fields => [ 
            { name => 'ID', },
            { name => 'login', },
            { grp => [
                { name => 'acttime', },
                { name => 'cmd', },
                { name => 'act', },
              ], },
            { name => 'elemid', showmacro => "show_edit_field cmd elemid" },
        ],
        order_by => ' ID desc ',
        #search => { fields => [ 'login', ], name => 'text', }, 
        filters => [
               {  name => 'Действия', field => 'act', grp => 1, like => 0 },
               {  name => 'Login', field => 'login', grp => 1, like => 0 },
               {  name => 'Время', field => 'acttime', like => 1, type => 'date2' },
        ], 
        alter_field_titles => {
            login => 'Логин',
            elemid => 'El', 
        },
        pager => { name => 'p', cc => 200, },
    };

    return $tinf;
}

sub list : CMDBS {
    my ($proj, $vars) = @_;
    
    my $tinf = {
        title => 'Проблемные урлы',
        #table => 'ProblemUrls',
        idfield => 'ID',
        fix_sql_problem => 1,
        readonly => 0,
        delonly => 1,
        inline_edit => 1,
        default_field_params => { shlist => 1, },
        fields => [ 
            { name => 'ParentID', ftype => 'hidden', addform => 1, shlist => 0 },
        ],
    };

    return $tinf;
}

sub table : CMDBS {
    return {
        title => 'Содержимое таблицы',
        table => '',
        extdbhname => 'dbhname',
        readonly => 1,
        default_field_params => { shlist => 1, showmacro => 'cuttext', },
        pager => { name => 'p', cc => 20, },
        NN => 1,
    };
}

1;
