package Cmds::RedButton;

use utf8;
use base qw(Cmds::Base);
use Data::Dumper;

use CGI;
use Template;
use Time::HiRes qw(gettimeofday tv_interval);
use POSIX qw(strftime);
use File::Basename;
use List::Util qw(min);
use JSON qw(to_json from_json);
use File::Slurp qw();


# путь к библиотекам Broadmatching
use FindBin;
use lib "$FindBin::Bin/../../lib";
use lib "$FindBin::Bin/../../wlib";

use Utils::Common;
use Utils::Sys qw(
    md5int
    do_safely
    save_json
    dir_files
    get_file_lock release_file_lock
);
use Utils::Hosts qw(
    get_curr_host
    get_host_role
    get_host_info
);
use DBI;
use WebCommon;
use Project;
use BaseForm;
use CatalogiaMediaProject;
use URI::Escape;
use Data::Dumper;

sub red_button : CMD {
    my ( $proj, $vars ) = @_;
    my $red_button_params = $Utils::Common::options->{RedButton_params};

    #$proj->do_auth();
    #my $loggeduser = $proj->{'login'};
    my $loggeduser = WebCommon::CheckCatalogiaAuth();   # чтобы не ходить в базу на catmedia    # TODO использовать только если не работает do_auth ?
    #$proj->dd([ $loggeduser ]);
    $vars->{loggeduser} = $loggeduser;

    # Выводим информацию о запущенных через красную кнопку deploy.pl
    my @red_button_runned;
    my $pid_dir = get_pid_dir();
    if (-d $pid_dir) {
        for my $name (dir_files($pid_dir)) {
            my $file = "$pid_dir/$name";
            if (get_file_lock($file, filename => 1)) {
                # process not active, skip it
                release_file_lock($file, filename => 1);
                next;
            }
            my $info = eval { File::Slurp::read_file($file) };
            push @red_button_runned, $info if $info;
        }
    }

    if (@red_button_runned) {
        my $hostname = $proj->host_info->{host};
        $vars->{red_button_runned} = join("\n", "deploy.pl is running at $hostname:", @red_button_runned);
    }

    $vars->{template} = 'RedButton/red_button_main.tmpl';
    $vars->{title} = "RedButton";

    my $macros_list = [
        { macro => "bmfront-up",                    descr => "svnupcrontab (для всех bmfornt-ов)", },
        { macro => "bmfront-up-myself",             descr => "svnupcrontab только для bmfront-а под балансером (актуально, если под балансером изменилась машинка и мы хотим сделать её мастером)", },
        {
            macro => "publish_catalogia_to_sandbox_ALL",
            descr => "build and upload to sandbox ALL resources",
        },
        {
            macro => "publish_catalogia_to_sandbox_selected",
            descr => "build and upload to sandbox selected resources",
            checkboxes => [
                {name => 'catalogia_publish', descr => 'catalogia_publish'},
                {name => 'qloud_gen_dicts', descr => 'qloud_gen_dicts'},
                {name => 'bm_scripts', descr => 'bm_scripts (drf)'},
                {name => 'bm_dicts', descr => 'bm_dicts (drf)'},
            ],
        },

        { macro => "cmedia-light",                  descr => "svnup, setcrontab, restart fcgi-server - изменение в web-интерфейсе", },
        { macro => "cmedia-short",                  descr => "svnup, setcrontab, restart prefprojserver, restart fcgi-server - изменение в лингвистике", },
        { macro => "infuse-cmedia-heavy",           descr => "На catalogia-media: 1. svn up  2. infuse_web_categs 3. enumerate-categs 4. svn commit dicts 5.( update_catmedia_db || restart subphraser || restart fcgi || restart prevproj ). Затем на ( ... ) svn up", },
        { macro => "infuse-cmedia",                 descr => "То же, что и infuse-cmedia-heavy, но update_catmedia_db и restart_subphraser выполняются только при необходимости", },
        { macro => "infuse-cmedia-light",           descr => "То же, что и infuse-cmedia, но без обновления продакшена", },
        { macro => "update_catmedia_db",            descr => "svn up, update_catmedia_db (только на инфьюз-хосте)" },

        { macro => "cmedia-gen-up",                 descr => "catalogia-media-gen: svnup", },
        { macro => "catalogia-media-auto01-up",     descr => "catalogia-media-auto01[fi]: svnup", },
        {
            macro => "bannerland",
            descr => "bannerland: update code",
            checkboxes => [
                {name => 'preprod', descr => 'bl preprod hosts: svn up + ya make + set crontab'},
                {name => 'iron', descr => 'iron hosts: svn up + ya make + set crontab'},
                {name => 'YT', descr => 'YT-gen hosts: svn up + ya make + set crontab'},
                {name => 'make_pocket', descr => 'make_pocket binary: build and publish (preprod => prod)'},

                {name => 'iron_dyn_regen', descr => 'dyn FORCE export_offers regeneration (+ iron update)'},
                {name => 'iron_perf_regen', descr => 'perf FORCE export_offers regeneration (+ iron update)'},
            ],
        },
        {
            macro => "qloud",
            descr => "Update resources in qloud envs.",
            checkboxes => [
                {name => 'bmapi', descr => 'Update code for bmapi in qloud'},
            ],
        },
        { macro => "bmcdict-front-up",              descr => "svnup на bmcdict-front0[12][hi]", },
    ];

    my $custommacros_list = [
        { macro => "command_svnup",                 descr => "svnup", },
        { macro => "command_svnupcrontab",          descr => "svnupcrontab", },
        { macro => "command_setcrontab",            descr => "setcrontab", },
        { macro => "command_kill_solomon_agent",    descr => "Kill Solomon agent", },
        { macro => "command_svnup_getresources",    descr => "svnup_getresources", },
        { macro => "command_svnup_clear",           descr => "svnup_clear (as usual, but run 'make' with '--clear')", },
        { macro => "command_svnup_revert_static_zmap",      descr => "svnup_revert_static_zmap", },
        { macro => "command_recheckout_arcadia",    descr => "recheckout_arcadia: recheckout /opt/arcadia, with STOP ALL SCRIPTS!", },
        { macro => "command_reconfigure_runit",    descr => "reconfigure_runit", },
        { macro => "command_check_logs",            descr => "check-logs", },
        { macro => "command_qtests_checking",       descr => "qtests_checking", },
        { macro => "command_crontab_checking",      descr => "crontab_checking", },
        { macro => "command_svn_diff",              descr => "svn_diff", },
    ];

    my $recent_macros = do_safely( sub {
            my $red_button_dbh = $proj->{$red_button_params->{dbh_name}};
            my $n_limit = 30;
            my $log_table = $red_button_params->{log_table};
            my $recent_list = $red_button_dbh->List_SQL(join(" ",
                    "SELECT `ID`, `Command`, `Hosts`, `Paths`, `Macro`, `DeployParams`",
                    "FROM $log_table",
                    "WHERE `Username` = '$loggeduser' AND `ID` > (SELECT MAX(`ID`) - 1000 FROM $log_table )",
                    "ORDER BY `ID` DESC",
                    "LIMIT $n_limit",
            ));

            my %standard_macros = map { $_->{macro} => 1 } @$macros_list;

            my @list;
            my %seen;
            for my $h (@$recent_list) {
                my $deploy_prm = from_json($h->{DeployParams});
                my $macro = $deploy_prm->{macro};
                my $macro_full_str = $macro . "\t" . to_json($deploy_prm->{macro_par} // {}, {canonical => 1});
                my $key;
                if ($standard_macros{$macro}) {
                    $key = $macro_full_str;
                } else {
                    $key = join("\t", $macro_full_str, map { $deploy_prm->{$_} } qw(command paths));
                }
                next if $seen{$key}++;

                my $descr;
                if ($standard_macros{$macro}) {
                    $descr = $h->{Macro};  # человеко-читаемое описание
                } else {
                    my $hosts = $h->{Hosts};  # реальные хосты; в DeployParams могут быть не указаны
                    $hosts =~ s/,/, /g;
                    my $paths = $deploy_prm->{paths} // $h->{Paths};
                    my $paths_str = $paths ? "($paths)" : "";
                    $descr = join(" &nbsp; ", grep {$_} @{$h}{qw[ Macro Command ]}) . " " . "<small>$hosts $paths_str</small>",
                }
                push @list, {macro => "repeat_id_".$h->{ID}, descr => $descr};
            }
            return \@list;
        },
        no_die => 1,
    ) || [];

    $vars->{recent_macros_list} = [ @$recent_macros, ];
    $vars->{custommacros_list} = [ @$custommacros_list ];
    $vars->{macros_list} = [ @$macros_list ];
    $vars->{default_paths} = $red_button_params->{default_paths};
}

sub red_button_run : CMD {
    my ( $proj, $vars ) = @_;
    my $red_button_params = $Utils::Common::options->{RedButton_params};
    my $form = $proj->form();
    my $cur_host = get_curr_host() // "";
    my $host_info = get_host_info($cur_host);
    my $balancer_name = "bmfront.bm.yandex-team.ru"; # Имя балансера, под которым лежит мастер bmfront-а
    my @errors;

    if ($host_info->{role} ne "bmfront") {
        flush_stdout ("ERROR: Deploy is accessible only at 'bmfront'-hosts! (Current role: '$host_info->{role}')\n");
        return 1;
    }

    # В Красной Кнопке авторизация только по логинам домена "yandex-team.ru" (ушли от авторизации по Яндексовым логинам)
    my $yandex_team_logins = {
        "anton-kalsin"  => 1,
        "danila-eremin" => 1,
        "fawkes"        => 1,
        "i-gataullin"   => 1,
        "ikhudoshin"    => 1,
        "ldo2"          => 1,
        "malykhin"      => 1,
        "modest"        => 1,
        "optozorax"     => 1,
        "sergio"        => 1,
        "yuryz"         => 1,
    };
    my $loggeduser = WebCommon::CheckCatalogiaAuth();
    if (! $yandex_team_logins->{$loggeduser}) {
        flush_stdout ("ERROR: User '$loggeduser' is not allowed to run Red Button!\n");
        return 1;
    }

    if ((! $host_info->{master}) && ($form->{macro} ne "bmfront-up-myself")) {
        flush_stdout ("ERROR: This isn't a deploy with 'bmfront:master' host! You can use only 'bmfront-up-myself' macro with this host.\n");
        return 1;
    }

    my %deploy_prm;
    my $out_log = "";
    if ($form->{macro} =~ m/^command_(.+)$/) {
        # Если поле 'macro' начинается с префикса 'command_', то вместо macro передаем в deploy.pl command, paths и hosts
        $deploy_prm{command} = $1;
        $deploy_prm{$_} = $form->{$_}  for qw[ hosts paths ];
    } elsif ($form->{macro} =~ m/^custommacro_(.+)$/)  {
        # Если поле 'macro' начинается с префикса 'custommacro_', то передаем в deploy.pl macro, paths и hosts
        $deploy_prm{macro} = $1;
        $deploy_prm{$_} = $form->{$_}  for qw[ hosts paths ];
    } elsif ($form->{macro} =~ m/^repeat_id_(\d+)$/)  {
        # Если поле 'macro' начинается с префикса 'repeat_id_', то берем параметры из RedButtonLog
        # Параметры берутся из поля DeployParams, остальные поля нужны для удобного отображения в интерфейсе
        my $deploy_id_prev = $1;
        my $dbtable_log = $proj->dbtable($red_button_params->{log_table}, 'ID', $red_button_params->{dbh_name});
        my $prev_opts = $dbtable_log->Get($deploy_id_prev) // {};
        my $prev_deploy_prm = from_json( $prev_opts->{DeployParams} );
        my @deploy_keys = qw[ macro macro_par command hosts paths revision make_clear sequential];
        $deploy_prm{$_} = $prev_deploy_prm->{$_}  for @deploy_keys;
        $proj->log("macro: " . $form->{macro} . " " . join(" ", map {"$_:".($deploy_prm{$_} // 'UNDEF')} @deploy_keys));
        delete $deploy_prm{$_} for grep {not defined $deploy_prm{$_}} keys %deploy_prm;
    } else {
        $deploy_prm{$_} = $form->{$_}  for qw[ macro ];
        my $macro = $form->{macro};
        # отмеченные чекбоксы записываем в macro_par
        # в именах макросов не должно быть "___"
        my %macro_par;
        for my $key (keys %$form) {
            my @f = split /___/, $key, 3;
            if ($f[0] eq 'chk' and $f[1] eq $macro) {
                $macro_par{$f[2]} = 1;
            }
        }

        $deploy_prm{macro_par} = \%macro_par;
    }
    $deploy_prm{$_} = $form->{$_}  for qw[ revision make_clear sequential]; # Номер ревизии и make_clear берем из $form (даже для repeat_id_...)
    %deploy_prm = map { $_ => $deploy_prm{$_} }  grep { ($deploy_prm{$_} // '') ne '' }  keys %deploy_prm;

    my $deploy_prm_json_str = to_json(\%deploy_prm);  # Для сохранения в RedButtonLog

    $deploy_prm{webusername} = $loggeduser;

    my $bm_path = "/opt/broadmatching";
    my $common_log_file = "$bm_path/log/red-button.log";
    my $temp_log_file = join("_",
        "$bm_path/temp/red-button",
        (grep {$_} map { $deploy_prm{$_} } qw[ macro command ]),
        time,
        $loggeduser,
        "$$.log",
    );

    my $temp_pid_dir = get_pid_dir();
    mkdir $temp_pid_dir if !-d $temp_dir_pid;
    my $deploy_pid_file = $proj->get_tempfile('info', DIR => $temp_pid_dir, UNLINK => 1);
    save_json({
        pid => $$,
        start_time => $proj->dates->cur_date('db_time'),
        config => \%deploy_prm,
        log_file => $temp_log_file,
    }, $deploy_pid_file);
    get_file_lock($deploy_pid_file, filename => 1);

    my $deploy_conf = $proj->get_tempfile('deploy_conf.json', UNLINK => 1);
    save_json(\%deploy_prm, $deploy_conf);

    my $deploy_command = join(" ",
        "($bm_path/scripts/utils/deploy.pl --file $deploy_conf 2>&1; ",
        '   EC=$?; echo DEPLOY_RESULT: $EC `if [ $EC != 0 ]; then echo "ERROR"; else echo "OK"; fi` ',
        ") | tee -a $temp_log_file | tee -a $common_log_file",
    );

    $proj->log("temp_log_file: $temp_log_file");
    $proj->log("deploy_command ...   $deploy_command");
    $out_log .= "deploy command:$deploy_command\n";
    my $time_begin = time;

    my $deploy_log = `$deploy_command`;
    my $time_end = time;
    my $deploy_duration = $time_end - $time_begin;
    $proj->log("deploy_command done.  $deploy_command");
    release_file_lock($deploy_pid_file, filename => 1);

    my $label = $red_button_params->{RedButtonLog_ID_label};
    my $deploy_id = (map { m/\t$label:(\d+)$/ } split /\n/, $deploy_log)[-1];
    $proj->log("deploy_id: " . ($deploy_id // ''));
    unless ($deploy_id) {
        $deploy_log .= "ERROR: void deploy_id\n";
    }

    my $time_re_str = '\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}';
    my $time_pid_host_re_str = $time_re_str.'\t\[\d+\]\t\[host:\S+\]';

    my $no_error_re_strings = [
        # ложные срабатывания на логе svn и ya make
        '^ ?[A-Z]\s+/opt/broadmatching/(work|temp)/deploy/broadmatching-deploy-test[a-zA-Z0-9\-_\./]+$',
        '^('.$time_pid_host_re_str.'\t|) ?[A-Z] +[a-zA-Z0-9\-_\./]+$',
        '^('.$time_pid_host_re_str.'\t|) +Updating .[a-zA-Z0-9\-_\./]+.:$', # 2017-10-17 22:43:38   [273123]    [host:bmaggrstat01f.yandex.ru]  Updating 'kernel/reqerror':
        '^ ?[A-Z] +[a-zA-Z0-9\-_\./]+$',
        '^('.$time_pid_host_re_str.'\t|)\|[ 0-9\.]+\%\| +\[[A-Z]+\] \$\([A-Z]+\)+[a-zA-Z0-9\-_\./ ,\{\}]+$',   # |59.2%| [CC] $(S)/util/system/error.cpp     |31.3%| [PB] $(B)/yt/17_5/yt/core/misc/error.pb.{cc, h}
        # | 9.6%| [CC] {} $(S)/contrib/libs/cxxsupp/libcxx-next/src/system_error.cpp
        '^('.$time_pid_host_re_str.'\t|)\s*\|[ \d\.%]*\|\s*\[\w*\]\s',
        '^[A-Z] +arcadia/[a-zA-Z0-9\-_\./]+$',
        '^[A-Z] +rt-research/[a-zA-Z0-9\-_\./]+$',

        # ложные срабатывания

        # 2017-10-24 10:55:14	[791930]	[host:bm-market11e.yandex.ru]	ERROR: The read operation timed out
        # 2017-10-11 17:18:38	[570612]	[host:host02i.yandex.ru]	Downloading https://proxy.sandbox.yandex-team.ru/366305860 [] ERROR: The read operation timed out
        '^'.$time_pid_host_re_str.'\s+(Downloading .*|)ERROR: The read operation timed out$', # https://cs.yandex-team.ru/#!The%20read%20operation%20timed%20out,%5E.*,,arcadia

        # 2018-03-19 16:44:28   [2062]  [host:bmcategorize01h.yandex.ru]    Error: ResourceDownloadError: Unable to reach any of 5 trackers {job:6497e59f:1}
        '^'.$time_pid_host_re_str.'\s+Error: ResourceDownloadError: ',

        # ERROR: ('The read operation timed out',)
        '^ERROR: ..The read operation timed out.',

        '\tNo errors \(diff\)',
        '\tprint_logs_errors: 0 errors',
        '\tget_logs_errors done',
        '\t\[host:' . $cur_host =~ s/\./\\\./rg . '\]\s+(tac: write error: Broken pipe',
        '\trsync error: error in socket IO \(code 10\) at clientserver.c\(128\) \[Receiver=3.1.0\])',
    ];

    my $no_error_re_string = "(" . join("|", @$no_error_re_strings) . ")";
    my $no_error_re = qr/$no_error_re_string/;

    my @deploy_errors = grep {
        ( m/\berror\b/i
          # временно(?) отключаем m/[^\-]conflict/i из-за ложных срабатываний на зависимостях
          # or  m/[^\-]conflict/i    # [^\-], чтобы убрать ложные срабатывания на "ya tool svn </dev/null up --accept theirs-conflict"
        ) and not $_ =~ $no_error_re
    } split /\n/, $deploy_log;
    my $deploy_errors = join("\n", @deploy_errors);

    $out_log .= $deploy_errors ? "\n<font color='red' size='+1'>Deploy failed!</font>\n" : "\n<font color='green' size='+1'>Deploy OK</font>\n";

    my $deploy_result = "\n";
    my $deploy_revision = undef;

    do_safely( sub {
            my $dbtable_log = $proj->dbtable($red_button_params->{log_table}, 'ID', $red_button_params->{dbh_name});
            if ($deploy_id) {
                if ($dbtable_log->Get($deploy_id)->{Log}) {    # Smth is wrong!
                    die "Wrong deploy_id ($deploy_id)";
                }
                $dbtable_log->Edit( $deploy_id, {
                        Errors => $deploy_errors,
                        Log => $deploy_log,
                    },
                );
                $deploy_revision = $dbtable_log->Get($deploy_id)->{Revision};
            } else {
                $proj->log("ERROR: Void deploy_id!");
                $deploy_errors .= "\nERROR: There was some problems with the RedButtonLog table (Void deploy_id!)\n";
                $deploy_result .= "\nERROR: There was some problems with the RedButtonLog table (Void deploy_id!)\n";
                #$deploy_result .= "\n-------- deploy log: --------\n\n$deploy_log\n";
                $deploy_id = $dbtable_log->Add( {
                        UpdateTime => $proj->dates->cur_date('db_time'),
                        Username => $loggeduser,
                        #Command => $options->{command},
                        Hosts => $form->{hosts} // '',
                        Paths => $form->{paths} // '',
                        Macro => $form->{macro} // '',
                        #Revision => $options->{revision},
                        Errors => $deploy_errors,
                        Log => $deploy_log,
                        DeployParams => $deploy_prm_json_str,
                    },
                );
                $proj->log("Added to RedButtonLog. id: $deploy_id");
            };
            return 1;
        },
        no_die => 1,
    ) or do {
        push @errors, "Could not save to RedButtonLog";
        $proj->log("ERROR: Could not save to RedButtonLog");
        $deploy_errors .= "\nERROR: Could not save to RedButtonLog\n";
        $deploy_result .= "\nERROR: Could not save to RedButtonLog\n";
    };

    $deploy_result .= $deploy_errors  ?  "\nErrors:\n$deploy_errors\n"  :  "deploy_command - OK!\n";
    $deploy_result .= "\ndeploy_id: $deploy_id\n";
    $deploy_result .= "\ndeploy log: https://$balancer_name/cgi-bin/interface/ind.pl?cmd=red_button_log_view&red_button_id=$deploy_id\n";
    $deploy_result .= "\ndeploy log (old format): https://$balancer_name/cgi-bin/interface/ind.pl?cmd=red_button_log_view_old&id=$deploy_id\n";
    $deploy_result .= "\ndownload deploy log: https://$balancer_name/cgi-bin/interface/ind.pl?cmd=red_button_log_download&id=$deploy_id\n";

    $out_log .= $deploy_result;
    $out_log .= "\n-------- deploy log: --------\n\n$deploy_log\n";

    my $text = join("\n\n",
        "Red button finished " . ($deploy_errors ? "with errors!" : "successfully"),
        "Deploy host: $cur_host",
        "Revision: " . ($deploy_revision // "[no revision info]"),
        "Deploy command: $deploy_command",
        "Deploy duration: $deploy_duration s",
        "$deploy_result",
    );
    my $macro_str = join(":", map {$deploy_prm{$_} || ()} qw[ macro command hosts ]);

    $proj->log("text2utf8 ...");
    $proj->log("text: " . join(" // ", split /\n/, $text) );
    my $body = $proj->detect_charset->text2utf8($text);
    $proj->log("send_mail_to_user ...");

    # Отправляем письмо на "yandex-team.ru"-логин, в рамках которого производилась авторизация в КК
    my %login_param = ("yandex_team_login" => $loggeduser);
    my $res = $proj->send_mail_to_user( {
            subject => "Red button result" . ($deploy_errors ? ": Errors were found!" : "") . " ($macro_str)",
            body => $body,
        },
        %login_param
    );

    $proj->log("send_mail_to_user done. res: ($res)");

    unless (@errors) {
        $proj->log("unlink temp_log_file: $temp_log_file");
        unlink $temp_log_file;
    }

    $proj->log("red_button_run done");

    flush_stdout($out_log);
    return 1;
}

sub red_button_log : CMDH {
    my ($proj, $vars) = @_;
    my $red_button_params = $Utils::Common::options->{RedButton_params};

    return {
        title => 'Лог красной кнопки',
        table => $red_button_params->{log_table},
        dbhname => $red_button_params->{dbh_name},
        default_field_params => { shlist => 1, showmacro => 'comma2commaspace', },
        readonly => 1,
        fields => [
            { name => 'ID' , title => 'ID', showmacroel => 'show_url_field',
                geturl => sub {
                    my ($el, $f) = @_;
                    my $id = $el->{ID};
                    #return "?cmd=red_button_log_view&red_button_id=$id";
                    return "?cmd=red_button_log_view_old&id=$id";
                },
            },
            { title => '', showmacroel => 'show_url_field',
                geturl => sub {
                    my ($el, $f) = @_;
                    my $id = $el->{ID};
                    return "?cmd=red_button_log_download&id=$id";
                },
                showmacroprmstr => '&#8681;',
                alt => 'download',
                target  => '_no',
            },
            { name => 'UpdateTime' , title => 'UpdateTime', },
            (map {{
                title => $_,
                name => $_,
            }} qw[ Username Macro Command Paths Hosts Revision ]),
            { name => 'Errors', title => 'Errors', filter_html => 1, showmacro => 'bigcuttext', width => 180 },
            { name => 'Duration', title => 'Duration' },
        ],
        action_onlist => sub {
            my ($proj, $el) = @_;
            return if ($el->{BeginTime} eq '0000-00-00 00:00:00');
            $el->{Duration} = $proj->dates->delta_time($el->{BeginTime}, $el->{UpdateTime},  'db_time',  'seconds');
        },
        filters => [
               { name => 'Username', field => 'Username', grp => 1, multi => 1, multiselect_include_select_all => 1, },
               { name => 'Macro', field => 'Macro', grp => 1, multi => 1, multiselect_include_select_all => 1, },
               { name => 'Command', field => 'Command', grp => 1, multi => 1, multiselect_include_select_all => 1, },
               { name => 'Hosts', field => 'Hosts', like => 1, },
#               { name => 'UpdateTime', field => 'UpdateTime', type => 'date2', },
        ],
        pager => { cc => '50', },
        order_by => 'UpdateTime desc',
    };
}

sub red_button_log_view_old : CMD {
    my ($proj, $vars) = @_;
    my $form = $proj->form;
    my $red_button_params = $Utils::Common::options->{RedButton_params};

    my $id = $form->{id};

    $vars->{template} = 'textdata.tmpl';
    $vars->{title} = "RedButtonLog: ID=$id";
    # " ?cmd=red_button_log_view&red_button_id=$id";

    #my $data;
    if ($id) {
        my $dbtable_log = $proj->dbtable($red_button_params->{log_table}, 'ID', $red_button_params->{dbh_name});
        my $el = $dbtable_log->Get($id);
        $proj->ddhtml([
            { map { $_ => $el->{$_} }  grep { !/^(Errors|Log)$/} keys %$el },
            (map {[ $_, "\n".$el->{$_}."\n" ]} qw[ Errors Log ]),
        ]);
    } else {
        $proj->dd("Error: Void id!");
    }

    #$vars->{data} = $data;
}

sub red_button_log_download : CMD {
    my ($proj, $vars) = @_;
    my $form = $proj->form;
    my $red_button_params = $Utils::Common::options->{RedButton_params};

    my $id = $form->{id};

    $vars->{template} = 'text_plain.tmpl';
    if ($id) {
        $vars->{'Content-type'} = "application/octet-stream\r\nContent-Disposition: attachment; filename=red_button_$id.log";
        my $dbtable_log = $proj->dbtable($red_button_params->{log_table}, 'ID', $red_button_params->{dbh_name});
        my $el = $dbtable_log->Get($id);
        $vars->{text} = Data::Dumper->Dump([
            { map { $_ => $el->{$_} }  grep { !/^(Errors|Log)$/} keys %$el },
            (map {[ $_, "\n".$el->{$_}."\n" ]} qw[ Errors Log ]),
        ]);
    } else {
        $vars->{text} = "Error: Void id!";
    }
}

sub red_button_log_view : CMDH {
    my ($proj, $vars) = @_;
    my $form = $proj->form;
    my $red_button_params = $Utils::Common::options->{RedButton_params};

    my $red_button_id = $form->{red_button_id};
    $red_button_id //= $form->{id};  # совместимость со старой версией

    my $toptext;
    my $red_button_data;
    if ($red_button_id) {
        my $dbtable_log = $proj->dbtable($red_button_params->{log_table}, 'ID', $red_button_params->{dbh_name});
        $red_button_data = $dbtable_log->Get($red_button_id);
        $toptext = Dumper([
                { map { $_ => $red_button_data->{$_} }  grep { !/^(Errors|Log)$/} keys %$red_button_data },
                (map {[ $_, "\n".$red_button_data->{$_}."\n" ]} qw[ Errors ]),
        ]);
        $toptext = "<pre>$toptext</pre>";
    };

    sub get_htmlcolor_by_text {
        my $text = shift;
        return "#FFFFFF"  if ($text // '') eq '';
        return '#' . join("", map { sprintf("%x", 192+32 + (md5int($_) % 32)) } ( $text, $text."1", $text."2"));
    };

    return {
        title => "RedButtonLog: ID=$red_button_id",
        readonly => 1,
        fields => [
            ( map { {
                        title => $_,
                        name => $_,
            } } qw[ ID Date PID ] ),
            {
                title => 'Host', name => 'Host',
                decorator => sub {
                    my ($el, $f) = @_;
                    my $val = $el->{ $f->{name} };
                    return {
                        #color => get_htmlcolor_by_text($el->{$f}),
                        'background-color' => get_htmlcolor_by_text($val),
                    };
                },
            },
            ( map { {
                        title => $_, name => $_,
                        decorator => sub {
                            my ($el, $f) = @_;
                            return {
                                'font-family' => 'monospace',
                                color => '#000000',
                            };
                        },
            } } qw[ Text ] ),
        ],
        filters => [
            ( map { { field => $_, name => $_, grp => 1, multi => 1, multiselect_include_select_all => 1, } } qw[ PID Host ] ),
            ( map { { field => $_, name => $_, like => 1, } } qw[ Text ] ),
            #{ field => 'Date', name => 'Date', use_other_filters => 1, type => 'date2', },
        ],
        default_field_params => {
            shlist => 1, showmacro => 'space2nbsp', inlinefilter => { group => 1, },
            filter_html => 1,
        },
        idfield => 'ID',
        transmit_url_params => [qw[ red_button_id id ]],
        toptext => $toptext,

        getlistflt => sub {
            my ($self, %prm) = @_;
            my $proj = $self->proj;

            if ($red_button_id) {
                my $log_text = $red_button_data->{Log};

                my $list = [];
                my $number = 0;
                for my $line (split /\n/, $log_text) {
                    next unless $line;

                    my $el = {};
                    @{$el}{qw[ Date PID Host Text ]} = $line =~ m/^(....-..-.. ..:..:..)\t\[(\d+)\]\t\[host:([\w\.\-\d]+)\]\t(.*)$/;
                    unless ($el->{Host}) {
                        @{$el}{qw[ Date PID Text ]} = $line =~ m/^(....-..-.. ..:..:..)\t\[(\d+)\]\t(.*)$/;
                    }
                    unless ($el->{PID}) {
                        $el->{Text} = $line;
                    }

                    $el->{$_} //= ''   for qw[ Date PID Host Text ];
                    $el->{Host} =~ s/\.yandex\.ru$//;
                    $el->{Date} =~ s/.* //g;
                    #$el->{$_} = "<pre>" . $el->{$_} . "</pre>"   for qw[ Date PID Host Text ];

                    ++$number;
                    $el->{ID} = $number;

                    push @$list, $el;
                }

                return $list;
            } else {
                $proj->dd("Error: Void red_button_id!");
                return [];
            }
        },
    };
}

sub red_button_log_lll : CMDH {
    my ($proj, $vars) = @_;

    return {
        title => 'Лог красной кнопки',
        idfield => 'UpdateTime',
        #table => 'RedButtonLog',
        getlistflt => sub {
            my ($self, %prm) = @_;
            my $proj = $self->proj;
            #$proj->dd($proj->dbhlist->{'catalogia_media_dbh'}->List_SQL('select * from RedButtonLog'));
            return $proj->dbhlist->{'catalogia_media_dbh'}->List_SQL('select * from RedButtonLog');
        },
        #dbhname => 'catalogia_media_dbh',
        default_field_params => { shlist => 1, showmacro => 'comma2commaspace', },
        txtfields => 'UpdateTime Username Macro Hosts',
        readonly => 1,
        filters => [
               { name => 'Username', field => 'Username', grp => 1, },
               { name => 'Command', field => 'Command', grp => 1, },
               { name => 'Hosts', field => 'Hosts', like => 1, },
               { name => 'UpdateTime', field => 'UpdateTime', type => 'date2', },
               { cmdslc => { 'Лог 1' => 'red_button_log_lll', 'Лог 2' => 'red_button_log_lll_2', }, },
        ],
        pager => { cc => '20', },
        select_elems => { binary => 0, right => 0, },
        bottom_actions => [
            { title => 'Послать письмом', name => 'sendemail', action => sub {
                    my ($self, $lst1, $lst2, $prmsh) = @_;
                    #$self->proj->dd(Dumper($self->proj->form, $prmsh));
                    #$self->proj->SendMail({
                    #    from => 'skreling@yandex-team.ru',
                    #    to => 'skreling@yandex-team.ru',
                    #    subject => 'test3',
                    #    body => Dumper($self->proj->form),
                    #});
                },
                inline => 1,
                fields => [
                    { name => "Name", title => 'Name', edlist => 1, typeaheadfield => 'Hosts', },
                    { name => "Lang", title => 'Lang', edlist => 1, shlist => 0, ftype => 'hidden', default => $lang },
                    { name => "BannersCount", title => 'Count', edlist => 1, disable_edit => 1 },
                ],
            },
        ],
        #order_by => 'UpdateTime desc',
    };
}

sub red_button_log_lll_2 : CMDH {
    return {
        title => 'Лог красной кнопки 2',
        base => 'red_button_log_lll',
    };
}

sub red_button_log_lll_3 : CMDH {
    return {
        title => 'Лог красной кнопки 3',
        base => 'red_button_log_lll_2',
    };
}

sub get_pid_dir {
    return $Utils::Common::options->{dirs}{temp} . '/red-button-pid';
}

sub flush_stdout {
    my $stdout = shift;
    print "Content-type: text/html\n\n$stdout";
}

1;
