package Cmds::SearchCategs;

use utf8;

use base qw(Cmds::Base);
use Encode;
use List::Util qw(min);
use Text::Iconv;
use Data::Dumper;
use URI::Escape;
use Utils::Sys qw(format_number h2sa);
use Time::HiRes qw(gettimeofday tv_interval);
use Utils::Sys qw(md5int);

use Data::Dumper;

sub search_categs : CMD {
    my ($proj, $vars) = @_;
    my $form = $proj->form;

    $vars->{template} = 'CategPhrases/search_categs.tmpl';
}

sub ajax_search_categs : CMD {
    my ($proj, $vars) = @_;
    my $form = $proj->form;
    $vars->{text} = $form->{text};
    my $lang = $proj->form->{lang} || $vars->{viewoptions}{lang} || 'ru';
    my $stext = $vars->{text};

    my $trstext = $proj->phrase($stext)->poor_layout;

    my $list = $proj->dbtable('CatalogiaDict')->List({ search => { 
        'CatID LIKE' => '%'.$stext.'%',   'CategoryName LIKE' => '%'.$stext.'%', 
        'CatID  LIKE' => '%'.$trstext.'%', 'CategoryName  LIKE' => '%'.$trstext.'%',  #Наличие пробелов важно, чтобы не склеились ключи
    }, Language => $lang, }, [qw{CatID CategoryName}]);

    $list = [ sort { $a->{'CatID'} cmp $b->{'CatID'} }  grep { $_->{'CatID'} !~ /^(\.|__homonym_)/ } @$list ];

    if( $form->{atoms} ){
        $list = [ grep { $_->{CategoryName} =~ /^\./ } @$list ];
    }else{
        $list = [ grep { $_->{CategoryName} !~ /^\./ } @$list ];
    }

    $vars->{list} = $list;

    $vars->{text} = $form->{text} if !@{$vars->{list}};
    $vars->{template} = 'CategPhrases/search_categs_result.tmpl';
    return;
}

1;
