package Cmds::SetsBanners;

use utf8;

use base qw(Cmds::Base);
use Encode;
use List::Util qw(min);
use Text::Iconv;
use Data::Dumper;
use URI::Escape;
use Utils::Sys qw(format_number h2sa);
use Time::HiRes qw(gettimeofday tv_interval);
use Utils::Sys qw(md5int);

sub TestBanners :CMDH {
    my ($proj, $vars) = @_;

    my $lang = $vars->{viewoptions}{lang};

    return {
        title => 'Эталонная выборка',
        table => 'TestBanners',
        #idfield => 'ID',
        readonly => 1,
        default_filter => { Lang => $lang, },
        default_field_params => { shlist => 0, show_text_field, },
        search => { fields => [ 'BannerID', 'Title', 'Body' ], name => 'text', title => 'Поиск' }, 
        txtfields => '
                BannerID                          
                Title            
                Body             
                Phrases          
                Mode             
                ManualCategory   
                InitialCategories
                PhrasesCategories
                Lang
        ',
        fields => [ 
            { name => "BannerID", shlist => 1, },
            { title => 'Баннеры', showmacro => 'bannerinf BannerID Title Body Phrases', shlist => 1, },
            { name => "Mode", shlist => 1, },
            { title => 'Категории', shlist => 1,
                grp => [
                    { name => "ManualCategory",    title => "ManualCategory",    shlist => 1, },
                    { name => "InitialCategories", title => "InitialCategories", shlist => 1, },
                    { name => "PhrasesCategories", title => "PhrasesCategories", shlist => 1, 
                          showsub => sub { 
                              my $t = $_[0]; 
                              $t=~s/###/ => /g;
                              $t=~s/\// \/ /g;
                              #return join '', map { "$_<br>" } split '/', $t;
                              return $t;
                          },
                    },
                ],
            },
            { name => "Lang", shlist => 1, },
        ],
        filters => [
               {  name => 'ManualCategory', field => 'ManualCategory', grp => 0, like => 1 },
               {  name => 'InitialCategories', field => 'InitialCategories', grp => 0, like => 1 },
               {  name => 'Lang', field => 'Lang', grp => 1, },
               #{  name => 'state', field => 'state', grp => 1 },
        ], 
        vertical => 1, 
        NN => 1,
        pager => { name => 'p', cc => 20, },
    };
}



1;
