package Cmds::ShowPhrases;

use utf8;
use base qw(Cmds::Base);
use Data::Dumper;

use CGI;
use Template;
use Time::HiRes qw(gettimeofday tv_interval);
use POSIX qw(strftime);
use File::Basename;
use List::Util qw(min);

# путь к библиотекам Broadmatching
use FindBin;
use lib "$FindBin::Bin/../../lib";
use lib "$FindBin::Bin/../../wlib";
#use lib "$FindBin::Bin/../web-interface-lib";

use Utils::Common;
use Utils::Sys qw(md5int);
use DBI;
use WebCommon;
use Project;
use BaseForm;
use CatalogiaMediaProject;
use URI::Escape;
use Data::Dumper;


sub show_phrases : CMD {
    my ($proj, $vars) = @_;

    my $form = $proj->form;
    my $dbh = $proj->dbh;
    my $lang = $vars->{viewoptions}{lang} || $form->{lang} || "ru";

    # в шаблон
    $vars->{cinf} = GetCategData( $proj, $form->{id}, $lang );
    $vars->{cinf}{direct_id} = $proj->categs_tree->get_minicateg_directid($proj->categs_tree->get_minicateg_by_id($form->{id}));
    $vars->{is_dict} = $vars->{cinf}{CatID} =~ /^adict/;
    $vars->{comments} = $proj->get_category_comments($form->{id});
    $vars->{viewoptionsstr} = $form->{viewoptionsstr};

    # добавление фраз
    if($form->{add_phrases}) {
        my @phrases = ();

        for my $line (split /\s*\r?\n/, $form->{phrases}) {
            push @phrases, $_ for grep{$_} split /\s*,\s*/, $line;
        }

        my $phl = $proj->phrase_list(\@phrases);
        $proj->save_phrase_list($phl);
        $proj->do_redirect(join("&",
            "ind.pl?cmd=edit_user_phrases",
            "phlid1=".$phl->cache_id,
            "catid1=".$vars->{cinf}{CatID},
            "action1=Add",
            "viewoptionsstr=".$form->{viewoptionsstr},
        ));
    }

    # смена родительской категории
    if ($form->{change_parent}) {
        my $cat_id = $form->{id};
        my $parent_id = $form->{title};

        my $valid_change = 1;
        while ($parent_id) {
            $valid_change = 0 if $parent_id eq $cat_id;
            $parent_id = $proj->get_parent_id($parent_id);
        }

        $proj->add_user_phrase(
            $cat_id,
            $form->{title},
            'ru',
            'ChangeParent'
        ) if $valid_change;

        $proj->do_redirect(join('&',
            'ind.pl?cmd=show_phrases',
            "id=$cat_id",
            "viewoptionsstr=".$form->{viewoptionsstr}
        ));
    }

    # добавление антислов
    if($form->{add_antiwords}) {
        my @anti_words = grep {$_} map {s/^\s+|\s+$//g; $_} split /,/, $form->{words};
        my $phrase_list = $proj->phrase_list(\@anti_words);
        $proj->save_phrase_list($phrase_list);
        my $redirect_path = 'ind.pl?cmd=show_phrases&id=' . $vars->{cinf}{CatID} . '&viewoptionsstr=' . $vars->{viewoptionsstr};
        $proj->do_redirect(join('&',
            'ind.pl?cmd=edit_user_phrases',
            'phlid1=' . $phrase_list->cache_id,
            'catid1=' . $vars->{cinf}{CatID},
            'action1=AddAntiword',
            'redirect_path=' . URI::Escape::uri_escape_utf8($redirect_path),
            'viewoptionsstr=' . $form->{viewoptionsstr}
        ));
    }

    # редактирование выбранных фраз
    if ($form->{'edit_phrases'} eq 'partialExport') {
        my $phrase_list = $proj->get_language($lang)->phrase_list($form->{'selectedPhrases'});
        $proj->save_phrase_list($phrase_list);
        $proj->do_redirect(join('&',
            'ind.pl?cmd=edit_phrase_list',
            'viewoptionsstr=' . $form->{'viewoptionsstr'},
            'phlid=' . $phrase_list->cache_id,
            'act=showphl'
        ));
    }

    # редактирование пачки фраз
    if($form->{edit_phrases} eq 'Export') {
        my $phl;

        my $h = $proj->phrase_list->web_get_category_full($form->{id}, $lang);
        $phl = $proj->phrase_list($h->{CategoryPhrases});

        $proj->save_phrase_list($phl);
        $proj->do_redirect(join("&",
           "ind.pl?cmd=edit_phrase_list",
            "viewoptionsstr=".$proj->form->{viewoptionsstr},
            "phlid=".$phl->cache_id,
            "act=showphl"
        ));
    }

    # подписан ли пользователь
    my $single_subscription = $proj->category_subscriptions->List(
        {CatID => $form->{id}, Login => $proj->login, SubscriptionType => 'Single'}
    );
    my $full_subscription = $proj->category_subscriptions->List(
        {CatID => $form->{id}, Login => $proj->login, SubscriptionType => 'Full'}
    );
    $vars->{isSingleSubscriber} = @$single_subscription ? 1 : 0;
    $vars->{isFullSubscriber} = @$full_subscription ? 1 : 0;

    # иерархия
    my $hier = [];

    # цепочка родительских категорий
    my $parent = $vars->{cinf};
    $parent->{IsCurrent} = 1;
    while($parent) {
        my $parent_id = $parent->{CatID};
        $parent->{isFullSubscriber} = @{$proj->category_subscriptions->List({
            CatID => $parent_id, Login => $proj->login, SubscriptionType => 'Full'})} ? 1 : 0;
        push @$hier, $parent;
        $parent = $proj->get_category_full($parent->{ParentID}, $lang);
    }
    $hier = [reverse @$hier];
    $hier->[$_]{Level} = $_ for 0..$#$hier;

    # потомки
    my $child_level = @$hier;
    my $children = $proj->get_category_children($form->{id});
    $vars->{cinf}{HasChildren} = @$children;
    for my $child (sort{$a->{CatID} cmp $b->{CatID}} @$children) {
        push @$hier, {%{$proj->get_category_full($child->{CatID}, $lang)}, Level => $child_level};
    }
    $vars->{hierarchy} = $hier;

    # категория в разных языках
    $vars->{LanguagesWithPhrases} = [];
    for my $lang_categ (@{$proj->categories_dict->List({ "CatID" => $vars->{cinf}{CatID} })}) {
        if($lang_categ->{CategoryPhrases}) {
            push @{$vars->{LanguagesWithPhrases}}, $lang_categ->{Language};
        }
    }

    my $type = "";
    my $result = {};
    my $message = "";

    # действия пользователей: добавление/удаление фраз/категорий
    my $user_phrases = $proj->get_user_phrases($form->{id}, $lang);
    $vars->{UserPhrasesHash} = {
        map {
            $_->{InitialPhrase} => 1
        } @$user_phrases
    };
    $vars->{DeletedPhrases} = {};
    $vars->{Phrases} = [];
    for my $phr (@$user_phrases) {
        if($phr->{Action} eq "Add") {
            push @{$vars->{Phrases}}, $phr;
        } elsif($phr->{Action} eq "Delete") {
            $vars->{DeletedPhrases}{$phr->{InitialPhrase}}++;
        }
    }

    # список виртуальных категонрий
    $vars->{VirtualCategoriesList} = $proj->get_virtual_categories_list;

    $vars->{lang} = $lang;
    $vars->{template} = 'CategPhrases/showphrases.tmpl';
}

sub GenerateAddPhrasesUrl {
    my ($proj, $categ_data) = @_;
    my $phl = $proj->phrase_list($categ_data->{CategoryPhrases});

    $proj->save_phrase_list($phl);

    return "ind.pl?cmd=bm_add_phrases&category_id=".$categ_data->{CatID}."&phl_id=".$phl->cache_id;
}

sub GetCategData {
    my ( $proj, $id, $lang ) = @_;

    my $h = $proj->phrase_list->web_get_category_full($id, $lang);

    $h->{UserName}              = $proj->get_user_category_name($id, $lang);
    $h->{MinusWords}            = [split(",", $h->{MinusWords}), map{$_->{InitialPhrase}} @{$proj->get_user_antiwords($id, $lang)}];
    $h->{categoryDescription}   = $proj->get_category_description($id, $lang);

    return $h;
}

# каждая фраза превращается в массив элементов вида {text => "фрагмент текста", categ_id => "id категории или 0"}
# нужно для простановки ссылок на атомы
sub ParseCategoryPhrases {
    my ($dbh, $phrases) = @_;
    my @result;

    for my $ph (split /\,\s*/, $phrases) {
        my @atoms = split /([\[\/])(\.[^\]\/]+)/, $ph;
        my @data = ();

        if(@atoms > 1) {
            # выделяем айдишники именованных атомов
            for(my $i = 0; $i < @atoms; $i += 3) {
               push @data, {text => join("", @atoms[$i..min($i + 1, $#atoms)]), categ_id => 0};

               if($i + 2 < @atoms) {
                   my $name = $atoms[$i + 2];
                   my $categ = $proj->get_category_by_name($name);
                   push @data, {text => $name, categ_id => ($categ ? $categ->{CatID} : 0 )};
               }
            }
        } else {
            @data = ({ text => $ph, categ_id => 0 });
        }


        push @result, \@data;
    }



    my ( $no_model_phrases, $model_phrases, $vendor_phrases ) = _SplitVendorsModelsToResult(\@result);

    return ( $no_model_phrases, $model_phrases, $vendor_phrases );
}

sub _SplitVendorsModelsToResult {
    my ( $result ) = @_;
    my $hash_phrases = {};
    for my $item ( @$result ) {
        for my $small_item ( @$item ) {
            $hash_phrases->{ $small_item->{text} } = 1;
        }
    }

#    my $hash_result = {};
    my @phrases_texts = keys %$hash_phrases;
#    my $phrases_to_send = join(',', @phrases_texts);
#    $phrases_to_send =~ s/[\r\n]+/ /g;
=h
    my $normalizer_result = $normalizer_client->Do('get_model_vendor_phrases ' . $phrases_to_send);
    my @m_v_result = split /\,/, $normalizer_result;
    for ( my $phrase_index = 0; $phrase_index < scalar(@phrases_texts); $phrase_index++ ) {
        my ( $phrase, $vendor, $model ) = ( $phrases_texts[ $phrase_index ], (split '###', $m_v_result[ $phrase_index ] ));
        $hash_result->{$phrase} = { vendor => $vendor, model => $model };
    }

    my ( $no_model_phrases, $model_phrases, $vendor_phrases ) = ( [], [], [] );
    for my $item ( @$result ) {
        my $is_model = 0;
        my $is_vendor = 0;
        for my $small_item ( @$item ) {
            my $text = $small_item->{ text };
            if ( $hash_result->{$text}{model} && $hash_result->{$text}{model} !~ /^\s*$/ ) {
                $is_model = 1;
            }
            if ( $hash_result->{$text}{vendor} && $hash_result->{$text}{vendor} !~ /^\s*$/ ) {
                $is_vendor = 1;
            }
        }
        if ( $is_model == 1 ) {
            push @$model_phrases, $item;
        } elsif ( $is_vendor == 1 ) {
            push @$vendor_phrases, $item;
        } else {
            push @$no_model_phrases, $item;
        }
    }
=cut
    return ( $no_model_phrases, $model_phrases, $vendor_phrases );

}

sub GetName {
    my ( $dbh, $id ) = @_;
    my $result = "";
    my $sth = $dbh->prepare("
        select
            CategoryName
        from
            CatalogiaDict
        where
                   CatID=" . $dbh->quote($id) . "
            and
                Language = " . $dbh->quote( $form->{lang} ) . "
    ");

    $sth->execute()
    or die $dbh->errstr;

    if ( $sth->rows() ) {
        ( $result ) = $sth->fetchrow_array();
        $sth->finish();
        return $result;
    }

    $sth->finish();

    return $result;

}

sub GetParentID {
    my ( $dbh, $id ) = @_;
    my $result = "";
    my $sth = $dbh->prepare("
        select
            ParentID
        from
            CatalogiaBrief
        where
            CatID=" . $dbh->quote($id) . "
    ");

    $sth->execute()
    or die $dbh->errstr;

    if ( $sth->rows() ) {
        ( $result ) = $sth->fetchrow_array();
        $sth->finish();
        return $result;
    }

    $sth->finish();

    return $result;

}

sub DoLog {
    my ( $dbh, $id, $command, $value ) = @_;

    $dbh->do("insert into CatalogiaModerate (CatID, Command, Value, Login, UpdateTime, ModerationStatus) values " .
        "(" . join(",",
            $dbh->quote($id),
            $dbh->quote($command),
            $dbh->quote($value),
            $dbh->quote($proj->login),
            'NOW()',
            $dbh->quote('New'),
    ) . ")
    on duplicate key update
        UpdateTime = now(),
        Login = values(Login),
        ModerationStatus = 'New'
    " ) or die $$DBI::errstr;

    return 1;
}


sub CheckPhrases {
    my ( $dbh, $form ) = @_;
    my $user_phrases = $form->{UserPhrases};
    #$user_phrases = Encode::decode('UTF-8', $user_phrases);
    $user_phrases =~ s/[\r\n]/,/g; # против поджигателей колхозов
    $user_phrases =~ s/,+/,/g; # против поджигателей колхозов
    $user_phrases =~ s/#+//g; # против поджигателей колхозов

    my $result = [];
    for my $item ( split /#+/, $normalizer_client->Do("check_add_phrases $user_phrases") ) {
        my @fields = split /\t/, $item;
        my $cause = "";
        my $can_add = $fields[3];
        my $phrase_id = md5int($fields[0]);

        if ( $fields[3] =~ /(WARNING|ERROR)(.*)/ ) {
            $can_add = $1;
            $cause = $2;
        }

        # дополнительно проверяем, что такую фразу больше никуда не добавляли
        if($can_add ne "ERROR") {
            my $sth = $dbh->prepare("
                select
                    CatID
                from
                    CatalogiaPhrases
                where
                    InitialPhraseID='$phrase_id'"
            );

            $sth->execute or die $sth->errstr;
            if($sth->rows()) {
                my ($cat_id) = $sth->fetchrow_array();

                $can_add = "ERROR";
                $cause = "Фраза уже добавлена в категорию '".GetName($dbh, $cat_id)."'";
            }

            $sth->finish;
        }

        push @$result, {
            InitialPhraseID  => $phrase_id,
            InitialPhrase    => $fields[0],
            NormalizedPhrase => $fields[1],
            Flags         => $fields[2],
            CanAdd         => $can_add,
            Cause         => $cause,
        };
    };

    return $result;
}

sub lemmer_fix_wordforms :CMD {
    my ($proj, $vars) = @_;

    my $file = $proj->options->{dirs}{dicts}.'/normalize/lemmer_fix';

    $proj->lemmer_test('-p');
    my $lmr = $proj->lemmer_test;

    my $get_paradigm = sub {
        my $word = shift;
        my $badlem = shift // {};
        my @lem_inf = $lmr->parse($lmr->analyze($word));
        my %seen;
        for my $inf (@lem_inf) {
            next unless $inf->{lang} eq 'ru';
            next if $badlem->{$inf->{lemma}};
            $seen{$_} = 1 for $lmr->parse_paradigm($inf->{paradigm});
        }
        return sort keys %seen;
    };

    my %badlem;
    open my $fh, '<:encoding(UTF-8)', $file
        or do { $vars->{text} = 'cant open'; return };
    while (<$fh>) {
        chomp;
        my ($word, $lemma) = split '/';
        $badlem{$word}{$lemma} = 1;
    }
    close $fh;

    my @result;
    for my $word (sort keys %badlem) {
        my @all = $get_paradigm->($word);
        my @good = $get_paradigm->($word, $badlem{$word});

        my %good = map { $_ => 1 } @good;
        push @result, [ $word, $_ ] for grep { !$good{$_} } @all;
    }

    @result = grep { $_->[0] ne $_->[1] } @result;

    $vars->{text} = join('', map { "$_->[0]/$_->[1]\n" } @result);
}


1;
