package Cmds::Tagging;

use utf8;
use open ":utf8";

use strict;
use base qw(Cmds::Base);
use Encode;
use List::Util qw(min);
use Text::Iconv;
use Data::Dumper;
use URI::Escape;
use Utils::Sys qw(format_number h2sa get_bash_cmd);
use Utils::Array qw{array_minus};
use Time::HiRes qw(gettimeofday tv_interval);
use Utils::Sys qw(md5int);
use POSIX qw(strftime);
use LWP::UserAgent;
use JSON qw(to_json);

# Дефолтное количество элементов в сете, который создаётся из рандомных элементов
my $default_items_quantity = 1000;

my $selectlist_categs_flags_hash = {
     ''         => { name => 'Нет разметки',        default => 1 , },
     goodflag   => { name => 'Правильный флаг',         color => '#00BB00', },
     good       => { name => 'Правильная категория',    color => '#00FF00', },
     bad        => { name => 'Неправильная категория',  color => '#FF0000', },
     badflag    => { name => 'Неправильный флаг',       color => '#FF8800', },
     old        => { name => 'Устаревший',              color => '#AAAAAA', },
     badlang    => { name => 'Неправильный язык',       color => '#FF7777', },
     strange    => { name => 'Странный',                color => '#d8a903', },
     uncat      => { name => 'Нет категории',           color => '#5555FF', },
};
$selectlist_categs_flags_hash = { map { $_ => { value => $_, %{$selectlist_categs_flags_hash->{$_}} } } keys $selectlist_categs_flags_hash };
my $selectlist_categs_flags = [ map { $selectlist_categs_flags_hash->{$_} } ("", qw[ goodflag good bad badflag old badlang strange uncat ])];
my $selectlist_categs = [ map { $selectlist_categs_flags_hash->{$_} } ("", qw[ good bad badlang old strange uncat ])];
my $selectlist_short = [ map { $selectlist_categs_flags_hash->{$_} } ("", qw[ good bad ])];
my $selectlist_good_bad = [ map { $selectlist_categs_flags_hash->{$_} } (qw[ good bad ])];

sub base_tagging_sets :CMDBS {
    my ($proj, $vars) = @_;

    my $lang = $vars->{viewoptions}{lang};

    return {
        title => 'Наборы данных для разметки',
        idfield => 'SetID',
        fix_sql_problem => 0,
        inline_edit => 1,
        compact_inline_add => 1,
        readonly => 0,
        #onclick => 'edit',
        #onclick => 'inline_extlists',
        onclick => 'extlists',
        disable_add => 1,
        disable_del => 1,
        add_filter => { Lang => $lang, },
        default_field_params => { shlist => 1, },
        fields => [
            { name => "SetID", edlist => 0, width => 30,},
            { name => "Name", title => 'Name', edlist => 1, width => 130, },
            { name => "Login", after => 'Name', edlist => 0, width => 200, },
            { name => "Lang", title => 'Lang', edlist => 1, shlist => 0, ftype => 'hidden', default => $lang, width => 30 },
            { name => "BannersCount", title => 'Count', edlist => 1, disable_edit => 1 },
            { name => "Comment", title => 'Comment', edlist => 1, width => 340, inline => 1, ftype => 'textarea', },
            { name => "Categs", title => 'Категории', edlist => 1, shlist => 0, }, #Названия(id) категории(ий) для выгрузка сущностей(баннеров, фраз, urlов) с этой категорией
            { name => "Only_one_categ", title => 'Категория единственная', edlist => 1, shlist => 0, ftype => 'checkbox'}, #Флаг, если хотим выгружать сущности только с одной категорией
            { extsql => ['
                   select SetID,
                       count(*) cc,
                       sum(IF(Mode="good", 1, 0)) goods,
                       sum(IF(LENGTH(Mode), IF(Mode="good", 0, 1), 0)) bad,
                       sum(IF(Mode="uncat", 0, 1))/(count(*) + 1) recall,
                       sum(IF(Mode="good", 1, 0))/sum(IF(LENGTH(Mode), IF(Mode="uncat", 0, 1), 0)) `precision`
                   from TaggingSetsTable where SetID in (?) group by SetID
              ', 'SetID'],
            },
            { extname => 'cc', width => 40, },
            { extname => 'goods', width => 40, },
            { extname => 'bad', width => 40, },
            { extname => 'precision', width => 40, },
            { extname => 'recall', width => 40, },
            { name => 'UpdateTime', title => 'Uploaded', after => 'recall', edlist => 0, width => 125, },
        ],
        order_by => 'SetID desc',
        extlists => [
            { cmd => 'tagging_elems', using => 'SetID', title => 'Dicts' },
        ],

        Moderate => {
            Del => sub {
                my ($self, $id) = @_;
                my $table = $self->tinf->{table};
                my ($type) = ($table =~ /^(.+)TaggingSets$/);

                $self->proj->log("$type tagging: Deleting SetID = $id");

                my $tbl_sets = $self->proj->dbtable($table);
                $tbl_sets->Do_SQL("delete from $table where SetID = $id");

                $table =~ s/Sets/Elems/;
                my $tbl_elems = $self->proj->dbtable($table);
                $tbl_elems->Do_SQL("delete from $table where SetID = $id");
            },
        },
        del_mes => "Вы уверены, что хотите удалить данный сет?",
        disable_del => 0,
        pager => { name => 'p', cc => 20, },
        fixed_header => 1,
    };
}

sub base_tagging_elems :CMDBS {
    my ($proj, $vars) = @_;

    my $set_id = '';
    if ($vars and exists ($vars->{form}) and (exists $vars->{form}->{SetID})) {
        $set_id = ": SetID ".($vars->{form}->{SetID});
    };

    my $is_good_bad_mode = (grep { $_ eq $vars->{form}{flt_dblist_fldorder_mode} } qw[ good-bad good-bad_Outer ]) ? 1 : 0;

    return {
        title => 'Разметка '.$set_id,
        idfield => 'ID',
        readonly => 1,
        disable_del => 1,
        disable_add => 1,
        logchanges => 1,
        fix_sql_problem => 0,
        onclick => 'show',
        NN => 1,
        default_field_params => { edlist => 0, },
        fields => [
            { name => "SetID", shlist => 0, addform => 1, },
            { name => 'Data', title => 'Проверяемые данные', },
            { title => 'Categories', shlist => 1, editlink => 0, extname => 'Categories',
                grp => [
                    { name => "CategoriesString",    title => "",  showmacro => 'catlist2links',  shlist => 1, },
                    { name => 'CategPhrases', title => '', show_banner_saved_categs => 'CategPhrases', },
                ],
                inlinefilter => { data_field_name => 'CategoriesString', },
            },
            { name => 'Mode', shlist => 1, width => 200,
                ftype => ($is_good_bad_mode ? 'radio' : 'dropdown'),
                inline => 1,
                edlist => 1,
                selectlist => ($is_good_bad_mode ? $selectlist_good_bad : $selectlist_categs),
                inlinefilter => { group => 1 },
            },
            { name => 'ManualCategory', title => 'Manual Category', shlist => 1, manual_category => 1, inlinefilter => { group => 1 }, showmacro => 'catlist2links', },
            { name => 'Comment', title => 'Комментарий', edlist => 1, inline => 1, ftype => 'textarea', after => 'Mode', shlist => 1, after => 'ManualCategory', width => 200, inlinefilter => { group => 1 }, },
            { name => 'OuterCategory', title => 'Outer Category', shlist => 1, inlinefilter => { group => 1 }, showmacro => 'catlist2links', },
            { extname => 'CurrentCategPhrases', title => 'Current categs phrases', shlist => 0, show_banner_saved_categs => 'CurrentCategPhrases', }, # TODO перенести в base_tagging_elems
        ],
        fld_orders => {
            title => 'Режим отображения',
            orders => [
                { name => 'usual', title => 'Обычный', order => undef},
                { name => 'good-bad', title => 'Разметка good-bad', order => undef},
                # CurrentCategPhrases_list - костыль для CurrentCategPhrases - см. show_banner_saved_categs (https://a.yandex-team.ru/arc/trunk/arcadia/rt-research/broadmatching/scripts/wlib/DBList.pm?rev=3940299#L1555)
                {
                    name => 'good-bad_Outer',
                    title => 'Разметка good-bad для Outer Category',
                    order => [qw[ IDs Phrase Serial_Data OuterCategory Mode ManualCategory Comment CurrentCategPhrases_list ]],
                },
                {
                    name => 'Data-Cat-Outer-Mode',
                    title => 'Разметка Outer Category',
                    order => [qw[ IDs Phrase Serial_Data OuterCategory Mode ManualCategory Comment CurrentCategPhrases_list ToCtg ]],
                },
             ],
        },
        pager => { name => 'p', cc => 100, },
        filters => [
               {  name => 'Статусы', field => 'Mode', grp => 1, like => 0, use_other_filters => 1 },
               {  name => 'bid', field => 'bid', grp => 0, like => 1, use_other_filters => 1 },
               {  name => 'Categories', field => 'CategoriesString', use_other_filters => 1, grp => 1, multi => 1, },
               {  name => 'ManualCategory', field => 'ManualCategory', use_other_filters => 1, grp => 1, multi => 1, },
               {  name => 'OuterCategory', field => 'OuterCategory', use_other_filters => 1, grp => 1, multi => 1, },
        ],
        order_by => "ID",
        fixed_header => 1,
    };
}

# Добавляет фразу в категорию. Фраза и категория берутся из таблицы по заданному id строки. Названия полей таблицы задаются в урле.
#   ind.pl?cmd=add_phrase_to_categ&table=PhrasesTaggingElems&phr_fld=Phrase&ctg_fld=ManualCategory&id=20556
sub add_phrase_to_categ :CMD {
    my ($proj, $vars) = @_;
    my $lang = $vars->{viewoptions}{lang};
    my $form = $proj->form;

    my ($table, $ctg_fld, $phr_fld, $id_fld, $id) = map { $_ //= '';  s/[^a-z0-9_]//ig;  $_ }
        @{ $form }{qw[ table ctg_fld phr_fld id_fld id ]};
    $id_fld ||= 'ID';
    ($table and $ctg_fld and $phr_fld and $id)
        or die "Void params in add_phrase_to_categ: ($table, $ctg_fld, $phr_fld, $id_fld, $id)";

    my $dbt = $proj->dbtable($table, $id_fld)
        or die "Void list in add_phrase_to_categ: ($table, $ctg_fld, $phr_fld, $id_fld, $id)";

    my $el = $dbt->Get($id)
        or die "Void list in add_phrase_to_categ: ($table, $ctg_fld, $phr_fld, $id_fld, $id)";

    my ($text, $ctg) = @{ $el }{ $phr_fld, $ctg_fld };
    #($text and $ctg)
    #    or die "Void text or ctg in add_phrase_to_categ: ($table, $ctg_fld, $phr_fld, $id_fld, $id); ($text, $ctg)";

    my $phl = $proj->phrase_list( $text );
    #$proj->dd([ $phl->perl_array ]);
    $proj->save_phrase_list($phl);
    my $ctg_id = $proj->get_category_id($ctg);
    my $url = join("&",
        "ind.pl?cmd=edit_user_phrases",
        "catid1=". $ctg_id,
        "phlid1=". $phl->cache_id,
        "action1=Add",
        "viewoptionsstr=".$form->{viewoptionsstr},
    );

    #$proj->dd($url);
    $proj->do_redirect($url);
}

#Парсим названия категорий. Потому что могут быть категории или id-шники. Проверяем категории на валидность
#Arguments: строка, которая пришла из запроса пользователя(окошко Категории).
sub _categs_or_id_2_categs_or_id {
    my ($proj, $categs_str, $type) = @_;
    $type //= "id";
    $categs_str =~ s/^\s*(.*?)\s*$/$1/;
    my @data = split(/\s*\/\s*/,$categs_str);
    my @transform_categs;
    for my $unknown (@data) {
        my $text;
        if (my $id = $proj->categs_tree->get_minicateg_id($unknown)) {
            my $categ = $unknown;
            if ($type eq "id") {
                $text = $id;
            }
            if ($type eq "categ") {
                $text = $categ;
            }
        } elsif (my $categ = $proj->categs_tree->get_minicateg_by_id($unknown)) {
            my $id = $unknown;
            if ($type eq "id") {
                $text = $id;
            }
            if ($type eq "categ") {
                $text = $categ;
            }
        }
        die "Bad input ($unknown)" unless ($text);
        push @transform_categs, $text;
    }
    return @transform_categs;
}

sub banners_tagging_sets :CMDH {
    my ($proj, $vars) = @_;
    my $lang = $vars->{viewoptions}{lang};

    return {
        base => 'base_tagging_sets',
        title => 'Наборы баннеров для разметки',
        table => 'BannersTaggingSets',
        extparams => {
            'TaggingSetsTable' => 'BannersTaggingElems',
            'tagging_elems'    => 'banners_tagging_elems',
        },
        fix_sql_problem => 0,
        fields => [
            {  name => 'state', title => 'State', shlist => 0,  },
            {  name => 'BannersCount', title => 'Count', shlist => 0, redefine_base => 1, },
            {  name => 'Type', title => 'Type', shlist => 1, edlist => 1, ftype => 'select', inline => 1, redefine_base => 1, width => 90,
              selectlist => [
                      { name => 'Обычный',      value => 'Regular',     default => 1,  color => '#FFB01E', },
                      { name => 'Эталон',    value => 'Benchmark', color => '#19D319', },
                  ],
            },
# TODO: добавить продакшен-категоризацию (возможно, на другой странице)
#            {  name => 'production_minicategs', title => 'Prod categs', shlist => 1, edlist => 1, ftype => 'checkbox', width => 30, },
            {  name => 'Name', title => 'Name', edlist => 1, after => "SetID", width => 150, redefine_base => 1, },
            {  name => 'DataFile',
                  edlist => 1,
                  title => 'Upload',
                  ftype => 'file',
                  shlist => 0,
            },
            { extname => "YTTable", title => 'YT table', edlist => 1, shlist => 0, }, # Путь к таблице на YT для загрузки данных
        ],
        toptext => qq[
    <div style="line-height: 1">

        <p style="height:5px;">Доступна загрузка баннеров по определенным категориям. Нужно заполнить поле Категории</p>
        <ol>
            <ol>
            <p>
            Категории указываются либо своим id-шником, либо точным названием категории. Категорий может быть несколько.
            <br />
            Если категория одна, то ищет баннеры у которых среди категорий есть указанная.
            <br />
            Если категорий несколько (они указываются через '/'), то ищет одинаковое количество баннеров каждой категории.
            <br />
            </ol>
            Количество баннеров указывается в поле Count(по умолчанию 1000)
            <br />
            Если стоит галочка возле "Категория единственная", то у всех баннеров может быть только одна категория.
        </ol>

        <p style="height:5px;">Доступна загрузка файлов двух типов:</p>
        <ol>
            <li style="padding:0px;height:19px;"><strong>tskv. </strong>Пример:</li>
            <p>bid=123&nbsp;&nbsp;&nbsp;title=Лучшие офисные стулья в мире!&nbsp;&nbsp;&nbsp;phrases=офисные стулья,офисные столы&nbsp;&nbsp;&nbsp; outer_category=Офисная мебель&nbsp;&nbsp;&nbsp;&nbsp; manual_category=Мебель для офиса<br />
            bid=321&nbsp;&nbsp;&nbsp;title=Оригинальные поздравления только у нас!&nbsp;&nbsp;&nbsp;phrases=поздравить маму с днём рождения&nbsp;&nbsp;&nbsp; outer_category=Поздравления</p>
            <li style="padding:0px;height:19px;"><strong>tsv. </strong>Пример:</li>
            <p>title&nbsp;&nbsp;&nbsp;bid&nbsp;&nbsp;&nbsp;phrases&nbsp;&nbsp;&nbsp;&nbsp;outer_category&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; manual_category<br />
            Лучшие офисные стулья в мире!&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;123&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;офисные стулья,офисные столы&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Офисная мебель&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Мебель для офиса<br />
            Оригинальные поздравления только у нас!&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;321&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;поздравить маму с днём рождения&nbsp;&nbsp;&nbsp;&nbsp;Поздравления</p>
        </ol>

        <p style="height:5px;">Доступные поля (вы можете выбрать ЛЮБЫЕ из этих полей и использовать их в любом порядке):</p>
    </div>

    <ul>
        <li style="padding:0px;height:19px;"><strong>bid</strong> &ndash; Директ id баннера</li>
        <li style="padding:0px;height:19px;"><strong>BannerID</strong> &ndash; БК id баннера</li>
        <li style="padding:0px;height:19px;"><strong>title</strong> &ndash; заголовок баннера</li>
        <li style="padding:0px;height:19px;"><strong>title_extension</strong> &ndash; второй заголовок баннера</li>
        <li style="padding:0px;height:19px;"><strong>body</strong> &ndash; тело баннера</li>
        <li style="padding:0px;height:19px;"><strong>phrases</strong> &ndash; фразы баннера, разделённые запятыми</li>
        <li style="padding:0px;height:19px;"><strong>url</strong> &ndash; ссылка</li>
        <li style="padding:0px;height:19px;"><strong>outer_category</strong> &ndash; категоризация согласно внешнему источнику</li>
        <li style="padding:0px;height:19px;"><strong>manual_category</strong> &ndash; &laquo;ручная&raquo; разметка категории.</li>
        <li style="padding:0px;height:19px;"><strong>comment</strong> &ndash; комментарий к баннеру</li>
    </ul>
        <p>Если указаны bid или BannerID и не указано ни одно из полей body, title, url, phrases, эти поля будут заполнены по указанному id баннера</p>

        <p>Также доступна загрузка данных из таблицы на YT (hahn)</p>
        ],
        filters => [
               {  name => 'SetID', field => 'SetID', list => 1, },
               {  name => 'Эталон/Обычный', field => 'Type', grp => 1, like => 0, use_other_filters => 1 },
               {  name => 'Login', field => 'Login', grp => 1, like => 0, use_other_filters => 1 },
        ],
        action_before_add => sub {
            my ($proj, $data) = @_;
            $data->{UpdateTime} ||= $proj->dates->cur_date('db_time');
            $data->{Login} ||= $proj->login;
            $data->{production_minicategs} = 0 unless ($data->{production_minicategs});
            $data->{state} = 'done'; # переписать на '', когда будет подключена обработка
            $data->{BannersCount} = $default_items_quantity unless ($data->{BannersCount});
        },
        action_onadd => sub {
            my ($proj, $id, $data) = @_;
            my $dbt_tsb = $proj->dbtable('BannersTaggingElems');
            my $no_recategorization = 0;

            my $bnl;
            if($data->{DataFile}) {
                my $str_sep = ($data->{DataFile} =~ /\r\n/) ? "\r\n" : "\n";
                $bnl = $proj->bf->banner_list_from_file([ split $str_sep, $data->{DataFile} ]);
            } elsif ($data->{Categs}) {
                my $flag_one_categ = $data->{Only_one_categ};
                my @requests_text = map {"categ_$_" } _categs_or_id_2_categs_or_id($proj, $data->{Categs});
                my $div_count = int ($data->{BannersCount} / (@requests_text));
                my $mod_count = $data->{BannersCount} % (@requests_text);
                my %ids;
                $bnl = [];
                for my $text (@requests_text) {
                    my $phrase = $proj->phrase($text);
                    my $count = $div_count;
                    if ($mod_count) {
                        $count++;
                        $mod_count--;
                    }
                    # Константа. Во сколько раз увелечиваем количество, потому что некоторые банеры могут быть не уникальные
                    my $multiplier = 2;
                    $multiplier = 1 if (@requests_text == 1);
                    $multiplier = 3 if ($flag_one_categ);
                    my @ids_to_push = $proj->banners_bender->find_ids($phrase, $count * $multiplier);
                    my $bnrs_to_push = $proj->bf->banner_list(\@ids_to_push);
                    for my $banner (@$bnrs_to_push) {
                        my $id = $banner->id;
                        next if ($ids{$id});
                        if ($flag_one_categ) {
                            my @categs = $banner->get_minicategs;
                            next if (@categs != 1);
                        }
                        $count--;
                        $ids{$id} = 1;
                        push @$bnl, $banner;
                        last unless ($count);
                    }
                }
                $bnl = $proj->bf->banner_list($bnl);
            } elsif ($data->{YTTable}) {
                my $yt_table = $data->{YTTable};
                $yt_table =~ s/(^\s+|\s+$)//g;
                if (!$yt_table or $yt_table =~ m/[^\/a-z0-9\_\-]/i) {
                    die "Bad yt_table ($yt_table)";
                }

                # Защита от больших таблиц
                my $row_count = $proj->yt_client->get_attribute($yt_table, 'row_count');
                my $max_allowed_row_count = 20_000;
                if ($row_count > $max_allowed_row_count) {
                    die "Can not load, because table $yt_table is too large: row_count=$row_count";
                }

                my $data = $proj->yt_client->read_table($yt_table, "'<encode_utf8=false>json'");
                $bnl = $proj->bf->ythashes2bnl($data);
                $_->{outer_category} = $_->{mctgs} for @$bnl;
                $no_recategorization = 1;
            } else {
                $bnl = $proj->bf->random_banners($data->{BannersCount}, $lang);
            }

            my @result = ();
            for my $bn ( @$bnl ) {
                my (@categs, $ctphs);
                if ($no_recategorization) {
                    $ctphs = [];
                } else {
                    @categs = $bn->get_minicategs;
                    $ctphs = [ map {{ category => $_->[0], phrase => $_->[1], }} map { @$_ } $bn->get_categs_phrases ];
                }

                push @result, {
                    SetID           => $id,
                    CategoriesString => join('/', @categs),
                    CategPhrases    => $proj->serial($ctphs),
                    bid             => $bn->{bid} || $bn->{id} || 0,
                    BannerID        => $bn->{bannerid} || $bn->{bs_banner_id} || 0,
                    Data            => $proj->serial([{
                        map {
                            if ( $_ eq 'phrases' ) {
                                'phrases' => ''.($bn->{all_phrases} || $bn->{phrases} || '')
                            }
                            else {
                                $_ => ''.$bn->{$_}
                            }
                        } qw{title title_extension body phrases url} }]),
                    Mode            => ((@categs || $bn->{outer_category}) ? '' : 'uncat'),
                    OuterCategory   => $bn->{outer_category},
                    ManualCategory  => $bn->{manual_category},
                    Comment         => $bn->{comment},
                };
            }
            $dbt_tsb->Add(\@result);
        },
    };
}

sub banners_tagging_elems :CMDH {
    my ($proj, $vars) = @_;

    my $set_info = "";
    if ($vars and exists ($vars->{form}) and (exists $vars->{form}->{SetID})) {
        my $set_id = ($vars->{form}->{SetID} =~ /(\d+)/)[0];
        if ($set_id) {
            my $sql_request = "select SetID, Name, BannersCount, UpdateTime, Type from BannersTaggingSets where SetID = $set_id";
            my $sql_set_info = $proj->catalogia_media_dbh->List_SQL($sql_request)->[0];
            $set_info = join(';',
                "SetID = $sql_set_info->{SetID}",
                "Name = '$sql_set_info->{Name}'",
                $sql_set_info->{UpdateTime},
                "BannersCount($sql_set_info->{BannersCount})",
                "Type = '$sql_set_info->{Type}'",
            ) if $sql_set_info;
        }
    }

    return {
        base => 'base_tagging_elems',
        title => 'Разметка баннеров.' . "<br>$set_info",
        table => 'BannersTaggingElems',
        fix_sql_problem => 0,
        fields => [
            { title => 'IDs', shlist => 1, extname => 'IDs', after => 'SetID',
                grp => [
                    { name => 'BannerID', title => 'BannerID', shlist => 1, edlist => 0, },
                    { name => 'bid', title => 'bid', shlist => 1, edlist => 0, showmacro => 'bid2link', },
                ],
                inlinefilter => { data_field_name => 'bid', },
            },
            { show_banner_saved_inf => 'Data', after => 'SetID',
                extname => 'Serial_Data', #Добавили extname, чтобы находить это поле, когда меняем порядок в dblist_fldorder_mode
                title => 'BannerInf', #Добавили title, чтобы extname не заменяло его собой
                width => 200
            },
            { extname => 'CurrentCategPhrases', shlist => 1, update_base => 1, },
        ],
        action_onlist => sub {
            my ($proj, $el) = @_;
            my $bnr_data = $proj->deserial($el->{Data})->[0];
            my $bnr = $proj->bf->dbhash2banner($bnr_data);

            my $ctphs = $bnr->get_categs_phrases_hlist;

            # TODO сделать вместо $bnr->get_categs_phrases_hlist все фразы из сабфрейзера
            #$proj->get_language('ru')->layer_categs->

            $el->{CurrentCategPhrases} = $proj->serial($ctphs);
        },
        # здесь поле Data для баннеров при выгрузке будет заменено на отдельные поля body title phrases url
        data_import_export => {
            list => [qw(BannerID bid Data CategoriesString CategPhrases OuterCategory ManualCategory Mode Comment)],
            no_import => 1,
            export => {
                use_grp => 1,
                filtered => 1,
                headers => 1,
                readable_CategPhrases => ['CategPhrases'],
                readable_tagging_mode => 1,
                lang_for_categs => 1,
                split_banner_data_field => 1,
            },
        },
        pager => { name => 'p', cc => 50, },
    };
}

sub flags_tagging_sets :CMDH {
    my ($proj, $vars) = @_;
    my $lang = $vars->{viewoptions}{lang};

    return {
        base => 'base_tagging_sets',
        title => 'Наборы баннеров для разметки флагов',
        table => 'FlagsTaggingSets',
        extparams => {
            'TaggingSetsTable' => 'FlagsTaggingElems',
            'tagging_elems'    => 'flags_tagging_elems',
        },
        fix_sql_problem => 0,
        fields => [
            {  name => 'DataFile',
                  edlist => 1,
                  title => 'Upload',
                  ftype => 'file',
                  #filenamefield => 'DataFileName',
                  shlist => 0,
            },
            { name => "Name", title => 'Name', redefine_base => 1, width => 180, after => "SetID", },
            { name => 'BannersCount', title => 'Count', shlist => 0, redefine_base => 1 },
            { name => "Categs", edlist => 0, delete_base => 1},
            { name => "Only_one_categ", edlist => 0, delete_base => 1},
            { extsql => ['
                   select SetID,
                       sum(IF(Mode="goodflag", 1, IF(Mode="good", 1, 0))) good,
                       sum(IF(Mode="badflag", 1, IF(Mode="bad", 1, 0))) bads,
                       sum(IF(Mode="uncat", 0, 1))/(count(*) + 1) recalls,
                       sum(IF(Mode="goodflag", 1, IF(Mode="good", 1, 0)))/sum(IF(Mode="badflag", 1, IF(Mode="bad", 1, IF(Mode="good", 1, IF(Mode="goodflag", 1, 0))))) `precisions`
                   from TaggingSetsTable where SetID in (?) group by SetID
              ', 'SetID'], redefine_base => 1,
            },
            { extname => 'good', width => 40, after => 'cc', },
            { extname => 'bads', width => 40, after => 'good', },
            { extname => 'precisions', width => 40, after => 'bads', },
            { extname => 'recalls', redefine_base => 1, after => 'precisions', },
            { extname => 'recall', redefine_base => 1, shlist => 0, },
            { extname => 'goods', redefine_base => 1, shlist => 0, },
            { extname => 'bad', redefine_base => 1, shlist => 0,},
            { extname => 'precision', width => 40, redefine_base => 1, shlist => 0, },
            { name => "Login", redefine_base => 1, shlist => 0, edlist => 0, },
        ],
        toptext => qq[
    <div style="line-height: 1">
        <p  style="height:5px;">Доступна загрузка файлов двух типов:</p>

        <ol>
            <li style="padding:0px;height:19px;"><strong>tskv. </strong>Пример:</li>
            <p>url=http://www.mebelux.ru/list/ofis&hellip;&nbsp;&nbsp;&nbsp; outer_category=Офисная мебель&nbsp;&nbsp;&nbsp;&nbsp; manual_category=Мебель для офиса<br />
            url=http://fun-cards.net/&hellip;&nbsp;&nbsp;&nbsp; outer_category=Поздравления</p>
            <li style="padding:0px;height:19px;"><strong>tsv. </strong>Пример:</li>
            <p>url&nbsp;&nbsp;&nbsp;&nbsp; outer_category&nbsp;&nbsp;&nbsp;&nbsp; manual_category<br />
            http://www.mebelux.ru/list/ofis&hellip;&nbsp;&nbsp;&nbsp; Офисная мебель&nbsp;&nbsp;&nbsp;&nbsp; Мебель для офиса<br />
            http://fun-cards.net/&hellip;&nbsp;&nbsp;&nbsp; Поздравления</p>
        </ol>

        <p  style="height:5px;">Доступные поля:</p>
    </div>

    <ul>
        <li style="padding:0px;height:19px;"><strong>bid</strong> &ndash; Директ id баннера</li>
        <li style="padding:0px;height:19px;"><strong>title</strong> &ndash; заголовок баннера</li>
        <li style="padding:0px;height:19px;"><strong>body</strong> &ndash; тело баннера</li>
        <li style="padding:0px;height:19px;"><strong>phrases</strong> &ndash; фразы баннера, разделённые запятыми</li>
        <li style="padding:0px;height:19px;"><strong>url</strong> &ndash; ссылка</li>
        <li style="padding:0px;height:19px;"><strong>comment</strong> &ndash; комментарий к баннеру</li>
    </ul>
        <p>Если указан bid и не указано ни одно из полей body, title, url, phrases, эти поля будут заполнены автоматически по указанному id баннера</p>
        ],
        action_before_add => sub {
            my ($proj, $data) = @_;
            $data->{UpdateTime} ||= $proj->dates->cur_date('db_time');
            #$data->{Login} ||= $proj->login; TODO: при необходимости добавить это поле в таблицу для флагов
        },
        action_onadd => sub {
            my ($proj, $id, $data) = @_;

            my $bnl;
            if($data->{DataFile}) {
                my $str_sep = ($data->{DataFile} =~ /\r\n/) ? "\r\n" : "\n";
                $bnl = $proj->bf->banner_list_from_file([ split $str_sep, $data->{DataFile} ]);
            } else {
                my $bnrcount = $data->{BannersCount} || $default_items_quantity;
                $bnl = $proj->bf->random_banners($bnrcount, $lang);
            }

            $proj->category_interface->create_flags_tagging_set($bnl, $id);
        },
    };
}

sub refresh_flags_tagging :CMD {
    my ($proj, $vars) = @_;
    my $set_id = $proj->form->{SetID};
    my $table = $proj->dbtable("FlagsTaggingElems");
    my $elems = $table->List({ SetID => $set_id });
    my $bid2banner = { map{$_->id => $_} @{$proj->bf->banner_list([ map{$_->{bid}} @$elems ])} };

    for my $elem (@$elems) {
        my $bnr = $bid2banner->{$elem->{bid}};
        next if !$bnr;

        $proj->category_interface->update_flags_tagging_entry($bnr, $elem);

        $table->Add($elem, {replace => 1});
    }

    $proj->do_redirect("?cmd=flags_tagging_elems&act=List&SetID=$set_id");
}

sub flags_tagging_elems :CMDH {
    my ($proj, $vars) = @_;

    my $set_id = '';
    if ($vars and exists ($vars->{form}) and (exists $vars->{form}->{SetID})) {
        $set_id = ": SetID ".($vars->{form}->{SetID});
    };

    my $flags_showsubel = sub {
        my ($el, $f) = @_;
        my $result = $el->{$f->{name}};

        if ($result) {
            $result =~ s/,/ /g;
            $result =~ s/\s*\S*dynamic\S*\s*/ /g;
        }

        return $result;
    };

    return {
        base => 'base_tagging_elems',
        title => 'Разметка флагов'.$set_id,
        table => 'FlagsTaggingElems',
        fix_sql_problem => 0,
        fldselection => 1,
        logchanges => 1,
        fields => [
            { name => "bid", title => "bid", shlist => 1, after => "SetID", showmacro => 'bid2infolink', inlinefilter => {}, },
            { show_banner_saved_inf => 'Data', after => 'SetID', width => 200, },
            { name => "Title", shlist => 0, fldslcthide => 1, after => "Data" },
            { name => "Body", shlist => 0, fldslcthide => 1, after => "Data" },
            { name => "PrefilteredText", shlist => 1, after => 'Data' },
            { name => "OldFlags", shlist => 1, after => "Categories", showsubel => $flags_showsubel },
            { name => "Flags", shlist => 1, after => "Categories", showsubel => $flags_showsubel, inlinefilter => { group => 1 }, },
            { name => "OuterCategory", delete_base => 1, },
            { name => "ManualCategory", delete_base => 1, },
            { name => "Mode", update_base => 1, selectlist => $selectlist_categs_flags, },
        ],
        filters => [
               {  title => 'Текст', field => 'Data', grp => 0, like => 1, use_other_filters => 1 },
               {  name => 'Categories', field => 'CategoriesString', delete_base => 1, },
               {  name => 'ManualCategory', field => 'ManualCategory', delete_base => 1, },
               {  name => 'OuterCategory', field => 'OuterCategory', delete_base => 1, },
        ],
        topmenu => [
            { title => "Флаги", sublist => [
                { title => "Пересчитать", url => "?cmd=refresh_flags_tagging", addformparams => { SetID =>  "SetID" } },
            ] }
        ],
        data_import_export => {
            list => [qw(bid Data CategoriesString Flags Mode)],
            no_import => 1,
            export => {
                headers => 1,
                split_banner_data_field => 1,
                use_grp => 1,
                filtered => 1,
            },
        },
    };
}

sub urls_tagging_sets :CMDH {
    my ($proj, $vars) = @_;
    my $lang = $vars->{viewoptions}{lang};

    return {
        base => 'base_tagging_sets',
        title => 'Наборы страниц для разметки',
        table => 'UrlsTaggingSets',
        extparams => {
            'TaggingSetsTable' => 'UrlsTaggingElems',
            'tagging_elems'    => 'urls_tagging_elems',
        },
        fix_sql_problem => 0,
        fields => [
#            {  name => 'BannersCount', title => 'Count', width => 1 },
            {  name => 'Type', title => 'Type', shlist => 1, edlist => 1, ftype => 'select', inline => 1, redefine_base => 1, width => 90,
              selectlist => [
                      { name => 'Обычный',      value => 'Regular',     default => 1,  color => '#FFB01E', },
                      { name => 'Эталон',    value => 'Benchmark', color => '#19D319', },
                  ],
            },
            {  name => 'BannersCount', title => 'Count', shlist => 0, delete_base => 1, },
            { name => "Categs", edlist => 0, delete_base => 1},
            { name => "Only_one_categ", edlist => 0, delete_base => 1},
            {  name => 'DataFile',
                  edlist => 1,
                  title => 'Upload',
                  ftype => 'file',
                  shlist => 0,
            },
        ],
        filters => [
               {  name => 'SetID', field => 'SetID', list => 1, },
               {  name => 'Эталон/Обычный', field => 'Type', grp => 1, like => 0, use_other_filters => 1 },
               {  name => 'Login', field => 'Login', grp => 1, like => 0, use_other_filters => 1 },
        ],
        toptext => qq[
    <div style="line-height: 1">
        <p  style="height:5px;">Доступна загрузка файлов двух типов:</p>

        <ol>
            <li style="padding:0px;height:19px;"><strong>tskv. </strong>Пример:</li>
            <p>url=http://www.mebelux.ru/list/ofis&hellip;&nbsp;&nbsp;&nbsp; outer_category=Офисная мебель&nbsp;&nbsp;&nbsp;&nbsp; manual_category=Мебель для офиса<br />
            url=http://fun-cards.net/&hellip;&nbsp;&nbsp;&nbsp; outer_category=Поздравления</p>
            <li style="padding:0px;height:19px;"><strong>tsv. </strong>Пример:</li>
            <p>url&nbsp;&nbsp;&nbsp;&nbsp; outer_category&nbsp;&nbsp;&nbsp;&nbsp; manual_category<br />
            http://www.mebelux.ru/list/ofis&hellip;&nbsp;&nbsp;&nbsp; Офисная мебель&nbsp;&nbsp;&nbsp;&nbsp; Мебель для офиса<br />
            http://fun-cards.net/&hellip;&nbsp;&nbsp;&nbsp; Поздравления</p>
        </ol>

        <p  style="height:5px;">Доступные поля:</p>
    </div>

    <ul>
        <li style="padding:0px;height:19px;"><strong>url</strong> &ndash; url баннера</li>
        <li style="padding:0px;height:19px;"><strong>outer_category</strong> &ndash; категоризация согласно внешнему источнику</li>
        <li style="padding:0px;height:19px;"><strong>manual_category</strong> &ndash; &laquo;ручная&raquo; разметка категории.</li>
    </ul>
        ],
        action_before_add => sub {
            my ($proj, $data) = @_;
            $data->{UpdateTime} ||= $proj->dates->cur_date('db_time');
            $data->{Login} ||= $proj->login;
        },
        action_onadd => sub {
            my ($proj, $id, $data) = @_;

            my $dbt_tsb = $proj->dbtable('UrlsTaggingElems');

            my $bnl;
            if($data->{DataFile}) {
                my $str_sep = ($data->{DataFile} =~ /\r\n/) ? "\r\n" : "\n";
                $bnl = $proj->bf->banner_list_from_file([ split $str_sep, $data->{DataFile} ]);
            } else {
                my $bnrcount = $data->{BannersCount} || $default_items_quantity;
                my $bnl = $proj->bf->random_active_banners($bnrcount, $lang);
            }

            my @result = ();
            my $lang = $proj->current_lang;
            for my $bn ( @$bnl ) {
                my $p = $bn->page;
                next unless $p->url;

                my @categs = $p->get_minicategs;
                my $data = $p->get_categs_subphrases_with_param({no_hier => 1});
                my $ctphs = [ map { my $t = $_;  map {
                         { phrase => $t, category => $_, tags => join(',', sort keys %{$data->{$t}{tags}}),  }
                     } keys %{$data->{$t}{categs}} }  keys %$data ];
                #$proj->dd($ctphs);
                #exit;

                my $hh = {
                    SetID        => $id,
                    CategoriesString => join('/', @categs),
                    CategPhrases => $proj->serial($ctphs),
                    Data         => $proj->serial([{}]),
                    Url          => $p->url,
                    Mode        => (@categs ? '' : 'uncat'),
                    OuterCategory   => $bn->{outer_category},
                    ManualCategory  => $bn->{manual_category},
                };

                $dbt_tsb->Add($hh);
            }
        },

    };
}

sub urls_tagging_elems :CMDH {
    my ($proj, $vars) = @_;

    my $set_id = '';
    if ($vars and exists ($vars->{form}) and (exists $vars->{form}->{SetID})) {
        $set_id = ": SetID ".($vars->{form}->{SetID});
    };

    return {
        base => 'base_tagging_elems',
        title => 'Разметка страниц',
        table => 'UrlsTaggingElems',
        fix_sql_problem => 0,
        fields => [
            { name => 'Url', after => 'SetID', shlist => 1, showmacro => 'exturl', },
            { title => 'Categories', update_base => 1, after => 'Url', },
        ],

        data_import_export => {
            list => [qw(SetID Url CategoriesString CategPhrases OuterCategory ManualCategory Mode)],
            no_import => 1,
            export => {
                use_grp => 1,
                filtered => 1,
                headers => 1,
                readable_CategPhrases => ['CategPhrases'],
                readable_tagging_mode => 1,
                lang_for_categs => 1,
            },
        },
        #pager => { name => 'p', cc => 20, },
    };
}

sub phrases_tagging_sets :CMDH {
    my ($proj, $vars) = @_;
    my $lang = $vars->{viewoptions}{lang};

    return {
        base => 'base_tagging_sets',
        title => 'Наборы фраз для разметки',
        table => 'PhrasesTaggingSets',
        extparams => {
            'TaggingSetsTable' => 'PhrasesTaggingElems',
            'tagging_elems'    => 'phrases_tagging_elems',
        },
        fix_sql_problem => 0,
        fields => [
            { name => 'Source', after => 'Uploaded', shlist => 1, width => 50, ftype => 'select', selectlist => [ map {{ name => $_, value => $_ }} qw[ banners advq ] ], },
            { name => 'BannersCount', title => 'Count', shlist => 0, delete_base => 1 },
            { name => 'PhrasesCount', title => 'Count', edlist => 1, shlist => 0, },
            { name => 'Type', title => 'Type', shlist => 1, edlist => 1, ftype => 'select', inline => 1, redefine_base => 1, width => 90,
              selectlist => [
                      { name => 'Обычный',      value => 'Regular',     default => 1,  color => '#FFB01E', },
                      { name => 'Эталон',    value => 'Benchmark', color => '#19D319', },
                  ],
            },
            { name => 'DataFile',
                  edlist => 1,
                  title => 'Upload',
                  ftype => 'file',
                  shlist => 0,
            },
        ],
        toptext => qq[
    <div style="line-height: 1">
        <p style="height:5px;">Доступна выгрузка advq-фраз по категории. Нужно заполнить поле Категории</p>
        <ol>
            <ol>
            <p>
                Категории указываются либо своим id-шником, либо точным названием категории. Категорий может быть несколько.
            <br />
                Если категория одна, то ищет фразы у которых среди категорий есть указанная.
            <br />
                Если категорий несколько (они указываются через '/'), то ищет одинаковое количество фраз каждой категории.
            <br />
            </ol>
            Количество фраз указывается в поле Count(по умолчанию 1000)
            <br />
            Если стоит галочка возле "Категория единственная", то у всех фраз может быть только одна категория.
        </ol>

        <p style="height:5px;">Доступна загрузка файлов двух типов:</p>
        <ol>
            <li style="padding:0px;height:19px;"><strong>tskv. </strong>Пример:</li>
            <p>phrase=офисные стулья&nbsp;&nbsp;&nbsp; outer_category=Офисная мебель&nbsp;&nbsp;&nbsp;&nbsp; manual_category=Мебель для офиса<br />
            phrase=поздравить маму с днём рождения&nbsp;&nbsp;&nbsp; outer_category=Поздравления</p>
            <li style="padding:0px;height:19px;"><strong>tsv. </strong>Пример:</li>
            <p>phrase&nbsp;&nbsp;&nbsp;&nbsp; outer_category&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; manual_category<br />
            офисные стулья&nbsp;&nbsp;&nbsp; Офисная мебель&nbsp;&nbsp;&nbsp;&nbsp; Мебель для офиса<br />
            поздравить маму с днём рождения&nbsp;&nbsp;&nbsp; Поздравления</p>
        </ol>

        <p  style="height:5px;">Доступные поля:</p>
    </div>

    <ul>
        <li style="padding:0px;height:19px;"><strong>phrase</strong> &ndash; фраза</li>
        <li style="padding:0px;height:19px;"><strong>outer_category</strong> &ndash; категоризация согласно внешнему источнику</li>
        <li style="padding:0px;height:19px;"><strong>manual_category</strong> &ndash; &laquo;ручная&raquo; разметка категории.</li>
        <li style="padding:0px;height:19px;"><strong>comment</strong> &ndash; комментарий к фразе</li>
    </ul>
        ],
        filters => [
               {  name => 'SetID', field => 'SetID', list => 1, },
               {  name => 'Эталон/Обычный', field => 'Type', grp => 1, like => 0, use_other_filters => 1 },
               {  name => 'Login', field => 'Login', grp => 1, like => 0, use_other_filters => 1 },
        ],
        action_before_add => sub {
            my ($proj, $data) = @_;
            $data->{UpdateTime} ||= $proj->dates->cur_date('db_time');
            $data->{Login} ||= $proj->login;
        },
        action_onadd => sub {
            my ($proj, $id, $data) = @_;

            my $dbt_tsb = $proj->dbtable('PhrasesTaggingElems');
            my $lang = $proj->current_lang;

            my $add_phrase_func = sub {
                my ($phr, $comment, $add_to_hh) = @_;

                my @categs = $phr->get_minicategs;
                my $ctphs = [ map {{ category => $_->[0], phrase => $_->[1], }} map { @$_ } $phr->get_categs_phrases ];

                my $hh = {
                    SetID           => $id,
                    CategoriesString => join('/', @categs),
                    CategPhrases    => $proj->serial($ctphs),
                    Phrase          => "$phr",
                    Mode            => (@categs ? '' : 'uncat'),
                    Comment         => $comment // '',
                };

                if ($add_to_hh and (ref $add_to_hh eq 'HASH')) {
                    $hh = { %$hh, %$add_to_hh };
                }
                $dbt_tsb->Add($hh);
            };

            my $bnl;
            if($data->{DataFile}) {
                my $str_sep = ($data->{DataFile} =~ /\r\n/) ? "\r\n" : "\n";
                $bnl = $proj->bf->banner_list_from_file([ split $str_sep, $data->{DataFile} ]);
                $data->{Source} = 'file';
                $data->{BannersCount} = $bnl->number_of_banners;
                $proj->Do_SQL("
                    UPDATE PhrasesTaggingSets
                    SET Source = \'".($data->{Source})."\', BannersCount = \'".($data->{BannersCount})."\' WHERE SetID = $id;");

                for my $bn ( @$bnl ) {
                    my $add_to_hh = {
                        OuterCategory   => $bn->{outer_category} // '',
                        ManualCategory  => $bn->{manual_category} // '',
                    };
                    my $comment = $bn->{comment};
                    for my $ph (@{$bn->phl}) {
                        $add_phrase_func->($ph, $comment, $add_to_hh);
                    }
                }

            } else {
                my $need_phrase_count = $data->{PhrasesCount} || $default_items_quantity;

                if ($data->{Source} eq 'banners') {
                    $bnl = $proj->bf->random_active_banners($need_phrase_count * 2, $lang);

                    my $phrase_count = 0;
                    for my $bn ( @$bnl ) {
                        my $phl = $bn->phl;
                        next unless @$phl;

                        my $ph = undef;
                        for my $test_phr (@$phl) {
                            # должно быть хотя бы одно слово без цифр
                            next if !grep{!/\d/} $test_phr->pluswords;

                            # определение языка иногда даёт сбой, поэтому проверяем на кириллицу
                            if($lang eq "ru" || $test_phr !~ /[а-я]/i) {
                                $ph = $test_phr;
                                last;
                            }
                        }
                        next if !$ph;
                        $add_phrase_func->($ph);

                        if (++$phrase_count >= $need_phrase_count) {
                            $proj->Do_SQL("UPDATE PhrasesTaggingSets SET BannersCount = \'$need_phrase_count\' WHERE SetID = $id;");
                            last;
                        }
                    }
                } else {
                    die "Unknown source ".$data->{Source};
                }
            }
        },

    };
}

sub phrases_tagging_elems :CMDH {
    my ($proj, $vars) = @_;

    my $set_info = "";
    if ($vars and exists ($vars->{form}) and (exists $vars->{form}->{SetID})) {
        my $set_id = ($vars->{form}->{SetID} =~ /(\d+)/)[0];
        if ($set_id) {
            my $sql_request = "select SetID, Name, UpdateTime, BannersCount, Type from PhrasesTaggingSets where SetID = $set_id";
            my $sql_set_info = $proj->catalogia_media_dbh->List_SQL($sql_request)->[0];
            $set_info = join(";",
                "SetID = $sql_set_info->{SetID}",
                "Name = '$sql_set_info->{Name}'",
                $sql_set_info->{UpdateTime},
                "BannersCount($sql_set_info->{BannersCount})",
                "Type = '$sql_set_info->{Type}'",
            ) if $sql_set_info;
        }
    }

    return {
        base => 'base_tagging_elems',
        title => 'Разметка фраз' . "<br>$set_info",
        table => 'PhrasesTaggingElems',
        fix_sql_problem => 0,
        topmenu => [
            { title => 'Другие действия', sublist => [
                  { title => 'Набор фраз для разметки', url => '?cmd=phrases_tagging_sets' },
           #       { title => 'Manual Categories to edit_phrase_list', name => 'edit_phrase_list', addfilters => 1,
           #             redir_action => sub {
           #                 my ($self, $lst1, $lst2, $prmsh) = @_;
           #                 my $proj = $self->proj;
           #                 my $setid = $proj->form->{SetID};
           #                 my $dbt = $proj->dbtable('PhrasesTaggingElems');
           #                 my $lst = $dbt->List({ SetID => $setid, 'length(ManualCategory) > ' => '0', });
           #                 my $phl = $proj->phrase_list([ map { $_->{Phrase} . ' => '.$_->{ManualCategory} } @$lst ]);
           #                $proj->save_phrase_list($phl);

           #                 $proj->do_redirect(join("&",
           #                     "ind.pl?cmd=edit_phrase_list",
           #                     "act=showphl",
           #                     "phlid=".$phl->cache_id,
           #                     "viewoptionsstr=".$form->{viewoptionsstr},
           #                 ));
           #             },
           #       }
            ], },
        ],
        fields => [
            { name => 'Phrase', after => 'SetID', showmacro => 'phrase2link', shlist => 1, },
            { title => "ToCtg", shlist => 1, after => "Mode", extname => 'ToCtg',
                showmacroel => 'show_btn_field',
                geturl => sub {
                    my ($el, $f) = @_;
                    my $url = join("&",
                        "ind.pl?cmd=add_phrase_to_categ",
                        "table=PhrasesTaggingElems",
                        "phr_fld=Phrase",
                        "ctg_fld=ManualCategory",
                        "id=".$el->{ID},
                        "viewoptionsstr=".$proj->form->{viewoptionsstr},
                    );
                    return $url;
                },
            },
        ],
        data_import_export => {
            list => [qw(SetID Phrase CategoriesString CategPhrases OuterCategory ManualCategory Mode Comment)],
            no_import => 1,
            export => {
                use_grp => 1,
                filtered => 1,
                headers => 1,
                readable_CategPhrases => ['CategPhrases'],
                readable_tagging_mode => 1,
                lang_for_categs => 1,
            },
        },
    };
}

sub data_tagging_elems :CMDH {
    my ($proj, $vars) = @_;
    my $set_id = '';
    if ($vars and exists ($vars->{form}) and (exists $vars->{form}->{SetID})) {
        $set_id = ": SetID ".($vars->{form}->{SetID});
    };

    my $form = $proj->form;
    return {
        base => 'base_tagging_elems',
        title => 'Разметка',
        table => 'DataTaggingElems',
        fix_sql_problem => 0,
        fields => [
            { name => 'Bnr', after => 'SetID', show_banner_inf => 'Value2' },
            { name => 'Data', after => 'SetID', shlist => 1, },
            { name => 'Categories', shlist => 0, redefine_base => 1, },
            { name => 'ManualCategory', shlist => 0, redefine_base => 1, },
            { name => "Mode", update_base => 1, selectlist => $selectlist_short, },
        ],
        default_filter => {
            ($form->{SetID} == 4  ?  (Value3 => 'Match')  :  ()),
        },

        #data_import_export => {
        #    list => [qw(Data CategoriesString Mode Comment)],
        #    no_import => 1,
        #},
    };

        #CREATE TABLE `DataTaggingElems` (
        #        `ID` bigint(22) NOT NULL AUTO_INCREMENT,
        #        `SetID` bigint(22) NOT NULL DEFAULT 0,
        #        `SetType` text default "",
        #        `Value1` text default "",
        #        `Value2` text default "",
        #        `Value3` text default "",
        #        `Data` text default "",
        #        `CategoriesString` text default "",
        #        `CategPhrases` text default "",
        #        `ManualCategory` text default "",
        #        `Mode` text default "",
        #        `Comment` text default "",
        #        PRIMARY KEY (`ID`)
        #) CHARSET=utf8 ;
}

sub urls_tagging_benchmark :CMDH {
    my ($proj, $vars) = @_;
    my $lang = $vars->{viewoptions}{lang};

    if ($proj->form->{update_urls_tagging_benchmark}) {
        Cmds::Tagging::update_urls_tagging_benchmark($proj);
    }

    return {
        title => 'Эталон разметки страниц',
        table => 'UrlsTaggingBenchmark',
        fix_sql_problem => 0,
        readonly => 1,
        disable_del => 1,
        disable_add => 1,
        add_filter => { Lang => $lang, },
        NN => 1,
        default_field_params => { edlist => 0, },
        fields => [
            { name => 'SetID', shlist => 1, },
            { name => 'Url', after => 'SetID', shlist => 1, showmacro => 'exturl', },
            { name => 'CategoriesString', shlist => 1, showmacro => 'catlist2links', redefine_base => 1, },
            { name => 'UpdateTime', shlist => 1, redefine_base => 1, },
        ],
        toptext =>  qq[<a class="btn btn-mini" style='list-style: none;line-height: 20px; border-radius: 0 0 0 0; padding: 2px 6px; display: inline-block;color: #000000;' href="ind.pl?cmd=urls_tagging_benchmark&update_urls_tagging_benchmark=1&viewoptionsstr=lang_$lang">Обновить</a>],

        filters => [
               {  name => 'SetID', field => 'SetID', list => 1, },
        ],
        data_import_export => {
            list => [qw(Lang Url CategoriesString UpdateTime)],
            no_import => 1,
            export => {
                use_grp => 1,
                filtered => 1,
                headers => 1,
                lang_for_categs => 1,
            },
        },
        order_by => "reverse(ID)",
        pager => { name => 'p', cc => 20, },
    };
}

# кнопка "Обновить" на странице UrlsBenchmark
sub update_urls_tagging_benchmark {
    my ($proj) = @_;

    my @sets_ids_langs_update_time = @{$proj->List_SQL("SELECT SetID, Lang, UpdateTime FROM UrlsTaggingSets WHERE Type = 'Benchmark'")};
    my @tagging_sets_ids = map {$_->{SetID}} @sets_ids_langs_update_time;
    my %set_id2lang = map {$_->{SetID} => $_->{Lang}} @sets_ids_langs_update_time;
    my %set_id2update_time = map {$_->{SetID} => $_->{UpdateTime}} @sets_ids_langs_update_time;

    my @tagging_elems_ids = ();
    for my $set_id (@tagging_sets_ids) {
        push @tagging_elems_ids, map {$_->{ID}} @{$proj->List_SQL("
        SELECT ID FROM UrlsTaggingElems
        WHERE SetID = $set_id AND ((Mode like 'good') OR
                                   ((Mode <> 'old') AND (ManualCategory <> '') AND (ManualCategory IS NOT NULL)))")};
    }

    my @benchmark_ids = map {$_->{ElemsID}} @{$proj->List_SQL("SELECT ElemsID FROM UrlsTaggingBenchmark")};

    # сет стал эталоном, надо его добавить
    my @ids_to_add = @{array_minus(\@tagging_elems_ids, \@benchmark_ids)};

    # сет перестал быть эталоном, надо его удалить
    my @ids_to_delete = @{array_minus(\@benchmark_ids, \@tagging_elems_ids)};

    # удаление сетов из UrlsBenchmark, если есть что удалять
    if (scalar @ids_to_delete > 0) {
        $proj->Do_SQL("DELETE FROM UrlsTaggingBenchmark WHERE (".(join " OR ", (map { "ElemsID = $_" } @ids_to_delete)).")");
    }

    # добавление элементов сета, если есть что добавлять
    if (scalar @ids_to_add > 0) {

        my $stm = "SELECT SetID, Url, CategoriesString, ManualCategory, Mode from UrlsTaggingElems where ID = ";

        my @result = ();
        for my $id (@ids_to_add) {
            # подставляем в выражение конкретный id
            my $elems_to_add = $proj->List_SQL($stm.$id);

            # добавляем по одной строчке
            for my $h (@$elems_to_add) {
                $h->{ElemsID} = $id;
                for my $f (qw(SetID Url CategoriesString ManualCategory Mode)) {
                    $h->{$f} = '' unless (defined $h->{$f});
                }

                my $set_id = $h->{SetID};
                $h->{Lang} = (exists $set_id2lang{$set_id}) ? $set_id2lang{$set_id} : '';
                $h->{UpdateTime} = (exists $set_id2update_time{$set_id}) ? $set_id2update_time{$set_id} : '';
                $h->{CategoriesString} = ($h->{Mode} eq 'good') ? $h->{CategoriesString} : $h->{ManualCategory};
                my @fields_to_add = qw(SetID Url CategoriesString UpdateTime Lang ElemsID);
                for my $k (keys %$h) {
                    delete $h->{$k} unless (grep { $_ eq $k } @fields_to_add);
                }
                push @result, $h;
            }
        }
        my $dbt_tsb = $proj->dbtable('UrlsTaggingBenchmark');
        $dbt_tsb->Add(\@result);
    }

#    $proj->dd('Tagging sets ids:', Dumper(\@tagging_elems_ids), 'Benchmark ids:', Dumper(\@benchmark_ids),
#              'Ids to add', Dumper(\@ids_to_add), 'Ids to delete', Dumper(\@ids_to_delete));

}

sub banners_tagging_benchmark :CMDH {
    my ($proj, $vars) = @_;
    my $lang = $vars->{viewoptions}{lang};

    if ($proj->form->{update_banners_tagging_benchmark}) {
        Cmds::Tagging::update_banners_tagging_benchmark($proj);
    }

    return {
        title => 'Эталон разметки баннеров',
        table => 'BannersTaggingBenchmark',
        fix_sql_problem => 0,
        disable_add => 1,
        rights => "right_tagging",
        readonly => 0,
        onclick => '',
        add_filter => { Lang => $lang, },
        NN => 1,
        default_field_params => { edlist => 1, shlist => 1 },
        idfield => 'ID',
        order_by => 'reverse(ID)',
        fields => [
            { name => 'SetID', },
            { title => 'IDs', extname => 'IDs', after => 'SetID',
                grp => [
                    { name => 'BannerID', title => 'BannerID', },
                    { name => 'bid', title => 'bid', showmacro => 'bid2link', },
                ],
            },
            { show_banner_saved_inf => 'Data', after => 'SetID', },
            { title => 'Categories', editlink => 0, extname => 'Categories',
                grp => [
                    { name => "CategoriesString",    title => "",  showmacro => 'catlist2links',  shlist => 1, },
                    { name => 'CategPhrases', title => '', show_banner_saved_categs => 'CategPhrases', },
                ],
            },
            { name => "ChangesHistory", redefine_base => 1, width => 280 },
        ],
        toptext =>  qq[<a class="btn btn-mini" style='list-style: none;line-height: 20px; border-radius: 0 0 0 0; padding: 2px 6px; display: inline-block;color: #000000;' href="ind.pl?cmd=banners_tagging_benchmark&update_banners_tagging_benchmark=1&viewoptionsstr=lang_$lang">Обновить</a>],

        data_import_export => {
            list => [qw(Lang Data CategoriesString CategPhrases UpdateTime)],
            no_import => 1,
            export => {
                use_grp => 1,
                filtered => 1,
                headers => 1,
                readable_CategPhrases => ['CategPhrases'],
                lang_for_categs => 1,
                split_banner_data_field => 1,
            },
        },
        filters => [
               {  name => 'SetID', field => 'SetID', grp => 1, like => 0, use_other_filters => 1, },
               {  name => 'BannerID', field => 'BannerID', like => 1, use_other_filters => 1, },
               {  name => 'bid', field => 'bid', like => 1, use_other_filters => 1, },
        ],
        Moderate => {
            Del => sub {
                my ($self, $id) = @_;

                my $tbl_review = $self->proj->dbtable("BannersTaggingBenchmarkForReview");
                $tbl_review->Do_SQL("delete from BannersTaggingBenchmarkForReview where BenchmarkID = $id");

                my $tbl = $self->proj->dbtable("BannersTaggingBenchmark");

                my @r = @{$tbl->List_SQL("select ElemsID from BannersTaggingBenchmark where ID = $id")};
                $tbl->Do_SQL("delete from BannersTaggingBenchmark where ID = $id");

                if (@r) {
                    @r = map { $_->{ElemsID} } @r;
                    my $h = { Mode => 'old' };
                    my $tbl_elems = $self->proj->dbtable("BannersTaggingElems");
                    for my $i (@r) {
                        $tbl_elems->Edit($i, $h);
                    }
                }
            },
        },
        del_mes => "Вы уверены, что хотите удалить данный элемент из эталона и установить режим Неправильная категория ...?",
        pager => { name => 'p', cc => 20, },
        fixed_header => 1,
    };
}

# кнопка "Обновить" на странице banners_tagging_benchmark
sub update_banners_tagging_benchmark {
    my ($proj) = @_;

    # ищем эталонные сеты
    my @sets_ids_langs_update_time = @{$proj->List_SQL("SELECT SetID, Lang, UpdateTime FROM BannersTaggingSets WHERE Type = 'Benchmark'")};
    my @tagging_sets_ids = map {$_->{SetID}} @sets_ids_langs_update_time;
    my %set_id2lang = map {$_->{SetID} => $_->{Lang}} @sets_ids_langs_update_time;
    my %set_id2update_time = map {$_->{SetID} => $_->{UpdateTime}} @sets_ids_langs_update_time;

    my @tagging_elems_ids = ();
    for my $set_id (@tagging_sets_ids) {
        push @tagging_elems_ids, map {$_->{ID}} @{$proj->List_SQL("
        SELECT ID FROM BannersTaggingElems
        WHERE SetID = $set_id AND ((Mode like 'good') OR
                                   ((Mode <> 'old') AND (ManualCategory <> '') AND (ManualCategory IS NOT NULL)))")};
    }

    # баннеры, находящиеся в таблице эталонов
    my @benchmark_res = @{$proj->List_SQL("SELECT ElemsID, CategoriesString FROM BannersTaggingBenchmark")};
    my @benchmark_ids = map {$_->{ElemsID}} @benchmark_res;
    my %benchmark_id_to_cat = map { $_->{ElemsID} => $_->{CategoriesString} } @benchmark_res;

    # сет стал эталоном, надо добавить баннеры, принадлежащие ему
    my @ids_to_add = @{array_minus(\@tagging_elems_ids, \@benchmark_ids)};

    # сет перестал быть эталоном, надо удалить баннеры, принадлежащие ему
    # или у элемента изменилась категоризация потому что модератор изменил Mode
    my @ids_to_delete = @{array_minus(\@benchmark_ids, \@tagging_elems_ids)};

    # то, что есть, надо обновить - вдруг, изменилось состояние
    my @ids_to_update = sort { $a <=> $b }  @{array_minus(\@benchmark_ids, \@ids_to_delete)};

    # обновление того, что есть - вдруг, что-то изменилось
    if (@ids_to_update) {
        my @elems_to_update = @{$proj->List_SQL("SELECT ID, CategoriesString, ManualCategory, Mode FROM BannersTaggingElems where ID in (".(join ",", @ids_to_update).")")};
        my %info_to_update = map { $_->{ID} => ($_->{Mode} eq 'good') ? $_->{CategoriesString} : $_->{ManualCategory} } @elems_to_update;
        for my $id (@ids_to_update) {
            if ($info_to_update{$id} and $benchmark_id_to_cat{$id} and $info_to_update{$id} ne $benchmark_id_to_cat{$id} ) {
                # удаляем старую запись и заполняем её же заново
                push @ids_to_delete, $id;
                push @ids_to_add, $id;
            }
        }
    }

    # удаление сетов из BannersTaggingBenchmark, если есть что удалять
    if (scalar @ids_to_delete > 0) {
        my @benchmark_ids_to_delete = map { $_->{ID} } @{$proj->List_SQL("SELECT ID FROM BannersTaggingBenchmark WHERE ElemsID in (".(join ", ", (@ids_to_delete)).")")};
        $proj->Do_SQL("DELETE FROM BannersTaggingBenchmark WHERE ElemsID in (".(join ", ", @ids_to_delete).")");
        $proj->Do_SQL("DELETE FROM BannersTaggingBenchmarkForReview WHERE BenchmarkID in (".(join ", ", @benchmark_ids_to_delete).")");
    }

    # добавление элементов сета, если есть что добавлять
    if (scalar @ids_to_add > 0) {
        # выбираем все поля, кроме ElemsID
        my $stm = "SELECT SetID, BannerID, bid, Data, CategoriesString, ManualCategory, Mode from BannersTaggingElems where ID = ";
        my $today_date = $proj->dates->cur_date('db_time');

        my @result = ();
        for my $id (@ids_to_add) {
            #  подставляем конкретный id
            my $elems_to_add = $proj->List_SQL($stm.$id);

            # добавляем по одной строчке
            for my $h (@$elems_to_add) {
                $h->{ElemsID} = $id;
                for my $f (qw(SetID Data CategoriesString ManualCategory Mode)) {
                    $h->{$f} = '' unless (defined $h->{$f});
                }

                my $set_id = $h->{SetID};
                $h->{Lang} = (exists $set_id2lang{$set_id}) ? $set_id2lang{$set_id} : '';
                $h->{UpdateTime} = (exists $set_id2update_time{$set_id}) ? $set_id2update_time{$set_id} : '';
                $h->{ChangesHistory} = "Added to benchmark $today_date;\n";
                $h->{CategoriesString} = ($h->{Mode} eq 'good') ? $h->{CategoriesString} : $h->{ManualCategory};
                my @fields_to_add = qw(SetID Data CategoriesString UpdateTime Lang ElemsID ChangesHistory BannerID bid);
                for my $k (keys %$h) {
                    delete $h->{$k} unless (grep { $_ eq $k } @fields_to_add);
                }
                #TODO: проверить, что в базе эталонов нет записи для этого BannerID / bid
                push @result, $h;
            }
        }
        my $dbt_tsb = $proj->dbtable('BannersTaggingBenchmark');
        $dbt_tsb->Add(\@result);
    }

#    $proj->dd('Tagging sets ids:', Dumper(\@tagging_elems_ids), 'Benchmark ids:', Dumper(\@benchmark_ids),
#              'Ids to add', Dumper(\@ids_to_add), 'Ids to delete', Dumper(\@ids_to_delete));

}

sub banners_tagging_benchmark_categs_diff :CMDH {
    my ($proj, $vars) = @_;
    my $lang = $vars->{viewoptions}{lang};

    return {
        title => 'Эталон разметки баннеров: изменение категоризации',
        table => 'BannersTaggingBenchmarkForReview',
        idfield => 'ID',
        readonly => 1,
        disable_del => 1,
        disable_add => 1,
        logchanges => 1,
        fix_sql_problem => 0,
        onclick => 'show',
        add_filter => { Lang => $lang, },
        NN => 1,
        default_field_params => { edlist => 0, },
        fields => [
            { title => 'IDs', shlist => 1, extname => 'IDs', after => 'SetID',
                grp => [
                    { name => 'BannerID', title => 'BannerID', shlist => 1, edlist => 0, },
                    { name => 'bid', title => 'bid', shlist => 1, edlist => 0, showmacro => 'bid2link', },
                ],
            },
            { show_banner_saved_inf => 'Data', width => 100 },
            { title => 'Benchmark Categories', shlist => 1, editlink => 0, extname => 'Old Categories',
                grp => [
                    { name => "CategoriesStringOld",    title => "",  showmacro => 'catlist2links',  shlist => 1, },
                    { name => 'CategPhrasesOld', title => '', show_banner_saved_categs => 'CategPhrasesOld', },
                ],
            },
            # Actual == new categories, benchmark == old categories
            { title => 'Actual Categories', shlist => 1, editlink => 0, extname => 'New Categories',
                grp => [
                    { name => "CategoriesStringNew",    title => "",  showmacro => 'catlist2links',  shlist => 1, },
                    { name => 'CategPhrasesNew', title => '', show_banner_saved_categs => 'CategPhrasesNew', },
                ],
            },
            { name => 'ManualCategory', title => 'Manual Category', shlist => 1, manual_category => 1, width => 170, inlinefilter => { group => 1 }, showmacro => 'catlist2links' },
            { name => 'ChangesHistory', shlist => 1, redefine_base => 1, width => 130, after => 'ManualCategory'},
            { name => 'Action', title => 'Action', inline => 1, edlist => 1, shlist => 1, width => 140, height => 80, ftype => 'dropdown', after => 'ChangesHistory',
                  selectlist => [
                          { name => 'Не выбрано',           value => '',        default => 1 },
                          { name => 'Категория эталона',     value => 'old',     color => '#F79393', },
                          { name => 'Текущая категория',      value => 'new',     color => '#60BA70', },
                          { name => 'Ручная категория',     value => 'manual',  color => '#8587D7', },
                      ],
            },
            #{ name => "Comment", title => 'Comment', edlist => 1, shlist => 1, inline => 1, ftype => 'textarea', width => 140, },
        ],

        topmenu => [
            { title => "Внести изменения в эталон", sublist => [
                { title => "Внести изменения в эталон", url => "?cmd=refresh_banners_tagging_benchmark_categs_diff", },
            ] },
            { title => 'Экспорт',
                name => 'export',
                sublist => [ {
                    title => 'Экспорт bid',
                    name => 'export_bid',
                    redir_action => sub {
                        my ($self, $lst1, $lst2, $prmsh) = @_;
                        my $proj = $self->proj;
                        my $lang = $vars->{viewoptions}{lang};

                        my $sql_request = "select bid from BannersTaggingBenchmarkForReview";

                        #Проверяем фильтрацию
                        if ((my $action) = ($proj->form->{flt_Action} =~ /(\w+)/)) {
                            $sql_request .= " where Action like \"$action\"";
                        }

                        my $list = $proj->List_SQL($sql_request);
                        my @bids = map {$_->{bid}} @{$list};
                        my $phl = $proj->phrase_list(\@bids);
                        $proj->save_phrase_list($phl);
                        my $id = $phl->cache_id;
                        my $url = join("&",
                            "?cmd=edit_phrase_list",
                            "act=showphl", "phlid=$id",
                            "viewoptionsstr=lang_$lang"
                        );
                        return $url;
                },
            }],
        },
        ],

        filters => [
               {  name => 'Action', field => 'Action', list => 1, grp =>1,  },
               {  name => 'BannerID', field => 'BannerID', like => 1, use_other_filters => 1, },
               {  name => 'bid', field => 'bid', like => 1, use_other_filters => 1, },
        ],
        order_by => "reverse(ID)",
        pager => { name => 'p', cc => 50, },
        fixed_header => 1,
    };
}

sub refresh_banners_tagging_benchmark_categs_diff :CMD {
    my ($proj, $vars) = @_;
    my @data = @{$proj->List_SQL("
        select * FROM BannersTaggingBenchmarkForReview
        WHERE Action = 'old' or Action = 'new' or (Action = 'manual' and ManualCategory != '')
    ")};

    my $today = $proj->dates->cur_date('db_time');
    for my $d (@data) {
        # в любом случае изменяем время обновления и обновляем строку истории изменений
        my $h = { UpdateTime => $today, ChangesHistory => ($d->{ChangesHistory})."Reviewed $today;\n" };

        if ($d->{Action} eq 'new') {
            # заменяем категорию на новую и дописываем время изменения
            $h->{$_} = $d->{$_."New"} for (qw(CategoriesString CategPhrases));
        }
        elsif ($d->{Action} eq 'manual') {
            # заменяем категорию на новую и дописываем время изменения
            $h->{CategoriesString} = $d->{ManualCategory};
            $h->{CategPhrases} = '';
        }

        # если остаётся старая категория,изменяем только время обновления
        my $dbt_tsb = $proj->dbtable('BannersTaggingBenchmark');
        $dbt_tsb->Edit( $d->{BenchmarkID}, $h );
        $proj->Do_SQL("delete from BannersTaggingBenchmarkForReview where ID=".($d->{ID}));
    }
    #TODO: заменить UpdateTime
    $proj->do_redirect("?cmd=banners_tagging_benchmark_categs_diff");
}

sub phrases_tagging_benchmark :CMDH {
    my ($proj, $vars) = @_;
    my $lang = $vars->{viewoptions}{lang};

    if ($proj->form->{update_phrases_tagging_benchmark}) {
        Cmds::Tagging::update_phrases_tagging_benchmark($proj);
    }

    return {
        title => 'Эталон разметки фраз',
        table => 'PhrasesTaggingBenchmark',
        fix_sql_problem => 0,
        readonly => 1,
        disable_del => 1,
        disable_add => 1,
        add_filter => { Lang => $lang, },
        NN => 1,
        default_field_params => { edlist => 0, },
        fields => [
            { name => 'SetID', shlist => 1, },
            { name => 'Phrase', after => 'SetID', showmacro => 'phrase2link', shlist => 1, },
            { name => 'CategoriesString', shlist => 1, showmacro => 'catlist2links', redefine_base => 1, },
            { name => 'UpdateTime', shlist => 1, redefine_base => 1, },
        ],
        toptext =>  qq[<a class="btn btn-mini" style='list-style: none;line-height: 20px; border-radius: 0 0 0 0; padding: 2px 6px; display: inline-block;color: #000000;' href="ind.pl?cmd=phrases_tagging_benchmark&update_phrases_tagging_benchmark=1&viewoptionsstr=lang_$lang">Обновить</a>],

        filters => [
               {  name => 'SetID', field => 'SetID', list => 1, },
        ],
        data_import_export => {
            list => [qw(Lang Phrase CategoriesString UpdateTime)],
            no_import => 1,
            export => {
                use_grp => 1,
                filtered => 1,
                headers => 1,
                lang_for_categs => 1,
            },
        },
        order_by => "reverse(ID)",
        pager => { name => 'p', cc => 20, },
        fixed_header => 1,
    };
}

# кнопка "Обновить" на странице PhrasesBenchmark
sub update_phrases_tagging_benchmark {
    my ($proj) = @_;

    my @sets_ids_langs_update_time = @{$proj->List_SQL("SELECT SetID, Lang, UpdateTime FROM PhrasesTaggingSets WHERE Type = 'Benchmark'")};
    my @tagging_sets_ids = map {$_->{SetID}} @sets_ids_langs_update_time;
    my %set_id2lang = map {$_->{SetID} => $_->{Lang}} @sets_ids_langs_update_time;
    my %set_id2update_time = map {$_->{SetID} => $_->{UpdateTime}} @sets_ids_langs_update_time;

    my @tagging_elems_ids = ();
    for my $set_id (@tagging_sets_ids) {
        push @tagging_elems_ids, map {$_->{ID}} @{$proj->List_SQL("
        SELECT ID FROM PhrasesTaggingElems
        WHERE SetID = $set_id AND ((Mode like 'good') OR
                                   ((Mode <> 'old') AND (ManualCategory <> '') AND (ManualCategory IS NOT NULL)))")};
    }

    my @benchmark_ids = map {$_->{ElemsID}} @{$proj->List_SQL("SELECT ElemsID FROM PhrasesTaggingBenchmark")};

    # сет стал эталоном, надо его добавить
    my @ids_to_add = @{array_minus(\@tagging_elems_ids, \@benchmark_ids)};

    # сет перестал быть эталоном, надо его удалить
    my @ids_to_delete = @{array_minus(\@benchmark_ids, \@tagging_elems_ids)};

    # удаление сетов из UrlsBenchmark, если есть что удалять
    if (scalar @ids_to_delete > 0) {
        $proj->Do_SQL("DELETE FROM PhrasesTaggingBenchmark WHERE (".(join " OR ", (map { "ElemsID = $_" } @ids_to_delete)).")");
    }

    # добавление элементов сета, если есть что добавлять
    if (scalar @ids_to_add > 0) {

        my $stm = "SELECT SetID, Phrase, CategoriesString, ManualCategory, Mode from PhrasesTaggingElems where ID = ";

        my @result = ();
        for my $id (@ids_to_add) {
            #  подставляем конкретный id
            my $elems_to_add = $proj->List_SQL($stm.$id);

            # добавляем по одной строчке
            for my $h (@$elems_to_add) {
                $h->{ElemsID} = $id;
                for my $f (qw(SetID Phrase CategoriesString ManualCategory Mode)) {
                    $h->{$f} = '' unless (defined $h->{$f});
                }

                my $set_id = $h->{SetID};
                $h->{Lang} = (exists $set_id2lang{$set_id}) ? $set_id2lang{$set_id} : '';
                $h->{UpdateTime} = (exists $set_id2update_time{$set_id}) ? $set_id2update_time{$set_id} : '';
                $h->{CategoriesString} = ($h->{Mode} eq 'good') ? $h->{CategoriesString} : $h->{ManualCategory};
                my @fields_to_add = qw(SetID Phrase CategoriesString UpdateTime Lang ElemsID);
                for my $k (keys %$h) {
                    delete $h->{$k} unless (grep { $_ eq $k } @fields_to_add);
                }
                push @result, $h;
            }
        }
        my $dbt_tsb = $proj->dbtable('PhrasesTaggingBenchmark');
        $dbt_tsb->Add(\@result);
    }

#    $proj->dd('Tagging sets ids:', Dumper(\@tagging_elems_ids), 'Benchmark ids:', Dumper(\@benchmark_ids),
#              'Ids to add', Dumper(\@ids_to_add), 'Ids to delete', Dumper(\@ids_to_delete));

}

sub banners_set_categorasation_diff :CMDH {
    my ($proj, $vars) = @_;
    my $lang = $vars->{viewoptions}{lang};

    return {
        title => 'Изменение категоризации фиксированного сета баннеров',
        table => 'BannersSetCategorasationDiff',
        idfield => 'ID',
        readonly => 1,
        disable_del => 1,
        disable_add => 1,
        logchanges => 1,
        fix_sql_problem => 0,
        onclick => 'show',
        add_filter => { Lang => $lang, },
        NN => 1,
        default_field_params => { edlist => 0, },
        fields => [
            { title => 'IDs', shlist => 1, extname => 'IDs', after => 'SetID',
                grp => [
                    { name => 'BannerID', title => 'BannerID', shlist => 1, edlist => 0, },
                    { name => 'bid', title => 'bid', shlist => 1, edlist => 0, showmacro => 'bid2link', },
                ],
            },
            { show_banner_saved_inf => 'Data', width => 100, },
            { name => 'ModeOld', title => 'Old Mode', shlist => 1, width => 30, inlinefilter => { group => 1 },
                ftype => 'select',
                showmacroel => 'show_list_inline_readonly_field',
                selectlist => $selectlist_categs,
                height => 60,
            },
            { title => 'Old Categories', shlist => 1, editlink => 0, extname => 'Old Categories',
                grp => [
                    { name => "CategoriesStringOld",    title => "",  showmacro => 'catlist2links',  shlist => 1, },
                    { name => 'CategPhrasesOld', title => '', show_banner_saved_categs => 'CategPhrasesOld', },
                ],
            },
            { title => 'New Categories', shlist => 1, editlink => 0, extname => 'New Categories',
                grp => [
                    { name => "CategoriesStringNew",    title => "",  showmacro => 'catlist2links',  shlist => 1, },
                    { name => 'CategPhrasesNew', title => '', show_banner_saved_categs => 'CategPhrasesNew', },
                ],
            },
            { name => 'ManualCategory', title => 'Manual Category', shlist => 1, manual_category => 1, width => 170, inlinefilter => { group => 1 }, showmacro => 'catlist2links' },
            { name => 'Action', title => 'Action', inline => 1, edlist => 1, shlist => 1, width => 140, height => 80, ftype => 'dropdown', after => 'ManualCategory', inlinefilter => { group => 1 },
                  selectlist => [
                          { name => 'Не выбрано',           value => '',        default => 1 },
                          { name => 'Старая категория',     value => 'old',     color => '#F79393', },
                          { name => 'Новая категория',      value => 'new',     color => '#60BA70', },
                          { name => 'Ручная категория',     value => 'manual',  color => '#8587D7', },
                      ],
            },
            #{ name => "Comment", title => 'Comment', edlist => 1, shlist => 1, inline => 1, ftype => 'textarea', width => 140, },
        ],

        filters => [
               {  name => 'Action', field => 'Action', list => 1, grp =>1,  },
        ],
        order_by => "reverse(ID)",
        pager => { name => 'p', cc => 50, },
        fixed_header => 1,
    };
}
1;

